/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.inline.function;

import com.google.common.base.Predicates;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.introduce.inplace.OccurrencesChooser;
import com.intellij.refactoring.ui.UsageViewDescriptorAdapter;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.codeStyle.PhpUnnecessaryParenthesesInspection;
import com.jetbrains.php.lang.inspections.controlFlow.PhpSideEffectDetector;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayIndex;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.ControlStatement;
import com.jetbrains.php.lang.psi.elements.Else;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParenthesizedExpression;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.StatementImpl;
import com.jetbrains.php.lang.psi.elements.impl.VariableImpl;
import com.jetbrains.php.lang.psi.visitors.PhpRecursiveElementVisitor;
import com.jetbrains.php.refactoring.PhpAliasImporter;
import com.jetbrains.php.refactoring.PhpNameUtil;
import com.jetbrains.php.refactoring.PhpRefactoringUtil;
import com.jetbrains.php.refactoring.importReferences.PhpClassReferenceResolver;
import com.jetbrains.php.refactoring.inline.function.InlineInputData;
import com.jetbrains.php.refactoring.inline.function.PhpInlineFunctionHandler;
import com.jetbrains.php.refactoring.inline.function.PhpInlineFunctionPresenter;
import com.jetbrains.php.refactoring.inline.function.ReplacementData;
import com.jetbrains.php.refactoring.introduce.PhpIntroduceBaseHandler;
import com.jetbrains.php.refactoring.introduce.PhpIntroduceContext;
import com.jetbrains.php.refactoring.introduce.introduceParameter.PhpIntroduceParameterHandler;
import com.jetbrains.php.refactoring.introduce.introduceVariable.PhpIntroduceVariableHandler;
import com.jetbrains.php.refactoring.introduce.introduceVariable.PhpIntroduceVariableNameSuggestionProvider;
import com.jetbrains.php.refactoring.introduce.introduceVariable.PhpIntroduceVariableSettings;
import com.jetbrains.php.refactoring.makeStatic.PhpMakeStaticHandler;
import com.jetbrains.php.refactoring.makeStatic.PhpMakeStaticProcessor;
import com.jetbrains.php.refactoring.makeStatic.PhpMakeStaticSettingsBatch;
import com.jetbrains.php.util.PhpStringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpInlineFunctionProcessor
extends BaseRefactoringProcessor {
    private static final Key<String> PHP_INLINE_MARK_KEY = Key.create((String)"");
    private final Function myFunction;
    @Nullable
    private final FunctionReference myReference;
    private final boolean myInlineThisFunctionUsageOnly;
    private final boolean myIsDeleteTheDeclaration;
    final PhpClassReferenceResolver referenceResolver = new PhpClassReferenceResolver();

    public PhpInlineFunctionProcessor(Project project, Function function, @Nullable FunctionReference reference, boolean invokeThisOnly, boolean isDeleteTheDeclaration) {
        super(project);
        this.myFunction = function;
        this.myReference = reference;
        this.myInlineThisFunctionUsageOnly = invokeThisOnly;
        this.myIsDeleteTheDeclaration = isDeleteTheDeclaration;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            PhpInlineFunctionProcessor.$$$reportNull$$$0(0);
        }
        return new UsageViewDescriptorAdapter(){

            public PsiElement @NotNull [] getElements() {
                PsiElement[] psiElementArray = new PsiElement[]{PhpInlineFunctionProcessor.this.myFunction};
                if (psiElementArray == null) {
                    1.$$$reportNull$$$0(0);
                }
                return psiElementArray;
            }

            public String getProcessedElementsHeader() {
                return RefactoringBundle.message((String)"all.invocations.in.project");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/refactoring/inline/function/PhpInlineFunctionProcessor$1", "getElements"));
            }
        };
    }

    protected UsageInfo @NotNull [] findUsages() {
        return this.findUsages(GlobalSearchScope.projectScope((Project)this.myFunction.getProject()));
    }

    private UsageInfo @NotNull [] findUsages(GlobalSearchScope scope) {
        if (this.myInlineThisFunctionUsageOnly) {
            assert (this.myReference != null);
            UsageInfo[] usageInfoArray = new UsageInfo[]{new UsageInfo(this.myReference.getElement())};
            if (usageInfoArray == null) {
                PhpInlineFunctionProcessor.$$$reportNull$$$0(1);
            }
            return usageInfoArray;
        }
        ReferencesSearch.SearchParameters searchParameters = new ReferencesSearch.SearchParameters((PsiElement)this.myFunction, (SearchScope)scope, false);
        UsageInfo[] usageInfoArray = (UsageInfo[])ReferencesSearch.search((ReferencesSearch.SearchParameters)searchParameters).findAll().stream().map(UsageInfo::new).toArray(UsageInfo[]::new);
        if (usageInfoArray == null) {
            PhpInlineFunctionProcessor.$$$reportNull$$$0(2);
        }
        return usageInfoArray;
    }

    protected void performRefactoring(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            PhpInlineFunctionProcessor.$$$reportNull$$$0(3);
        }
        LocalHistoryAction a = LocalHistory.getInstance().startAction(this.getCommandName());
        try {
            this.invokeProcess(usages, this.myInlineThisFunctionUsageOnly, this.myIsDeleteTheDeclaration);
        }
        finally {
            a.finish();
        }
    }

    @NotNull
    @NlsSafe
    protected String getCommandName() {
        String string = PhpBundle.message("refactoring.inline.function.command", this.getElementDescription());
        if (string == null) {
            PhpInlineFunctionProcessor.$$$reportNull$$$0(4);
        }
        return string;
    }

    public static Collection<FunctionReference> addBraces(Collection<? extends FunctionReference> references) {
        final ArrayList<FunctionReference> newReferences = new ArrayList<FunctionReference>();
        for (FunctionReference functionReference : references) {
            functionReference.putCopyableUserData(PHP_INLINE_MARK_KEY, (Object)"");
        }
        for (FunctionReference functionReference : references) {
            Statement statement = PhpPsiUtil.getParentOfClass((PsiElement)functionReference, Statement.class);
            if (statement == null) continue;
            PsiElement parent = statement.getParent();
            if (parent instanceof ControlStatement || parent instanceof Else) {
                PhpRefactoringUtil.wrapWithBraces(functionReference.getProject(), statement).accept((PsiElementVisitor)new PhpRecursiveElementVisitor(){

                    public void visitPhpFunctionCall(FunctionReference reference) {
                        if (reference.getCopyableUserData(PHP_INLINE_MARK_KEY) != null) {
                            newReferences.add(reference);
                            reference.putCopyableUserData(PHP_INLINE_MARK_KEY, null);
                        }
                        super.visitPhpFunctionCall(reference);
                    }
                });
                continue;
            }
            newReferences.add(functionReference);
        }
        for (FunctionReference functionReference : references) {
            functionReference.putCopyableUserData(PHP_INLINE_MARK_KEY, null);
        }
        return newReferences;
    }

    public void invokeProcess(boolean inlineThisOnly, boolean deleteDeclaration) {
        this.invokeProcess(this.findUsages(), inlineThisOnly, deleteDeclaration);
    }

    public void invokeProcess(UsageInfo[] usages, boolean inlineThisOnly, boolean deleteDeclaration) {
        if (inlineThisOnly) {
            FunctionReference functionReference = PhpInlineFunctionProcessor.addBraces((Collection<? extends FunctionReference>)new SmartList((Object)this.myReference)).iterator().next();
            PsiFile file = functionReference.getContainingFile();
            ArrayList<TextRange> rangeToReformat = new ArrayList<TextRange>(this.doReplacement(functionReference, true));
            PhpInlineFunctionProcessor.commitAndFormat(this.myProject, file, rangeToReformat);
        } else {
            CommonRefactoringUtil.sortDepthFirstRightLeftOrder((UsageInfo[])usages);
            ArrayList<FunctionReference> bracedFunctionReferences = new ArrayList();
            for (UsageInfo it : usages) {
                if (!(it.getElement() instanceof FunctionReference)) continue;
                bracedFunctionReferences.add((FunctionReference)it.getElement());
            }
            bracedFunctionReferences = PhpInlineFunctionProcessor.addBraces(bracedFunctionReferences);
            this.doReplacement(bracedFunctionReferences);
            if (deleteDeclaration) {
                if (this.myFunction.getDocComment() != null) {
                    this.myFunction.getDocComment().delete();
                }
                this.myFunction.delete();
            }
        }
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            PhpInlineFunctionProcessor.$$$reportNull$$$0(5);
        }
        MultiMap conflicts = new MultiMap();
        for (UsageInfo it : (UsageInfo[])refUsages.get()) {
            if (!(it.getElement() instanceof FunctionReference)) continue;
            conflicts.putAllValues(PhpInlineFunctionHandler.validateFunctionContext(this.myFunction, (FunctionReference)it.getElement()));
        }
        return this.showConflicts(conflicts, (UsageInfo[])refUsages.get());
    }

    public void doReplacement(Collection<FunctionReference> functionReferences) {
        MultiMap chains = ContainerUtil.groupBy(functionReferences, PhpInlineFunctionProcessor::getLastChainMember);
        Set filesWithChains = chains.entrySet().stream().filter(e -> ((Collection)e.getValue()).size() > 1).map(e -> ((PsiElement)e.getKey()).getContainingFile()).collect(Collectors.toSet());
        ((StreamEx)StreamEx.of((Collection)chains.entrySet()).map(it -> PhpInlineFunctionProcessor.getFirstFunctionReference((Collection)it.getValue())).filter(Objects::nonNull)).forEach(it -> {
            PhpUseList useStatement = PhpPsiUtil.getParentOfClass((PsiElement)it, true, PhpUseList.class);
            if (useStatement != null) {
                useStatement.delete();
            } else {
                Collection<TextRange> ranges = this.doReplacement((FunctionReference)it, false);
                PhpInlineFunctionProcessor.commitAndFormat(this.myProject, it.getContainingFile(), ranges);
            }
        });
        if (!filesWithChains.isEmpty()) {
            Optional<GlobalSearchScope> scope = filesWithChains.stream().map(GlobalSearchScope::fileScope).reduce(GlobalSearchScope::union);
            scope.ifPresent(searchScope -> this.invokeProcess(this.findUsages((GlobalSearchScope)searchScope), this.myInlineThisFunctionUsageOnly, this.myIsDeleteTheDeclaration));
        }
    }

    @Nullable
    private static FunctionReference getFirstFunctionReference(@NotNull Collection<FunctionReference> functionReferences) {
        if (functionReferences == null) {
            PhpInlineFunctionProcessor.$$$reportNull$$$0(6);
        }
        return functionReferences.stream().min(Comparator.comparingInt(a -> a.getTextRange().getEndOffset())).orElse(null);
    }

    @NotNull
    private static PsiElement getLastChainMember(@NotNull PsiElement member) {
        if (member == null) {
            PhpInlineFunctionProcessor.$$$reportNull$$$0(7);
        }
        if (!PhpInlineFunctionProcessor.isChainMember(member)) {
            PsiElement psiElement = member;
            if (psiElement == null) {
                PhpInlineFunctionProcessor.$$$reportNull$$$0(8);
            }
            return psiElement;
        }
        if (PhpInlineFunctionProcessor.isChainMember(member.getParent())) {
            return PhpInlineFunctionProcessor.getLastChainMember(member.getParent());
        }
        PsiElement psiElement = member;
        if (psiElement == null) {
            PhpInlineFunctionProcessor.$$$reportNull$$$0(9);
        }
        return psiElement;
    }

    private static boolean isChainMember(@Nullable PsiElement e) {
        return e instanceof FunctionReference || e instanceof FieldReference || e instanceof Variable;
    }

    @NotNull
    private static Map<Integer, String> createAssignmentsHeader(final @NotNull Function function, final @NotNull FunctionReference functionReference) {
        if (function == null) {
            PhpInlineFunctionProcessor.$$$reportNull$$$0(10);
        }
        if (functionReference == null) {
            PhpInlineFunctionProcessor.$$$reportNull$$$0(11);
        }
        final HashMap<Integer, String> guardingAssignments = new HashMap<Integer, String>();
        final Parameter[] parameters = function.getParameters();
        function.accept((PsiElementVisitor)new PhpRecursiveElementVisitor(){

            public void visitPhpVariable(Variable variable) {
                if (guardingAssignments.size() == parameters.length) {
                    return;
                }
                Set<Parameter> parametersSet = Set.of(function.getParameters());
                for (int i = 0; i < parameters.length; ++i) {
                    if (guardingAssignments.containsKey(i) || variable.resolve() != parameters[i]) continue;
                    PsiElement parent = variable.getParent();
                    boolean isFunctionReference = parent instanceof FunctionReference && !(parent instanceof MethodReference);
                    String parameterName = function.getParameters()[i].getName();
                    if ((parameters[i].isPassByRef() || !variable.isWriteAccess()) && !isFunctionReference && !this.isStringInterpolation(variable, parameterName, i)) continue;
                    String uniqueName = PhpInlineFunctionProcessor.getUniqueName((PsiElement)functionReference, parameterName, parametersSet);
                    guardingAssignments.put(i, uniqueName);
                }
                super.visitPhpVariable(variable);
            }

            private boolean isStringInterpolation(Variable variable, String parameterName, int i) {
                PsiElement parent = variable.getParent();
                if (parent instanceof MemberReference && PhpInlineFunctionProcessor.isInterpolationReference((PhpReference)((MemberReference)parent))) {
                    return true;
                }
                if (PhpInlineFunctionProcessor.isInterpolationReference((PhpReference)variable)) {
                    return true;
                }
                return PhpInlineFunctionProcessor.isInterpolationReference((PhpReference)functionReference) && !(functionReference.getParameter(parameterName, i) instanceof Variable);
            }
        });
        HashMap<Integer, String> hashMap = guardingAssignments;
        if (hashMap == null) {
            PhpInlineFunctionProcessor.$$$reportNull$$$0(12);
        }
        return hashMap;
    }

    private static Method makeStatic(@NotNull Method method, @Nullable String instanceVariableName) {
        if (method == null) {
            PhpInlineFunctionProcessor.$$$reportNull$$$0(13);
        }
        PhpMakeStaticSettingsBatch.MakeStaticSettingsBuilder settingsBuilder = new PhpMakeStaticSettingsBatch.MakeStaticSettingsBuilder().setPassedByFields(false).setPassedByObject(instanceVariableName != null).setObjectName(instanceVariableName);
        PhpMakeStaticSettingsBatch settings = settingsBuilder.build();
        settings.setMethod(method);
        return PhpMakeStaticProcessor.doMakeStatic(method.getProject(), (Method)method.copy(), settings);
    }

    @Nullable
    private static Statement createVariable(@NotNull PsiElement expression) {
        if (expression == null) {
            PhpInlineFunctionProcessor.$$$reportNull$$$0(14);
        }
        try {
            PhpIntroduceVariableHandler handler = new PhpIntroduceVariableHandler();
            PhpIntroduceContext context = handler.getIntroduceContext(null, expression);
            return PhpIntroduceVariableHandler.getVariableDeclaration(context, PhpInlineFunctionProcessor.getIntroduceVariableSettings(context), context.getElementDeclarationText());
        }
        catch (PhpIntroduceBaseHandler.RefactoringErrorException e) {
            return null;
        }
    }

    @NotNull
    public static PhpIntroduceVariableSettings getIntroduceVariableSettings(PhpIntroduceContext context) {
        final PhpIntroduceVariableNameSuggestionProvider nameSuggestionProvider = new PhpIntroduceVariableNameSuggestionProvider(context, PhpIntroduceVariableHandler.getOccupiedElements(context));
        return new PhpIntroduceVariableSettings(){

            @Override
            public OccurrencesChooser.BaseReplaceChoice getReplaceChoice() {
                return OccurrencesChooser.ReplaceChoice.NO;
            }

            @Override
            public boolean isEmbedVariable() {
                return false;
            }

            @Override
            public String getName() {
                return (String)ArrayUtil.getFirstElement((Object[])nameSuggestionProvider.getSuggestedNames());
            }
        };
    }

    private static Pair<Statement, String> introduceVariableIfNeeded(@NotNull Method method, @NotNull PhpExpression expression, boolean inlineThisOnly) {
        if (method == null) {
            PhpInlineFunctionProcessor.$$$reportNull$$$0(15);
        }
        if (expression == null) {
            PhpInlineFunctionProcessor.$$$reportNull$$$0(16);
        }
        if (!PhpMakeStaticHandler.processInternalUsages(method).isObjectIsNeeded()) {
            return Pair.empty();
        }
        if (inlineThisOnly && expression instanceof MethodReference && ((MethodReference)expression).isReferenceTo((PsiElement)method)) {
            return Pair.empty();
        }
        if (expression instanceof PhpNamedElement) {
            return Pair.pair(null, (Object)((PhpNamedElement)expression).getName());
        }
        Statement statement = PhpInlineFunctionProcessor.createVariable((PsiElement)expression);
        AssignmentExpression assignmentExpression = (AssignmentExpression)PsiTreeUtil.getChildOfType((PsiElement)statement, AssignmentExpression.class);
        assert (assignmentExpression != null);
        assert (assignmentExpression.getVariable() != null);
        return Pair.pair((Object)statement, (Object)assignmentExpression.getVariable().getName());
    }

    private ReplacementData createReplacement(InlineInputData inputData, Map<Integer, String> guardingAssignments, boolean inlineThisOnly) {
        boolean lastReturn;
        ArrayList<PsiElement> functionsStatements = new ArrayList<PsiElement>();
        boolean isMethod = inputData.myFunction instanceof Method;
        PhpExpression reference = inputData.getClassReference();
        if (isMethod && reference != null && !PhpInlineFunctionProcessor.isSpecialClassReference(reference)) {
            Method method = (Method)inputData.myFunction;
            Pair<Statement, String> variable = PhpInlineFunctionProcessor.introduceVariableIfNeeded(method, reference, inlineThisOnly);
            if (variable.first != null) {
                functionsStatements.add((PsiElement)variable.first);
            } else if (PhpSideEffectDetector.canContainSideEffect((PsiElement)reference)) {
                PsiElement sideEffectExpression = PhpPsiUtil.unparenthesize((PsiElement)reference);
                Statement sideEffectStatement = PhpPsiElementFactory.createStatement(sideEffectExpression.getProject(), sideEffectExpression.getText() + ";");
                functionsStatements.add((PsiElement)sideEffectStatement);
            }
            if (!method.isStatic()) {
                inputData = new InlineInputData(inputData.myFunctionReference, (Function)PhpInlineFunctionProcessor.makeStatic(method, (String)variable.second));
            }
        }
        Parameter[] parameters = inputData.myFunction.getParameters();
        HashMap<RangeMarker, String> replaceMap = new HashMap<RangeMarker, String>();
        LinkedHashSet<PhpNamedElement> namedElementsToImport = new LinkedHashSet<PhpNamedElement>();
        HashMap<PhpNamedElement, String> aliases = new HashMap<PhpNamedElement, String>();
        PhpPsiElement scopeHolder = PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)inputData.myFunctionReference);
        Set<String> usedNames = PhpInlineFunctionProcessor.collectUsedNames(scopeHolder);
        DocumentImpl document = new DocumentImpl(inputData.myFunction.getText());
        this.processInternalReferences(inputData, guardingAssignments, (Document)document, parameters, replaceMap, namedElementsToImport, aliases, scopeHolder, usedNames);
        Collection<Statement> statementsList = this.collectAssignmentStatements(inputData, guardingAssignments);
        this.referenceResolver.processElements(statementsList);
        replaceMap.forEach((arg_0, arg_1) -> PhpInlineFunctionProcessor.lambda$createReplacement$7((Document)document, arg_0, arg_1));
        Method functionReplacement = isMethod ? PhpPsiElementFactory.createMethod(this.myProject, document.getText()) : PhpPsiElementFactory.createFunction(this.myProject, document.getText());
        GroupStatement groupStatement = (GroupStatement)PhpPsiUtil.getChildByCondition((PsiElement)functionReplacement, (Condition<? super PsiElement>)GroupStatement.INSTANCEOF);
        assert (groupStatement != null);
        PsiElement[] groupStatementStatements = groupStatement.getStatements();
        final ArrayList returnStatements = new ArrayList();
        functionReplacement.accept((PsiElementVisitor)new PhpRecursiveElementVisitor(this){

            public void visitPhpReturn(PhpReturn returnStatement) {
                returnStatements.add(returnStatement);
                super.visitPhpReturn(returnStatement);
            }

            public void visitPhpFunction(Function function) {
                if (function.isClosure()) {
                    return;
                }
                super.visitPhpFunction(function);
            }
        });
        PhpExpression toInline = null;
        if (returnStatements.size() > 1 || returnStatements.size() == 1 && !(groupStatementStatements[groupStatementStatements.length - 1] instanceof PhpReturn)) {
            String returnVar = PhpInlineFunctionProcessor.getUniqueName((PsiElement)inputData.myFunctionReference, inputData.myFunction.getName(), new HashSet());
            returnStatements.forEach(e -> {
                PsiElement returnArgument = e.getArgument();
                if (returnArgument != null) {
                    e.replace((PsiElement)PhpPsiElementFactory.createStatement(this.myProject, "$" + returnVar + "=" + returnArgument.getText() + ";"));
                }
            });
            toInline = PhpPsiElementFactory.createFromText(this.myProject, PhpExpression.class, "$" + returnVar);
        }
        functionReplacement = (Function)CodeStyleManager.getInstance((Project)this.myProject).reformat((PsiElement)functionReplacement);
        GroupStatement groupStatementToInline = (GroupStatement)PhpPsiUtil.getChildByCondition((PsiElement)functionReplacement, (Condition<? super PsiElement>)GroupStatement.INSTANCEOF);
        assert (groupStatementToInline != null);
        PsiElement[] statements = groupStatementToInline.getStatements();
        int last = statements.length - 1;
        boolean bl = lastReturn = returnStatements.size() == 1 && statements[last] instanceof PhpReturn;
        if (lastReturn) {
            toInline = ((PhpReturn)statements[last]).getArgument();
        }
        if (PhpPsiUtil.unparenthesize((PsiElement)toInline) instanceof Variable && PhpInlineFunctionProcessor.isInsideSimpleStatement(inputData.myFunctionReference)) {
            if (toInline.getParent() != null) {
                toInline.getParent().delete();
            } else {
                toInline.delete();
            }
            toInline = null;
        }
        PsiElement child = groupStatementToInline.getFirstChild();
        if ((child = child.getNextSibling()) instanceof PsiWhiteSpace) {
            child = child.getNextSibling();
        }
        while (child != null) {
            PsiElement sibling;
            if (!(lastReturn && child == statements[last] || (sibling = child.getNextSibling()) == null || child instanceof PsiWhiteSpace && sibling == groupStatementToInline.getLastChild())) {
                functionsStatements.add(child);
            }
            child = child.getNextSibling();
        }
        PsiDocumentManager.getInstance((Project)this.myProject).commitDocument((Document)document);
        return new ReplacementData((PsiElement)toInline, functionsStatements, !returnStatements.isEmpty(), statementsList, namedElementsToImport, aliases);
    }

    private static boolean isInterpolationReference(@NotNull PhpReference reference) {
        Variable curlyBracedExpression;
        if (reference == null) {
            PhpInlineFunctionProcessor.$$$reportNull$$$0(17);
        }
        return (curlyBracedExpression = (Variable)PsiTreeUtil.getParentOfType((PsiElement)reference, Variable.class, (boolean)true, (Class[])new Class[]{MemberReference.class, Function.class, ArrayIndex.class})) != null && curlyBracedExpression.getParent() instanceof StringLiteralExpression;
    }

    private static boolean isInsideSimpleStatement(@NotNull FunctionReference functionReference) {
        StatementImpl statement;
        if (functionReference == null) {
            PhpInlineFunctionProcessor.$$$reportNull$$$0(18);
        }
        if ((statement = PhpPsiUtil.getParentOfClass((PsiElement)functionReference, StatementImpl.class)) == null) {
            return false;
        }
        return PhpPsiUtil.unparenthesize(statement.getFirstChild()) == functionReference;
    }

    private static boolean isSpecialClassReference(PhpExpression reference) {
        return reference instanceof ClassReference && PhpLangUtil.isClassNameSpecial(reference.getName());
    }

    @NotNull
    private Collection<Statement> collectAssignmentStatements(@NotNull InlineInputData inputData, @NotNull Map<Integer, String> guardingAssignments) {
        if (inputData == null) {
            PhpInlineFunctionProcessor.$$$reportNull$$$0(19);
        }
        if (guardingAssignments == null) {
            PhpInlineFunctionProcessor.$$$reportNull$$$0(20);
        }
        List list = ContainerUtil.mapNotNull(guardingAssignments.keySet(), key -> this.getAssignmentStatement(inputData, guardingAssignments, (int)key));
        if (list == null) {
            PhpInlineFunctionProcessor.$$$reportNull$$$0(21);
        }
        return list;
    }

    @Nullable
    private Statement getAssignmentStatement(@NotNull InlineInputData inputData, @NotNull Map<Integer, String> guardingAssignments, int parameterIndex) {
        PsiElement argument;
        if (inputData == null) {
            PhpInlineFunctionProcessor.$$$reportNull$$$0(22);
        }
        if (guardingAssignments == null) {
            PhpInlineFunctionProcessor.$$$reportNull$$$0(23);
        }
        return (argument = PhpIntroduceParameterHandler.getArgumentByParameterIndex(inputData.myFunction.getParameters(), inputData.parameterExpressions, parameterIndex)) != null ? PhpPsiElementFactory.createStatement(this.myProject, String.format("$%s = %s;", guardingAssignments.get(parameterIndex), argument.getText())) : null;
    }

    private void processInternalReferences(final InlineInputData inputData, final Map<Integer, String> guardingAssignments, final Document document, final Parameter[] parameters, final Map<RangeMarker, String> replaceMap, final Collection<PhpNamedElement> namedElementsToImport, final Map<PhpNamedElement, String> aliases, final PhpPsiElement scopeHolder, final Set<String> usedNames) {
        inputData.myFunction.accept((PsiElementVisitor)new PhpRecursiveElementVisitor(){

            public void visitPhpVariable(Variable variable) {
                int counter = 0;
                for (Parameter it : parameters) {
                    if (variable.resolve() == it) {
                        if (counter < inputData.parameterExpressions.length && inputData.parameterExpressions[counter] != null) {
                            this.replaceParameterWithArgumentValue(variable, counter);
                        } else {
                            this.replaceParameterUsageWithDefaultValue(variable, counter);
                        }
                    }
                    ++counter;
                }
                super.visitPhpVariable(variable);
            }

            private PsiElement replaceDefaultValueWithContextIndependent(PsiElement element) {
                PsiElement resolve2;
                PhpExpression expression;
                if (element instanceof MemberReference && (expression = ((MemberReference)element).getClassReference()) instanceof ClassReference && (resolve2 = ((ClassReference)expression).resolve()) instanceof PhpClass) {
                    String name = PhpInlineFunctionProcessor.getNameForClassReference((PhpClass)resolve2, scopeHolder);
                    return PhpPsiElementFactory.createFromText(PhpInlineFunctionProcessor.this.myProject, MemberReference.class, name + element.getText().substring(expression.getTextLength()));
                }
                return element;
            }

            private void replaceParameterWithArgumentValue(Variable variable, int counter) {
                replaceMap.put(document.createRangeMarker(variable.getTextRange().shiftLeft(inputData.myFunction.getTextRange().getStartOffset())), guardingAssignments.get(counter) != null ? PhpPsiElementFactory.createVariable(PhpInlineFunctionProcessor.this.myProject, (String)guardingAssignments.get(counter), true).getText() : 6.getReplacementText(variable, inputData.parameterExpressions[counter]));
            }

            private void replaceParameterUsageWithDefaultValue(Variable variable, int counter) {
                PsiElement value = parameters[counter].getDefaultValue();
                if (value != null) {
                    replaceMap.put(document.createRangeMarker(variable.getTextRange().shiftLeft(inputData.myFunction.getTextRange().getStartOffset())), guardingAssignments.get(counter) != null ? PhpPsiElementFactory.createVariable(PhpInlineFunctionProcessor.this.myProject, (String)guardingAssignments.get(counter), true).getText() : 6.getReplacementText(variable, this.replaceDefaultValueWithContextIndependent(value)));
                }
            }

            private static String getReplacementText(Variable variable, PsiElement value) {
                if (value instanceof StringLiteralExpression && PhpPsiUtil.getParentByCondition((PsiElement)variable, false, (Condition<? super PsiElement>)StringLiteralExpression.INSTANCEOF, (Condition<? super PsiElement>)Statement.INSTANCEOF) != null) {
                    return ((StringLiteralExpression)value).getContents();
                }
                if (value instanceof NewExpression) {
                    value = PhpCodeEditUtil.parenthesize(value);
                }
                return value.getText();
            }

            public void visitPhpFunctionCall(FunctionReference functionReference) {
                Function function;
                PsiElement resolve2 = functionReference.resolve();
                if (resolve2 instanceof Function && !((function = (Function)resolve2) instanceof Method)) {
                    this.prepareReplacementWithImport((PhpReference)functionReference, (PhpNamedElement)function, usedNames);
                }
                super.visitPhpFunctionCall(functionReference);
            }

            public void visitPhpConstantReference(ConstantReference constantReference) {
                if (!PhpLangUtil.isNull(constantReference)) {
                    PsiElement resolve2 = constantReference.resolve();
                    if (resolve2 instanceof PhpNamedElement) {
                        this.prepareReplacementWithImport((PhpReference)constantReference, (PhpNamedElement)resolve2, usedNames);
                    }
                    super.visitPhpConstantReference(constantReference);
                }
            }

            public void visitPhpClassReference(ClassReference classReference) {
                PsiElement resolve2;
                String name = classReference.getName();
                ASTNode nameNode = classReference.getNameNode();
                if (name != null && nameNode != null && (resolve2 = classReference.resolve()) instanceof PhpClass) {
                    TextRange nameRange = new TextRange(classReference.getTextRange().getStartOffset(), nameNode.getTextRange().getEndOffset());
                    String className = PhpInlineFunctionProcessor.getNameForClassReference((PhpClass)resolve2, scopeHolder);
                    replaceMap.put(document.createRangeMarker(nameRange.shiftLeft(inputData.myFunction.getTextRange().getStartOffset())), className);
                }
                super.visitPhpClassReference(classReference);
            }

            private void prepareReplacementWithImport(PhpReference reference, PhpNamedElement resolve2, Set<String> usedNames2) {
                String notImportedName;
                ASTNode nameNode = reference.getNameNode();
                assert (nameNode != null);
                TextRange nameRange = new TextRange(reference.getTextRange().getStartOffset(), nameNode.getTextRange().getEndOffset());
                String string = notImportedName = resolve2.getNamespaceName().equals(inputData.myFunctionReference.getNamespaceName()) ? resolve2.getName() : resolve2.getFQN();
                if (PhpCodeInsightUtil.isAutoImportEnabled(scopeHolder)) {
                    String importedName;
                    if (namedElementsToImport.add(resolve2)) {
                        String elementName = resolve2.getName();
                        if (usedNames2.contains(elementName)) {
                            String aliasName;
                            importedName = aliasName = this.getAliasName(usedNames2, elementName);
                            aliases.put(resolve2, aliasName);
                        } else {
                            importedName = elementName;
                        }
                    } else {
                        String aliasName = (String)aliases.get(resolve2);
                        importedName = aliasName != null ? aliasName : resolve2.getName();
                    }
                    replaceMap.put(document.createRangeMarker(nameRange.shiftLeft(inputData.myFunction.getTextRange().getStartOffset())), importedName);
                } else {
                    replaceMap.put(document.createRangeMarker(nameRange.shiftLeft(inputData.myFunction.getTextRange().getStartOffset())), notImportedName);
                }
            }

            @Nullable
            String getAliasName(@Nullable Collection<String> usedNames2, @NotNull String name) {
                if (name == null) {
                    6.$$$reportNull$$$0(0);
                }
                if (usedNames2 != null) {
                    Object aliasName = name;
                    int counter = 1;
                    while (usedNames2.contains(aliasName)) {
                        aliasName = name + counter++;
                    }
                    usedNames2.add((String)aliasName);
                    return aliasName;
                }
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/php/refactoring/inline/function/PhpInlineFunctionProcessor$6", "getAliasName"));
            }
        });
    }

    @NotNull
    private static String getNameForClassReference(PhpClass resolve2, PhpPsiElement scopeHolder) {
        String className = PhpCodeInsightUtil.isAutoImportEnabled(scopeHolder) ? resolve2.getName() : (PhpCodeInsightUtil.isSameNamespace(scopeHolder, resolve2.getFQN()) ? resolve2.getName() : resolve2.getFQN());
        String string = className;
        if (string == null) {
            PhpInlineFunctionProcessor.$$$reportNull$$$0(24);
        }
        return string;
    }

    @NotNull
    private static Set<String> collectUsedNames(PhpPsiElement scopeHolder) {
        HashSet<String> usedNames = new HashSet<String>();
        List<PhpUseList> useLists = null;
        if (scopeHolder != null) {
            useLists = PhpCodeInsightUtil.collectImports(scopeHolder);
        }
        if (useLists != null) {
            for (PhpUseList list : useLists) {
                PhpUse[] declarations;
                for (PhpUse declaration : declarations = list.getDeclarations()) {
                    String name = declaration.getName();
                    String aliasName = declaration.getAliasName();
                    if (aliasName != null) {
                        usedNames.add(aliasName);
                        continue;
                    }
                    usedNames.add(name);
                }
            }
        }
        HashSet<String> hashSet = usedNames;
        if (hashSet == null) {
            PhpInlineFunctionProcessor.$$$reportNull$$$0(25);
        }
        return hashSet;
    }

    public static String getUniqueName(PsiElement position, String variableName, Set<? extends Parameter> parameters) {
        Set<? extends PhpNamedElement> declarations = VariableImpl.collectDeclarations(position, false, null);
        Set<String> usedNames = declarations.stream().map(element -> element.getName()).collect(Collectors.toSet());
        Set strings = ContainerUtil.map2Set(parameters, e -> e.getName());
        usedNames.addAll(strings);
        SmartList name = new SmartList((Object)variableName);
        PhpNameUtil.unique((List<String>)name, usedNames);
        return (String)name.get(0);
    }

    public static void importIfNeeded(@NotNull PhpPsiElement scopeForUseOperator, PhpNamedElement namedElement, String alias) {
        String fqn;
        if (scopeForUseOperator == null) {
            PhpInlineFunctionProcessor.$$$reportNull$$$0(26);
        }
        if (PhpCodeInsightUtil.isSameNamespace(scopeForUseOperator, fqn = namedElement.getFQN())) {
            return;
        }
        String importKeyword = null;
        if (namedElement instanceof Function) {
            importKeyword = "function";
        } else if (namedElement instanceof Constant) {
            importKeyword = "const";
        }
        PhpAliasImporter.insertUseStatementWithKeyword(importKeyword, fqn, alias, scopeForUseOperator);
    }

    public Collection<TextRange> doReplacement(@NotNull FunctionReference functionReference, boolean inlineThisOnly) {
        if (functionReference == null) {
            PhpInlineFunctionProcessor.$$$reportNull$$$0(27);
        }
        Document document = PsiDocumentManager.getInstance((Project)this.myProject).getDocument(functionReference.getContainingFile());
        Map<Integer, String> guardingAssignments = PhpInlineFunctionProcessor.createAssignmentsHeader(this.myFunction, functionReference);
        InlineInputData inputData = new InlineInputData(functionReference, this.myFunction);
        ReplacementData functionReplacement = this.createReplacement(inputData, guardingAssignments, inlineThisOnly);
        Statement statement = PhpPsiUtil.getParentOfClass((PsiElement)functionReference, Statement.class);
        PhpPsiElement scopeHolder = PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)functionReference);
        assert (statement != null && document != null && scopeHolder != null);
        this.referenceResolver.processElement((PsiElement)this.myFunction);
        for (PhpNamedElement namedElement : functionReplacement.myNamedElementsToImport) {
            PhpInlineFunctionProcessor.importIfNeeded(scopeHolder, namedElement, functionReplacement.myAliases.get(namedElement));
        }
        Set<String> parameterNamesPassedByRef = this.getParameterNamesPassedByRef(inputData);
        Set variablesWithUsedNames = (Set)((StreamEx)StreamEx.of(VariableImpl.collectDeclarations((PsiElement)functionReference, false, null)).map(PsiNamedElement::getName).filter((Predicate)Predicates.not(parameterNamesPassedByRef::contains))).collect(PhpStringUtil.toCaseInsensitiveSet());
        PsiElement parent = statement.getParent();
        Collection rangeToReformat = functionReplacement.myGuardingAssignemnts.stream().map(it -> parent.addBefore((PsiElement)it, (PsiElement)statement)).map(PsiElement::getTextRange).collect(Collectors.toList());
        Collection<PsiElement> replacedStatements = PhpInlineFunctionProcessor.replaceStatements(functionReference, functionReplacement, statement, parent, rangeToReformat);
        this.renameVariablesWithWriteAccessToUniqueNames(PhpInlineFunctionProcessor.getReplacedVariablesGroupedByName(replacedStatements, variablesWithUsedNames));
        this.referenceResolver.importReferences(scopeHolder, parent);
        return rangeToReformat;
    }

    @NotNull
    private Set<String> getParameterNamesPassedByRef(InlineInputData inputData) {
        Set<String> parameterNamesPassedByRef = PhpStringUtil.createCaseInsensitiveSet();
        Parameter[] parameters = this.myFunction.getParameters();
        for (int i = 0; i < inputData.parameterExpressions.length; ++i) {
            Variable parameterExpression;
            if (i >= parameters.length || (parameterExpression = (Variable)ObjectUtils.tryCast((Object)inputData.parameterExpressions[i], Variable.class)) == null || !parameters[i].isPassByRef()) continue;
            parameterNamesPassedByRef.add(parameterExpression.getName());
        }
        Set<String> set = parameterNamesPassedByRef;
        if (set == null) {
            PhpInlineFunctionProcessor.$$$reportNull$$$0(28);
        }
        return set;
    }

    @NotNull
    private static Collection<PsiElement> replaceStatements(@NotNull FunctionReference functionReference, ReplacementData functionReplacement, Statement statement, PsiElement parent, Collection<TextRange> rangeToReformat) {
        if (functionReference == null) {
            PhpInlineFunctionProcessor.$$$reportNull$$$0(29);
        }
        ArrayList<PsiElement> replacedStatements = new ArrayList<PsiElement>(functionReplacement.myFunctionStatements.size() + 1);
        if (!functionReplacement.myFunctionStatements.isEmpty()) {
            for (PsiElement it : functionReplacement.myFunctionStatements) {
                replacedStatements.add(parent.addBefore(it, (PsiElement)statement));
            }
        }
        if (functionReplacement.myIsReturn && functionReplacement.myExpressionToInline != null) {
            PsiElement replacedExpression = PhpInlineFunctionProcessor.replaceFunctionReference(functionReference, functionReplacement.myExpressionToInline);
            rangeToReformat.add(replacedExpression.getTextRange());
            replacedStatements.add(replacedExpression);
        } else if (functionReplacement.myExpressionToInline == null) {
            statement.delete();
        }
        ArrayList<PsiElement> arrayList = replacedStatements;
        if (arrayList == null) {
            PhpInlineFunctionProcessor.$$$reportNull$$$0(30);
        }
        return arrayList;
    }

    private static PsiElement replaceFunctionReference(@NotNull FunctionReference functionReference, @NotNull PsiElement toInline) {
        if (functionReference == null) {
            PhpInlineFunctionProcessor.$$$reportNull$$$0(31);
        }
        if (toInline == null) {
            PhpInlineFunctionProcessor.$$$reportNull$$$0(32);
        }
        if (PhpInlineFunctionProcessor.isInterpolationReference((PhpReference)functionReference)) {
            return functionReference.replace(toInline);
        }
        PsiElement parenthesized = functionReference.replace((PsiElement)PhpCodeEditUtil.parenthesize(toInline));
        if (PhpUnnecessaryParenthesesInspection.isParensUnnecessary((ParenthesizedExpression)parenthesized)) {
            return parenthesized.replace(toInline);
        }
        return parenthesized;
    }

    private void renameVariablesWithWriteAccessToUniqueNames(MultiMap<String, Variable> variablesMap) {
        for (Map.Entry entry : variablesMap.entrySet()) {
            Collection variables = (Collection)entry.getValue();
            Map<Variable, PhpAccessVariableInstruction> instructions = variables.stream().map(v -> Pair.create((Object)v, (Object)PhpControlFlowUtil.getAccessInstruction((PhpPsiElement)v, PhpAccessVariableInstruction.class))).filter(i -> i.getSecond() != null).collect(Collectors.toMap(i -> (Variable)i.getFirst(), i -> (PhpAccessVariableInstruction)i.getSecond()));
            Optional<PhpAccessVariableInstruction> firstWriteAccess = instructions.values().stream().filter(i -> i.getAccess().isWrite()).min(Comparator.comparingInt(PhpInstruction::num));
            if (firstWriteAccess.isEmpty()) continue;
            String uniqueName = PhpInlineFunctionProcessor.getUniqueName((PsiElement)ContainerUtil.getFirstItem((Collection)variables), (String)entry.getKey(), Collections.emptySet());
            Variable variableForReplacement = PhpPsiElementFactory.createVariable(this.myProject, uniqueName, true);
            int firstWriteInstructionNum = firstWriteAccess.get().num();
            instructions.entrySet().stream().filter(e -> ((PhpAccessVariableInstruction)e.getValue()).num() >= firstWriteInstructionNum).forEach(e -> ((Variable)e.getKey()).replace((PsiElement)variableForReplacement));
        }
    }

    @NotNull
    private static MultiMap<String, Variable> getReplacedVariablesGroupedByName(Collection<PsiElement> replacedStatements, Collection<String> variableNames) {
        MultiMap replacedVariablesWithExistingNames = MultiMap.create();
        for (PsiElement replacedStatement : replacedStatements) {
            if (!replacedStatement.isValid()) continue;
            PsiTreeUtil.findChildrenOfAnyType((PsiElement)replacedStatement, (boolean)false, (Class[])new Class[]{Variable.class}).stream().filter(v -> variableNames.contains(v.getName())).forEach(v -> replacedVariablesWithExistingNames.putValue((Object)v.getName(), v));
        }
        MultiMap multiMap = replacedVariablesWithExistingNames;
        if (multiMap == null) {
            PhpInlineFunctionProcessor.$$$reportNull$$$0(33);
        }
        return multiMap;
    }

    public static void commitAndFormat(@NotNull Project project, PsiFile file, Collection<? extends TextRange> rangeToReformat) {
        Document document;
        if (project == null) {
            PhpInlineFunctionProcessor.$$$reportNull$$$0(34);
        }
        if ((document = PsiDocumentManager.getInstance((Project)project).getDocument(file)) != null) {
            PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(document);
            PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(document);
            if (rangeToReformat != null) {
                rangeToReformat.forEach(range -> CodeStyleManager.getInstance((Project)project).reformatText(file, range.getStartOffset(), range.getEndOffset()));
            }
        }
    }

    @NotNull
    String getElementDescription() {
        String string = PhpInlineFunctionPresenter.getElementDescription(this.myFunction, false);
        if (string == null) {
            PhpInlineFunctionProcessor.$$$reportNull$$$0(35);
        }
        return string;
    }

    private static /* synthetic */ void lambda$createReplacement$7(Document document, RangeMarker e, String v) {
        document.replaceString(e.getStartOffset(), e.getEndOffset(), (CharSequence)v);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 4, 8, 9, 12, 21, 24, 25, 28, 30, 33, 35 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 9: 
            case 12: 
            case 21: 
            case 24: 
            case 25: 
            case 28: 
            case 30: 
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/inline/function/PhpInlineFunctionProcessor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refUsages";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionReferences";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 11: 
            case 18: 
            case 27: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionReference";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputData";
                break;
            }
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "guardingAssignments";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeForUseOperator";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toInline";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/inline/function/PhpInlineFunctionProcessor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getLastChainMember";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createAssignmentsHeader";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "collectAssignmentStatements";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameForClassReference";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "collectUsedNames";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterNamesPassedByRef";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceStatements";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getReplacedVariablesGroupedByName";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 9: 
            case 12: 
            case 21: 
            case 24: 
            case 25: 
            case 28: 
            case 30: 
            case 33: 
            case 35: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "preprocessUsages";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFirstFunctionReference";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getLastChainMember";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createAssignmentsHeader";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "makeStatic";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createVariable";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "introduceVariableIfNeeded";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isInterpolationReference";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isInsideSimpleStatement";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "collectAssignmentStatements";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getAssignmentStatement";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "importIfNeeded";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "doReplacement";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "replaceStatements";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "replaceFunctionReference";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "commitAndFormat";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 4, 8, 9, 12, 21, 24, 25, 28, 30, 33, 35 -> new IllegalStateException(string);
        };
    }
}

