/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.inline;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.tree.IElementType;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpEntryPointInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpAccessVariableInstructionImpl;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.annotator.PhpAnnotatorVisitor;
import com.jetbrains.php.lang.inspections.controlFlow.PhpUnusedLocalVariableInspection;
import com.jetbrains.php.lang.intentions.PhpReplaceQuotesIntention;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.ConcatenationExpression;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParenthesizedExpression;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.SelfAssignmentExpression;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.refactoring.PhpRefactoringErrorException;
import com.jetbrains.php.refactoring.PhpRefactoringSettings;
import com.jetbrains.php.refactoring.inline.PhpInlineActionHandler;
import com.jetbrains.php.refactoring.inline.PhpInlineVariableDialog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpInlineVariableHandler
extends PhpInlineActionHandler {
    public static final String REFACTORING_HELP_ID = "refactoring.inlineVariable";
    public static final String FEATURE_ID = "refactoring.inlineVariable";

    private static boolean isClosedDoubleQuotedString(@NotNull StringLiteralExpression stringLiteralExpression) {
        if (stringLiteralExpression == null) {
            PhpInlineVariableHandler.$$$reportNull$$$0(0);
        }
        PsiElement lastChild = stringLiteralExpression.getLastChild();
        return PhpPsiUtil.isOfType(lastChild, PhpTokenTypes.chRDOUBLE_QUOTE);
    }

    private static boolean isClosedHeredoc(@NotNull StringLiteralExpression stringLiteralExpression) {
        if (stringLiteralExpression == null) {
            PhpInlineVariableHandler.$$$reportNull$$$0(1);
        }
        PsiElement lastChild = stringLiteralExpression.getLastChild();
        return PhpPsiUtil.isOfType(lastChild, PhpTokenTypes.HEREDOC_END);
    }

    public boolean canInlineElement(PsiElement element) {
        return element instanceof Variable && ((Variable)element).canReadName() || element instanceof Parameter;
    }

    public void inlineElement(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            PhpInlineVariableHandler.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            PhpInlineVariableHandler.$$$reportNull$$$0(3);
        }
        if (element == null) {
            PhpInlineVariableHandler.$$$reportNull$$$0(4);
        }
        try {
            FeatureUsageTracker.getInstance().triggerFeatureUsed("refactoring.inlineVariable");
            PhpInlineVariableHandler.invoke(project, editor);
        }
        catch (PhpRefactoringErrorException e) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)RefactoringBundle.getCannotRefactorMessage((String)e.getMessage()), (String)PhpBundle.message("dialog.title.inline.variable", new Object[0]), (String)"refactoring.inlineVariable");
        }
    }

    public static void invoke(@NotNull Project project, @NotNull Editor editor) throws PhpRefactoringErrorException {
        PsiReference psiReference;
        if (project == null) {
            PhpInlineVariableHandler.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            PhpInlineVariableHandler.$$$reportNull$$$0(6);
        }
        if (!((psiReference = TargetElementUtil.findReference((Editor)editor)) instanceof Variable)) {
            throw new PhpRefactoringErrorException(PhpBundle.message("refactoring.inline.cannot.find.variable.to.inline", new Object[0]));
        }
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        }
        PhpInlineVariableHandler.invoke(project, editor, (Variable)psiReference);
    }

    public static void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull Variable variable) throws PhpRefactoringErrorException {
        int i;
        boolean deleteInitializer;
        CharSequence variableName;
        if (project == null) {
            PhpInlineVariableHandler.$$$reportNull$$$0(7);
        }
        if (variable == null) {
            PhpInlineVariableHandler.$$$reportNull$$$0(8);
        }
        if ((variableName = variable.getNameCS()).isEmpty()) {
            return;
        }
        PhpAccessVariableInstruction accessVariableInstruction = PhpControlFlowUtil.getAccessInstruction((PhpPsiElement)variable, PhpAccessVariableInstruction.class);
        if (accessVariableInstruction == null) {
            return;
        }
        List<PhpAccessVariableInstruction> latestWriteAccesses = PhpInlineVariableHandler.getLatestVariableWriteAccess(accessVariableInstruction);
        if (latestWriteAccesses.size() != 1) {
            throw new PhpRefactoringErrorException(RefactoringBundle.message((String)"variable.has.no.dominating.definition"));
        }
        PhpAccessVariableInstruction latestWriteAccess = latestWriteAccesses.get(0);
        Ref initializerRef = new Ref();
        Ref valueRef = new Ref();
        PhpPsiElement writeVariable = latestWriteAccess.getAnchor();
        PsiElement parent = writeVariable.getParent();
        PhpAccessInstruction.Access access = latestWriteAccess.getAccess();
        if (access.isReadRef() || access.isReadWrite() || access.isWriteRef()) {
            throw new PhpRefactoringErrorException(PhpBundle.message("refactoring.inline.variable.cannot.extract.value", variableName));
        }
        if (parent instanceof AssignmentExpression) {
            if (PhpElementTypes.MULTIASSIGNMENT_EXPRESSION == parent.getNode().getElementType()) {
                throw new PhpRefactoringErrorException(PhpBundle.message("refactoring.inline.variable.cannot.extract.value", variableName));
            }
            if (parent instanceof SelfAssignmentExpression) {
                valueRef.set((Object)PhpUnusedLocalVariableInspection.createBinaryOperationFromSelfAssignment((SelfAssignmentExpression)parent));
                initializerRef.set((Object)((SelfAssignmentExpression)parent));
            } else {
                valueRef.set((Object)((AssignmentExpression)parent).getValue());
                initializerRef.set((Object)((AssignmentExpression)parent));
            }
        }
        if (valueRef.isNull()) {
            throw new PhpRefactoringErrorException(PhpBundle.message("refactoring.inline.variable.cannot.extract.value", variableName));
        }
        List<PhpAccessVariableInstruction> followingReadAccesses = PhpInlineVariableHandler.getFollowingVariableReadAccess(latestWriteAccess);
        int readAccessSizeBeforeFiltering = followingReadAccesses.size();
        for (int i2 = followingReadAccesses.size() - 1; i2 >= 0; --i2) {
            PhpAccessVariableInstruction readAccess = followingReadAccesses.get(i2);
            if (!PhpInlineVariableHandler.isPossibleToInline(readAccess, PhpPsiUtil.unparenthesize((PsiElement)valueRef.get()))) {
                followingReadAccesses.remove(i2);
                continue;
            }
            List<PhpAccessVariableInstruction> writeAccesses = PhpInlineVariableHandler.getLatestVariableWriteAccess(readAccess);
            if (writeAccesses.size() != 1) {
                followingReadAccesses.remove(i2);
            }
            if (!PhpInlineVariableHandler.isInvalidInliningToUnaryOperation(latestWriteAccess, readAccess)) continue;
            throw new PhpRefactoringErrorException(PhpBundle.message("refactoring.inline.variable.unary.operation", new Object[0]));
        }
        if (accessVariableInstruction == latestWriteAccess) {
            if (followingReadAccesses.isEmpty()) {
                throw new PhpRefactoringErrorException(PhpBundle.message("refactoring.inline.variable.no.occurrences", new Object[0]));
            }
        } else if (!followingReadAccesses.contains(accessVariableInstruction)) {
            throw new PhpRefactoringErrorException(PhpBundle.message("refactoring.inline.variable.no.occurrences", variableName));
        }
        HighlightManager highlightManager = HighlightManager.getInstance((Project)project);
        PhpScopeHolder scopeHolder = PhpPsiUtil.getScopeHolder((PsiElement)variable);
        boolean bl = deleteInitializer = scopeHolder != null && !PhpInlineVariableHandler.isReferenced(scopeHolder, latestWriteAccess) && readAccessSizeBeforeFiltering == followingReadAccesses.size();
        if (PhpInlineVariableHandler.editorIsAvailable(editor)) {
            boolean hasOccurrencesToReplace;
            highlightManager.addOccurrenceHighlights(editor, new PsiElement[]{latestWriteAccess.getAnchor()}, EditorColors.WRITE_SEARCH_RESULT_ATTRIBUTES, true, null);
            Variable[] occurrences = new Variable[followingReadAccesses.size()];
            for (i = 0; i < followingReadAccesses.size(); ++i) {
                occurrences[i] = followingReadAccesses.get(i).getAnchor();
            }
            highlightManager.addOccurrenceHighlights(editor, (PsiElement[])occurrences, EditorColors.SEARCH_RESULT_ATTRIBUTES, true, null);
            boolean invokedOnReference = followingReadAccesses.contains(accessVariableInstruction);
            boolean bl2 = hasOccurrencesToReplace = deleteInitializer || occurrences.length > 1;
            if (invokedOnReference && hasOccurrencesToReplace) {
                if (EditorSettingsExternalizable.getInstance().isShowInlineLocalDialog()) {
                    PhpInlineVariableDialog dialog = new PhpInlineVariableDialog(project, variable, occurrences.length);
                    if (!dialog.showAndGet()) {
                        PhpInlineVariableHandler.showAdviseToRemoveHighlighting(project);
                        return;
                    }
                    if (dialog.isInlineThis()) {
                        PhpInlineVariableHandler.replaceInstructionsWithOnlyCurrent(accessVariableInstruction, followingReadAccesses);
                        deleteInitializer = false;
                    }
                } else if (PhpRefactoringSettings.getInstance().INLINE_LOCAL_THIS) {
                    PhpInlineVariableHandler.replaceInstructionsWithOnlyCurrent(accessVariableInstruction, followingReadAccesses);
                    deleteInitializer = false;
                }
            }
        } else if (ApplicationManager.getApplication().isUnitTestMode() && PhpRefactoringSettings.getInstance().INLINE_LOCAL_THIS) {
            PhpInlineVariableHandler.replaceInstructionsWithOnlyCurrent(accessVariableInstruction, followingReadAccesses);
            deleteInitializer = false;
        }
        MultiMap variablesInString = new MultiMap();
        for (i = followingReadAccesses.size() - 1; i >= 0; --i) {
            PhpAccessVariableInstruction readAccess = followingReadAccesses.get(i);
            PhpPsiElement anchor = readAccess.getAnchor();
            StringLiteralExpression stringParent = PhpPsiUtil.getParentOfClass((PsiElement)anchor, StringLiteralExpression.class);
            if (stringParent == null) continue;
            followingReadAccesses.remove(i);
            variablesInString.putValue((Object)stringParent, (Object)((Variable)anchor));
        }
        Object[] replacedOccurrences = new SmartPsiElementPointer[followingReadAccesses.size() + variablesInString.size()];
        boolean finalDeleteInitializer = deleteInitializer;
        Runnable runnable = () -> PhpInlineVariableHandler.lambda$invoke$0(project, followingReadAccesses, valueRef, (SmartPsiElementPointer[])replacedOccurrences, variablesInString, finalDeleteInitializer, initializerRef);
        if (IntentionPreviewUtils.isPreviewElement((PsiElement)variable)) {
            runnable.run();
        } else {
            CommandProcessor.getInstance().executeCommand(project, () -> ApplicationManager.getApplication().runWriteAction(runnable), RefactoringBundle.message((String)"inline.command", (Object[])new Object[]{variableName}), null);
            if (PhpInlineVariableHandler.editorIsAvailable(editor)) {
                PsiElement[] elementsToHighlight = (PsiElement[])ContainerUtil.mapNotNull((Object[])replacedOccurrences, r -> r.getElement(), (Object[])PsiElement.EMPTY_ARRAY);
                highlightManager.addOccurrenceHighlights(editor, elementsToHighlight, EditorColors.SEARCH_RESULT_ATTRIBUTES, true, null);
                PhpInlineVariableHandler.showAdviseToRemoveHighlighting(project);
            }
        }
    }

    private static PsiElement replaceSelfAssigment(@NotNull PsiElement expression, @NotNull SelfAssignmentExpression selfAssigment) {
        if (expression == null) {
            PhpInlineVariableHandler.$$$reportNull$$$0(9);
        }
        if (selfAssigment == null) {
            PhpInlineVariableHandler.$$$reportNull$$$0(10);
        }
        PhpPsiElement variable = selfAssigment.getVariable();
        PsiElement operation = selfAssigment.getOperation();
        PhpPsiElement value = selfAssigment.getValue();
        if (variable == null || operation == null || value == null) {
            return selfAssigment;
        }
        value = PhpInlineVariableHandler.parenthesizedIfNeeded((PsiElement)selfAssigment.getValue(), variable);
        String operationText = StringUtil.trimEnd((String)operation.getText(), (char)'=');
        String newExpressionText = String.format("%s = %s %s %s;", variable.getText(), expression.getText(), operationText, value.getText());
        AssignmentExpression newExpression = PhpPsiElementFactory.createPhpPsiFromText(expression.getProject(), AssignmentExpression.class, newExpressionText);
        return selfAssigment.replace((PsiElement)newExpression);
    }

    public static PsiElement parenthesizedIfNeeded(@NotNull PsiElement expression, @NotNull PhpPsiElement anchor) {
        if (expression == null) {
            PhpInlineVariableHandler.$$$reportNull$$$0(11);
        }
        if (anchor == null) {
            PhpInlineVariableHandler.$$$reportNull$$$0(12);
        }
        if (PhpCodeEditUtil.needToParenthesizeWhenReplace((PsiElement)anchor, expression)) {
            return PhpCodeEditUtil.parenthesize(expression);
        }
        return expression;
    }

    private static boolean isReferenced(@NotNull PhpScopeHolder scopeHolder, @NotNull PhpAccessVariableInstruction accessInstruction) {
        if (scopeHolder == null) {
            PhpInlineVariableHandler.$$$reportNull$$$0(13);
        }
        if (accessInstruction == null) {
            PhpInlineVariableHandler.$$$reportNull$$$0(14);
        }
        if (accessInstruction.getAccess().isWriteRef()) {
            return true;
        }
        Function function = (Function)ObjectUtils.tryCast((Object)scopeHolder, Function.class);
        Variable variable = (Variable)ObjectUtils.tryCast((Object)accessInstruction.getAnchor(), Variable.class);
        if (function == null || variable == null) {
            return false;
        }
        if (!variable.canReadName()) {
            return false;
        }
        if (PhpControlFlowUtil.isReferencedInUseList(function, variable) || PhpControlFlowUtil.isPassByRefParameter(variable)) {
            return true;
        }
        if (!PhpControlFlowUtil.hasPredecessorWithRefAccess(accessInstruction, variable).booleanValue()) {
            return false;
        }
        return PhpInlineVariableHandler.hasWriteRefInScope(scopeHolder);
    }

    private static boolean hasWriteRefInScope(@NotNull PhpScopeHolder scopeHolder) {
        if (scopeHolder == null) {
            PhpInlineVariableHandler.$$$reportNull$$$0(15);
        }
        return StreamEx.of((Object[])scopeHolder.getControlFlow().getInstructions()).select(PhpAccessInstruction.class).anyMatch(instruction -> instruction.getAccess().isWriteRef());
    }

    private static void replaceInstructionsWithOnlyCurrent(PhpAccessVariableInstruction accessVariableInstruction, List<PhpAccessVariableInstruction> followingReadAccesses) {
        followingReadAccesses.clear();
        followingReadAccesses.add(accessVariableInstruction);
    }

    private static void showAdviseToRemoveHighlighting(@NotNull Project project) {
        if (project == null) {
            PhpInlineVariableHandler.$$$reportNull$$$0(16);
        }
        WindowManager.getInstance().getStatusBar(project).setInfo(RefactoringBundle.message((String)"press.escape.to.remove.the.highlighting"));
    }

    private static boolean editorIsAvailable(@Nullable Editor editor) {
        return editor != null && !ApplicationManager.getApplication().isUnitTestMode();
    }

    private static boolean isPossibleToInline(@NotNull PhpAccessVariableInstruction instruction, @NotNull PsiElement value) {
        IElementType variableParentType;
        PhpPsiElement anchor;
        if (instruction == null) {
            PhpInlineVariableHandler.$$$reportNull$$$0(17);
        }
        if (value == null) {
            PhpInlineVariableHandler.$$$reportNull$$$0(18);
        }
        if (!((anchor = instruction.getAnchor()) instanceof Variable)) {
            return false;
        }
        if (instruction.getAccess().isLightRead()) {
            return false;
        }
        PsiElement variableParent = anchor.getParent();
        if (variableParent instanceof Variable || variableParent instanceof PhpUseList) {
            return false;
        }
        StringLiteralExpression parentString = PhpPsiUtil.getParentOfClass(variableParent, false, StringLiteralExpression.class);
        if (variableParent instanceof MemberReference) {
            if (((MemberReference)variableParent).getClassReference() != anchor || value instanceof StringLiteralExpression) {
                return false;
            }
        } else {
            if (variableParent instanceof FunctionReference) {
                return false;
            }
            if (variableParent instanceof ClassReference) {
                return false;
            }
            if (variableParent instanceof AssignmentExpression) {
                return !PhpWorkaroundUtil.isAssignByReference((AssignmentExpression)variableParent);
            }
        }
        if (PhpElementTypes.tsARRAY_EXPRESSIONS.contains(variableParentType = variableParent.getNode().getElementType())) {
            return PhpLanguageFeature.ARRAY_DEREFERENCING.isSupported(value.getProject()) || !(value instanceof FunctionReference);
        }
        if (parentString != null) {
            IElementType parentType = parentString.getNode().getElementType();
            if (PhpElementTypes.HEREDOC.equals(parentType) && PhpInlineVariableHandler.isClosedHeredoc(parentString) || PhpElementTypes.STRING.equals(parentType) && PhpInlineVariableHandler.isClosedDoubleQuotedString(parentString)) {
                if (value instanceof StringLiteralExpression) {
                    return value.getChildren().length == 0;
                }
                return !PhpPsiUtil.isOfType(value, PhpElementTypes.FUNCTION_CALL, PhpElementTypes.NEW_EXPRESSION, PhpElementTypes.CLOSURE);
            }
            return false;
        }
        return true;
    }

    private static PsiElement replaceVariableInString(@NotNull StringLiteralExpression stringLiteral, @NotNull Collection<Variable> variables, @NotNull PsiElement value) {
        if (stringLiteral == null) {
            PhpInlineVariableHandler.$$$reportNull$$$0(19);
        }
        if (variables == null) {
            PhpInlineVariableHandler.$$$reportNull$$$0(20);
        }
        if (value == null) {
            PhpInlineVariableHandler.$$$reportNull$$$0(21);
        }
        String parentText = stringLiteral.getText();
        int parentStartOffset = stringLiteral.getTextRange().getStartOffset();
        StringBuilder builder2 = new StringBuilder();
        int lastEnd = 0;
        ArrayList<Variable> sortedVariables = new ArrayList<Variable>(variables);
        ContainerUtil.sort(sortedVariables, Comparator.comparing(v -> PhpInlineVariableHandler.getVariableRange(parentStartOffset, (PsiElement)v), Comparator.comparingInt(TextRange::getStartOffset)));
        for (Variable variable : sortedVariables) {
            builder2.append(parentText, lastEnd, PhpInlineVariableHandler.getVariableRange(parentStartOffset, PhpInlineVariableHandler.findTopmostVariable((PsiElement)variable)).getStartOffset());
            lastEnd = PhpInlineVariableHandler.processVariableInString(variable, value, stringLiteral, builder2);
        }
        builder2.append(parentText, lastEnd, parentText.length());
        PhpExpression newStringLiteral = PhpPsiElementFactory.createPhpPsiFromText(stringLiteral.getProject(), PhpExpression.class, builder2.toString());
        return stringLiteral.replace((PsiElement)newStringLiteral);
    }

    private static int processVariableInString(@NotNull Variable variable, @NotNull PsiElement value, @NotNull StringLiteralExpression sourceExpression, @NotNull StringBuilder builder2) {
        if (variable == null) {
            PhpInlineVariableHandler.$$$reportNull$$$0(22);
        }
        if (value == null) {
            PhpInlineVariableHandler.$$$reportNull$$$0(23);
        }
        if (sourceExpression == null) {
            PhpInlineVariableHandler.$$$reportNull$$$0(24);
        }
        if (builder2 == null) {
            PhpInlineVariableHandler.$$$reportNull$$$0(25);
        }
        int sourceStartOffset = sourceExpression.getTextRange().getStartOffset();
        TextRange innerVariableRange = PhpInlineVariableHandler.getVariableRange(sourceStartOffset, (PsiElement)variable);
        String sourceText = sourceExpression.getText();
        String stringValue = PhpCodeInsightUtil.toString(value);
        if (stringValue != null) {
            if (value instanceof StringLiteralExpression && ((StringLiteralExpression)value).isSingleQuote()) {
                stringValue = PhpReplaceQuotesIntention.escapeString(stringValue, '\"', '\'');
            }
            builder2.append(stringValue);
            return innerVariableRange.getEndOffset();
        }
        if (PhpInlineVariableHandler.isPossibleToUseCurlySyntax(value)) {
            return PhpInlineVariableHandler.addValueUsingCurlySyntax(value, sourceText, builder2, variable, sourceStartOffset, innerVariableRange);
        }
        ConcatenationExpression concat = (ConcatenationExpression)ObjectUtils.tryCast((Object)value, ConcatenationExpression.class);
        if (concat != null) {
            if (concat.getLeftOperand() != null) {
                PhpInlineVariableHandler.processVariableInString(variable, concat.getLeftOperand(), sourceExpression, builder2);
            }
            if (concat.getRightOperand() != null) {
                PhpInlineVariableHandler.processVariableInString(variable, concat.getRightOperand(), sourceExpression, builder2);
            }
            return innerVariableRange.getEndOffset();
        }
        return PhpInlineVariableHandler.addValueUsingConcatenation(builder2, value, innerVariableRange);
    }

    private static boolean isPossibleToUseCurlySyntax(@NotNull PsiElement value) {
        if (value == null) {
            PhpInlineVariableHandler.$$$reportNull$$$0(26);
        }
        return value instanceof Variable || value instanceof FieldReference || value instanceof MethodReference;
    }

    private static int addValueUsingConcatenation(@NotNull StringBuilder builder2, @NotNull PsiElement value, @NotNull TextRange innerVariableRange) {
        if (builder2 == null) {
            PhpInlineVariableHandler.$$$reportNull$$$0(27);
        }
        if (value == null) {
            PhpInlineVariableHandler.$$$reportNull$$$0(28);
        }
        if (innerVariableRange == null) {
            PhpInlineVariableHandler.$$$reportNull$$$0(29);
        }
        boolean isNeedToParenthesize = value instanceof PhpExpression && !(value instanceof ParenthesizedExpression) && !(value instanceof StringLiteralExpression);
        builder2.append("\" . ");
        if (isNeedToParenthesize) {
            builder2.append("(");
        }
        builder2.append(value.getText());
        if (isNeedToParenthesize) {
            builder2.append(")");
        }
        builder2.append(" .\"");
        return innerVariableRange.getEndOffset();
    }

    private static int addValueUsingCurlySyntax(@NotNull PsiElement value, @NotNull String parentText, @NotNull StringBuilder builder2, @NotNull Variable variable, int parentStartOffset, @NotNull TextRange innerVariableRange) {
        if (value == null) {
            PhpInlineVariableHandler.$$$reportNull$$$0(30);
        }
        if (parentText == null) {
            PhpInlineVariableHandler.$$$reportNull$$$0(31);
        }
        if (builder2 == null) {
            PhpInlineVariableHandler.$$$reportNull$$$0(32);
        }
        if (variable == null) {
            PhpInlineVariableHandler.$$$reportNull$$$0(33);
        }
        if (innerVariableRange == null) {
            PhpInlineVariableHandler.$$$reportNull$$$0(34);
        }
        PsiElement topmostVariable = PhpInlineVariableHandler.findTopmostVariable((PsiElement)variable);
        TextRange topmostVariableRange = PhpInlineVariableHandler.getVariableRange(parentStartOffset, topmostVariable);
        builder2.append("{");
        builder2.append(value.getText());
        TextRange tailRange = TextRange.create((int)innerVariableRange.getEndOffset(), (int)topmostVariableRange.getEndOffset());
        if (!tailRange.isEmpty()) {
            int endOffsetOfTopmostVariableContent = PhpPsiUtil.isOfType(topmostVariable.getLastChild(), PhpTokenTypes.chRBRACE) ? tailRange.getEndOffset() - 1 : tailRange.getEndOffset();
            builder2.append(parentText, tailRange.getStartOffset(), endOffsetOfTopmostVariableContent);
        }
        builder2.append("}");
        return tailRange.getEndOffset();
    }

    @NotNull
    private static PsiElement findTopmostVariable(@NotNull PsiElement variable) {
        if (variable == null) {
            PhpInlineVariableHandler.$$$reportNull$$$0(35);
        }
        while (!(variable.getParent() instanceof StringLiteralExpression)) {
            variable = variable.getParent();
        }
        PsiElement psiElement = variable;
        if (psiElement == null) {
            PhpInlineVariableHandler.$$$reportNull$$$0(36);
        }
        return psiElement;
    }

    @NotNull
    private static TextRange getVariableRange(int parentStartOffset, PsiElement variable) {
        TextRange textRange = variable.getTextRange().shiftLeft(parentStartOffset);
        if (textRange == null) {
            PhpInlineVariableHandler.$$$reportNull$$$0(37);
        }
        return textRange;
    }

    private static List<PhpAccessVariableInstruction> getLatestVariableWriteAccess(@NotNull PhpAccessVariableInstruction instruction) {
        if (instruction == null) {
            PhpInlineVariableHandler.$$$reportNull$$$0(38);
        }
        final CharSequence variableName = instruction.getVariableName();
        final ArrayList<PhpAccessVariableInstruction> latestWriteAccess = new ArrayList<PhpAccessVariableInstruction>();
        final Ref isEntryPointReached = new Ref((Object)false);
        PhpControlFlowUtil.processPredecessors((PhpInstruction)instruction, true, new PhpInstructionProcessor(){

            public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                PhpAccessInstruction.Access access = instruction.getAccess();
                if (PhpLangUtil.equalsVariableNames(variableName, instruction.getVariableName()) && (access.isWrite() || access.isWriteRef() || access.isReadWrite() || access.isReadRef())) {
                    latestWriteAccess.add(instruction);
                    return false;
                }
                return true;
            }

            public boolean processEntryPointInstruction(PhpEntryPointInstruction instruction) {
                isEntryPointReached.set((Object)true);
                return false;
            }
        });
        if (latestWriteAccess.isEmpty() || ((Boolean)isEntryPointReached.get()).booleanValue()) {
            return Collections.emptyList();
        }
        return latestWriteAccess;
    }

    private static List<PhpAccessVariableInstruction> getFollowingVariableReadAccess(@NotNull PhpAccessVariableInstruction instruction) {
        if (instruction == null) {
            PhpInlineVariableHandler.$$$reportNull$$$0(39);
        }
        final CharSequence variableName = instruction.getVariableName();
        final ArrayList<PhpAccessVariableInstruction> followingReadAccess = new ArrayList<PhpAccessVariableInstruction>();
        PhpControlFlowUtil.processSuccessors((PhpInstruction)instruction, false, new PhpInstructionProcessor(){

            public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                if (PhpLangUtil.equalsVariableNames(variableName, instruction.getVariableName())) {
                    if (!(instruction.getAccess().isWrite() || instruction.getAccess().isWriteRef() || instruction.getAccess().isReadRef())) {
                        followingReadAccess.add(instruction);
                        return true;
                    }
                    return false;
                }
                return true;
            }
        });
        if (followingReadAccess.isEmpty()) {
            return Collections.emptyList();
        }
        return followingReadAccess;
    }

    private static void deleteExpression(@NotNull PhpExpression expression) {
        if (expression == null) {
            PhpInlineVariableHandler.$$$reportNull$$$0(40);
        }
        PsiElement parent = expression.getParent();
        if (PhpPsiUtil.isOfType(parent, PhpElementTypes.STATEMENT, PhpElementTypes.STATIC_STATEMENT)) {
            PsiElement nextSibling = parent.getNextSibling();
            if (nextSibling instanceof PsiWhiteSpace) {
                nextSibling.delete();
            }
            parent.getParent().deleteChildRange(parent, parent);
        }
    }

    private static boolean isInvalidInliningToUnaryOperation(@NotNull PhpAccessVariableInstruction latestWriteAccess, @NotNull PhpAccessVariableInstruction readAccess) {
        PsiElement assignedValue;
        if (latestWriteAccess == null) {
            PhpInlineVariableHandler.$$$reportNull$$$0(41);
        }
        if (readAccess == null) {
            PhpInlineVariableHandler.$$$reportNull$$$0(42);
        }
        if (PhpInlineVariableHandler.isAssignable(assignedValue = ((PhpAccessVariableInstructionImpl)latestWriteAccess).getAssignedValue())) {
            return false;
        }
        PsiElement parent = readAccess.getAnchor().getParent();
        UnaryExpression expression = (UnaryExpression)ObjectUtils.tryCast((Object)parent, UnaryExpression.class);
        if (expression == null) {
            return false;
        }
        return PhpPsiUtil.isOfType(expression.getOperation(), PhpTokenTypes.opDECREMENT, PhpTokenTypes.opINCREMENT);
    }

    private static boolean isAssignable(PsiElement element) {
        if (!PhpAnnotatorVisitor.isAssignable(element)) {
            return false;
        }
        if (element instanceof FieldReference) {
            FieldReference fieldReference = (FieldReference)element;
            Collection fields = fieldReference.multiResolveStrict(Field.class);
            if (fields.isEmpty()) {
                return true;
            }
            if (ContainerUtil.exists((Iterable)fields, f -> f.isReadonly())) {
                return false;
            }
        }
        return true;
    }

    private static /* synthetic */ void lambda$invoke$0(Project project, List followingReadAccesses, Ref valueRef, SmartPsiElementPointer[] replacedOccurrences, MultiMap variablesInString, boolean finalDeleteInitializer, Ref initializerRef) {
        SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)project);
        for (int i = 0; i < followingReadAccesses.size(); ++i) {
            PhpAccessVariableInstruction readAccess = (PhpAccessVariableInstruction)followingReadAccesses.get(i);
            PhpPsiElement anchor = readAccess.getAnchor();
            PsiElement expression = PhpInlineVariableHandler.parenthesizedIfNeeded((PsiElement)valueRef.get(), anchor);
            replacedOccurrences[i] = anchor.getParent() instanceof SelfAssignmentExpression ? smartPointerManager.createSmartPsiElementPointer(PhpInlineVariableHandler.replaceSelfAssigment(expression, (SelfAssignmentExpression)anchor.getParent())) : smartPointerManager.createSmartPsiElementPointer(PhpCodeEditUtil.replace((PsiElement)anchor, expression));
        }
        for (StringLiteralExpression literalExpression : variablesInString.keySet()) {
            replacedOccurrences[i++] = smartPointerManager.createSmartPsiElementPointer(PhpInlineVariableHandler.replaceVariableInString(literalExpression, variablesInString.get((Object)literalExpression), (PsiElement)valueRef.get()));
        }
        if (finalDeleteInitializer) {
            PhpInlineVariableHandler.deleteExpression((PhpExpression)initializerRef.get());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 36, 37 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringLiteralExpression";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: 
            case 22: 
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 9: 
            case 11: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selfAssigment";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeHolder";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessInstruction";
                break;
            }
            case 17: 
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
            case 18: 
            case 21: 
            case 23: 
            case 26: 
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringLiteral";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variables";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceExpression";
                break;
            }
            case 25: 
            case 27: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 29: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "innerVariableRange";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentText";
                break;
            }
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/inline/PhpInlineVariableHandler";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "latestWriteAccess";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "readAccess";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/inline/PhpInlineVariableHandler";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "findTopmostVariable";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariableRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isClosedDoubleQuotedString";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isClosedHeredoc";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "inlineElement";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "replaceSelfAssigment";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "parenthesizedIfNeeded";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isReferenced";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "hasWriteRefInScope";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "showAdviseToRemoveHighlighting";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isPossibleToInline";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "replaceVariableInString";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "processVariableInString";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isPossibleToUseCurlySyntax";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "addValueUsingConcatenation";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "addValueUsingCurlySyntax";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "findTopmostVariable";
                break;
            }
            case 36: 
            case 37: {
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getLatestVariableWriteAccess";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getFollowingVariableReadAccess";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "deleteExpression";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "isInvalidInliningToUnaryOperation";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 36, 37 -> new IllegalStateException(string);
        };
    }
}

