/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.extractMethod;

import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.extractMethod.SimpleDuplicatesFinder;
import com.intellij.refactoring.extractMethod.SimpleMatch;
import com.intellij.refactoring.util.AbstractVariableData;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.RWAccess;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.refactoring.extractMethod.PhpExtractMethodCodeFragment;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpSimpleDuplicatesFinder
extends SimpleDuplicatesFinder {
    private final PhpExtractMethodCodeFragment myFragment;

    public PhpSimpleDuplicatesFinder(@NotNull PhpExtractMethodCodeFragment fragment, AbstractVariableData[] inputVariablesData, Collection<String> outputVariables) {
        if (fragment == null) {
            PhpSimpleDuplicatesFinder.$$$reportNull$$$0(0);
        }
        super(fragment.getStartStatement(), fragment.getEndStatement(), outputVariables, inputVariablesData);
        this.myFragment = fragment;
    }

    public List<SimpleMatch> findDuplicates(@Nullable List<? extends PsiElement> scope, @NotNull PsiElement generatedMethod) {
        if (generatedMethod == null) {
            PhpSimpleDuplicatesFinder.$$$reportNull$$$0(1);
        }
        List duplicates = super.findDuplicates(scope, generatedMethod);
        return ContainerUtil.filter((Collection)duplicates, match -> PhpPsiUtil.getParentOfClass(match.getStartElement(), false, Parameter.class) == null);
    }

    @Nullable
    public SimpleMatch match(@NotNull PhpExtractMethodCodeFragment candidate) {
        if (candidate == null) {
            PhpSimpleDuplicatesFinder.$$$reportNull$$$0(2);
        }
        this.annotatePattern();
        SimpleMatch match = this.isDuplicateFragment(candidate.getStartStatement());
        this.deannotatePattern();
        return match;
    }

    @Nullable
    public SimpleMatch isDuplicateFragment(@NotNull PsiElement candidate) {
        SimpleMatch fragment;
        if (candidate == null) {
            PhpSimpleDuplicatesFinder.$$$reportNull$$$0(3);
        }
        if ((fragment = super.isDuplicateFragment(candidate)) == null) {
            return null;
        }
        if (!this.isReplaceable(fragment)) {
            return null;
        }
        return fragment;
    }

    protected boolean isVariable(PsiElement element) {
        return element.getParent() instanceof Variable;
    }

    private boolean isReplaceable(SimpleMatch fragment) {
        Object nonReplaceableContext = PhpPsiUtil.getParentByCondition(fragment.getStartElement(), false, (Condition<? super PsiElement>)((Condition)element -> element instanceof Parameter || element instanceof PhpDocComment || element instanceof PhpUseList || element instanceof RWAccess && ((RWAccess)element).isWriteAccess()));
        if (nonReplaceableContext != null) {
            return false;
        }
        if (fragment.getStartElement() == fragment.getEndElement() && this.myFragment.getStartStatement() == this.myFragment.getEndStatement() && fragment.getStartElement() instanceof Variable && this.myFragment.getStartStatement() instanceof Variable) {
            return ((Variable)fragment.getStartElement()).getName().equals(((Variable)this.myFragment.getStartStatement()).getName());
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragment";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generatedMethod";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/refactoring/extractMethod/PhpSimpleDuplicatesFinder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "findDuplicates";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "match";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isDuplicateFragment";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

