/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.extractMethod;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.search.PsiTodoSearchHelper;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.refactoring.PhpNameUtil;
import com.jetbrains.php.refactoring.extractMethod.PhpExtractMethodCodeFragment;
import com.jetbrains.php.refactoring.extractMethod.PhpExtractMethodExpressionCodeFragment;
import com.jetbrains.php.refactoring.introduce.PhpIntroduceBaseHandler;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpExtractMethodBlockCodeFragment
extends PhpExtractMethodCodeFragment {
    @NotNull
    private final PsiElement myStartElement;
    @NotNull
    private final PsiElement myEndElement;
    @NotNull
    private final Statement myStartStatement;
    @NotNull
    private final Statement myEndStatement;
    private final int myStartElementOffset;
    private final int myEndOffset;
    private final int myStartStatementOffset;
    private final int myEndStatementOffset;

    PhpExtractMethodBlockCodeFragment(@NotNull PsiFile file, @NotNull PhpScopeHolder scopeHolder, @NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull Statement startStatement, @NotNull Statement endStatement) {
        if (file == null) {
            PhpExtractMethodBlockCodeFragment.$$$reportNull$$$0(0);
        }
        if (scopeHolder == null) {
            PhpExtractMethodBlockCodeFragment.$$$reportNull$$$0(1);
        }
        if (startElement == null) {
            PhpExtractMethodBlockCodeFragment.$$$reportNull$$$0(2);
        }
        if (endElement == null) {
            PhpExtractMethodBlockCodeFragment.$$$reportNull$$$0(3);
        }
        if (startStatement == null) {
            PhpExtractMethodBlockCodeFragment.$$$reportNull$$$0(4);
        }
        if (endStatement == null) {
            PhpExtractMethodBlockCodeFragment.$$$reportNull$$$0(5);
        }
        super(file, scopeHolder);
        this.myStartElement = startElement;
        this.myEndElement = endElement;
        this.myStartStatement = startStatement;
        this.myEndStatement = endStatement;
        this.myStartElementOffset = this.myStartElement.getTextRange().getStartOffset();
        this.myEndOffset = this.myEndElement.getTextRange().getEndOffset();
        this.myStartStatementOffset = this.myStartStatement.getTextRange().getStartOffset();
        this.myEndStatementOffset = this.myEndStatement.getTextRange().getEndOffset();
    }

    public PhpExtractMethodBlockCodeFragment(@NotNull Statement startStatement, @NotNull Statement endStatement, @NotNull PhpScopeHolder scopeHolder) {
        if (startStatement == null) {
            PhpExtractMethodBlockCodeFragment.$$$reportNull$$$0(6);
        }
        if (endStatement == null) {
            PhpExtractMethodBlockCodeFragment.$$$reportNull$$$0(7);
        }
        if (scopeHolder == null) {
            PhpExtractMethodBlockCodeFragment.$$$reportNull$$$0(8);
        }
        this(startStatement.getContainingFile(), scopeHolder, (PsiElement)startStatement, (PsiElement)endStatement, startStatement, endStatement);
    }

    @Override
    public int getStartOffset() {
        return this.myStartElementOffset;
    }

    @Override
    public int getEndOffset() {
        return this.myEndOffset;
    }

    @Override
    @NotNull
    public String generateCodeText() {
        String string = this.extractText();
        if (string == null) {
            PhpExtractMethodBlockCodeFragment.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public Statement getStartStatement() {
        Statement statement = this.myStartStatement;
        if (statement == null) {
            PhpExtractMethodBlockCodeFragment.$$$reportNull$$$0(10);
        }
        return statement;
    }

    @NotNull
    public Statement getEndStatement() {
        Statement statement = this.myEndStatement;
        if (statement == null) {
            PhpExtractMethodBlockCodeFragment.$$$reportNull$$$0(11);
        }
        return statement;
    }

    @NotNull
    public PsiElement getStartElement() {
        PsiElement psiElement = this.myStartElement;
        if (psiElement == null) {
            PhpExtractMethodBlockCodeFragment.$$$reportNull$$$0(12);
        }
        return psiElement;
    }

    @NotNull
    public PsiElement getEndElement() {
        PsiElement psiElement = this.myEndElement;
        if (psiElement == null) {
            PhpExtractMethodBlockCodeFragment.$$$reportNull$$$0(13);
        }
        return psiElement;
    }

    @Override
    @NotNull
    public Collection<String> suggestMethodNames() {
        PhpExpression onlyExpressionChild;
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        ContainerUtil.addIfNotNull(result, (Object)this.getNameByComment());
        if (this.myStartStatement == this.myEndStatement && (onlyExpressionChild = PhpPsiUtil.getOnlyPsiChild(this.myStartStatement, PhpExpression.class)) != null) {
            result.addAll(new PhpExtractMethodExpressionCodeFragment(this.getFile(), this.getScopeHolder(), onlyExpressionChild).suggestMethodNames());
        }
        LinkedHashSet<String> linkedHashSet = result;
        if (linkedHashSet == null) {
            PhpExtractMethodBlockCodeFragment.$$$reportNull$$$0(14);
        }
        return linkedHashSet;
    }

    @Nullable
    public String getNameByComment() {
        String text = PhpExtractMethodBlockCodeFragment.tryExtractCommentText(PsiTreeUtil.skipWhitespacesBackward((PsiElement)this.myStartElement));
        if (text != null) {
            return text;
        }
        return PhpExtractMethodBlockCodeFragment.tryExtractCommentText(this.myStartElement instanceof PsiComment ? this.myStartElement : PsiTreeUtil.skipWhitespacesBackward((PsiElement)this.myStartElement));
    }

    @Nullable
    private static String tryExtractCommentText(PsiElement prev) {
        String sanitized;
        String normalized;
        int pos;
        String commentText;
        String firstPart;
        if (prev instanceof PsiComment && ((PsiComment)prev).getTokenType() == PhpTokenTypes.LINE_COMMENT && PhpExtractMethodBlockCodeFragment.isAfterNewLine(prev) && !(firstPart = (commentText = prev.getText().trim().substring(prev.getText().startsWith("#") ? 1 : 2)).substring(0, (pos = commentText.indexOf(46)) >= 0 ? pos : commentText.length())).isEmpty() && PhpNameUtil.isValidFunctionName(normalized = StringUtil.decapitalize((String)StringUtil.capitalizeWords((String)(sanitized = firstPart.replaceAll("[-,]", " ")), (boolean)true).replaceAll(" ", ""))) && normalized.length() <= 50 && !PhpExtractMethodBlockCodeFragment.isTodoComment(prev)) {
            return normalized;
        }
        return null;
    }

    private static boolean isTodoComment(@NotNull PsiElement comment) {
        if (comment == null) {
            PhpExtractMethodBlockCodeFragment.$$$reportNull$$$0(15);
        }
        PsiFile file = comment.getContainingFile();
        return ContainerUtil.exists((Object[])PsiTodoSearchHelper.getInstance((Project)file.getProject()).findTodoItems(file), todo -> comment.getTextRange().intersects(todo.getTextRange()));
    }

    private static boolean isAfterNewLine(@NotNull PsiElement comment) {
        ASTNode prev;
        if (comment == null) {
            PhpExtractMethodBlockCodeFragment.$$$reportNull$$$0(16);
        }
        if ((prev = comment.getNode().getTreePrev()) != null && prev.getPsi() instanceof PsiWhiteSpace) {
            return prev.textContains('\n');
        }
        return false;
    }

    @NotNull
    public TextRange getTextRange() {
        TextRange textRange = TextRange.create((Segment)this);
        if (textRange == null) {
            PhpExtractMethodBlockCodeFragment.$$$reportNull$$$0(17);
        }
        return textRange;
    }

    @Nullable
    public PsiElement getPlace() {
        return null;
    }

    @NotNull
    public String render() {
        String text = PhpIntroduceBaseHandler.getTrimmedText((PsiElement)this.myStartStatement);
        if (this.myStartStatement != this.myEndStatement) {
            String string = text + "...";
            if (string == null) {
                PhpExtractMethodBlockCodeFragment.$$$reportNull$$$0(18);
            }
            return string;
        }
        String string = text;
        if (string == null) {
            PhpExtractMethodBlockCodeFragment.$$$reportNull$$$0(19);
        }
        return string;
    }

    @Override
    @Nullable
    public PhpExtractMethodBlockCodeFragment restoreFragment(@NotNull PsiFile file) {
        PsiElement startElement;
        if (file == null) {
            PhpExtractMethodBlockCodeFragment.$$$reportNull$$$0(20);
        }
        if ((startElement = PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)this.myStartElementOffset, (Class)this.myStartElement.getClass(), (boolean)false)) == null) {
            return null;
        }
        Statement startStatement = (Statement)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)this.myStartStatementOffset, (Class)this.myStartStatement.getClass(), (boolean)false);
        if (startStatement == null) {
            return null;
        }
        PsiElement endElement = PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)(this.myEndOffset - 1), (Class)this.myEndElement.getClass(), (boolean)false);
        if (endElement == null) {
            return null;
        }
        Statement endStatement = (Statement)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)(this.myEndStatementOffset - 1), (Class)this.myEndStatement.getClass(), (boolean)false);
        if (endStatement == null) {
            return null;
        }
        PhpScopeHolder scopeHolder = (PhpScopeHolder)PhpPsiUtil.getParentByCondition((PsiElement)startStatement, (Condition<? super PsiElement>)PhpScopeHolder.INSTANCE_OF);
        if (scopeHolder == null) {
            return null;
        }
        return new PhpExtractMethodBlockCodeFragment(file, scopeHolder, startElement, endElement, startStatement, endStatement);
    }

    public boolean isValid() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 10, 11, 12, 13, 14, 17, 18, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeHolder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startStatement";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endStatement";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/extractMethod/PhpExtractMethodBlockCodeFragment";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/extractMethod/PhpExtractMethodBlockCodeFragment";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "generateCodeText";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getStartStatement";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getEndStatement";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getStartElement";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getEndElement";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestMethodNames";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextRange";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "render";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isTodoComment";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isAfterNewLine";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "restoreFragment";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 10, 11, 12, 13, 14, 17, 18, 19 -> new IllegalStateException(string);
        };
    }
}

