/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.extractClass;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.refactoring.PhpFileCreationInfo;
import com.jetbrains.php.refactoring.extractClass.PhpExtractClassBaseProcessor;
import com.jetbrains.php.refactoring.extractClass.PhpFunctionInfo;
import com.jetbrains.php.refactoring.move.function.PhpMoveFunctionProcessor;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class PhpExtractFunctionsToClassProcessor
extends PhpExtractClassBaseProcessor {
    @NotNull
    private final List<Function> myFunctionList;

    @ApiStatus.Internal
    public PhpExtractFunctionsToClassProcessor(@NotNull Project project, @NotNull List<PhpFunctionInfo> functionInfos, @NotNull String className, @NotNull String namespace, @NotNull PhpFileCreationInfo fileCreationInfo) {
        if (project == null) {
            PhpExtractFunctionsToClassProcessor.$$$reportNull$$$0(0);
        }
        if (functionInfos == null) {
            PhpExtractFunctionsToClassProcessor.$$$reportNull$$$0(1);
        }
        if (className == null) {
            PhpExtractFunctionsToClassProcessor.$$$reportNull$$$0(2);
        }
        if (namespace == null) {
            PhpExtractFunctionsToClassProcessor.$$$reportNull$$$0(3);
        }
        if (fileCreationInfo == null) {
            PhpExtractFunctionsToClassProcessor.$$$reportNull$$$0(4);
        }
        super(project, className, namespace, fileCreationInfo);
        this.myFunctionList = ContainerUtil.map(functionInfos, e -> (Function)e.getMember());
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            PhpExtractFunctionsToClassProcessor.$$$reportNull$$$0(5);
        }
        return new UsageViewDescriptor(){

            public PsiElement @NotNull [] getElements() {
                PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(PhpExtractFunctionsToClassProcessor.this.myFunctionList);
                if (psiElementArray == null) {
                    1.$$$reportNull$$$0(0);
                }
                return psiElementArray;
            }

            public String getProcessedElementsHeader() {
                return PhpBundle.message("refactoring.extract.class.extracting.from.file", new Object[0]);
            }

            @NotNull
            public String getCodeReferencesText(int usagesCount, int filesCount) {
                String string = PhpBundle.message("refactoring.make.method.static.references.to.be.changed", UsageViewBundle.getReferencesString((int)usagesCount, (int)filesCount));
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/jetbrains/php/refactoring/extractClass/PhpExtractFunctionsToClassProcessor$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getElements";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getCodeReferencesText";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    protected UsageInfo @NotNull [] findUsages() {
        UsageInfo[] usageInfoArray = (UsageInfo[])this.myFunctionList.stream().flatMap(e -> ReferencesSearch.search((PsiElement)e).findAll().stream()).map(e -> new UsageInfo(e)).toArray(UsageInfo[]::new);
        if (usageInfoArray == null) {
            PhpExtractFunctionsToClassProcessor.$$$reportNull$$$0(6);
        }
        return usageInfoArray;
    }

    @Override
    protected void performMainRefactoring(UsageInfo[] usages) {
        if (!this.tryToCreateClass()) {
            return;
        }
        assert (this.myTargetClass != null);
        new PhpMoveFunctionProcessor(this.myFunctionList, this.myTargetClass).moveFunctionsAsMethodsToClass(usages);
        this.reformatCreatedFileAndNavigate();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionInfos";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileCreationInfo";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/extractClass/PhpExtractFunctionsToClassProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/extractClass/PhpExtractFunctionsToClassProcessor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }
}

