/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.copy;

import com.intellij.CommonBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.JBUI;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.PhpFileType;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.refactoring.PhpFileCreationInfo;
import com.jetbrains.php.refactoring.PhpNameUtil;
import com.jetbrains.php.refactoring.move.dnd.PhpMoveClassesDragAndDropDialog;
import com.jetbrains.php.refactoring.validation.PhpFilePathValidationException;
import com.jetbrains.php.roots.ui.PhpPsrNamespacePanel;
import java.util.Collections;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpCopyClassDialog
extends RefactoringDialog {
    private final EditorTextField myNameField;
    private final PhpPsrNamespacePanel myDirectoryChoosePanel;
    private final String myExtension;
    private PhpFileCreationInfo myCreationInfo;

    protected PhpCopyClassDialog(@NotNull Project project, @NotNull PhpClass classToCopy, @NotNull String suggestedNamespace, @NotNull VirtualFile target) {
        if (project == null) {
            PhpCopyClassDialog.$$$reportNull$$$0(0);
        }
        if (classToCopy == null) {
            PhpCopyClassDialog.$$$reportNull$$$0(1);
        }
        if (suggestedNamespace == null) {
            PhpCopyClassDialog.$$$reportNull$$$0(2);
        }
        if (target == null) {
            PhpCopyClassDialog.$$$reportNull$$$0(3);
        }
        super(project, false);
        this.myNameField = new EditorTextField("");
        this.myNameField.setText(classToCopy.getName());
        this.myNameField.selectAll();
        PsiFile containingFile = classToCopy.getContainingFile();
        String name = containingFile.getName();
        int i = name.indexOf(46);
        this.myExtension = i < 0 ? "." + PhpFileType.INSTANCE.getDefaultExtension() : name.substring(i);
        this.setTitle(PhpBundle.message("refactoring.copy.class.name", new Object[0]));
        this.myDirectoryChoosePanel = PhpMoveClassesDragAndDropDialog.getNamespacePanel(project, Collections.singleton(containingFile), suggestedNamespace, target, PhpBundle.message("copy.to.namespace", new Object[0]), JBUI.insets((int)0));
        Disposer.register((Disposable)this.getDisposable(), (Disposable)this.myDirectoryChoosePanel);
        this.setRefactorButtonText(CommonBundle.getOkButtonText());
        this.init();
    }

    protected boolean hasPreviewButton() {
        return false;
    }

    @Nullable
    public PhpFileCreationInfo getCreationInfo() {
        return this.myCreationInfo;
    }

    protected void doAction() {
        String className = this.getClassName();
        if (!PhpNameUtil.isValidClassName(className)) {
            this.showErrorMessage(PhpBundle.message("validation.class.not.valid.name", className));
            return;
        }
        String newNamespaceName = PhpLangUtil.toPresentableFQN(this.getNamespaceName());
        if (StringUtil.isNotEmpty((String)newNamespaceName) && !PhpNameUtil.isValidNamespaceFullName(newNamespaceName, PhpLanguageLevel.current((Project)this.myProject))) {
            this.showErrorMessage(PhpBundle.message("refactoring.common.validation.namespace.name", newNamespaceName));
            return;
        }
        try {
            this.myCreationInfo = this.createNewFileConfig();
        }
        catch (PhpFilePathValidationException e) {
            this.showErrorMessage(e.getMessage());
        }
        this.closeOKAction();
    }

    @NotNull
    public String getNamespaceName() {
        String string = this.myDirectoryChoosePanel.getNamespaceName();
        if (string == null) {
            PhpCopyClassDialog.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    private PhpFileCreationInfo createNewFileConfig() throws PhpFilePathValidationException {
        String copiedFileName = this.getClassName() + this.myExtension;
        PhpFileCreationInfo phpFileCreationInfo = PhpFileCreationInfo.generateConfiguration(this.myProject, this.myDirectoryChoosePanel.getSelectedDirectory(), copiedFileName, false);
        if (phpFileCreationInfo == null) {
            PhpCopyClassDialog.$$$reportNull$$$0(5);
        }
        return phpFileCreationInfo;
    }

    private void showErrorMessage(@NlsContexts.DialogMessage String message) {
        CommonRefactoringUtil.showErrorMessage((String)this.getTitle(), (String)message, (String)this.getHelpId(), (Project)this.myProject);
    }

    protected JComponent createCenterPanel() {
        FormBuilder builder2 = FormBuilder.createFormBuilder().addLabeledComponent(PhpBundle.message("label.new.name", new Object[0]), (JComponent)this.myNameField, true).addComponent((JComponent)this.myDirectoryChoosePanel);
        return builder2.getPanel();
    }

    @NotNull
    public String getClassName() {
        String string = this.myNameField.getText();
        if (string == null) {
            PhpCopyClassDialog.$$$reportNull$$$0(6);
        }
        return string;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNameField;
    }

    @Nullable
    protected String getHelpId() {
        return "refactoring.copy.classes";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classToCopy";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suggestedNamespace";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/copy/PhpCopyClassDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/copy/PhpCopyClassDialog";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespaceName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewFileConfig";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6 -> new IllegalStateException(string);
        };
    }
}

