/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.psalm.types;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.parser.PhpDocElementTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.resolve.types.PhpCharBasedTypeKey;
import com.jetbrains.php.lang.psi.resolve.types.PhpCharTypeKey;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeProvider4;
import com.jetbrains.php.lang.psi.resolve.types.generics.PhpGenericsExtendedTypeProvider;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class PsalmExtendedStringDocTypeProvider
implements PhpTypeProvider4 {
    private static final Collection<String> EXTENDED_STRINGS = List.of("callable-string", "numeric-string", "non-empty-string", "trait-string", "literal-string", "lowercase-string", "non-empty-lowercase-string", "truthy-string", "non-falsy-string");
    @NotNull
    private static final PhpType NUMERIC_TYPE = PhpType.builder().add(PhpType.STRING).add(PhpType.INT).add(PhpType.FLOAT).build();
    public static final Map<String, PhpType> NO_RETURN_TYPES = Map.of("never-return", PhpType.VOID, "never-returns", PhpType.VOID, "no-return", PhpType.VOID);
    public static final Map<String, PhpType> INT_ALIASES = Map.of("positive-int", PhpType.INT, "non-positive-int", PhpType.INT, "negative-int", PhpType.INT, "non-negative-int", PhpType.INT);
    private static final Map<String, PhpType> ALTERNATIVE_SCALAR_TYPES = Map.copyOf(ContainerUtil.union((Map)ContainerUtil.union(Map.of("scalar", PhpType.SCALAR, "numeric", NUMERIC_TYPE, "array-key", PhpType.builder().add(PhpType.STRING).add(PhpType.INT).build(), "empty", PhpType.MIXED, "closed-resource", PhpType.RESOURCE, "int-mask-of", PhpType.INT, "int-mask", PhpType.INT), INT_ALIASES), NO_RETURN_TYPES));
    public static final @Unmodifiable Collection<String> EXTENDED_SCALAR_TYPES = ContainerUtil.union(EXTENDED_STRINGS, ALTERNATIVE_SCALAR_TYPES.keySet());
    private static final PhpCharBasedTypeKey KEY = new PhpCharTypeKey('\u1894');

    public char getKey() {
        return KEY.getKey();
    }

    @Nullable
    public PhpType getType(PsiElement element) {
        if (element instanceof PhpDocType) {
            String name = StringUtil.toLowerCase((String)((PhpDocType)element).getName());
            PhpType type = PsalmExtendedStringDocTypeProvider.getScalarType(name);
            if (name != null && !type.isEmpty()) {
                PsiElement attributes = PhpPsiUtil.getChildOfType(element, (IElementType)PhpDocElementTypes.phpDocAttributeList);
                PhpPsiElement attributeContent = attributes instanceof PhpPsiElement ? ((PhpPsiElement)attributes).getFirstPsiChild() : null;
                String attributesText = PsalmExtendedStringDocTypeProvider.getAttributesText(attributeContent);
                return PhpType.from((String[])new String[]{KEY.sign(attributesText != null ? PhpType.createParametrizedType((String)name, (String[])new String[]{attributesText}) : name)});
            }
        }
        return null;
    }

    @Nullable
    private static String getAttributesText(PhpPsiElement attributeContent) {
        if (attributeContent instanceof PhpDocType) {
            Set parts = ((PhpDocType)attributeContent).getType().getTypesWithParametrisedParts();
            if (parts.size() == 1) {
                return (String)ContainerUtil.getFirstItem((Collection)parts);
            }
            String type = (String)ContainerUtil.find((Iterable)parts, t -> PhpGenericsExtendedTypeProvider.KEY.signed((String)t));
            if (type != null) {
                return type;
            }
        }
        return attributeContent != null ? attributeContent.getText() : null;
    }

    @NotNull
    private static PhpType getScalarType(String name) {
        if (ALTERNATIVE_SCALAR_TYPES.containsKey(name)) {
            PhpType phpType = ALTERNATIVE_SCALAR_TYPES.get(name);
            if (phpType == null) {
                PsalmExtendedStringDocTypeProvider.$$$reportNull$$$0(0);
            }
            return phpType;
        }
        if (EXTENDED_STRINGS.contains(name)) {
            PhpType phpType = PhpType.STRING;
            if (phpType == null) {
                PsalmExtendedStringDocTypeProvider.$$$reportNull$$$0(1);
            }
            return phpType;
        }
        PhpType phpType = PhpType.EMPTY;
        if (phpType == null) {
            PsalmExtendedStringDocTypeProvider.$$$reportNull$$$0(2);
        }
        return phpType;
    }

    @Nullable
    public PhpType complete(String expression, Project project) {
        String expr = PhpLangUtil.toPresentableFQN(expression.substring(2));
        int dimension = PhpType.getPluralDimension((String)expression);
        expr = PhpType.unpluralize((String)expr, (int)dimension);
        return PsalmExtendedStringDocTypeProvider.getScalarType(PhpType.removeParametrisedType((String)expr)).pluralise(dimension);
    }

    public Collection<? extends PhpNamedElement> getBySignature(String expression, Set<String> visited, int depth, Project project) {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/psalm/types/PsalmExtendedStringDocTypeProvider", "getScalarType"));
    }
}

