/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.psalm.types;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocTokenTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocRef;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpNamespaceReference;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.impl.ClassReferenceImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpReferenceImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeProvider4;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeSignatureKey;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsalmExtendedClassConstantReferenceTypeProvider
implements PhpTypeProvider4 {
    private static final Condition<PsiElement> IS_DOC_IDENTIFIER = e -> PhpPsiUtil.isOfType(e, PhpDocTokenTypes.DOC_IDENTIFIER);
    private static final char KEY = '\u1895';
    private static final String WILDCARD = "*";

    public char getKey() {
        return '\u1895';
    }

    @Nullable
    public PhpType getType(PsiElement element) {
        if (element instanceof PhpDocType) {
            PhpPsiElement child = ((PhpDocType)element).getFirstPsiChild();
            if (child instanceof PhpDocRef) {
                return this.getType((PhpDocRef)child);
            }
        } else if (element instanceof PhpDocRef) {
            return this.getType((PhpDocRef)element);
        }
        return null;
    }

    private PhpType getType(PhpDocRef docRef) {
        String constantName;
        PhpNamespaceReference reference = (PhpNamespaceReference)PhpPsiUtil.getChildByCondition((PsiElement)docRef, (Condition<? super PsiElement>)PhpNamespaceReference.INSTANCEOF);
        String immediateNamespaceName = reference != null ? reference.getFullName() : "";
        String namespaceName = PhpReferenceImpl.findNamespaceName(immediateNamespaceName, (PsiElement)docRef);
        PsiElement docStatic = PhpPsiUtil.getChildOfType((PsiElement)docRef, PhpDocTokenTypes.DOC_STATIC);
        if (docStatic == null) {
            return null;
        }
        Object className = PhpPsiUtil.getPrevSiblingByCondition(docStatic, IS_DOC_IDENTIFIER);
        if (className == null) {
            return null;
        }
        PhpType classType = ClassReferenceImpl.resolveClassTypeFromSpecialName((PsiElement)docRef, className.getText());
        if (classType.isEmpty()) {
            classType = PhpType.from((String[])new String[]{PhpLangUtil.concat(namespaceName, className.getText())});
        }
        if ((constantName = PsalmExtendedClassConstantReferenceTypeProvider.getConstantName(docStatic)) == null) {
            return null;
        }
        return classType.map(fqn -> this.getClassConstantSignature(namespaceName, constantName, (String)fqn));
    }

    @Nullable
    private static String getConstantName(PsiElement docStatic) {
        Object constantNameElement = PhpPsiUtil.getNextSiblingByCondition(docStatic, IS_DOC_IDENTIFIER);
        if (constantNameElement != null) {
            return PsalmExtendedClassConstantReferenceTypeProvider.isNextSiblingWildcard(constantNameElement) ? constantNameElement.getText() + WILDCARD : constantNameElement.getText();
        }
        if (PsalmExtendedClassConstantReferenceTypeProvider.isNextSiblingWildcard(docStatic)) {
            return WILDCARD;
        }
        return null;
    }

    @NotNull
    private String getClassConstantSignature(String namespaceName, @NotNull String constantName, String classSignature) {
        if (constantName == null) {
            PsalmExtendedClassConstantReferenceTypeProvider.$$$reportNull$$$0(0);
        }
        if (!PhpType.isSignedType((String)classSignature)) {
            classSignature = PhpTypeSignatureKey.CLASS.sign((CharSequence)PhpLangUtil.concat(namespaceName, classSignature));
        }
        String constantFQN = classSignature + "." + constantName;
        String string = constantName.endsWith(WILDCARD) ? this.sign(constantFQN) : PhpTypeSignatureKey.CLASS_CONSTANT.sign((CharSequence)constantFQN);
        if (string == null) {
            PsalmExtendedClassConstantReferenceTypeProvider.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static boolean isNextSiblingWildcard(@NotNull PsiElement element) {
        PsiElement sibling;
        if (element == null) {
            PsalmExtendedClassConstantReferenceTypeProvider.$$$reportNull$$$0(2);
        }
        return PhpPsiUtil.isOfType(sibling = element.getNextSibling(), PhpDocTokenTypes.DOC_TEXT) && sibling.textMatches((CharSequence)WILDCARD);
    }

    @NotNull
    private String sign(String name) {
        String string = "#" + this.getKey() + name;
        if (string == null) {
            PsalmExtendedClassConstantReferenceTypeProvider.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public PhpType complete(String expression, Project project) {
        return null;
    }

    public Collection<? extends PhpNamedElement> getBySignature(String expression, Set<String> visited, int depth, Project project) {
        int separatorIndex = expression.lastIndexOf(46);
        String pattern = expression.substring(separatorIndex + 1, expression.length() - 1);
        return PhpIndex.getInstance((Project)project).getBySignature(expression.substring(0, separatorIndex)).stream().map(e -> e instanceof PhpClass ? (PhpClass)e : null).filter(Objects::nonNull).flatMap(c -> c.getFields().stream()).filter(Field::isConstant).filter(e -> StringUtil.startsWith((CharSequence)e.getName(), (CharSequence)pattern)).collect(Collectors.toSet());
    }

    public static boolean isSigned(String type) {
        return StringUtil.startsWith((CharSequence)type, (CharSequence)"#\u1895");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constantName";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/psalm/types/PsalmExtendedClassConstantReferenceTypeProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/psalm/types/PsalmExtendedClassConstantReferenceTypeProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassConstantSignature";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "sign";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getClassConstantSignature";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isNextSiblingWildcard";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3 -> new IllegalStateException(string);
        };
    }
}

