/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.profiler.xdebug.model2;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.php.profiler.xdebug.model2.XCall;
import com.jetbrains.php.profiler.xdebug.model2.XCallable;
import com.jetbrains.php.profiler.xdebug.model2.statistics.XCallableStatisticsData;
import com.jetbrains.php.profiler.xdebug.model2.statistics.XCallableStatisticsDataWithMemory;
import com.jetbrains.php.profiler.xdebug.model2.statistics.XModelStatistics;
import com.jetbrains.php.profiler.xdebug.model2.storage.XLeafCall;
import com.jetbrains.php.profiler.xdebug.model2.storage.XModelStorage;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class XModel {
    public static final String INTERNAL_FILE_NAME = "php:internal";
    @NlsSafe
    public static final String INTERNAL_FUNCTION_NAME_PREFIX = "php::";
    public static final String[] INCLUDE_PREFIXES = new String[]{"require_once::", "require::", "include_once::", "include::"};
    public final XModelStorage myXModelStorage;
    public final XModelStatistics myXModelStatistics = new XModelStatistics();
    private static final Key<XModel> KEY = Key.create((String)"profiler.xmodel.key");
    private final Set<VirtualFile> myVirtualFiles = new HashSet<VirtualFile>();

    public XModel() {
        this.myXModelStorage = new XModelStorage();
    }

    @Nullable
    public static XModel find(VirtualFile file) {
        return (XModel)file.getUserData(KEY);
    }

    public static void removeFrom(VirtualFile file) {
        file.putUserData(KEY, null);
    }

    public static void store(VirtualFile file, XModel model) {
        file.putUserData(KEY, (Object)model);
    }

    public void calculateStatistics() {
        for (XCall it : this.myXModelStorage.myTreeRoots) {
            this.calculateStatistics(it, (Object2IntMap<XCallable>)new Object2IntOpenHashMap());
        }
    }

    public Set<XCallable> getCallees(XCallable callableToGet) {
        if (callableToGet == XCallable.CALLABLE_ROOT) {
            return this.myXModelStorage.myTreeRoots.stream().map(e -> e.getCallable()).collect(Collectors.toSet());
        }
        if (callableToGet == null) {
            return Collections.emptySet();
        }
        XCallableStatisticsData data = this.myXModelStatistics.getStatisticsMap().get(callableToGet);
        if (data == null) {
            return Collections.emptySet();
        }
        return data.myCallees;
    }

    public Set<XCallable> getCallers(XCallable callable) {
        if (callable == null) {
            return Collections.emptySet();
        }
        XCallableStatisticsData callableStatisticsData = this.myXModelStatistics.getStatisticsMap().get(callable);
        if (callableStatisticsData == null) {
            return Collections.emptySet();
        }
        Set<XCallable> callers = callableStatisticsData.myCallers;
        if (callers.isEmpty()) {
            for (Map.Entry<XCallable, XCallableStatisticsData> it : this.myXModelStatistics.getStatisticsMap().entrySet()) {
                if (!it.getValue().myCallees.contains(callable)) continue;
                callers.add(it.getKey());
            }
        }
        return callers;
    }

    private void calculateStatistics(@NotNull XCall subtreeRoot, Object2IntMap<XCallable> callStack) {
        XCallable callable;
        if (subtreeRoot == null) {
            XModel.$$$reportNull$$$0(0);
        }
        if (callStack.containsKey((Object)(callable = subtreeRoot.getCallable())) && callStack.getInt((Object)callable) > 0) {
            XCallableStatisticsData statistics = this.getStatistics(callable);
            statistics.subtractFromCumulativeTime(subtreeRoot.getCumulativeTime());
            if (statistics instanceof XCallableStatisticsDataWithMemory) {
                statistics.subtractFromCumulativeMemory(subtreeRoot.getCumulativeMemory());
            }
        }
        if (!(subtreeRoot instanceof XLeafCall)) {
            callStack.put((Object)callable, callStack.getInt((Object)callable) + 1);
            for (XCall xCall : subtreeRoot.getChildren(this)) {
                this.calculateStatistics(xCall, callStack);
            }
            callStack.put((Object)callable, callStack.getInt((Object)callable) - 1);
        }
    }

    public XCallableStatisticsData getStatistics(XCallable callable) {
        XCallableStatisticsData statistics;
        if (this.myXModelStatistics.getStatisticsMap().containsKey(callable)) {
            statistics = this.myXModelStatistics.getStatisticsMap().get(callable);
        } else {
            statistics = this.myXModelStorage.isWithMemory() ? new XCallableStatisticsDataWithMemory() : new XCallableStatisticsData();
            this.myXModelStatistics.getStatisticsMap().put(callable, statistics);
        }
        return statistics;
    }

    public void addVirtualFile(VirtualFile file) {
        this.myVirtualFiles.add(file);
    }

    public Set<VirtualFile> getVirtualFiles() {
        return this.myVirtualFiles;
    }

    public long getCumulativeTime() {
        return this.myXModelStorage.myTreeRoots.stream().mapToLong(e -> e.getCumulativeTime()).sum();
    }

    public long getCumulativeMemory() {
        return this.myXModelStorage.myTreeRoots.stream().mapToLong(e -> e.getCumulativeMemory()).sum();
    }

    public long getInvocationCount() {
        return this.myXModelStatistics.getSnapshotSummaryData().getNumberOfCalls();
    }

    public XCallable getMaxSummaryCumulativeTime() {
        XCallable max = null;
        long maxValue = -1L;
        for (XCallable next : this.myXModelStorage.myCallables.getValues()) {
            long curValue = this.getCumulativeTime(next);
            if (maxValue >= curValue) continue;
            max = next;
            maxValue = curValue;
        }
        assert (max != null);
        return max;
    }

    public XCallable getMaxSummaryCumulativeMemory() {
        XCallable max = null;
        long maxValue = -1L;
        for (XCallable next : this.myXModelStorage.myCallables.getValues()) {
            long curValue = this.getCumulativeMemory(next);
            if (maxValue >= curValue) continue;
            max = next;
            maxValue = curValue;
        }
        assert (max != null);
        return max;
    }

    public XCallable getMaxSummaryInvocationCount() {
        XCallable max = null;
        long maxValue = 0L;
        for (XCallable next : this.myXModelStorage.myCallables.getValues()) {
            long curValue = this.getInvocationCount(next);
            if (maxValue >= curValue) continue;
            max = next;
            maxValue = curValue;
        }
        assert (max != null);
        return max;
    }

    public XCallable getMaxOwnTime() {
        XCallable max = null;
        long maxValue = 0L;
        for (XCallable next : this.myXModelStorage.myCallables.getValues()) {
            long curValue = this.getOwnTime(next);
            if (maxValue >= curValue) continue;
            max = next;
            maxValue = curValue;
        }
        assert (max != null);
        return max;
    }

    public long getInvocationCount(XCallable callable) {
        if (callable == XCallable.CALLABLE_ROOT) {
            return this.getInvocationCount();
        }
        return this.myXModelStatistics.getStatisticsMap().get(callable).getNumberOfCalls();
    }

    public long getCumulativeMemory(XCallable callable) {
        if (callable == XCallable.CALLABLE_ROOT) {
            return this.getCumulativeMemory();
        }
        return this.myXModelStatistics.getStatisticsMap().get(callable).getCumulativeMemory();
    }

    public long getOwnMemory(XCallable callable) {
        return this.myXModelStatistics.getStatisticsMap().get(callable).getOwnMemory();
    }

    public long getCumulativeTime(XCallable callable) {
        if (callable == XCallable.CALLABLE_ROOT) {
            return this.getCumulativeTime();
        }
        return this.myXModelStatistics.getStatisticsMap().get(callable).getCumulativeTime();
    }

    public long getOwnTime(XCallable callable) {
        return this.myXModelStatistics.getStatisticsMap().get(callable).getOwnTime();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subtreeRoot", "com/jetbrains/php/profiler/xdebug/model2/XModel", "calculateStatistics"));
    }
}

