/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phpunit;

import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.openapi.progress.Cancellation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.PhpDocUtil;
import com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocTokenTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocRef;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocCoversTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocDataProviderTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocDependsTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocExpectedExceptionTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamespaceReference;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpUnitUtil {
    public static final String PHPUNIT_TEST_CLASS_FQN = "\\PHPUnit\\Framework\\TestCase";
    public static final NotificationGroup NOTIFICATION_GROUP = (NotificationGroup)Cancellation.forceNonCancellableSectionInClassInitializer(() -> NotificationGroupManager.getInstance().getNotificationGroup(TOOL_NAME));
    private static final String PHPUNIT_TEST_CLASS = "PHPUnit_Framework_TestCase";
    private static final String PHPUNIT_SUITE_METHOD = "suite";
    private static final String PHPUNIT_TEST_METHOD_PREFIX = "test";
    private static final String PHPUNIT_TEST_METHOD_ANNOTATION = "@test";
    private static final String TAG_PHPUNIT = "phpunit";
    public static final String PHPUNIT_XML_DIST = "phpunit.xml.dist";
    public static final String PHPUNIT_XML = "phpunit.xml";
    public static final String PHPUNIT = "phpunit";
    public static final String XML = "xml";
    public static final String GET_PHPUNIT_PHAR_URL = "https://phar.phpunit.de/phpunit.phar";
    public static final String PHPUNIT_PHAR = "phpunit.phar";
    public static final Condition<PhpClass> IS_TEST_CLASS_ALLOW_SUITE_CONDITION = phpClass -> PhpUnitUtil.isTestClass(phpClass);
    public static final String TOOL_NAME = "PHPUnit";
    public static final String CODE_COVERAGE_IGNORE_TAG = "@codeCoverageIgnore";
    @NotNull
    private static final Key<CachedValue<Collection<PhpClass>>> KEY = Key.create((String)"php.phpunit.test.class");
    public static final String PHPUNIT_TEST_METHOD_ATTRIBUTE = "\\PHPUnit\\Framework\\Attributes\\Test";
    public static PhpType PHPUNIT_TEST_CLASS_BASE_TYPE = PhpType.from((String[])new String[]{"\\PHPUnit\\Framework\\TestCase", "PHPUnit_Framework_TestCase"});

    private PhpUnitUtil() {
    }

    @Nullable
    public static PhpClass findClassByFQNInFile(@NotNull String fqn, @NotNull PsiFile psiFile, @NotNull Project project) {
        if (fqn == null) {
            PhpUnitUtil.$$$reportNull$$$0(0);
        }
        if (psiFile == null) {
            PhpUnitUtil.$$$reportNull$$$0(1);
        }
        if (project == null) {
            PhpUnitUtil.$$$reportNull$$$0(2);
        }
        if (psiFile instanceof PhpFile && ScratchUtil.isScratch((VirtualFile)psiFile.getVirtualFile())) {
            return PhpPsiUtil.findClass((PhpFile)psiFile, (Condition<? super PhpClass>)((Condition)aClass -> PhpLangUtil.equalsClassNames(aClass.getPresentableFQN(), fqn)));
        }
        for (PhpClass phpClass : PhpIndex.getInstance((Project)project).getClassesByFQN(fqn)) {
            PsiFile containingFile = phpClass.getContainingFile();
            if (containingFile != psiFile) continue;
            return phpClass;
        }
        return null;
    }

    public static Collection<PhpClass> getTestCaseClasses(@NotNull Project project) {
        if (project == null) {
            PhpUnitUtil.$$$reportNull$$$0(3);
        }
        return PhpIndex.getInstance((Project)project).getLibClassesCached(PHPUNIT_TEST_CLASS_FQN, KEY);
    }

    public static boolean isTestClass(@NotNull PhpClass phpClass) {
        if (phpClass == null) {
            PhpUnitUtil.$$$reportNull$$$0(4);
        }
        return (Boolean)CachedValuesManager.getCachedValue((PsiElement)phpClass, () -> new CachedValueProvider.Result((Object)PhpUnitUtil.isTestClass(phpClass, true), new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    public static boolean isTestClass(@NotNull PhpClass phpClass, boolean allowSuite) {
        Method method;
        if (phpClass == null) {
            PhpUnitUtil.$$$reportNull$$$0(5);
        }
        if (phpClass.isAbstract() || phpClass.isInterface() || phpClass.isAnonymous()) {
            return false;
        }
        if (allowSuite && PhpUnitUtil.isSuiteMethod(method = phpClass.findMethodByName((CharSequence)PHPUNIT_SUITE_METHOD))) {
            return true;
        }
        return PhpUnitUtil.extendsRootTestClass(phpClass);
    }

    public static boolean isTestSuite(@NotNull PhpClass phpClass) {
        if (phpClass == null) {
            PhpUnitUtil.$$$reportNull$$$0(6);
        }
        return PhpUnitUtil.isSuiteMethod(phpClass.findMethodByName((CharSequence)PHPUNIT_SUITE_METHOD));
    }

    public static boolean isRunnableTestClass(@NotNull PhpClass phpClass) {
        if (phpClass == null) {
            PhpUnitUtil.$$$reportNull$$$0(7);
        }
        return phpClass.isAbstract() ? PhpUnitUtil.extendsRootTestClass(phpClass) && PhpUnitUtil.getRealTestClass(phpClass) != null : PhpUnitUtil.isTestClass(phpClass);
    }

    public static boolean extendsRootTestClass(@NotNull PhpClass phpClass) {
        if (phpClass == null) {
            PhpUnitUtil.$$$reportNull$$$0(8);
        }
        return (Boolean)CachedValuesManager.getCachedValue((PsiElement)phpClass, () -> {
            Ref isTestClassRef = new Ref((Object)false);
            PhpClassHierarchyUtils.processSuperClasses((PhpClass)phpClass, (boolean)true, (boolean)true, aClass -> {
                if (PhpUnitUtil.isRootTestClass(aClass)) {
                    isTestClassRef.set((Object)true);
                }
                return (Boolean)isTestClassRef.get() == false;
            });
            return new CachedValueProvider.Result((Object)((Boolean)isTestClassRef.get()), new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
    }

    public static boolean isRootTestClass(PhpClass aClass) {
        String superFqn = aClass.getSuperFQN();
        if (superFqn != null) {
            return PhpLangUtil.equalsClassNames(PHPUNIT_TEST_CLASS_FQN, superFqn) || PhpLangUtil.equalsClassNames(PHPUNIT_TEST_CLASS, PhpLangUtil.toShortName(superFqn));
        }
        String fqn = aClass.getFQN();
        return PhpLangUtil.equalsClassNames(PhpLangUtil.toFQN(PHPUNIT_TEST_CLASS), fqn) || PhpLangUtil.equalsClassNames(PHPUNIT_TEST_CLASS_FQN, fqn);
    }

    private static boolean canBeTestMethod(@NotNull Method method) {
        if (method == null) {
            PhpUnitUtil.$$$reportNull$$$0(9);
        }
        return !method.isAbstract() && method.getAccess().isPublic();
    }

    private static boolean isSuiteMethod(@Nullable Method method) {
        return method != null && PhpLangUtil.equalsMethodNames(PHPUNIT_SUITE_METHOD, method.getNameCS()) && PhpUnitUtil.canBeTestMethod(method) && method.isStatic();
    }

    @Nullable
    private static PhpClass getRealTestClass(@NotNull PhpClass containingClass) {
        if (containingClass == null) {
            PhpUnitUtil.$$$reportNull$$$0(10);
        }
        for (PhpClass clazz : PhpClassHierarchyUtils.getDirectSubclasses((PhpClass)containingClass)) {
            if (!PhpUnitUtil.isTestClass(clazz, false)) continue;
            return clazz;
        }
        return null;
    }

    public static boolean isTestMethod(@NotNull PhpClass containingClass, @NotNull Method method) {
        if (containingClass == null) {
            PhpUnitUtil.$$$reportNull$$$0(11);
        }
        if (method == null) {
            PhpUnitUtil.$$$reportNull$$$0(12);
        }
        if (PhpUnitUtil.canBeTestMethod(method)) {
            return PhpUnitUtil.isTestMethodInternal(containingClass, method);
        }
        return false;
    }

    public static boolean isTestMethod(@NotNull Method method) {
        if (method == null) {
            PhpUnitUtil.$$$reportNull$$$0(13);
        }
        if (PhpUnitUtil.canBeTestMethod(method)) {
            PhpClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return false;
            }
            return PhpUnitUtil.isTestMethodInternal(containingClass, method);
        }
        return false;
    }

    private static boolean isTestMethodInternal(@NotNull PhpClass containingClass, @NotNull Method method) {
        if (containingClass == null) {
            PhpUnitUtil.$$$reportNull$$$0(14);
        }
        if (method == null) {
            PhpUnitUtil.$$$reportNull$$$0(15);
        }
        if (containingClass.isAbstract()) {
            PhpClass realTestClass = PhpUnitUtil.getRealTestClass(containingClass);
            if (realTestClass == null) {
                return false;
            }
            containingClass = realTestClass;
        }
        return PhpUnitUtil.isTestClass(containingClass) && PhpUnitUtil.hasTestMethodSignature(method);
    }

    public static boolean hasTestMethodSignature(@NotNull Method method) {
        if (method == null) {
            PhpUnitUtil.$$$reportNull$$$0(16);
        }
        if (StringUtil.startsWith((CharSequence)method.getNameCS(), (CharSequence)PHPUNIT_TEST_METHOD_PREFIX) || PhpUnitUtil.isSuiteMethod(method)) {
            return true;
        }
        if (!method.getAttributes(PHPUNIT_TEST_METHOD_ATTRIBUTE).isEmpty()) {
            return true;
        }
        PhpDocComment docComment = method.getDocComment();
        return docComment != null && PhpDocUtil.hasDocTagWithName(docComment, PHPUNIT_TEST_METHOD_ANNOTATION);
    }

    public static boolean isPhpUnitConfigurationFile(@NotNull PsiFile psiFile) {
        XmlFile xmlFile;
        XmlTag rootTag;
        if (psiFile == null) {
            PhpUnitUtil.$$$reportNull$$$0(17);
        }
        return psiFile instanceof XmlFile && (rootTag = (xmlFile = (XmlFile)psiFile).getRootTag()) != null && rootTag.getName().equalsIgnoreCase("phpunit");
    }

    @Nullable
    public static PhpClass findTestClass(@NotNull PhpFile phpFile) {
        if (phpFile == null) {
            PhpUnitUtil.$$$reportNull$$$0(18);
        }
        return PhpPsiUtil.findClass(phpFile, IS_TEST_CLASS_ALLOW_SUITE_CONDITION);
    }

    public static boolean isPhpUnitTestFileName(@NotNull String fileNameWithoutExtension) {
        if (fileNameWithoutExtension == null) {
            PhpUnitUtil.$$$reportNull$$$0(19);
        }
        return fileNameWithoutExtension.equalsIgnoreCase("AllTests") || fileNameWithoutExtension.contains("Test");
    }

    public static boolean isPhpUnitTestFile(@NotNull PsiFile psiFile) {
        PhpFile phpFile;
        VirtualFile virtualFile;
        if (psiFile == null) {
            PhpUnitUtil.$$$reportNull$$$0(20);
        }
        return psiFile instanceof PhpFile && (virtualFile = (phpFile = (PhpFile)psiFile).getVirtualFile()) != null && PhpUnitUtil.isPhpUnitTestFileName(virtualFile.getNameWithoutExtension()) && PhpUnitUtil.findTestClass(phpFile) != null;
    }

    @NotNull
    public static Pair<String, String> getClassFqnAndMethodName(@Nullable PhpDocRef dataProvider, @NotNull String testClassNamespace) {
        PsiElement methodIdentifier;
        if (testClassNamespace == null) {
            PhpUnitUtil.$$$reportNull$$$0(21);
        }
        if (dataProvider != null && (methodIdentifier = PhpUnitUtil.getDataProviderIdentifier(dataProvider)) != null) {
            PsiElement classIdentifier = PhpPsiUtil.findPrevSiblingOfAnyType(methodIdentifier, PhpDocTokenTypes.DOC_IDENTIFIER);
            Pair pair = Pair.create((Object)PhpUnitUtil.getClassFqn(classIdentifier, testClassNamespace), (Object)methodIdentifier.getText());
            if (pair == null) {
                PhpUnitUtil.$$$reportNull$$$0(22);
            }
            return pair;
        }
        Pair pair = Pair.empty();
        if (pair == null) {
            PhpUnitUtil.$$$reportNull$$$0(23);
        }
        return pair;
    }

    @Nullable
    public static PsiElement getDataProviderIdentifier(@NotNull PhpDocRef dataProvider) {
        PsiElement child;
        if (dataProvider == null) {
            PhpUnitUtil.$$$reportNull$$$0(24);
        }
        return PhpPsiUtil.isOfType(child = dataProvider.getLastChild(), PhpDocTokenTypes.DOC_IDENTIFIER) ? child : PhpPsiUtil.findPrevSiblingOfAnyType(child, PhpDocTokenTypes.DOC_IDENTIFIER);
    }

    @Nullable
    private static String getClassFqn(@Nullable PsiElement classIdentifier, @NotNull String testClassNamespace) {
        if (testClassNamespace == null) {
            PhpUnitUtil.$$$reportNull$$$0(25);
        }
        if (classIdentifier == null) {
            return null;
        }
        String className = classIdentifier.getText();
        PhpNamespaceReference namespaceReference = (PhpNamespaceReference)ObjectUtils.tryCast((Object)classIdentifier.getPrevSibling(), PhpNamespaceReference.class);
        String namespace = namespaceReference != null ? namespaceReference.getFullName() : testClassNamespace;
        return PhpLangUtil.concat(PhpLangUtil.toFQN(namespace), PhpLangUtil.toFQN(className));
    }

    @Nullable
    public static String getDefaultCoveredClassName(@Nullable PhpClass clazz) {
        PhpDocComment docComment = clazz != null ? clazz.getDocComment() : null;
        PhpDocTag defaultCoveredClassTag = docComment != null ? (PhpDocTag)ArrayUtil.getFirstElement((Object[])docComment.getTagElementsByName("@coversDefaultClass")) : null;
        PhpReference reference = (PhpReference)PhpPsiUtil.getChildByCondition((PsiElement)defaultCoveredClassTag, (Condition<? super PsiElement>)PhpReference.INSTANCEOF);
        return reference != null ? reference.getFQN() : null;
    }

    public static boolean isPhpUnitTag(@Nullable PhpDocTag docTag) {
        if (docTag == null) {
            return false;
        }
        return docTag instanceof PhpDocExpectedExceptionTag || docTag instanceof PhpDocDataProviderTag || docTag instanceof PhpDocDependsTag || docTag instanceof PhpDocCoversTag || StringUtil.equals((CharSequence)docTag.getName(), (CharSequence)"@coversDefaultClass");
    }

    public static boolean isInPhpUnitTag(@Nullable PsiElement element) {
        PhpDocTag docTag = (PhpDocTag)PhpPsiUtil.getParentByCondition(element, false, (Condition<? super PsiElement>)PhpDocTag.INSTANCEOF, (Condition<? super PsiElement>)PhpDocComment.INSTANCEOF);
        return docTag != null && (PhpUnitUtil.isPhpUnitTag(docTag) || StringUtil.equals((CharSequence)docTag.getName(), (CharSequence)"@uses"));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 22, 23 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 1: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpClass";
                break;
            }
            case 9: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 10: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingClass";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpFile";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileNameWithoutExtension";
                break;
            }
            case 21: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testClassNamespace";
                break;
            }
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/phpunit/PhpUnitUtil";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/phpunit/PhpUnitUtil";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassFqnAndMethodName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findClassByFQNInFile";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getTestCaseClasses";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isTestClass";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isTestSuite";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isRunnableTestClass";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "extendsRootTestClass";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "canBeTestMethod";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getRealTestClass";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isTestMethod";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isTestMethodInternal";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "hasTestMethodSignature";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isPhpUnitConfigurationFile";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findTestClass";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isPhpUnitTestFileName";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isPhpUnitTestFile";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getClassFqnAndMethodName";
                break;
            }
            case 22: 
            case 23: {
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getDataProviderIdentifier";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getClassFqn";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 22, 23 -> new IllegalStateException(string);
        };
    }
}

