/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phpunit;

import com.intellij.execution.Location;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.IntRef;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.config.servers.PhpServer;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocRef;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.ArrayHashElement;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpAttribute;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.elements.PhpYield;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.ArrayCreationExpressionImpl;
import com.jetbrains.php.phpunit.LocationInfo;
import com.jetbrains.php.phpunit.PhpCompositeLocation;
import com.jetbrains.php.phpunit.PhpMethodLocation;
import com.jetbrains.php.phpunit.PhpPsiLocationWithDataSet;
import com.jetbrains.php.phpunit.PhpUnitRuntimeConfigurationProducer;
import com.jetbrains.php.phpunit.PhpUnitUtil;
import com.jetbrains.php.util.pathmapper.PhpPathMapper;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpUnitQualifiedNameLocationProvider
implements SMTestLocator {
    private static final String PROTOCOL_ID = "php_qn";
    public static final int WORDS_COUNT_IN_METHOD_WITH_DATASET = 5;
    @NotNull
    protected final PhpPathMapper myPathMapper;

    public PhpUnitQualifiedNameLocationProvider(@NotNull PhpPathMapper pathMapper) {
        if (pathMapper == null) {
            PhpUnitQualifiedNameLocationProvider.$$$reportNull$$$0(0);
        }
        this.myPathMapper = pathMapper;
    }

    public static PhpUnitQualifiedNameLocationProvider create(@NotNull Project project, @NotNull String serverName) {
        PhpServer server;
        if (project == null) {
            PhpUnitQualifiedNameLocationProvider.$$$reportNull$$$0(1);
        }
        if (serverName == null) {
            PhpUnitQualifiedNameLocationProvider.$$$reportNull$$$0(2);
        }
        if ((server = PhpProjectConfigurationFacade.getInstance(project).findServer(serverName)) == null) {
            return new PhpUnitQualifiedNameLocationProvider(PhpPathMapper.create());
        }
        return new PhpUnitQualifiedNameLocationProvider(PhpPathMapper.create(server));
    }

    public static PhpUnitQualifiedNameLocationProvider create(@NotNull PhpPathMapper pathMapper) {
        if (pathMapper == null) {
            PhpUnitQualifiedNameLocationProvider.$$$reportNull$$$0(3);
        }
        return new PhpUnitQualifiedNameLocationProvider(pathMapper);
    }

    @NotNull
    public PhpPathMapper getPathMapper() {
        PhpPathMapper phpPathMapper = this.myPathMapper;
        if (phpPathMapper == null) {
            PhpUnitQualifiedNameLocationProvider.$$$reportNull$$$0(4);
        }
        return phpPathMapper;
    }

    @NotNull
    public List<Location> getLocation(@NotNull String protocol, @NotNull String path, @NotNull Project project, @NotNull GlobalSearchScope scope) {
        LocationInfo locationInfo;
        LocationElementStore element;
        if (protocol == null) {
            PhpUnitQualifiedNameLocationProvider.$$$reportNull$$$0(5);
        }
        if (path == null) {
            PhpUnitQualifiedNameLocationProvider.$$$reportNull$$$0(6);
        }
        if (project == null) {
            PhpUnitQualifiedNameLocationProvider.$$$reportNull$$$0(7);
        }
        if (scope == null) {
            PhpUnitQualifiedNameLocationProvider.$$$reportNull$$$0(8);
        }
        if (PROTOCOL_ID.equals(protocol) && (element = this.findElement(locationInfo = this.getLocationInfo(path), project)) != null) {
            if (element.testDetectionElement == null) {
                PhpClass containingClass;
                if (element.primaryNavigationElement instanceof Method && (containingClass = (PhpClass)ContainerUtil.getFirstItem((Collection)PhpIndex.getInstance((Project)project).getClassesByFQN(locationInfo.getClassName()))) != null) {
                    List<PhpMethodLocation> list = Collections.singletonList(new PhpMethodLocation(project, (Method)element.primaryNavigationElement, containingClass, PhpUnitQualifiedNameLocationProvider.getDataSet(locationInfo)));
                    if (list == null) {
                        PhpUnitQualifiedNameLocationProvider.$$$reportNull$$$0(9);
                    }
                    return list;
                }
                List<PhpPsiLocationWithDataSet<PsiElement>> list = Collections.singletonList(new PhpPsiLocationWithDataSet<PsiElement>(project, element.primaryNavigationElement, PhpUnitQualifiedNameLocationProvider.getDataSet(locationInfo)));
                if (list == null) {
                    PhpUnitQualifiedNameLocationProvider.$$$reportNull$$$0(10);
                }
                return list;
            }
            List<PhpCompositeLocation> list = Collections.singletonList(new PhpCompositeLocation(project, element.primaryNavigationElement, PhpUnitQualifiedNameLocationProvider.getDataSet(locationInfo), element.testDetectionElement));
            if (list == null) {
                PhpUnitQualifiedNameLocationProvider.$$$reportNull$$$0(11);
            }
            return list;
        }
        List<Location> list = Collections.emptyList();
        if (list == null) {
            PhpUnitQualifiedNameLocationProvider.$$$reportNull$$$0(12);
        }
        return list;
    }

    @Nullable
    private static String getDataSet(@Nullable LocationInfo locationInfo) {
        String methodName = locationInfo != null ? locationInfo.getMethodName() : null;
        Object[] parts = methodName != null ? methodName.split(" ", 5) : ArrayUtilRt.EMPTY_STRING_ARRAY;
        return parts.length > 1 ? (String)ArrayUtil.getLastElement((Object[])parts) : null;
    }

    @Nullable
    protected LocationInfo getLocationInfo(@NotNull String link) {
        String[] location;
        int tokensNumber;
        if (link == null) {
            PhpUnitQualifiedNameLocationProvider.$$$reportNull$$$0(13);
        }
        if ((tokensNumber = (location = link.split("::")).length) <= 0 || tokensNumber > 3) {
            return null;
        }
        String filePath = location[0];
        if (filePath == null) {
            return null;
        }
        String className = tokensNumber > 1 ? location[1] : null;
        String methodName = tokensNumber > 2 ? location[2] : null;
        return new LocationInfo(className, methodName, this.myPathMapper.getLocalFile(filePath));
    }

    @Contract(value="null, _ -> null")
    @Nullable
    protected LocationElementStore findElement(@Nullable LocationInfo locationInfo, Project project) {
        if (locationInfo == null) {
            return null;
        }
        Pair<String, String> methodAndDataSet = PhpUnitQualifiedNameLocationProvider.splitMethodAndDataSet(locationInfo.getMethodName());
        return this.getLocation(project, locationInfo.getFile(), locationInfo.getClassName(), (String)methodAndDataSet.first, (String)methodAndDataSet.second);
    }

    @NotNull
    private static Pair<String, String> splitMethodAndDataSet(@Nullable String s) {
        if (s == null) {
            Pair pair = Pair.create(null, null);
            if (pair == null) {
                PhpUnitQualifiedNameLocationProvider.$$$reportNull$$$0(14);
            }
            return pair;
        }
        if (s.contains("with data set")) {
            String[] parts = s.split(" ", 5);
            String methodName = parts[0];
            String dataSet = parts[parts.length - 1];
            String trimmedDataSet = StringUtil.unquoteString((String)dataSet);
            Pair pair = Pair.create((Object)methodName, (Object)trimmedDataSet);
            if (pair == null) {
                PhpUnitQualifiedNameLocationProvider.$$$reportNull$$$0(15);
            }
            return pair;
        }
        String result = StringUtil.substringBefore((String)s, (String)" ");
        if (result == null) {
            Pair pair = Pair.create((Object)s, null);
            if (pair == null) {
                PhpUnitQualifiedNameLocationProvider.$$$reportNull$$$0(16);
            }
            return pair;
        }
        Pair pair = Pair.create((Object)result, null);
        if (pair == null) {
            PhpUnitQualifiedNameLocationProvider.$$$reportNull$$$0(17);
        }
        return pair;
    }

    @Nullable
    protected LocationElementStore getLocation(@NotNull Project project, @Nullable VirtualFile virtualFile, @Nullable String className, @Nullable String methodName, @Nullable String dataSet) {
        if (project == null) {
            PhpUnitQualifiedNameLocationProvider.$$$reportNull$$$0(18);
        }
        if (virtualFile == null) {
            return null;
        }
        PhpFile file = (PhpFile)ObjectUtils.tryCast((Object)PsiManager.getInstance((Project)project).findFile(virtualFile), PhpFile.class);
        if (file == null) {
            return null;
        }
        if (className != null) {
            PhpClass phpClass;
            if (StringUtil.isEmpty((String)className)) {
                PhpClass testClass;
                if (methodName != null && !DumbService.isDumb((Project)project) && (testClass = PhpUnitUtil.findTestClass(file)) != null) {
                    Method method = testClass.findOwnMethodByName((CharSequence)methodName);
                    if (method != null) {
                        return PhpUnitQualifiedNameLocationProvider.processMethod(dataSet, method);
                    }
                    return new LocationElementStore((PsiElement)testClass);
                }
                return null;
            }
            if (!DumbService.isDumb((Project)project) && (phpClass = PhpPsiUtil.findClass(file, (Condition<? super PhpClass>)((Condition)aClass -> PhpLangUtil.equalsClassNames(aClass.getFQN(), className)))) != null) {
                if (methodName != null) {
                    Method method = phpClass.findOwnMethodByName((CharSequence)methodName);
                    if (method != null) {
                        return PhpUnitQualifiedNameLocationProvider.processMethod(dataSet, method);
                    }
                    return new LocationElementStore((PsiElement)phpClass);
                }
                return new LocationElementStore((PsiElement)phpClass);
            }
        }
        return new LocationElementStore((PsiElement)file);
    }

    @NotNull
    private static LocationElementStore processMethod(@Nullable String dataSet, @NotNull Method method) {
        PsiElement dataProviderKey;
        PhpDocComment comment;
        if (method == null) {
            PhpUnitQualifiedNameLocationProvider.$$$reportNull$$$0(19);
        }
        if ((comment = method.getDocComment()) != null && dataSet != null && (dataProviderKey = PhpUnitQualifiedNameLocationProvider.tryFindDataProviderKeyFromDoc(dataSet, comment)) != null) {
            return new LocationElementStore(dataProviderKey, (PsiElement)method);
        }
        if (dataSet != null && (dataProviderKey = PhpUnitQualifiedNameLocationProvider.tryFindDataProviderKeyFromAttributes(dataSet, method)) != null) {
            return new LocationElementStore(dataProviderKey, (PsiElement)method);
        }
        return new LocationElementStore((PsiElement)method);
    }

    @Nullable
    private static PsiElement tryFindDataProviderKeyFromDoc(@NotNull String dataSet, @NotNull PhpDocComment comment) {
        if (dataSet == null) {
            PhpUnitQualifiedNameLocationProvider.$$$reportNull$$$0(20);
        }
        if (comment == null) {
            PhpUnitQualifiedNameLocationProvider.$$$reportNull$$$0(21);
        }
        PhpDocTag[] dataProviderTags = comment.getTagElementsByName("@dataProvider");
        IntRef seenDatasets = new IntRef(0);
        for (PhpDocTag tag : dataProviderTags) {
            PsiReference[] references;
            PsiElement candidate;
            Collection docRefs = PsiTreeUtil.findChildrenOfType((PsiElement)tag, PhpDocRef.class);
            if (docRefs.isEmpty() || (candidate = PhpUnitQualifiedNameLocationProvider.processDataProviderReferences(dataSet, references = ((PhpDocRef)docRefs.iterator().next()).getReferences(), seenDatasets)) == null) continue;
            return candidate;
        }
        return null;
    }

    @Nullable
    private static PsiElement tryFindDataProviderKeyFromAttributes(@NotNull String dataSet, @NotNull Method method) {
        if (dataSet == null) {
            PhpUnitQualifiedNameLocationProvider.$$$reportNull$$$0(22);
        }
        if (method == null) {
            PhpUnitQualifiedNameLocationProvider.$$$reportNull$$$0(23);
        }
        IntRef seenDatasets = new IntRef(0);
        Collection attributes = method.getAttributes("\\PHPUnit\\Framework\\Attributes\\DataProvider");
        for (PhpAttribute attribute : attributes) {
            PsiElement lastElement = (PsiElement)ArrayUtil.getLastElement((Object[])attribute.getParameters());
            PsiReference[] references = lastElement.getReferences();
            PsiElement candidate = PhpUnitQualifiedNameLocationProvider.processDataProviderReferences(dataSet, references, seenDatasets);
            if (candidate == null) continue;
            return candidate;
        }
        return null;
    }

    @Nullable
    private static PsiElement processDataProviderReferences(@NotNull String dataSet, PsiReference[] references, IntRef seenDatasets) {
        if (dataSet == null) {
            PhpUnitQualifiedNameLocationProvider.$$$reportNull$$$0(24);
        }
        if (references.length == 0) {
            return null;
        }
        Method dataProviderMethod = (Method)ObjectUtils.tryCast((Object)references[references.length - 1].resolve(), Method.class);
        if (dataProviderMethod == null) {
            return null;
        }
        PsiElement yieldsCandidate = PhpUnitQualifiedNameLocationProvider.handleYields(dataSet, seenDatasets, dataProviderMethod);
        if (yieldsCandidate != null) {
            return yieldsCandidate;
        }
        PsiElement returnsCandidate = PhpUnitQualifiedNameLocationProvider.handleReturns(dataSet, seenDatasets, dataProviderMethod);
        if (returnsCandidate != null) {
            return returnsCandidate;
        }
        return null;
    }

    @Nullable
    private static PsiElement handleYields(@NotNull String dataSet, IntRef seenDatasets, Method dataProviderMethod) {
        Collection yields;
        if (dataSet == null) {
            PhpUnitQualifiedNameLocationProvider.$$$reportNull$$$0(25);
        }
        if ((yields = PsiTreeUtil.findChildrenOfType((PsiElement)dataProviderMethod, PhpYield.class)).isEmpty()) {
            return null;
        }
        for (PhpYield yield : yields) {
            String dataSetName;
            PhpMethodLocation dataSetLoc = PhpUnitRuntimeConfigurationProducer.extractDataSetInfoFromYield(yield);
            if (dataSetLoc == null || (dataSetName = dataSetLoc.getDataSet()) == null) continue;
            if (dataSetName.equals(dataSet)) {
                return yield;
            }
            if (!(dataSetName = PhpUnitQualifiedNameLocationProvider.increaseIndex(dataSetName, seenDatasets.get())).equals(dataSet)) continue;
            return yield;
        }
        seenDatasets.set(seenDatasets.get() + yields.size());
        return null;
    }

    @Nullable
    private static PsiElement handleReturns(@NotNull String dataSet, IntRef seenDatasets, Method dataProviderMethod) {
        Collection returns;
        if (dataSet == null) {
            PhpUnitQualifiedNameLocationProvider.$$$reportNull$$$0(26);
        }
        if ((returns = PsiTreeUtil.findChildrenOfType((PsiElement)dataProviderMethod, PhpReturn.class)).size() != 1) {
            return null;
        }
        PhpReturn returnStatement = (PhpReturn)returns.iterator().next();
        PsiElement expr = returnStatement.getArgument();
        ArrayCreationExpression array = null;
        if (expr instanceof ArrayCreationExpression) {
            ArrayCreationExpression arrayCreationExpression;
            array = arrayCreationExpression = (ArrayCreationExpression)expr;
        } else if (expr instanceof Variable) {
            Variable variable = (Variable)expr;
            PsiElement definition = variable.resolve();
            if (definition == null) {
                return null;
            }
            PsiElement parent = definition.getParent();
            if (parent == null) {
                return null;
            }
            PhpPsiElement value = ((AssignmentExpression)parent).getValue();
            if (value instanceof ArrayCreationExpression) {
                ArrayCreationExpression arrayCreationExpression = (ArrayCreationExpression)value;
                if (!PhpUnitRuntimeConfigurationProducer.isReturnedValue(arrayCreationExpression)) {
                    return null;
                }
                array = arrayCreationExpression;
            }
        } else {
            return null;
        }
        if (array == null) {
            return null;
        }
        ArrayList children = new ArrayList();
        ArrayCreationExpressionImpl.children(array).forEach(children::add);
        for (PhpPsiElement child : children) {
            String dataSetName;
            PhpPsiElement key = null;
            if (child instanceof ArrayHashElement) {
                ArrayHashElement hash = (ArrayHashElement)child;
                key = hash.getKey();
            }
            if ((dataSetName = PhpUnitRuntimeConfigurationProducer.extractDataSetName(key, array, (PsiElement)child)) == null || !(dataSetName = PhpUnitQualifiedNameLocationProvider.increaseIndex(dataSetName, seenDatasets.get())).equals(dataSet)) continue;
            if (child instanceof ArrayHashElement) {
                ArrayHashElement hash = (ArrayHashElement)child;
                return hash.getKey();
            }
            PhpPsiElement phpPsiElement = child.getFirstPsiChild();
            if (phpPsiElement instanceof ArrayCreationExpression) {
                ArrayCreationExpression arrayCreationExpression = (ArrayCreationExpression)phpPsiElement;
                return arrayCreationExpression.getFirstChild();
            }
            return child;
        }
        seenDatasets.set(seenDatasets.get() + children.size());
        return null;
    }

    private static String increaseIndex(String dataSet, int count) {
        if (count > 0 && StringUtil.startsWith((CharSequence)dataSet, (CharSequence)"#")) {
            return "#" + (Integer.parseInt(dataSet.substring(1)) + count);
        }
        return dataSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 9, 10, 11, 12, 14, 15, 16, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMapper";
                break;
            }
            case 1: 
            case 7: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverName";
                break;
            }
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/phpunit/PhpUnitQualifiedNameLocationProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "protocol";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "link";
                break;
            }
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSet";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/phpunit/PhpUnitQualifiedNameLocationProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathMapper";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocation";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "splitMethodAndDataSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getLocation";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getLocationInfo";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "processMethod";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "tryFindDataProviderKeyFromDoc";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "tryFindDataProviderKeyFromAttributes";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "processDataProviderReferences";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "handleYields";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "handleReturns";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 9, 10, 11, 12, 14, 15, 16, 17 -> new IllegalStateException(string);
        };
    }

    public static final class LocationElementStore
    extends Record {
        @NotNull
        private final PsiElement primaryNavigationElement;
        @Nullable
        private final PsiElement testDetectionElement;

        public LocationElementStore(@NotNull PsiElement element) {
            if (element == null) {
                LocationElementStore.$$$reportNull$$$0(0);
            }
            this(element, null);
        }

        public LocationElementStore(@NotNull PsiElement primaryNavigationElement, @Nullable PsiElement testDetectionElement) {
            if (primaryNavigationElement == null) {
                LocationElementStore.$$$reportNull$$$0(1);
            }
            this.primaryNavigationElement = primaryNavigationElement;
            this.testDetectionElement = testDetectionElement;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{LocationElementStore.class, "primaryNavigationElement;testDetectionElement", "primaryNavigationElement", "testDetectionElement"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{LocationElementStore.class, "primaryNavigationElement;testDetectionElement", "primaryNavigationElement", "testDetectionElement"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{LocationElementStore.class, "primaryNavigationElement;testDetectionElement", "primaryNavigationElement", "testDetectionElement"}, this, o);
        }

        @NotNull
        public PsiElement primaryNavigationElement() {
            PsiElement psiElement = this.primaryNavigationElement;
            if (psiElement == null) {
                LocationElementStore.$$$reportNull$$$0(2);
            }
            return psiElement;
        }

        @Nullable
        public PsiElement testDetectionElement() {
            return this.testDetectionElement;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "primaryNavigationElement";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/phpunit/PhpUnitQualifiedNameLocationProvider$LocationElementStore";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/phpunit/PhpUnitQualifiedNameLocationProvider$LocationElementStore";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "primaryNavigationElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

