/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phpunit;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.SMTestRunnerConnectionUtil;
import com.intellij.execution.testframework.ui.BaseTestsOutputConsoleView;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.composer.actions.update.ComposerInstalledPackagesService;
import com.jetbrains.php.composer.statistics.ComposerPackageVersion;
import com.jetbrains.php.composer.statistics.ComposerPackageVersionParser;
import com.jetbrains.php.config.commandLine.PhpCommandSettings;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocRef;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpAttribute;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.phpunit.PhpParaTestRunner;
import com.jetbrains.php.phpunit.PhpUnitConsoleProperties;
import com.jetbrains.php.phpunit.PhpUnitSettings;
import com.jetbrains.php.phpunit.PhpUnitSettingsManager;
import com.jetbrains.php.phpunit.PhpUnitTestPattern;
import com.jetbrains.php.phpunit.PhpUnitTestRunnerSettings;
import com.jetbrains.php.phpunit.PhpUnitUtil;
import com.jetbrains.php.run.PhpExecutionUtil;
import com.jetbrains.php.run.PhpRunUtil;
import com.jetbrains.php.run.filters.PhpUnitFilter;
import com.jetbrains.php.run.filters.XdebugCallStackFilter;
import com.jetbrains.php.util.pathmapper.PhpPathMapper;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpUnitExecutionUtil {
    private static final Logger LOG = Logger.getInstance(PhpUnitExecutionUtil.class);
    public static final String PHPUNIT_HELPER_SCRIPT_NAME = "phpunit.php";
    public static final String PHPSTORM_BOOTSTRAP_SCRIPT_NAME = "phpstorm_bootstrap.php";
    public static final String PHPUNIT_VERSION = "IDE_PHPUNIT_VERSION";
    public static final String PHPUNIT_HELPER_ENV_CUSTOM_LOADER = "IDE_PHPUNIT_CUSTOM_LOADER";
    public static final String PHPUNIT_HELPER_ENV_PHPUNIT_PHAR = "IDE_PHPUNIT_PHPUNIT_PHAR";
    public static final String PHPUNIT_HELPER_ENV_PHPUNIT_INCLUDE = "IDE_PHPUNIT_PHPUNIT_INCLUDE";
    private static final String DEPENDS_TAG = "@depends";
    private static final String DEPENDS_FQN = "\\PHPUnit\\Framework\\Attributes\\Depends";
    @NotNull
    private static final ComposerPackageVersion PARATEST_FILTER_FIX_VERSION = Objects.requireNonNull(ComposerPackageVersionParser.parseVersion(">=6.6.5"));

    private PhpUnitExecutionUtil() {
    }

    public static ConsoleView createConsole(@NotNull Project project, @NotNull ProcessHandler processHandler, @NotNull PhpUnitConsoleProperties properties) {
        if (project == null) {
            PhpUnitExecutionUtil.$$$reportNull$$$0(0);
        }
        if (processHandler == null) {
            PhpUnitExecutionUtil.$$$reportNull$$$0(1);
        }
        if (properties == null) {
            PhpUnitExecutionUtil.$$$reportNull$$$0(2);
        }
        PhpPathMapper pathMapper = properties.getPathMapper();
        properties.addStackTraceFilter(new PhpUnitFilter(project, pathMapper));
        properties.addStackTraceFilter(new XdebugCallStackFilter(project, pathMapper));
        BaseTestsOutputConsoleView testsOutputConsoleView = SMTestRunnerConnectionUtil.createConsole((String)"PhpUnit", (TestConsoleProperties)properties);
        testsOutputConsoleView.attachToProcess(processHandler);
        PhpExecutionUtil.addMessageFilters(project, (ConsoleView)testsOutputConsoleView, pathMapper);
        Disposer.register((Disposable)PhpUnitSettingsManager.getInstance(project), (Disposable)testsOutputConsoleView);
        return testsOutputConsoleView;
    }

    @NotNull
    public static VirtualFile getPhpUnitHelperScriptFile() throws ExecutionException {
        String phpunitScriptPath = System.getProperty("phpunit.script.path");
        if (phpunitScriptPath != null) {
            VirtualFile file = LocalFileSystem.getInstance().refreshAndFindFileByPath(phpunitScriptPath);
            LOG.assertTrue(file != null, (Object)("Cannot find phpunit script at " + phpunitScriptPath));
            VirtualFile virtualFile = file;
            if (virtualFile == null) {
                PhpUnitExecutionUtil.$$$reportNull$$$0(3);
            }
            return virtualFile;
        }
        VirtualFile virtualFile = PhpExecutionUtil.getHelperScriptFile(PHPUNIT_HELPER_SCRIPT_NAME);
        if (virtualFile == null) {
            PhpUnitExecutionUtil.$$$reportNull$$$0(4);
        }
        return virtualFile;
    }

    public static void fillConfigurationOption(@Nullable String configurationFilePath, @NotNull PhpCommandSettings command, boolean useMappingsForConfigurationFile, boolean useParaTest) {
        if (command == null) {
            PhpUnitExecutionUtil.$$$reportNull$$$0(5);
        }
        if (StringUtil.isNotEmpty((String)configurationFilePath)) {
            command.addArgument("--configuration");
            if (useMappingsForConfigurationFile) {
                command.addPathArgument(configurationFilePath);
            } else {
                command.addArgument(configurationFilePath);
            }
        } else if (!useParaTest) {
            command.addArgument("--no-configuration");
        }
    }

    private static void fillBootstrapOption(@Nullable String bootstrapFilePath, @NotNull PhpCommandSettings command, boolean useMappingsForBootstrapFile) {
        if (command == null) {
            PhpUnitExecutionUtil.$$$reportNull$$$0(6);
        }
        if (StringUtil.isNotEmpty((String)bootstrapFilePath)) {
            command.addArgument("--bootstrap");
            if (useMappingsForBootstrapFile) {
                command.addPathArgument(bootstrapFilePath);
            } else {
                command.addArgument(bootstrapFilePath);
            }
        }
    }

    public static void fillPhpUnitTestRunnerArguments(@NotNull Project project, @NotNull PhpUnitTestRunnerSettings testRunnerSettings, @NotNull List<String> arguments, @NotNull PhpCommandSettings command, @Nullable PhpUnitSettings phpUnitConfiguration) {
        String testRunnerOptions;
        String configurationFilePath;
        if (project == null) {
            PhpUnitExecutionUtil.$$$reportNull$$$0(7);
        }
        if (testRunnerSettings == null) {
            PhpUnitExecutionUtil.$$$reportNull$$$0(8);
        }
        if (arguments == null) {
            PhpUnitExecutionUtil.$$$reportNull$$$0(9);
        }
        if (command == null) {
            PhpUnitExecutionUtil.$$$reportNull$$$0(10);
        }
        boolean useParaTest = PhpUnitExecutionUtil.isUseParaTest(project, testRunnerSettings);
        boolean useLocalConfigurationFile = testRunnerSettings.isUseAlternativeConfigurationFile();
        if (useLocalConfigurationFile) {
            configurationFilePath = testRunnerSettings.getConfigurationFilePath();
        } else if (phpUnitConfiguration != null && phpUnitConfiguration.isUseConfigurationFile()) {
            configurationFilePath = phpUnitConfiguration.getConfigurationFilePath();
            testRunnerSettings.setConfigurationFilePath(configurationFilePath);
        } else {
            configurationFilePath = null;
        }
        String bootstrapFilePath = PhpUnitExecutionUtil.getBootstrapFilePath(project, testRunnerSettings, command, phpUnitConfiguration, configurationFilePath, useParaTest);
        if (useParaTest) {
            PhpUnitExecutionUtil.fillBootstrapOption(bootstrapFilePath, command, testRunnerSettings.isUseAlternativeBootstrapFile());
        }
        if (StringUtil.isNotEmpty((String)(testRunnerOptions = testRunnerSettings.getTestRunnerOptions()))) {
            command.addArguments(Arrays.asList(ParametersList.parse((String)testRunnerOptions)));
        }
        command.addArguments(arguments);
        if (!useParaTest) {
            PhpUnitExecutionUtil.fillBootstrapOption(bootstrapFilePath, command, testRunnerSettings.isUseAlternativeBootstrapFile());
        }
        PhpUnitExecutionUtil.fillConfigurationOption(configurationFilePath, command, useLocalConfigurationFile, useParaTest);
        PhpUnitExecutionUtil.fillCommandArguments(project, testRunnerSettings, command);
    }

    @Nullable
    private static String getBootstrapFilePath(@NotNull Project project, @NotNull PhpUnitTestRunnerSettings testRunnerSettings, @NotNull PhpCommandSettings command, @Nullable PhpUnitSettings phpUnitConfiguration, @Nullable String configurationFilePath, boolean useParaTest) {
        if (project == null) {
            PhpUnitExecutionUtil.$$$reportNull$$$0(11);
        }
        if (testRunnerSettings == null) {
            PhpUnitExecutionUtil.$$$reportNull$$$0(12);
        }
        if (command == null) {
            PhpUnitExecutionUtil.$$$reportNull$$$0(13);
        }
        if (testRunnerSettings.isUseAlternativeBootstrapFile()) {
            return testRunnerSettings.getBootstrapFilePath();
        }
        if (phpUnitConfiguration != null && phpUnitConfiguration.isUseBootstrapFile()) {
            return phpUnitConfiguration.getBootstrapFilePath();
        }
        if (useParaTest && StringUtil.isEmpty((String)configurationFilePath)) {
            try {
                return PhpExecutionUtil.loadHelperScriptAndGetText(project, PHPSTORM_BOOTSTRAP_SCRIPT_NAME, command, PhpUnitExecutionUtil.class);
            }
            catch (ExecutionException e) {
                LOG.error("Failed to load phpstorm_bootstrap.php script", (Throwable)e);
            }
        }
        return null;
    }

    public static void fillCommandArguments(@NotNull Project project, @NotNull PhpUnitTestRunnerSettings testRunnerSettings, @NotNull PhpCommandSettings command) {
        if (project == null) {
            PhpUnitExecutionUtil.$$$reportNull$$$0(14);
        }
        if (testRunnerSettings == null) {
            PhpUnitExecutionUtil.$$$reportNull$$$0(15);
        }
        if (command == null) {
            PhpUnitExecutionUtil.$$$reportNull$$$0(16);
        }
        PhpUnitTestRunnerSettings.Scope scope = testRunnerSettings.getScope();
        switch (scope) {
            case Directory: {
                command.addPathArgument(StringUtil.notNullize((String)testRunnerSettings.getDirectoryPath()));
                break;
            }
            case Class: {
                PhpClass aClass = PhpUnitExecutionUtil.findClass(project, testRunnerSettings.getFilePath(), testRunnerSettings.getClassName());
                command.addArgument(aClass != null && PhpUnitUtil.isTestSuite(aClass) ? "--testsuite" : "--filter");
                command.addClassFqnArgument(StringUtil.notNullize((String)testRunnerSettings.getClassName()));
                PhpUnitExecutionUtil.addFilePathArgument(testRunnerSettings, command);
                break;
            }
            case Method: {
                PhpClass aClass = PhpUnitExecutionUtil.findClass(project, testRunnerSettings.getFilePath(), testRunnerSettings.getClassName());
                command.addArgument(aClass != null && PhpUnitUtil.isTestSuite(aClass) ? "--testsuite" : "--filter");
                command.addClassFqnArgument("/" + PhpUnitExecutionUtil.createMethodWithDependenciesFilterArgument(project, testRunnerSettings) + "( .*)?$/");
                PhpUnitExecutionUtil.addFilePathArgument(testRunnerSettings, command);
                break;
            }
            case Pattern: {
                command.addArgument("--filter");
                command.addArgument("/" + PhpUnitExecutionUtil.createFilterArgument(project, testRunnerSettings.getTestPatterns()) + "$/");
                if (testRunnerSettings.getFilePath() != null) {
                    PhpUnitExecutionUtil.addFilePathArgument(testRunnerSettings, command);
                    break;
                }
                if (testRunnerSettings.getDirectoryPath() == null) break;
                command.addPathArgument(testRunnerSettings.getDirectoryPath());
            }
        }
    }

    public static boolean isUseParaTest(@NotNull Project project, @NotNull PhpUnitTestRunnerSettings testRunnerSettings) {
        if (project == null) {
            PhpUnitExecutionUtil.$$$reportNull$$$0(17);
        }
        if (testRunnerSettings == null) {
            PhpUnitExecutionUtil.$$$reportNull$$$0(18);
        }
        return !PhpUnitExecutionUtil.hasUnsupportedParaTestOptions(project, testRunnerSettings) && testRunnerSettings.isUseParaTest() && StringUtil.isNotEmpty((String)testRunnerSettings.getParaTestPath());
    }

    public static boolean hasUnsupportedParaTestOptions(@NotNull Project project, @NotNull PhpUnitTestRunnerSettings testRunnerSettings) {
        if (project == null) {
            PhpUnitExecutionUtil.$$$reportNull$$$0(19);
        }
        if (testRunnerSettings == null) {
            PhpUnitExecutionUtil.$$$reportNull$$$0(20);
        }
        if (!testRunnerSettings.isUseParaTest() || StringUtil.isEmpty((String)testRunnerSettings.getParaTestPath())) {
            return false;
        }
        VirtualFile paraTestBin = LocalFileSystem.getInstance().findFileByPath(testRunnerSettings.getParaTestPath());
        ComposerPackageVersion version = PhpUnitExecutionUtil.getParaTestVersion(project, paraTestBin);
        if (version == null || !PARATEST_FILTER_FIX_VERSION.isGreaterThan(version)) {
            return false;
        }
        PhpUnitTestRunnerSettings.Scope scope = testRunnerSettings.getScope();
        return !PhpParaTestRunner.SUPPORTED_SCOPES.contains((Object)scope) || !testRunnerSettings.getTestPatterns().isEmpty();
    }

    @Nullable
    public static ComposerPackageVersion getParaTestVersion(@NotNull Project project, @Nullable VirtualFile context) {
        ComposerInstalledPackagesService installedPackagesService;
        if (project == null) {
            PhpUnitExecutionUtil.$$$reportNull$$$0(21);
        }
        if ((installedPackagesService = ComposerInstalledPackagesService.getInstance(project, context)) == null) {
            return null;
        }
        String versionStr = installedPackagesService.getCurrentPackageVersion("brianium/paratest");
        if (versionStr == null) {
            return null;
        }
        return ComposerPackageVersionParser.parseVersion(versionStr);
    }

    private static void addFilePathArgument(@NotNull PhpUnitTestRunnerSettings testRunnerSettings, @NotNull PhpCommandSettings command) {
        if (testRunnerSettings == null) {
            PhpUnitExecutionUtil.$$$reportNull$$$0(22);
        }
        if (command == null) {
            PhpUnitExecutionUtil.$$$reportNull$$$0(23);
        }
        command.addArgument("--test-suffix");
        command.addArgument(PathUtil.getFileName((String)StringUtil.notNullize((String)testRunnerSettings.getFilePath())));
        String path = PathUtil.getParentPath((String)StringUtil.notNullize((String)testRunnerSettings.getFilePath()));
        if (!StringUtil.isEmpty((String)path)) {
            command.addPathArgument(path);
        }
    }

    @NotNull
    private static String createFilterArgument(@NotNull Project project, @NotNull List<? extends PhpUnitTestPattern> patterns) {
        if (project == null) {
            PhpUnitExecutionUtil.$$$reportNull$$$0(24);
        }
        if (patterns == null) {
            PhpUnitExecutionUtil.$$$reportNull$$$0(25);
        }
        HashSet<? extends PhpUnitTestPattern> patternsWithDependencies = new HashSet<PhpUnitTestPattern>(patterns);
        for (PhpUnitTestPattern phpUnitTestPattern : patterns) {
            Method method = PhpUnitExecutionUtil.findMethod(project, phpUnitTestPattern.getContainingFileAbsolutePath(), phpUnitTestPattern.getClassFqn(), phpUnitTestPattern.getMethodName());
            PhpClass containingClass = method != null ? method.getContainingClass() : null;
            if (containingClass == null) continue;
            for (Method dependencyMethod : PhpUnitExecutionUtil.collectMethodDependencies(method, containingClass)) {
                ContainerUtil.addIfNotNull(patternsWithDependencies, (Object)PhpUnitTestPattern.create((PhpNamedElement)dependencyMethod));
            }
        }
        return PhpUnitExecutionUtil.concatenateTests(patternsWithDependencies);
    }

    @NotNull
    private static String createMethodWithDependenciesFilterArgument(@NotNull Project project, @NotNull PhpUnitTestRunnerSettings testRunnerSettings) {
        PhpClass testClass;
        Method method;
        if (project == null) {
            PhpUnitExecutionUtil.$$$reportNull$$$0(26);
        }
        if (testRunnerSettings == null) {
            PhpUnitExecutionUtil.$$$reportNull$$$0(27);
        }
        if ((method = PhpUnitExecutionUtil.findMethod(project, testRunnerSettings.getFilePath(), testRunnerSettings.getClassName(), testRunnerSettings.getMethodName())) != null && (testClass = method.getContainingClass()) != null) {
            return PhpUnitExecutionUtil.createDependenciesMethodNamesArgument(method, testClass);
        }
        String string = "::" + StringUtil.notNullize((String)testRunnerSettings.getMethodName());
        if (string == null) {
            PhpUnitExecutionUtil.$$$reportNull$$$0(28);
        }
        return string;
    }

    @Nullable
    public static Method findMethod(@NotNull Project project, @Nullable String filePath, @Nullable String classFQN, @Nullable String methodName) {
        PhpClass testClass;
        PhpFile file;
        if (project == null) {
            PhpUnitExecutionUtil.$$$reportNull$$$0(29);
        }
        if (!DumbService.isDumb((Project)project) && (file = (PhpFile)ObjectUtils.tryCast((Object)PhpRunUtil.findPsiFile(project, filePath, true), PhpFile.class)) != null && (testClass = PhpUnitUtil.findClassByFQNInFile(PhpLangUtil.toFQN(StringUtil.notNullize((String)classFQN)), (PsiFile)file, project)) != null) {
            return testClass.findOwnMethodByName((CharSequence)methodName);
        }
        return null;
    }

    @Nullable
    public static PhpClass findClass(@NotNull Project project, @Nullable String filePath, @Nullable String classFQN) {
        PhpFile file;
        if (project == null) {
            PhpUnitExecutionUtil.$$$reportNull$$$0(30);
        }
        if (!DumbService.isDumb((Project)project) && (file = (PhpFile)ObjectUtils.tryCast((Object)PhpRunUtil.findPsiFile(project, filePath, true), PhpFile.class)) != null) {
            return PhpUnitUtil.findClassByFQNInFile(PhpLangUtil.toFQN(StringUtil.notNullize((String)classFQN)), (PsiFile)file, project);
        }
        return null;
    }

    @NotNull
    private static String createDependenciesMethodNamesArgument(@NotNull Method testMethod, @NotNull PhpClass testClass) {
        if (testMethod == null) {
            PhpUnitExecutionUtil.$$$reportNull$$$0(31);
        }
        if (testClass == null) {
            PhpUnitExecutionUtil.$$$reportNull$$$0(32);
        }
        String string = "(" + StreamEx.of(PhpUnitExecutionUtil.collectMethodDependencies(testMethod, testClass)).append((Object)testMethod).map(m -> testClass.getPresentableFQN() + "::" + m.getName()).joining((CharSequence)"|") + ")";
        if (string == null) {
            PhpUnitExecutionUtil.$$$reportNull$$$0(33);
        }
        return string;
    }

    @NotNull
    private static Collection<Method> collectMethodDependencies(@NotNull Method testMethod, @NotNull PhpClass testClass) {
        if (testMethod == null) {
            PhpUnitExecutionUtil.$$$reportNull$$$0(34);
        }
        if (testClass == null) {
            PhpUnitExecutionUtil.$$$reportNull$$$0(35);
        }
        String testNamespace = testClass.getNamespaceName();
        String testClassFQN = testClass.getFQN();
        ArrayDeque<Method> dependencies = new ArrayDeque<Method>();
        dependencies.addLast(testMethod);
        HashSet<Method> visited = new HashSet<Method>();
        while (!dependencies.isEmpty()) {
            Method currentMethod = (Method)dependencies.pollFirst();
            if (!visited.add(currentMethod)) continue;
            PhpUnitExecutionUtil.addPhpDocDependencyTestMethods(testClass, currentMethod, testNamespace, testClassFQN, dependencies);
            PhpUnitExecutionUtil.addAttributeDependencyTestMethods(testClass, currentMethod, dependencies);
        }
        visited.remove(testMethod);
        HashSet<Method> hashSet = visited;
        if (hashSet == null) {
            PhpUnitExecutionUtil.$$$reportNull$$$0(36);
        }
        return hashSet;
    }

    private static void addAttributeDependencyTestMethods(@NotNull PhpClass testClass, Method currentMethod, Deque<Method> dependencies) {
        if (testClass == null) {
            PhpUnitExecutionUtil.$$$reportNull$$$0(37);
        }
        for (PhpAttribute attribute : currentMethod.getAttributes()) {
            if (!DEPENDS_FQN.equals(attribute.getFQN())) continue;
            for (PhpAttribute.PhpAttributeArgument argument : attribute.getArguments()) {
                PhpNamedElement dependencyElement = argument.getArgument().getNamedElement(currentMethod.getProject());
                if (dependencyElement instanceof Method) {
                    Method dependencyMethod = (Method)dependencyElement;
                    dependencies.add(dependencyMethod);
                    continue;
                }
                Method method = testClass.findOwnMethodByName((CharSequence)StringUtil.unquoteString((String)argument.getArgument().getValue()));
                ContainerUtil.addIfNotNull(dependencies, (Object)method);
            }
        }
    }

    private static void addPhpDocDependencyTestMethods(@NotNull PhpClass testClass, Method currentMethod, String testNamespace, String testClassFQN, Deque<Method> dependencies) {
        PhpDocComment docComment;
        PhpDocTag[] tags;
        if (testClass == null) {
            PhpUnitExecutionUtil.$$$reportNull$$$0(38);
        }
        for (PhpDocTag tag : tags = (docComment = currentMethod.getDocComment()) != null ? docComment.getTagElementsByName(DEPENDS_TAG) : PhpDocTag.EMPTY_ARRAY) {
            Pair<String, String> dependencyPair = PhpUnitUtil.getClassFqnAndMethodName((PhpDocRef)PsiTreeUtil.getChildOfType((PsiElement)tag, PhpDocRef.class), testNamespace);
            String dependencyClassFQN = (String)dependencyPair.getFirst();
            String dependencyMethodName = (String)dependencyPair.getSecond();
            if (dependencyMethodName == null || dependencyClassFQN != null && PhpLangUtil.compareFQN(dependencyClassFQN, testClassFQN) != 0) continue;
            ContainerUtil.addIfNotNull(dependencies, (Object)testClass.findOwnMethodByName((CharSequence)dependencyMethodName));
        }
    }

    @NotNull
    public static String concatenateTests(@NotNull Collection<? extends PhpUnitTestPattern> testPatterns) {
        if (testPatterns == null) {
            PhpUnitExecutionUtil.$$$reportNull$$$0(39);
        }
        Map<String, Collection<String>> testMap = PhpUnitExecutionUtil.collectArgumentsForCommandLine(testPatterns);
        int size = testMap.size();
        StringBuilder builder2 = new StringBuilder(size * 10);
        int added = 0;
        for (Map.Entry<String, Collection<String>> entry : testMap.entrySet()) {
            ++added;
            builder2.append(entry.getKey());
            if (entry.getValue().isEmpty()) {
                builder2.append("::").append("(.*)");
            } else if (entry.getValue().size() == 1) {
                builder2.append("::").append(entry.getValue().iterator().next());
            } else {
                builder2.append("::(").append(StringUtil.join(entry.getValue(), (String)"|")).append(")");
            }
            if (added >= size) continue;
            builder2.append("|");
        }
        Object testNames = builder2.toString();
        if (size > 1) {
            testNames = "(" + (String)testNames + ")";
        }
        String string = testNames;
        if (string == null) {
            PhpUnitExecutionUtil.$$$reportNull$$$0(40);
        }
        return string;
    }

    @NotNull
    public static Map<String, Collection<String>> collectArgumentsForCommandLine(@NotNull Collection<? extends PhpUnitTestPattern> testPatterns) {
        if (testPatterns == null) {
            PhpUnitExecutionUtil.$$$reportNull$$$0(41);
        }
        Map map = StreamEx.of(testPatterns).groupingBy(PhpUnitTestPattern::getClassFqn, Collectors.toSet());
        for (PhpUnitTestPattern phpUnitTestPattern : testPatterns) {
            if (StringUtil.isEmpty((String)phpUnitTestPattern.getMethodName())) {
                map.put(phpUnitTestPattern.getClassFqn(), Collections.emptySet());
                continue;
            }
            if (!StringUtil.isEmpty((String)phpUnitTestPattern.getDataSet())) continue;
            map.put(phpUnitTestPattern.getClassFqn(), PhpUnitExecutionUtil.removePatternsWithDataSetsByMethodName(phpUnitTestPattern.getMethodName(), (Set)map.get(phpUnitTestPattern.getClassFqn())));
        }
        Map map2 = StreamEx.of(map.keySet()).toMap(StringUtil::escapeBackSlashes, k -> ContainerUtil.map((Collection)((Collection)map.get(k)), PhpUnitExecutionUtil::formatMethodPatternForCommandLine));
        if (map2 == null) {
            PhpUnitExecutionUtil.$$$reportNull$$$0(42);
        }
        return map2;
    }

    @NotNull
    public static Set<PhpUnitTestPattern> removePatternsWithDataSetsByMethodName(@NotNull String methodName, @NotNull Set<PhpUnitTestPattern> patterns) {
        if (methodName == null) {
            PhpUnitExecutionUtil.$$$reportNull$$$0(43);
        }
        if (patterns == null) {
            PhpUnitExecutionUtil.$$$reportNull$$$0(44);
        }
        Set set = ((StreamEx)StreamEx.of(patterns).remove(p -> StringUtil.isNotEmpty((String)p.getDataSet()) && StringUtil.equals((CharSequence)methodName, (CharSequence)p.getMethodName()))).toSet();
        if (set == null) {
            PhpUnitExecutionUtil.$$$reportNull$$$0(45);
        }
        return set;
    }

    @NotNull
    private static String formatMethodPatternForCommandLine(@NotNull PhpUnitTestPattern pattern) {
        if (pattern == null) {
            PhpUnitExecutionUtil.$$$reportNull$$$0(46);
        }
        assert (StringUtil.isNotEmpty((String)pattern.getMethodName()));
        StringBuilder sb = new StringBuilder();
        sb.append(pattern.getMethodName());
        String dataSet = pattern.getDataSet();
        if (StringUtil.isNotEmpty((String)dataSet)) {
            sb.append(" with data set ");
            sb.append((String)(dataSet.startsWith("#") ? dataSet : "\"" + StringUtil.escapeToRegexp((String)StringUtil.unquoteString((String)dataSet)) + "\""));
        } else {
            sb.append("( .*)?$");
        }
        String string = sb.toString();
        if (string == null) {
            PhpUnitExecutionUtil.$$$reportNull$$$0(47);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 28, 33, 36, 40, 42, 45, 47 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 3: 
            case 4: 
            case 28: 
            case 33: 
            case 36: 
            case 40: 
            case 42: 
            case 45: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/phpunit/PhpUnitExecutionUtil";
                break;
            }
            case 5: 
            case 6: 
            case 10: 
            case 13: 
            case 16: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 8: 
            case 12: 
            case 15: 
            case 18: 
            case 20: 
            case 22: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testRunnerSettings";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 25: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patterns";
                break;
            }
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testMethod";
                break;
            }
            case 32: 
            case 35: 
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testClass";
                break;
            }
            case 39: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testPatterns";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/phpunit/PhpUnitExecutionUtil";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPhpUnitHelperScriptFile";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "createMethodWithDependenciesFilterArgument";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "createDependenciesMethodNamesArgument";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "collectMethodDependencies";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "concatenateTests";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "collectArgumentsForCommandLine";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "removePatternsWithDataSetsByMethodName";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "formatMethodPatternForCommandLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createConsole";
                break;
            }
            case 3: 
            case 4: 
            case 28: 
            case 33: 
            case 36: 
            case 40: 
            case 42: 
            case 45: 
            case 47: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "fillConfigurationOption";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "fillBootstrapOption";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "fillPhpUnitTestRunnerArguments";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getBootstrapFilePath";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "fillCommandArguments";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isUseParaTest";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "hasUnsupportedParaTestOptions";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getParaTestVersion";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addFilePathArgument";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createFilterArgument";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createMethodWithDependenciesFilterArgument";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "findMethod";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "findClass";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "createDependenciesMethodNamesArgument";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "collectMethodDependencies";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "addAttributeDependencyTestMethods";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "addPhpDocDependencyTestMethods";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "concatenateTests";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "collectArgumentsForCommandLine";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "removePatternsWithDataSetsByMethodName";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "formatMethodPatternForCommandLine";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 28, 33, 36, 40, 42, 45, 47 -> new IllegalStateException(string);
        };
    }
}

