/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phpunit;

import com.intellij.execution.Executor;
import com.intellij.execution.Location;
import com.intellij.execution.testframework.actions.AbstractRerunFailedTestsAction;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.execution.testframework.sm.runner.SMTRunnerEventsListener;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.testframework.sm.runner.ui.TestStackTraceParser;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentContainer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.Navigatable;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.phpunit.ParaTestSMTEventsAdapter;
import com.jetbrains.php.phpunit.PhpMethodLocation;
import com.jetbrains.php.phpunit.PhpParaTestExecutor;
import com.jetbrains.php.phpunit.PhpPsiLocationWithDataSet;
import com.jetbrains.php.phpunit.PhpUnitExecutionUtil;
import com.jetbrains.php.phpunit.PhpUnitLocalRunConfiguration;
import com.jetbrains.php.phpunit.PhpUnitQualifiedNameLocationProvider;
import com.jetbrains.php.phpunit.PhpUnitRunConfigurationSettings;
import com.jetbrains.php.phpunit.PhpUnitTestStackTraceParser;
import com.jetbrains.php.phpunit.actions.PhpUnitRerunFailedTestsAction;
import com.jetbrains.php.run.PhpRunConfiguration;
import com.jetbrains.php.util.pathmapper.PhpPathMapper;
import java.util.Arrays;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpUnitConsoleProperties<T extends PhpRunConfiguration>
extends SMTRunnerConsoleProperties {
    private final PhpUnitQualifiedNameLocationProvider myLocator;
    private final boolean myMultipleSelectionInTreeSupported;

    public PhpUnitConsoleProperties(@NotNull T config, @NotNull Executor executor, @NotNull PhpUnitQualifiedNameLocationProvider locator, boolean multipleSelectionInTreeSupported) {
        if (config == null) {
            PhpUnitConsoleProperties.$$$reportNull$$$0(0);
        }
        if (executor == null) {
            PhpUnitConsoleProperties.$$$reportNull$$$0(1);
        }
        if (locator == null) {
            PhpUnitConsoleProperties.$$$reportNull$$$0(2);
        }
        super(config, "PhpUnit", executor);
        this.myLocator = locator;
        this.myMultipleSelectionInTreeSupported = multipleSelectionInTreeSupported;
        if (executor instanceof PhpParaTestExecutor || PhpUnitConsoleProperties.isUseParaTest(config)) {
            config.getProject().getMessageBus().connect((Disposable)this).subscribe(SMTRunnerEventsListener.TEST_STATUS, (Object)new ParaTestSMTEventsAdapter());
        }
    }

    private static boolean isUseParaTest(@NotNull PhpRunConfiguration<?> config) {
        if (config == null) {
            PhpUnitConsoleProperties.$$$reportNull$$$0(3);
        }
        if (!(config instanceof PhpUnitLocalRunConfiguration)) {
            return false;
        }
        PhpUnitLocalRunConfiguration phpUnit = (PhpUnitLocalRunConfiguration)config;
        return PhpUnitExecutionUtil.isUseParaTest(phpUnit.getProject(), ((PhpUnitRunConfigurationSettings)phpUnit.getSettings()).getTestRunnerSettings());
    }

    public SMTestLocator getTestLocator() {
        return this.myLocator;
    }

    @NotNull
    public PhpPathMapper getPathMapper() {
        PhpPathMapper phpPathMapper = this.myLocator.getPathMapper();
        if (phpPathMapper == null) {
            PhpUnitConsoleProperties.$$$reportNull$$$0(4);
        }
        return phpPathMapper;
    }

    @Nullable
    public AbstractRerunFailedTestsAction createRerunFailedTestsAction(ConsoleView consoleView) {
        return new PhpUnitRerunFailedTestsAction((ComponentContainer)consoleView, this);
    }

    @Nullable
    public Navigatable getErrorNavigatable(@NotNull Location<?> location, @NotNull String stacktrace) {
        String reversedStackTrace;
        Navigatable navigatable;
        if (location == null) {
            PhpUnitConsoleProperties.$$$reportNull$$$0(5);
        }
        if (stacktrace == null) {
            PhpUnitConsoleProperties.$$$reportNull$$$0(6);
        }
        if (location instanceof PhpPsiLocationWithDataSet && !(location.getPsiElement() instanceof Method)) {
            return location.getNavigatable();
        }
        Object[] lines = StringUtil.splitByLinesKeepSeparators((String)stacktrace);
        if (PhpUnitConsoleProperties.isLaravelTestCase((String[])lines)) {
            lines = (String[])Arrays.copyOfRange(lines, 0, lines.length - 1);
        }
        if ((navigatable = super.getErrorNavigatable(location, reversedStackTrace = ((StreamEx)StreamEx.ofReversed((Object[])lines).filter(line -> !line.isEmpty())).joining())) instanceof SMTRunnerConsoleProperties.FileHyperlinkNavigatable) {
            SMTRunnerConsoleProperties.FileHyperlinkNavigatable fileHyperlinkNavigatable = (SMTRunnerConsoleProperties.FileHyperlinkNavigatable)navigatable;
            if (location instanceof PhpMethodLocation) {
                PhpMethodLocation methodLocation = (PhpMethodLocation)location;
                if (!fileHyperlinkNavigatable.getOpenFileDescriptor().getFile().equals(methodLocation.getVirtualFile())) {
                    return methodLocation.getNavigatable();
                }
                int offset = fileHyperlinkNavigatable.getOpenFileDescriptor().getOffset();
                TextRange methodTextRange = ((Method)methodLocation.getPsiElement()).getTextRange();
                if (!methodTextRange.contains(offset)) {
                    return methodLocation.getNavigatable();
                }
            }
        }
        return navigatable;
    }

    private static boolean isLaravelTestCase(String[] lines) {
        if (lines.length < 2) {
            return false;
        }
        String last = lines[lines.length - 1];
        return last.matches("^.+(/|\\\\)laravel(/|\\\\)framework(/|\\\\)src(/|\\\\)Illuminate(/|\\\\)Foundation(/|\\\\)Testing(/|\\\\)TestCase.php:\\d+\\s*$");
    }

    public int getSelectionMode() {
        return this.myMultipleSelectionInTreeSupported ? 4 : super.getSelectionMode();
    }

    public boolean serviceMessageHasNewLinePrefix() {
        return true;
    }

    public TestStackTraceParser getTestStackTraceParser(@NotNull String url, @NotNull SMTestProxy proxy, @NotNull Project project) {
        if (url == null) {
            PhpUnitConsoleProperties.$$$reportNull$$$0(7);
        }
        if (proxy == null) {
            PhpUnitConsoleProperties.$$$reportNull$$$0(8);
        }
        if (project == null) {
            PhpUnitConsoleProperties.$$$reportNull$$$0(9);
        }
        return PhpUnitTestStackTraceParser.parse(url, proxy.getStacktrace(), proxy.getErrorMessage(), this.myLocator, project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/phpunit/PhpUnitConsoleProperties";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stacktrace";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "proxy";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/phpunit/PhpUnitConsoleProperties";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathMapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isUseParaTest";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getErrorNavigatable";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getTestStackTraceParser";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

