/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.navigation;

import com.intellij.codeInsight.navigation.actions.GotoDeclarationHandler;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocTokenTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpGotoInheritDocParentHandler
implements GotoDeclarationHandler {
    public PsiElement @Nullable [] getGotoDeclarationTargets(@Nullable PsiElement sourceElement, int offset, Editor editor) {
        PhpDocComment docComment;
        if (PhpGotoInheritDocParentHandler.isInheritDoc(sourceElement) && (docComment = PhpPsiUtil.getParentOfClass(sourceElement, PhpDocComment.class)) != null) {
            return ContainerUtil.filter(PhpGotoInheritDocParentHandler.findParents(docComment.getOwner()), parent -> parent.getDocComment() != null).toArray(PsiElement.EMPTY_ARRAY);
        }
        return null;
    }

    private static boolean isInheritDoc(@Nullable PsiElement element) {
        if (PhpPsiUtil.isOfType(element, PhpDocTokenTypes.DOC_TAG_NAME)) {
            String tagText = element.getText();
            return "@inheritDoc".equals(tagText) || "@inheritdoc".equals(tagText);
        }
        return false;
    }

    @NotNull
    private static Collection<? extends PhpNamedElement> findParents(@Nullable PsiElement childElement) {
        if (childElement instanceof PhpClass) {
            return PhpGotoInheritDocParentHandler.findSupers((PhpClass)childElement);
        }
        if (childElement instanceof Field || childElement instanceof Method) {
            MyHierarchySuperMembersProcessor superMembersProcessor = new MyHierarchySuperMembersProcessor();
            PhpClassHierarchyUtils.processSuperMembers((PhpClassMember)((PhpClassMember)childElement), (PhpClassHierarchyUtils.HierarchyClassMemberProcessor)superMembersProcessor);
            List<PhpClassMember> list = superMembersProcessor.myMembers;
            if (list == null) {
                PhpGotoInheritDocParentHandler.$$$reportNull$$$0(0);
            }
            return list;
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            PhpGotoInheritDocParentHandler.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    private static Collection<PhpClass> findSupers(@NotNull PhpClass clazz) {
        if (clazz == null) {
            PhpGotoInheritDocParentHandler.$$$reportNull$$$0(2);
        }
        ArrayList<PhpClass> supers = new ArrayList<PhpClass>();
        PhpClassHierarchyUtils.processSupers((PhpClass)clazz, (boolean)false, (boolean)false, (Processor)new CommonProcessors.CollectProcessor(supers));
        ArrayList<PhpClass> arrayList = supers;
        if (arrayList == null) {
            PhpGotoInheritDocParentHandler.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/navigation/PhpGotoInheritDocParentHandler";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "findParents";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/navigation/PhpGotoInheritDocParentHandler";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findSupers";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findSupers";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2 -> new IllegalArgumentException(string);
        };
    }

    private static class MyHierarchySuperMembersProcessor
    implements PhpClassHierarchyUtils.HierarchyClassMemberProcessor {
        private final List<PhpClassMember> myMembers = new ArrayList<PhpClassMember>();

        private MyHierarchySuperMembersProcessor() {
        }

        public boolean process(PhpClassMember member, PhpClass subClass, PhpClass baseClass) {
            Method superMethod;
            if (member instanceof Field) {
                if (subClass.isInterface() || baseClass.isInterface()) {
                    return false;
                }
                Field superField = baseClass.findOwnFieldByName((CharSequence)member.getName(), ((Field)member).isConstant());
                if (superField == null || !MyHierarchySuperMembersProcessor.isAnyPrivate(member, (PhpClassMember)superField)) {
                    this.myMembers.add(member);
                    return true;
                }
            } else if (member instanceof Method && ((superMethod = baseClass.findOwnMethodByName((CharSequence)member.getName())) == null || !MyHierarchySuperMembersProcessor.isAnyPrivate(member, (PhpClassMember)superMethod))) {
                this.myMembers.add(member);
                return true;
            }
            return false;
        }

        private static boolean isAnyPrivate(PhpClassMember member, PhpClassMember superMember) {
            return superMember.getModifier().getAccess().isPrivate() || member.getModifier().getAccess().isPrivate();
        }
    }
}

