/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.stubs.indexes;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.BooleanDataDescriptor;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.KeyDescriptor;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.inspections.PhpLanguageFeatureUsageVisitor;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpTypeDeclaration;
import com.jetbrains.php.lang.psi.elements.impl.ArrayCreationExpressionImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeAnalyserVisitor;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpConstantNameIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpDepthLimitedRecursiveElementVisitor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpMaxLanguageLevelIndex
extends FileBasedIndexExtension<Boolean, PhpLanguageLevel> {
    @NonNls
    private static final ID<Boolean, PhpLanguageLevel> KEY = ID.create((String)"php.max.language.level");

    @NotNull
    public ID<Boolean, PhpLanguageLevel> getName() {
        ID<Boolean, PhpLanguageLevel> iD = KEY;
        if (iD == null) {
            PhpMaxLanguageLevelIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    @NotNull
    public DataIndexer<Boolean, PhpLanguageLevel, FileContent> getIndexer() {
        DataIndexer dataIndexer = inputData -> {
            final EnumSet<PhpLanguageFeature> usedFeatures = EnumSet.noneOf(PhpLanguageFeature.class);
            final PhpLanguageFeatureUsageVisitor visitor = new PhpLanguageFeatureUsageVisitor(this, false){

                @Override
                public void visitPhpParameter(Parameter parameter) {
                    PhpTypeDeclaration declaration = parameter.getTypeDeclaration();
                    if (declaration != null) {
                        this.checkScalarTypeHint(parameter, PhpLangUtil.toFQN(declaration.getText()));
                    }
                    super.visitPhpParameter(parameter);
                }

                @Override
                protected void checkFeature(@NotNull PhpLanguageFeature languageFeature, @NotNull String errorMessage, @NotNull PsiElement psiElement, @Nullable TextRange rangeInElement) {
                    if (languageFeature == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (errorMessage == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (psiElement == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    usedFeatures.add(languageFeature);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "languageFeature";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "errorMessage";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[0] = "psiElement";
                            break;
                        }
                    }
                    objectArray[1] = "com/jetbrains/php/lang/psi/stubs/indexes/PhpMaxLanguageLevelIndex$1";
                    objectArray[2] = "checkFeature";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            inputData.getPsiFile().accept((PsiElementVisitor)new PhpDepthLimitedRecursiveElementVisitor(this){

                @Override
                public void visitElement(@NotNull PsiElement element) {
                    if (element == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (element instanceof PhpDocComment) {
                        return;
                    }
                    element.accept((PsiElementVisitor)visitor);
                    if (element instanceof ArrayCreationExpression) {
                        ArrayCreationExpression arrayCreationExpression = (ArrayCreationExpression)element;
                        ArrayCreationExpressionImpl.children(arrayCreationExpression).limit(PhpTypeAnalyserVisitor.MAX_ARRAY_VALUES).forEach(x$0 -> super.visitElement((PsiElement)x$0));
                    } else {
                        super.visitElement(element);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/php/lang/psi/stubs/indexes/PhpMaxLanguageLevelIndex$2", "visitElement"));
                }
            });
            PhpLanguageLevel maxUsedLevel = PhpMaxLanguageLevelIndex.findMaxLanguageLevelWithFeature(usedFeatures);
            if (maxUsedLevel == null) {
                return Collections.emptyMap();
            }
            HashMap<Boolean, PhpLanguageLevel> map = new HashMap<Boolean, PhpLanguageLevel>();
            map.put(Boolean.TRUE, maxUsedLevel);
            return map;
        };
        if (dataIndexer == null) {
            PhpMaxLanguageLevelIndex.$$$reportNull$$$0(1);
        }
        return dataIndexer;
    }

    @Nullable
    private static PhpLanguageLevel findMaxLanguageLevelWithFeature(EnumSet<PhpLanguageFeature> features) {
        PhpLanguageLevel[] values = PhpLanguageLevel.values();
        int i = values.length - 1;
        while (i > 0) {
            int finalI;
            if (!ContainerUtil.exists(features, arg_0 -> PhpMaxLanguageLevelIndex.lambda$findMaxLanguageLevelWithFeature$1(values, finalI = i--, arg_0))) continue;
            return values[i];
        }
        return null;
    }

    @NotNull
    public KeyDescriptor<Boolean> getKeyDescriptor() {
        BooleanDataDescriptor booleanDataDescriptor = BooleanDataDescriptor.INSTANCE;
        if (booleanDataDescriptor == null) {
            PhpMaxLanguageLevelIndex.$$$reportNull$$$0(2);
        }
        return booleanDataDescriptor;
    }

    @NotNull
    public DataExternalizer<PhpLanguageLevel> getValueExternalizer() {
        return new DataExternalizer<PhpLanguageLevel>(this){

            public void save(@NotNull DataOutput out, PhpLanguageLevel value) throws IOException {
                if (out == null) {
                    3.$$$reportNull$$$0(0);
                }
                out.writeUTF(value.getVersionString());
            }

            public PhpLanguageLevel read(@NotNull DataInput in) throws IOException {
                if (in == null) {
                    3.$$$reportNull$$$0(1);
                }
                String versionString = in.readUTF();
                return (PhpLanguageLevel)ContainerUtil.find((Object[])PhpLanguageLevel.values(), level -> level.getVersionString().equals(versionString));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "out";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "in";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/php/lang/psi/stubs/indexes/PhpMaxLanguageLevelIndex$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "save";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "read";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    public int getVersion() {
        return 5;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull FileBasedIndex.InputFilter getInputFilter() {
        FileBasedIndex.InputFilter inputFilter = PhpConstantNameIndex.PHP_INPUT_FILTER;
        if (inputFilter == null) {
            PhpMaxLanguageLevelIndex.$$$reportNull$$$0(3);
        }
        return inputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    @Nullable
    public static PhpLanguageLevel getMaxUsedLanguageLevel(Project project) {
        return FileBasedIndex.getInstance().getValues(KEY, (Object)Boolean.TRUE, GlobalSearchScope.projectScope((Project)project)).stream().max(Comparator.comparingLong(Enum::ordinal)).orElse(null);
    }

    private static /* synthetic */ boolean lambda$findMaxLanguageLevelWithFeature$1(PhpLanguageLevel[] values, int finalI, PhpLanguageFeature languageFeature) {
        return values[finalI].hasFeature(languageFeature) && !values[finalI - 1].hasFeature(languageFeature);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/php/lang/psi/stubs/indexes/PhpMaxLanguageLevelIndex";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFilter";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

