/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.stubs;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.io.StringRef;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.stubs.PhpStubElementType;
import com.jetbrains.php.lang.psi.stubs.PhpStubSerializer;
import com.jetbrains.php.lang.psi.stubs.PhpUseStub;
import com.jetbrains.php.lang.psi.stubs.PhpUseStubImpl;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpUseReferenceNameIndex;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0016J\u001e\u0010\u000b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/php/lang/psi/stubs/PhpUseStubSerializer;", "Lcom/jetbrains/php/lang/psi/stubs/PhpStubSerializer;", "Lcom/jetbrains/php/lang/psi/elements/PhpUse;", "Lcom/jetbrains/php/lang/psi/stubs/PhpUseStub;", "<init>", "()V", "serialize", "", "stub", "dataStream", "Lcom/intellij/psi/stubs/StubOutputStream;", "deserialize", "Lcom/intellij/psi/stubs/StubInputStream;", "parentStub", "Lcom/intellij/psi/stubs/StubElement;", "getElementType", "Lcom/intellij/psi/tree/IElementType;", "indexStub", "sink", "Lcom/intellij/psi/stubs/IndexSink;", "intellij.php.impl"})
public final class PhpUseStubSerializer
extends PhpStubSerializer<PhpUse, PhpUseStub> {
    public void serialize(@NotNull PhpUseStub stub, @NotNull StubOutputStream dataStream) {
        Intrinsics.checkNotNullParameter((Object)stub, (String)"stub");
        Intrinsics.checkNotNullParameter((Object)dataStream, (String)"dataStream");
        dataStream.writeName(stub.getName());
        dataStream.writeName(stub.getFQN());
        dataStream.writeName(stub.getAliasName());
        dataStream.writeShort((int)stub.getFlags());
    }

    @NotNull
    public PhpUseStub deserialize(@NotNull StubInputStream dataStream, @Nullable StubElement<?> parentStub) {
        Intrinsics.checkNotNullParameter((Object)dataStream, (String)"dataStream");
        StringRef name = dataStream.readName();
        StringRef original = dataStream.readName();
        StringRef aliasName = dataStream.readName();
        short flags = dataStream.readShort();
        return new PhpUseStubImpl(parentStub, (IElementType)PhpElementTypes.USE, name, original, aliasName, flags);
    }

    @Override
    @NotNull
    public IElementType getElementType() {
        PhpStubElementType phpStubElementType = PhpElementTypes.USE;
        Intrinsics.checkNotNullExpressionValue((Object)phpStubElementType, (String)"USE");
        return (IElementType)phpStubElementType;
    }

    @Override
    public void indexStub(@NotNull PhpUseStub stub, @NotNull IndexSink sink) {
        Intrinsics.checkNotNullParameter((Object)stub, (String)"stub");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        String string = PhpLangUtil.toShortName(stub.getFQN());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toShortName(...)");
        String referenceName = string;
        if (StringUtil.isNotEmpty((String)referenceName)) {
            sink.occurrence(PhpUseReferenceNameIndex.KEY, (Object)StringUtil.toLowerCase((String)referenceName));
        }
    }
}

