/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.resolve.types.generics;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.resolve.types.PhpCharBasedTypeKey;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeSignatureKey;
import com.jetbrains.php.lang.psi.resolve.types.generics.PhpGenericsBaseExtendedWithGenericTypeProvider;
import com.jetbrains.php.lang.psi.resolve.types.generics.PhpGenericsTemplatesCustomDocTagValueStubProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpGenericsMemberBaseExtendedWithGenericTypeProvider
extends PhpGenericsBaseExtendedWithGenericTypeProvider<PhpClassMember> {
    @Override
    @Nullable
    public PhpType getType(PsiElement element) {
        if (element instanceof MemberReference) {
            for (PhpNamedElement member : ((MemberReference)element).resolveLocal()) {
                if (!(member instanceof PhpClassMember) || !PhpGenericsMemberBaseExtendedWithGenericTypeProvider.mayExtendSuperTemplates(((PhpClassMember)member).getContainingClass()) && this.getSubstitutedTemplateInfo((PhpClassMember)member, false).isEmpty() && !PhpGenericsMemberBaseExtendedWithGenericTypeProvider.containsTemplatesInDocTag(member)) continue;
                return this.getSignatureType((MemberReference)element);
            }
        }
        return null;
    }

    public static boolean containsTemplatesInDocTag(PhpNamedElement member) {
        Collection<String> templates = PhpGenericsMemberBaseExtendedWithGenericTypeProvider.getTemplates(member);
        if (templates.isEmpty()) {
            return false;
        }
        return member.getDocTags().stream().flatMap(t -> PsiTreeUtil.findChildrenOfType((PsiElement)t, PhpDocType.class).stream()).anyMatch(t -> ContainerUtil.exists((Iterable)templates, template -> t.textMatches((CharSequence)template)));
    }

    @NotNull
    protected abstract PhpCharBasedTypeKey getSignatureKey();

    public char getKey() {
        return this.getSignatureKey().getKey();
    }

    public static boolean mayExtendSuperTemplates(PhpClass aClass) {
        PhpDocComment comment;
        if (aClass == null) {
            return false;
        }
        if ((aClass.getSuperFQN() != null || aClass.getInterfaceNames().length > 0) && (comment = aClass.getDocComment()) != null) {
            return !PhpGenericsMemberBaseExtendedWithGenericTypeProvider.getTemplates(comment).isEmpty() || ContainerUtil.exists((Object[])PhpGenericsTemplatesCustomDocTagValueStubProvider.getExtendedNames(), t -> comment.getTagElementsByName(t).length > 0);
        }
        return PhpGenericsMemberBaseExtendedWithGenericTypeProvider.usedClassesTags(aClass).findAny().isPresent();
    }

    @NotNull
    private PhpType getSignatureType(MemberReference element) {
        PhpType type = new PhpType();
        for (String part : element.getSignatureParts()) {
            if (!this.getSignatureKey().signed(part)) continue;
            type.add(part);
        }
        PhpType phpType = type;
        if (phpType == null) {
            PhpGenericsMemberBaseExtendedWithGenericTypeProvider.$$$reportNull$$$0(0);
        }
        return phpType;
    }

    @Override
    protected Class<PhpClassMember> getElementClass() {
        return PhpClassMember.class;
    }

    @Override
    protected PhpClass getContainingClass(PhpClassMember element) {
        return element.getContainingClass();
    }

    @Override
    @Nullable
    protected Collection<PhpGenericsBaseExtendedWithGenericTypeProvider.TemplateInfo> getSubstitutedTemplateInfo(PhpClassMember m, Collection<PhpClassMember> visited, boolean global) {
        return PhpGenericsMemberBaseExtendedWithGenericTypeProvider.doGetSubstitutedTemplateInfo(this, m, m, visited, member -> member, global);
    }

    @Nullable
    public static <T extends PhpNamedElement> Collection<PhpGenericsBaseExtendedWithGenericTypeProvider.TemplateInfo> doGetSubstitutedTemplateInfo(PhpGenericsBaseExtendedWithGenericTypeProvider<T> provider, T element, PhpClassMember m, Collection<T> visited, Function<PhpClassMember, T> elementSupplier, boolean global) {
        PhpDocComment comment;
        List<PhpGenericsBaseExtendedWithGenericTypeProvider.TemplateInfo> infos = provider.doGetSubstitutedTemplateInfo(element, visited);
        if (infos == null) {
            return Collections.emptyList();
        }
        if (!infos.isEmpty()) {
            return infos;
        }
        ArrayList<PhpGenericsBaseExtendedWithGenericTypeProvider.TemplateInfo> res = new ArrayList<PhpGenericsBaseExtendedWithGenericTypeProvider.TemplateInfo>();
        if (global && ((comment = m.getDocComment()) == null || comment.hasInheritDocTag() && comment.getReturnTag() == null)) {
            PhpClassHierarchyUtils.processSuperMembers((PhpClassMember)m, (classMember, subClass, baseClass) -> {
                Collection<PhpGenericsBaseExtendedWithGenericTypeProvider.TemplateInfo> info = PhpGenericsMemberBaseExtendedWithGenericTypeProvider.doGetSubstitutedTemplateInfo(provider, (PhpNamedElement)elementSupplier.apply(classMember), classMember, visited, elementSupplier, true);
                if (info != null) {
                    res.addAll(info);
                } else {
                    res.add(null);
                }
                return false;
            });
        }
        return res.contains(null) ? null : res;
    }

    @Override
    protected Collection<String> getDeclaredTypes(PhpClassMember m) {
        return PhpGenericsMemberBaseExtendedWithGenericTypeProvider.getDocDeclaredTypes((PhpTypedElement)m);
    }

    public static @NotNull Set<@NlsSafe String> getDocDeclaredTypes(PhpTypedElement m) {
        Set set = m.getDocType().map(t -> PhpTypeSignatureKey.POLYMORPHIC_CLASS.isSigned(t) ? t.substring(2) : t).getTypesWithParametrisedParts();
        if (set == null) {
            PhpGenericsMemberBaseExtendedWithGenericTypeProvider.$$$reportNull$$$0(1);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/php/lang/psi/resolve/types/generics/PhpGenericsMemberBaseExtendedWithGenericTypeProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSignatureType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocDeclaredTypes";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

