/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.resolve.types.generics;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.lang.documentation.phpdoc.PhpDocUtil;
import com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocTokenTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.documentation.phpdoc.psi.impl.tags.PhpDocTemplateTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocParamTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.resolve.types.PhpCharBasedTypeKey;
import com.jetbrains.php.lang.psi.resolve.types.PhpCharTypeKey;
import com.jetbrains.php.lang.psi.resolve.types.PhpDocPrefixProvider;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeProvider4;
import com.jetbrains.php.lang.psi.resolve.types.generics.PhpGenericsBaseExtendedWithGenericTypeProvider;
import com.jetbrains.php.lang.psi.resolve.types.generics.PhpGenericsTemplatesCustomDocTagValueStubProvider;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpGenericsExtendedTypeProvider
implements PhpTypeProvider4 {
    public static final PhpCharBasedTypeKey KEY = new PhpCharTypeKey('\u1890'){

        @Override
        @NotNull
        public String sign(@Nullable CharSequence name) {
            String string = super.sign(name) + ".";
            if (string == null) {
                1.$$$reportNull$$$0(0);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/lang/psi/resolve/types/generics/PhpGenericsExtendedTypeProvider$1", "sign"));
        }
    };

    public char getKey() {
        return KEY.getKey();
    }

    @Nullable
    public PhpType getType(PsiElement element) {
        String name;
        PhpDocComment docComment;
        if (element instanceof PhpDocType && PhpGenericsExtendedTypeProvider.declaredInCustomTypeDocTag(docComment = PhpPsiUtil.getParentOfClass(element, PhpDocComment.class), name = ((PhpDocType)element).getName())) {
            return PhpGenericsExtendedTypeProvider.handleCustomDocTagUpperBoundType(element, name, docComment);
        }
        return null;
    }

    @NotNull
    private static PhpType handleCustomDocTagUpperBoundType(PsiElement element, String name, PhpDocComment docComment) {
        PhpDocTag ownerTag;
        PhpType type = new PhpType().add(KEY.sign(name));
        List<PhpDocType> superTypes = PhpGenericsExtendedTypeProvider.getTemplateSuperTypes(docComment, name);
        boolean hasArrayKeyBound = false;
        for (PhpDocType superType : superTypes) {
            if (superType.textMatches((CharSequence)"array-key")) {
                hasArrayKeyBound = true;
                continue;
            }
            type = type.add((PsiElement)superType);
        }
        if (hasArrayKeyBound && (ownerTag = PhpPsiUtil.getParentOfClass(element, PhpDocTag.class)) != null) {
            PhpDocType outer;
            String ownerName = ownerTag.getName();
            if (ownerTag instanceof PhpDocParamTag && (StringUtil.endsWith((CharSequence)ownerName, (CharSequence)"param") || StringUtil.endsWith((CharSequence)ownerName, (CharSequence)"var")) && (outer = PhpPsiUtil.getChildOfClass((PsiElement)ownerTag, PhpDocType.class)) == element) {
                type = type.add(PhpType.builder().add(PhpType.STRING).add(PhpType.INT).build());
            }
        }
        PhpType phpType = type;
        if (phpType == null) {
            PhpGenericsExtendedTypeProvider.$$$reportNull$$$0(0);
        }
        return phpType;
    }

    @NotNull
    private static List<PhpDocType> getTemplateSuperTypes(PhpDocComment docComment, String name) {
        List<PhpDocType> list = PhpGenericsTemplatesCustomDocTagValueStubProvider.getTypeNamesPsiInCurrentCommentOrClass(docComment, PhpGenericsBaseExtendedWithGenericTypeProvider.getTemplateNames()).filter(identifier -> identifier.getText().equals(name)).map(identifier -> PhpPsiUtil.getParentOfClass(identifier, PhpDocTemplateTag.class)).filter(Objects::nonNull).flatMap(templateTag -> Arrays.stream(templateTag.getSuperTypeComponents())).collect(Collectors.toList());
        if (list == null) {
            PhpGenericsExtendedTypeProvider.$$$reportNull$$$0(1);
        }
        return list;
    }

    static boolean declaredInCustomTypeDocTag(@Nullable PhpDocComment docComment, String name) {
        return PhpGenericsTemplatesCustomDocTagValueStubProvider.getTemplates(docComment).contains(name);
    }

    public static Collection<String> getCustomTypes(PhpDocComment docComment) {
        return (Collection)StreamEx.of(PhpDocPrefixProvider.EP_NAME.getExtensionList().stream()).map(p -> p.getPrefix() + "type").flatMap(name -> PhpGenericsExtendedTypeProvider.customTypeInCurrentScope(docComment, name).stream()).append(PhpGenericsExtendedTypeProvider.getImportedTypeNames(docComment)).collect(Collectors.toSet());
    }

    public static Collection<String> customTypeInCurrentScope(@Nullable PhpDocComment docComment, String name) {
        return PhpGenericsTemplatesCustomDocTagValueStubProvider.getNamesInCurrentCommentOrClass(docComment, c -> List.copyOf(PhpGenericsExtendedTypeProvider.getCustomTypes(c, name).keySet()));
    }

    public static Map<String, PhpType> getCustomTypes(@Nullable PhpDocComment comment, String tagName) {
        if (comment == null) {
            return Collections.emptyMap();
        }
        HashMap<String, PhpType> res = new HashMap<String, PhpType>();
        PhpDocUtil.processTagElementsByNames(comment, tag -> {
            PsiElement identifier = PhpPsiUtil.getChildOfType((PsiElement)tag, PhpDocTokenTypes.DOC_IDENTIFIER);
            if (identifier != null) {
                res.put(identifier.getText(), PhpType.from(PhpPsiUtil.getChildren((PsiElement)tag, (Condition<? super PsiElement>)((Condition)PhpDocType.class::isInstance))));
            }
        }, tagName);
        return res;
    }

    private static Collection<String> getImportedTypeNames(@Nullable PhpDocComment docComment) {
        return PhpDocPrefixProvider.EP_NAME.getExtensionList().stream().flatMap(p -> PhpGenericsExtendedTypeProvider.doGetImportedTypeNames(docComment, p.getPrefix()).stream()).collect(Collectors.toSet());
    }

    private static List<String> doGetImportedTypeNames(@Nullable PhpDocComment docComment, String prefix) {
        return PhpGenericsTemplatesCustomDocTagValueStubProvider.getNamesInCurrentCommentOrClass(docComment, c -> List.copyOf(PhpGenericsExtendedTypeProvider.doGetImportedTypeNamesFromComment(c, prefix).keySet()));
    }

    @NotNull
    public static Map<String, PhpType> doGetImportedTypeNamesFromComment(@Nullable PhpDocComment c, String prefix) {
        if (c == null) {
            Map<String, PhpType> map = Collections.emptyMap();
            if (map == null) {
                PhpGenericsExtendedTypeProvider.$$$reportNull$$$0(2);
            }
            return map;
        }
        Map map = StreamEx.of((Object[])c.getTagElementsByName(prefix + "import-type")).mapToEntry(PhpGenericsExtendedTypeProvider::getAliasIdentifierFromImportedType, tag -> PhpType.from(PhpPsiUtil.getChildren((PsiElement)tag, (Condition<? super PsiElement>)((Condition)PhpDocType.class::isInstance)))).filterKeys(Objects::nonNull).mapKeys(PsiElement::getText).distinctKeys().toMap();
        if (map == null) {
            PhpGenericsExtendedTypeProvider.$$$reportNull$$$0(3);
        }
        return map;
    }

    @Nullable
    public PhpType complete(String expression, Project project) {
        return PhpType.isPluralType((String)expression) ? PhpType.ARRAY : null;
    }

    public Collection<? extends PhpNamedElement> getBySignature(String expression, Set<String> visited, int depth, Project project) {
        return null;
    }

    public static PsiElement getAliasIdentifierFromImportedType(PhpDocTag tag) {
        Object docType = PhpPsiUtil.getChildByCondition((PsiElement)tag, (Condition<? super PsiElement>)((Condition)PhpDocType.class::isInstance));
        PsiElement possibleAsModifier = PhpPsiUtil.getNextSiblingIgnoreWhitespace(docType, true);
        if (PhpPsiUtil.isOfType(possibleAsModifier, PhpDocTokenTypes.DOC_IDENTIFIER) && possibleAsModifier.textMatches((CharSequence)"as")) {
            return PhpPsiUtil.getNextSiblingIgnoreWhitespace(possibleAsModifier, true);
        }
        return PhpPsiUtil.getChildOfType((PsiElement)tag, PhpDocTokenTypes.DOC_IDENTIFIER);
    }

    public static String unsign(String s) {
        if (KEY.signed(s)) {
            return s.substring(2, s.length() - 1);
        }
        return s;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/php/lang/psi/resolve/types/generics/PhpGenericsExtendedTypeProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "handleCustomDocTagUpperBoundType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateSuperTypes";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetImportedTypeNamesFromComment";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

