/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.resolve.types;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlow;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpStatementInstruction;
import com.jetbrains.php.completion.PhpArrayShapeIndexCompletionProvider;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.attributes.PhpArrayKeyDoesNotMatchArrayShapeInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.ArrayHashElement;
import com.jetbrains.php.lang.psi.elements.ArrayIndex;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.MultiassignmentExpression;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.resolve.types.PhpArrayShapeIndexTP;
import com.jetbrains.php.lang.psi.resolve.types.PhpCharBasedTypeKey;
import com.jetbrains.php.lang.psi.resolve.types.PhpParameterBasedTypeProvider;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeProvider4;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeSignatureKey;
import com.jetbrains.php.lang.psi.resolve.types.shapes.PhpArrayShapesProvider;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpConstantsArrayShapesDefaultValuesIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionArgument;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionConstantArgument;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionScalarArgument;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpShapeEntriesIndex;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpArrayShapeTP
implements PhpTypeProvider4 {
    public static final String ANY_INDEX = " ";

    public char getKey() {
        return '\u9999';
    }

    @Nullable
    public PhpType getType(PsiElement element) {
        if (element instanceof ArrayAccessExpression) {
            PhpPsiElement value = ((ArrayAccessExpression)element).getValue();
            ArrayIndex index = ((ArrayAccessExpression)element).getIndex();
            PhpPsiElement indexValue = index != null ? index.getValue() : null;
            return this.getTypeFromArrayShapeAccess((PsiElement)value, indexValue);
        }
        if (element instanceof PhpExpression) {
            PhpAccessVariableInstruction variableInstruction;
            PsiElement array;
            PhpScopeHolder scope;
            if (element instanceof Variable && (scope = PhpPsiUtil.getScopeHolder(element)) != null && (array = PhpArrayShapeTP.getForeachArray(variableInstruction = PhpControlFlowUtil.getAccessInstructionInScopeHolder(scope, (PhpPsiElement)element, PhpAccessVariableInstruction.class), scope.getControlFlow())) != null) {
                return this.getTypeFromArrayShapeAccess(array, false, ANY_INDEX, null, key -> true);
            }
            return this.getTypeFromArrayDestructing((PhpExpression)element);
        }
        return null;
    }

    @Nullable
    private static PsiElement getForeachArray(@Nullable PhpAccessVariableInstruction variableInstruction, @NotNull PhpControlFlow flow) {
        if (flow == null) {
            PhpArrayShapeTP.$$$reportNull$$$0(0);
        }
        if (variableInstruction == null) {
            return null;
        }
        if (!PhpArrayShapeTP.insidePotentialForeachByValue(flow, variableInstruction)) {
            return null;
        }
        final Ref res = new Ref(null);
        PhpControlFlowUtil.processPreviousVariableAccesses(variableInstruction, false, new PhpInstructionProcessor(){

            public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                ForeachStatement foreach;
                if (instruction.getAccess().isWrite()) {
                    return false;
                }
                PhpPsiElement anchor = instruction.getAnchor();
                PsiElement psiElement = anchor.getParent();
                if (psiElement instanceof ForeachStatement && (foreach = (ForeachStatement)psiElement).getValue() == anchor) {
                    res.set((Object)foreach.getArray());
                    return false;
                }
                return super.processAccessVariableInstruction(instruction);
            }
        });
        return (PsiElement)res.get();
    }

    private static boolean insidePotentialForeachByValue(PhpControlFlow flow, PhpAccessVariableInstruction instruction) {
        PhpPsiElement anchor = instruction.getAnchor();
        while ((anchor = (PhpPsiElement)PhpPsiUtil.getParentOfClass((PsiElement)anchor, ForeachStatement.class)) != null) {
            ForeachStatement foreachStatement;
            Statement statement;
            PhpStatementInstruction statementInstruction = (PhpStatementInstruction)flow.getInstruction((PsiElement)anchor, PhpStatementInstruction.class);
            if (statementInstruction == null || !((statement = statementInstruction.getStatement()) instanceof ForeachStatement) || (foreachStatement = (ForeachStatement)statement).getValue() == null || !PhpLangUtil.equalsVariableNames(foreachStatement.getValue().getName(), instruction.getVariableName())) continue;
            return true;
        }
        return false;
    }

    private PhpType getTypeFromArrayDestructing(PhpExpression element) {
        PsiElement parent = element.getParent();
        if (!PhpPsiUtil.isOfType(parent, PhpElementTypes.ARRAY_VALUE)) {
            return null;
        }
        MultiassignmentExpression assignment = (MultiassignmentExpression)PhpPsiUtil.getParentByCondition(parent, (Condition<? super PsiElement>)MultiassignmentExpression.INSTANCEOF, (Condition<? super PsiElement>)Statement.INSTANCEOF);
        if (assignment == null) {
            return null;
        }
        if (!assignment.getVariables().contains(element)) {
            return null;
        }
        PhpPsiElement value = assignment.getValue();
        PhpPsiElement assignedValue = value != null ? value.getFirstPsiChild() : null;
        PsiElement grandParent = parent.getParent();
        if (grandParent instanceof ArrayHashElement) {
            PhpPsiElement key2 = ((ArrayHashElement)grandParent).getKey();
            return this.getTypeFromArrayShapeAccess((PsiElement)assignedValue, key2);
        }
        String index = String.valueOf(PhpArrayShapeTP.countCommasBefore(parent));
        return this.getTypeFromArrayShapeAccess((PsiElement)assignedValue, true, index, index, key -> PhpArrayShapeTP.isNumberScalarArgumentWithValue(key, index));
    }

    private static int countCommasBefore(PsiElement element) {
        int res = 0;
        while (element != null) {
            if (PhpPsiUtil.isOfType(element, PhpTokenTypes.opCOMMA)) {
                ++res;
            }
            element = element.getPrevSibling();
        }
        return res;
    }

    private static boolean isNumberScalarArgumentWithValue(PhpExpectedFunctionArgument key, String value) {
        return key instanceof PhpExpectedFunctionScalarArgument && !((PhpExpectedFunctionScalarArgument)key).isStringLiteral() && key.getValue().equals(value);
    }

    @Nullable
    private PhpType getTypeFromArrayShapeAccess(@Nullable PsiElement value, @Nullable PhpPsiElement indexValue) {
        if (value == null || indexValue == null) {
            return null;
        }
        boolean possibleIndex = PhpArrayKeyDoesNotMatchArrayShapeInspection.isPossibleArrayShapeIndex(indexValue);
        return this.getTypeFromArrayShapeAccess(value, possibleIndex, PhpArrayShapeTP.encodeIndexValue(indexValue), indexValue.getText(), key -> key.matches((PsiElement)indexValue));
    }

    @Nullable
    private PhpType getTypeFromArrayShapeAccess(@Nullable PsiElement value, boolean possibleIndex, @NlsSafe String encodedIndexValue, @NlsSafe @Nullable String indexValueText, Predicate<PhpExpectedFunctionArgument> shapePredicate) {
        ArrayDeque<PhpExpectedFunctionArgument> parentAccesses = new ArrayDeque<PhpExpectedFunctionArgument>();
        if ((value = PhpArrayShapeIndexCompletionProvider.findTargetValue(value, parentAccesses)) == null) {
            return null;
        }
        for (PhpArrayShapesProvider provider : PhpArrayShapesProvider.EP_NAME.getExtensionList()) {
            PhpType type = new PhpType();
            Collection<PhpShapeEntriesIndex.PhpShapeEntry> arrayShapes = PhpArrayShapeIndexCompletionProvider.collectShapesByParentAccesses(parentAccesses, provider.getValues(value, true));
            for (PhpShapeEntriesIndex.PhpShapeEntry shape : arrayShapes) {
                PhpExpectedFunctionArgument key = shape.getKey();
                if (PhpShapeEntriesIndex.isConstantToBeInlined(shape) && possibleIndex) {
                    String keyValue = key instanceof PhpExpectedFunctionConstantArgument ? PhpTypeSignatureKey.CONSTANT.sign((CharSequence)key.getValue()) : PhpTypeSignatureKey.CLASS_CONSTANT.sign((CharSequence)key.getValue());
                    type.add("#" + this.getKey() + keyValue + "." + indexValueText);
                    continue;
                }
                if (possibleIndex && !shapePredicate.test(key)) continue;
                type.add(shape.getType());
            }
            if (type.isEmpty()) continue;
            return type;
        }
        return PhpArrayShapeTP.getPossibleEncodedShape(value, encodedIndexValue, parentAccesses, PhpArrayShapeIndexTP.KEY);
    }

    @Nullable
    public static PhpType getPossibleEncodedShape(@NotNull PsiElement value, String encodedIndexValue, ArrayDeque<PhpExpectedFunctionArgument> parentAccesses, PhpCharBasedTypeKey key) {
        PhpReference reference;
        if (value == null) {
            PhpArrayShapeTP.$$$reportNull$$$0(1);
        }
        if ((reference = (PhpReference)ObjectUtils.tryCast((Object)value, PhpReference.class)) == null) {
            return null;
        }
        List valueSignatures = ContainerUtil.filter((Collection)reference.getSignatureParts(), s -> PhpTypeSignatureKey.FUNCTION.isSigned(s) || PhpTypeSignatureKey.METHOD.isSigned(s) || PhpTypeSignatureKey.FIELD.isSigned(s));
        return valueSignatures.isEmpty() ? null : PhpArrayShapeTP.encodeToPossibleShape(encodedIndexValue, valueSignatures, parentAccesses, key);
    }

    @NotNull
    private static PhpType encodeToPossibleShape(@NlsSafe String encodedIndexValue, Collection<String> valueSignatures, ArrayDeque<PhpExpectedFunctionArgument> parentAccesses, PhpCharBasedTypeKey key) {
        String parentAccessesSerialized = PhpParameterBasedTypeProvider.wrapTypes(ContainerUtil.map(parentAccesses, PhpExpectedFunctionArgument::getValue));
        String payload = (String)StreamEx.of(valueSignatures).append((Object)("." + PhpParameterBasedTypeProvider.wrap(encodedIndexValue) + parentAccessesSerialized)).map(PhpParameterBasedTypeProvider::wrap).collect(Collectors.joining());
        PhpType phpType = payload.isEmpty() ? PhpType.EMPTY : new PhpType().add(key.sign(payload));
        if (phpType == null) {
            PhpArrayShapeTP.$$$reportNull$$$0(2);
        }
        return phpType;
    }

    @NlsSafe
    private static String encodeIndexValue(PhpPsiElement indexValue) {
        if (!PhpArrayKeyDoesNotMatchArrayShapeInspection.isPossibleArrayShapeIndex(indexValue)) {
            return ANY_INDEX;
        }
        return indexValue instanceof StringLiteralExpression ? StringUtil.wrapWithDoubleQuote((String)((StringLiteralExpression)indexValue).getContents()) : indexValue.getText();
    }

    @Nullable
    public PhpType complete(String expression, Project project) {
        int lastDot = expression.lastIndexOf(46);
        String signature = expression.substring(2, lastDot);
        String indexValue = expression.substring(lastDot + 1);
        return PhpIndex.getInstance((Project)project).getBySignature(signature).stream().flatMap(element -> PhpConstantsArrayShapesDefaultValuesIndex.shapes(project, element)).filter(shape -> shape.getKey().getValue().equals(indexValue)).map(PhpShapeEntriesIndex.PhpShapeEntry::getType).reduce(new PhpType(), PhpType::add);
    }

    public Collection<? extends PhpNamedElement> getBySignature(String expression, Set<String> visited, int depth, Project project) {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flow";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/resolve/types/PhpArrayShapeTP";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/resolve/types/PhpArrayShapeTP";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "encodeToPossibleShape";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getForeachArray";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getPossibleEncodedShape";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

