/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.resolve.types;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpCaches;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.PhpIndexImpl;
import com.jetbrains.php.completion.PhpAnyExpressionArgument;
import com.jetbrains.php.completion.PhpArrayShapeIndexCompletionProvider;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.resolve.types.PhpCharBasedTypeKey;
import com.jetbrains.php.lang.psi.resolve.types.PhpCharTypeKey;
import com.jetbrains.php.lang.psi.resolve.types.PhpObjectShapeTypeProvider;
import com.jetbrains.php.lang.psi.resolve.types.PhpParameterBasedTypeProvider;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeProvider4;
import com.jetbrains.php.lang.psi.resolve.types.shapes.PhpArrayShapesProvider;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionArgument;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionScalarArgument;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpShapeEntriesIndex;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlin.jvm.functions.Function1;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpArrayShapeIndexTP
implements PhpTypeProvider4 {
    public static final PhpCharBasedTypeKey KEY = new PhpCharTypeKey('a');

    public char getKey() {
        return KEY.getKey();
    }

    @Nullable
    public PhpType getType(PsiElement element) {
        if (element instanceof Function || element instanceof Field) {
            for (PhpArrayShapesProvider provider : PhpArrayShapesProvider.EP_NAME.getExtensionList()) {
                PhpType type = new PhpType();
                List<Object> values = element instanceof Function ? provider.getValues((Function)element) : provider.getValues((Field)element);
                for (PhpShapeEntriesIndex.PhpShapeEntry phpShapeEntry : values) {
                    String payload = PhpArrayShapeIndexTP.serializeShape(phpShapeEntry);
                    if (payload == null) continue;
                    type.add(KEY.sign(payload));
                }
                if (type.isEmpty()) continue;
                return type;
            }
        }
        return null;
    }

    @Nullable
    static String serializeShape(PhpShapeEntriesIndex.PhpShapeEntry shape) {
        PhpExpectedFunctionArgument key = shape.getKey();
        if (key instanceof PhpExpectedFunctionScalarArgument) {
            String res = (String)StreamEx.of((Object)key.getValue()).append((Collection)shape.getType().getTypes()).map(PhpParameterBasedTypeProvider::wrap).collect(Collectors.joining());
            String childrenPayload = PhpParameterBasedTypeProvider.wrapTypes(ContainerUtil.map(shape.getChildren(), PhpArrayShapeIndexTP::serializeShape));
            return PhpParameterBasedTypeProvider.wrapTypes(List.of(res, childrenPayload));
        }
        return null;
    }

    public PhpType complete(String expression, Project project) {
        return PhpArrayShapeIndexTP.complete(expression, project, KEY);
    }

    @Nullable
    public static PhpType complete(String expression, Project project, PhpCharBasedTypeKey key) {
        List<String> payload = PhpParameterBasedTypeProvider.extractSignatures(expression, 2);
        String possibleIndexPayload = PhpArrayShapeIndexTP.getLastPossibleIndex(payload);
        if (possibleIndexPayload == null) {
            return null;
        }
        List<String> indexWithParentAccess = PhpParameterBasedTypeProvider.extractSignatures(possibleIndexPayload, 0);
        String possibleIndex = indexWithParentAccess.get(0);
        ArrayDeque<String> parentAccesses = new ArrayDeque<String>(indexWithParentAccess.subList(1, indexWithParentAccess.size()));
        List<PhpShapeEntriesIndex.PhpShapeEntry> shapeEntries = payload.subList(0, payload.size() - 1).stream().flatMap(s -> PhpArrayShapeIndexTP.fetchShapeEntries(project, s, key)).collect(Collectors.toList());
        return PhpArrayShapeIndexTP.collectShapesByParentAccesses(parentAccesses, shapeEntries).stream().filter(e -> possibleIndex.equals(" ") || e.getKey().getNormalizedValue().equals(possibleIndex)).map(PhpShapeEntriesIndex.PhpShapeEntry::getType).reduce(PhpType::or).orElse(PhpType.EMPTY);
    }

    public static Collection<PhpShapeEntriesIndex.PhpShapeEntry> collectShapesByParentAccesses(ArrayDeque<String> parentAccesses, Collection<PhpShapeEntriesIndex.PhpShapeEntry> arrayShapes) {
        return PhpArrayShapeIndexCompletionProvider.collectShapesByParentAccesses(parentAccesses, (key, access) -> "%".equals(access) || key.getValue().equals(access), arrayShapes);
    }

    @Nullable
    private static String getLastPossibleIndex(List<String> payload) {
        String possibleIndex = (String)ContainerUtil.getLastItem(payload);
        return StringUtil.startsWithChar((CharSequence)possibleIndex, (char)'.') ? possibleIndex.substring(1) : null;
    }

    public static Stream<PhpShapeEntriesIndex.PhpShapeEntry> fetchArrayShapeEntries(Project project, String signature) {
        return PhpArrayShapeIndexTP.fetchShapeEntries(project, signature, KEY);
    }

    public static Stream<PhpShapeEntriesIndex.PhpShapeEntry> fetchShapeEntries(Project project, String signature, PhpCharBasedTypeKey key) {
        return PhpCaches.getInstance((Project)project).shapesTypeCache.getOrCompute(signature, (Function1<String, Collection<PhpShapeEntriesIndex.PhpShapeEntry>>)((Function1)_signature -> PhpArrayShapeIndexTP.fetchShapeEntriesInner(project, _signature, key))).stream();
    }

    @NotNull
    private static Collection<PhpShapeEntriesIndex.PhpShapeEntry> fetchShapeEntriesInner(Project project, String signature, PhpCharBasedTypeKey key) {
        HashSet<PhpShapeEntriesIndex.PhpShapeEntry> res = new HashSet<PhpShapeEntriesIndex.PhpShapeEntry>();
        ((PhpIndexImpl)PhpIndex.getInstance((Project)project)).completeType(project, new PhpType().add(signature), new HashSet<String>(), s -> {
            if (key.signed((String)s)) {
                List<String> signaturesData = PhpParameterBasedTypeProvider.extractSignatures(s, 2);
                ContainerUtil.addIfNotNull((Collection)res, (Object)PhpArrayShapeIndexTP.extractShape(signaturesData, key == PhpObjectShapeTypeProvider.KEY));
            }
            return null;
        });
        HashSet<PhpShapeEntriesIndex.PhpShapeEntry> hashSet = res;
        if (hashSet == null) {
            PhpArrayShapeIndexTP.$$$reportNull$$$0(0);
        }
        return hashSet;
    }

    @Nullable
    private static PhpShapeEntriesIndex.PhpShapeEntry extractShape(List<String> signaturesData, boolean isObjectShape) {
        List<String> signatures = PhpParameterBasedTypeProvider.extractSignatures(signaturesData.get(0), 0);
        List children = signaturesData.size() > 1 ? ContainerUtil.mapNotNull(PhpParameterBasedTypeProvider.extractSignatures(signaturesData.get(1), 0), s -> PhpArrayShapeIndexTP.extractShape(PhpParameterBasedTypeProvider.extractSignatures(s, 0), signatures.size() > 1 && ((String)signatures.get(1)).equals("\\object"))) : Collections.emptyList();
        String key = (String)ContainerUtil.getFirstItem(signatures);
        if (key != null && !PhpType.isUnresolved((String)key) && PhpArrayShapeIndexTP.getLastPossibleIndex(signatures) == null) {
            PhpType value = new PhpType();
            signatures.subList(1, signatures.size()).forEach(arg_0 -> ((PhpType)value).add(arg_0));
            PhpExpectedFunctionScalarArgument argument = key.equals("%") ? PhpAnyExpressionArgument.INSTANCE : new PhpExpectedFunctionScalarArgument(key, 0, 0, null, false, "", false);
            return new PhpShapeEntriesIndex.PhpShapeEntry(argument, value, children, isObjectShape);
        }
        return null;
    }

    public Collection<? extends PhpNamedElement> getBySignature(String expression, Set<String> visited, int depth, Project project) {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/lang/psi/resolve/types/PhpArrayShapeIndexTP", "fetchShapeEntriesInner"));
    }
}

