/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.resolve.types;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.PhpIndexImpl;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.resolve.types.PhpKeyTypeProvider;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeProvider4;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeSignatureKey;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpArrayKeyAccessTP
implements PhpTypeProvider4 {
    private static final char KEY = 'Y';
    private static final String SEPARATOR = "\u3899";

    public char getKey() {
        return 'Y';
    }

    @Nullable
    public PhpType getType(PsiElement element) {
        PhpTypedElement array;
        ForeachStatement foreach;
        if (element instanceof Variable && (foreach = (ForeachStatement)ObjectUtils.tryCast((Object)element.getParent(), ForeachStatement.class)) != null && foreach.getKey() == element && (array = (PhpTypedElement)foreach.getArray()) != null) {
            PhpType type = new PhpType();
            for (PhpKeyTypeProvider extension : (PhpKeyTypeProvider[])PhpKeyTypeProvider.EP_NAME.getExtensions()) {
                type.add(extension.getType((PsiElement)array));
            }
            if (type.isEmpty()) {
                return PhpType.NUMERIC;
            }
            return PhpArrayKeyAccessTP.getArrayKeyType(type);
        }
        return null;
    }

    @NotNull
    public static PhpType getArrayKeyType(PhpType type) {
        PhpType phpType = new PhpType().add("#Y" + StringUtil.join((Collection)type.getTypesWithParametrisedParts(), (String)SEPARATOR));
        if (phpType == null) {
            PhpArrayKeyAccessTP.$$$reportNull$$$0(0);
        }
        return phpType;
    }

    @Nullable
    public PhpType complete(String expression, Project project) {
        PhpType type = new PhpType();
        boolean hasSuitableType = false;
        List types = StringUtil.split((String)expression.substring(2), (String)SEPARATOR);
        for (String s : types) {
            Collection providers = PhpKeyTypeProvider.getProviders((String)s);
            for (PhpKeyTypeProvider extension : providers) {
                PhpType typeFromExtension = extension.complete(s, project);
                if (!typeFromExtension.hasUnknown() && !typeFromExtension.isEmpty()) {
                    hasSuitableType = true;
                }
                type.add(typeFromExtension.filterUnknown());
            }
            if (!providers.isEmpty()) continue;
            for (String part : PhpType.global((Project)project, (String[])new String[]{s}).getTypesWithParametrisedParts()) {
                if (!PhpType.hasParameterizedPart((String)part)) continue;
                hasSuitableType = PhpArrayKeyAccessTP.tryAddSuitableType(project, type, part) || hasSuitableType;
            }
        }
        if (!hasSuitableType && !type.isEmpty()) {
            type.add(PhpType.NUMERIC);
        }
        if (!type.isAmbiguous()) {
            return type;
        }
        for (String s : types) {
            Collection bySignature = PhpIndex.getInstance((Project)project).getBySignature(s.substring(2));
            if (PhpArrayKeyAccessTP.getBySignature(bySignature, PhpIndex.getInstance((Project)project), new HashSet<String>(), 0).isEmpty()) continue;
            return null;
        }
        return PhpType.NUMERIC;
    }

    private static boolean tryAddSuitableType(Project project, PhpType type, String s) {
        String item;
        List parts = PhpType.getParametrizedParts((String)s);
        if (parts.size() == 2 && !PhpArrayKeyAccessTP.isIntRange(s) && PhpType.ITERABLE.isConvertibleFrom(project, PhpType.from((String[])new String[]{s})) && !PhpType.isUnresolved((String)(item = (String)ContainerUtil.getFirstItem((List)parts)))) {
            type.add(item);
            return true;
        }
        return false;
    }

    private static boolean isIntRange(String s) {
        return "\\int".equals(PhpType.removeParametrisedType((String)PhpType.unpluralize((String)s)));
    }

    public Collection<? extends PhpNamedElement> getBySignature(String entityName, Set<String> visited, int depth, Project project) {
        PhpIndex index = PhpIndex.getInstance((Project)project);
        return StringUtil.split((String)entityName, (String)SEPARATOR).stream().map(e -> !PhpKeyTypeProvider.getProviders((String)e).isEmpty() ? e.substring(2) : e).flatMap(s -> {
            Collection bySignature = index.getBySignature(s, visited, depth + 1);
            return PhpArrayKeyAccessTP.getBySignature(bySignature, index, visited, depth).stream();
        }).collect(Collectors.toSet());
    }

    @NotNull
    private static List<PhpNamedElement> getBySignature(Collection<? extends PsiElement> bySignature, PhpIndex index, Set<String> visited, int depth) {
        SmartList elements = new SmartList();
        for (PsiElement psiElement : bySignature) {
            if (!(psiElement instanceof PhpTypedElement)) continue;
            PhpType type = ((PhpTypedElement)psiElement).getType();
            Set strings = type.getTypes();
            for (String name : strings) {
                elements.addAll(index.getTypeMethods(PhpTypeSignatureKey.CLASS.signIfUnsigned(name), visited, PhpIndexImpl.ARRAY_KEY_PROVIDERS, depth + 1));
            }
        }
        SmartList smartList = elements;
        if (smartList == null) {
            PhpArrayKeyAccessTP.$$$reportNull$$$0(1);
        }
        return smartList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/php/lang/psi/resolve/types/PhpArrayKeyAccessTP";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getArrayKeyType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getBySignature";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

