/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.elements.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.NamedStub;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpIcons;
import com.jetbrains.php.PhpIndexImpl;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.annotator.PhpAnnotatorVisitor;
import com.jetbrains.php.lang.documentation.phpdoc.parser.PhpDocElementTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocParamTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.inspections.phpdoc.PhpUpdateSignatureFromPhpDocQuickFix;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.ArrayHashElement;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpAttribute;
import com.jetbrains.php.lang.psi.elements.PhpAttributesOwner;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpDeprecationAttributeOwner;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpParameterType;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpTypeDeclaration;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.ConstantImpl;
import com.jetbrains.php.lang.psi.elements.impl.FunctionImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpNamedElementImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpTypeDeclarationImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpArrayFunctionsProcessorParameterTypeProvider;
import com.jetbrains.php.lang.psi.resolve.types.PhpCustomDocTagTypeProvider;
import com.jetbrains.php.lang.psi.resolve.types.PhpOptionalCompletionTP;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeAnalyserVisitor;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeSignatureKey;
import com.jetbrains.php.lang.psi.stubs.PhpAvailableInLanguageLevelRangeElement;
import com.jetbrains.php.lang.psi.stubs.PhpLanguageTypeMap;
import com.jetbrains.php.lang.psi.stubs.PhpLanguageTypeMapOwnerStub;
import com.jetbrains.php.lang.psi.stubs.PhpNamedStub;
import com.jetbrains.php.lang.psi.stubs.PhpParameterStub;
import com.jetbrains.php.lang.psi.stubs.PhpParameterStubImpl;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.Icon;
import one.util.streamex.EntryStream;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParameterImpl
extends PhpNamedElementImpl<PhpParameterStub>
implements Parameter,
PhpDeprecationAttributeOwner,
PhpAvailableInLanguageLevelRangeElement {
    public static final TokenSet PARAMETER = TokenSet.create((IElementType[])new IElementType[]{PhpStubElementTypes.NOT_PROMOTED_PARAMETER, PhpStubElementTypes.PROMOTED_FIELD_PARAMETER});

    public ParameterImpl(ASTNode node) {
        super(node);
    }

    public ParameterImpl(PhpParameterStub stub) {
        this(stub, (IElementType)PhpStubElementTypes.NOT_PROMOTED_PARAMETER);
    }

    protected ParameterImpl(PhpParameterStub stub, IElementType nodeType) {
        super(stub, nodeType);
    }

    @Override
    @NotNull
    public String getName() {
        NamedStub stub = (NamedStub)this.getGreenStub();
        if (stub != null) {
            String string = stub.getName();
            if (string == null) {
                ParameterImpl.$$$reportNull$$$0(0);
            }
            return string;
        }
        ASTNode nameNode = this.getNameNode();
        if (nameNode != null) {
            String name = nameNode.getText();
            String string = name.charAt(0) == '$' ? name.substring(1) : name;
            if (string == null) {
                ParameterImpl.$$$reportNull$$$0(1);
            }
            return string;
        }
        return "";
    }

    public boolean isPromotedField() {
        return false;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull PhpModifier.Access getPromotedFieldAccess() {
        PhpModifier.Access access = PhpModifier.Access.PUBLIC;
        if (access == null) {
            ParameterImpl.$$$reportNull$$$0(2);
        }
        return access;
    }

    public boolean isOptional(List<? extends PsiElement> arguments) {
        if (!this.isOptional()) {
            return false;
        }
        switch (this.getFunctionFQN()) {
            case "\\rand": 
            case "\\mt_rand": {
                return arguments.isEmpty();
            }
            case "\\timezone_identifiers_list": {
                PhpExpression classReference;
                Object[] parameters = this.getFunction().getParameters();
                PsiElement firstArgument = (PsiElement)ContainerUtil.getFirstItem(arguments);
                int indexOf = ArrayUtil.indexOfIdentity((Object[])parameters, (Object)this);
                if (indexOf == 0 && firstArgument != null) {
                    return false;
                }
                if (indexOf != 1 || !(firstArgument instanceof ClassConstantReference) || !((classReference = ((ClassConstantReference)firstArgument).getClassReference()) instanceof ClassReference) || !PhpLangUtil.equalsClassNames("\\DateTimeZone", ((ClassReference)classReference).getFQN())) break;
                return !PhpLangUtil.equalsClassConstantNames("PER_COUNTRY", ((ClassConstantReference)firstArgument).getName());
            }
        }
        return true;
    }

    @Override
    @NotNull
    public CharSequence getNameCS() {
        ASTNode nameNode = this.getNameNode();
        CharSequence name = nameNode != null ? nameNode.getChars() : "";
        CharSequence charSequence = !name.isEmpty() && name.charAt(0) == '$' ? name.subSequence(1, name.length()) : name;
        if (charSequence == null) {
            ParameterImpl.$$$reportNull$$$0(3);
        }
        return charSequence;
    }

    @Override
    @Nullable
    public ASTNode getNameNode() {
        return this.getNode().findChildByType(PhpTokenTypes.VARIABLE);
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        ASTNode astNode;
        if (name == null) {
            ParameterImpl.$$$reportNull$$$0(4);
        }
        if ((astNode = this.getNameNode()) != null && !this.getName().equals(name)) {
            Variable variable = PhpPsiElementFactory.createVariable(this.getProject(), name, true);
            ASTNode nameNode = variable.getNameNode();
            assert (nameNode != null);
            astNode.getTreeParent().replaceChild(astNode, nameNode);
        }
        return this;
    }

    @Override
    protected void accept(@NotNull PhpElementVisitor phpElementVisitor) {
        if (phpElementVisitor == null) {
            ParameterImpl.$$$reportNull$$$0(5);
        }
        phpElementVisitor.visitPhpParameter((Parameter)this);
    }

    @NotNull
    public SearchScope getUseScope() {
        if (PhpLanguageFeature.NAMED_ARGUMENTS.isSupported(this.getProject())) {
            return new LocalSearchScope((PsiElement)this.getContainingFile());
        }
        Function f = PhpPsiUtil.getParentOfClass((PsiElement)this, Function.class);
        if (f != null) {
            PhpDocComment docComment = f.getDocComment();
            if (docComment != null) {
                return new LocalSearchScope(new PsiElement[]{f, docComment});
            }
            return new LocalSearchScope((PsiElement)f);
        }
        SearchScope searchScope = super.getUseScope();
        if (searchScope == null) {
            ParameterImpl.$$$reportNull$$$0(6);
        }
        return searchScope;
    }

    @Override
    @Nullable
    public Icon getIcon() {
        return PhpIcons.PARAMETER;
    }

    public boolean isOptional() {
        PhpParameterStub stub = (PhpParameterStub)this.getGreenStub();
        if (stub != null) {
            return stub.isOptional();
        }
        if (this.findChildByType(PhpElementTypes.PARAMETER_DEFAULT_VALUE) != null) {
            return true;
        }
        PhpDocParamTag paramTag = this.getDocTag();
        return paramTag != null && paramTag.isOptional();
    }

    public boolean isVariadic() {
        PhpParameterStub stub = (PhpParameterStub)this.getGreenStub();
        if (stub != null) {
            return stub.isVariadic();
        }
        return this.getNode().findChildByType(PhpTokenTypes.opVARIADIC) != null;
    }

    public boolean isPassByRef() {
        PhpParameterStub stub = (PhpParameterStub)this.getGreenStub();
        if (stub != null) {
            return stub.isPassByRef();
        }
        return this.getNode().findChildByType(PhpTokenTypes.opBIT_AND) != null;
    }

    @NotNull
    public PhpType getDeclaredType() {
        PhpType languageTypeMap1 = ParameterImpl.getTypeFromLanguageMap(this);
        if (languageTypeMap1 != null) {
            PhpType phpType = languageTypeMap1;
            if (phpType == null) {
                ParameterImpl.$$$reportNull$$$0(7);
            }
            return phpType;
        }
        PhpType type = ParameterImpl.transformPrimitiveTypes(this.getProject(), this.getDeclaredTypeWithPrimitiveTypesNotTransformed());
        PhpType phpType = this.isVariadic() ? type.pluralise() : type;
        if (phpType == null) {
            ParameterImpl.$$$reportNull$$$0(8);
        }
        return phpType;
    }

    @Override
    @NotNull
    public PhpType getType() {
        PhpType languageTypeMap = ParameterImpl.getTypeFromLanguageMap(this);
        if (languageTypeMap != null) {
            PhpType phpType = languageTypeMap;
            if (phpType == null) {
                ParameterImpl.$$$reportNull$$$0(9);
            }
            return phpType;
        }
        PhpType phpType = ParameterImpl.transformPrimitiveTypes(this.getProject(), super.getType()).createImmutableType();
        if (phpType == null) {
            ParameterImpl.$$$reportNull$$$0(10);
        }
        return phpType;
    }

    @Override
    @Nullable
    public String getAvailableInLanguageLevelFrom() {
        PhpNamedStub stub = (PhpNamedStub)this.getGreenStub();
        if (stub instanceof PhpAvailableInLanguageLevelRangeElement) {
            return ((PhpAvailableInLanguageLevelRangeElement)stub).getAvailableInLanguageLevelFrom();
        }
        return this.getAvailableInLanguageLevelFromAstBased();
    }

    @Override
    @Nullable
    public String getAvailableInLanguageLevelTo() {
        PhpNamedStub stub = (PhpNamedStub)this.getGreenStub();
        if (stub instanceof PhpAvailableInLanguageLevelRangeElement) {
            return ((PhpAvailableInLanguageLevelRangeElement)stub).getAvailableInLanguageLevelTo();
        }
        return this.getAvailableInLanguageLevelToAstBased();
    }

    @Nullable
    protected static PhpType getTypeFromLanguageMap(PhpNamedElementImpl<?> parameter) {
        PhpLanguageTypeMap languageTypeMap = ParameterImpl.getLanguageLevelTypeMap(parameter);
        if (languageTypeMap != null) {
            return ParameterImpl.getType(parameter.getProject(), languageTypeMap);
        }
        return null;
    }

    @NotNull
    protected static PhpType getType(@NotNull Project project, @NotNull PhpLanguageTypeMap languageTypeMap) {
        if (project == null) {
            ParameterImpl.$$$reportNull$$$0(11);
        }
        if (languageTypeMap == null) {
            ParameterImpl.$$$reportNull$$$0(12);
        }
        PhpLanguageLevel current = PhpLanguageLevel.current((Project)project);
        PhpType phpType = ((EntryStream)EntryStream.of((Map)languageTypeMap.getLanguageTypeMap()).mapKeys(PhpLanguageLevel::parse).filterKeys(Objects::nonNull).sorted(Map.Entry.comparingByKey(Comparator.comparingInt(Enum::ordinal).reversed()))).findFirst(e -> current.isAtLeast((PhpLanguageLevel)e.getKey())).map(Map.Entry::getValue).orElseGet(() -> ((PhpLanguageTypeMap)languageTypeMap).getDefaultType());
        if (phpType == null) {
            ParameterImpl.$$$reportNull$$$0(13);
        }
        return phpType;
    }

    @Nullable
    public static PhpLanguageTypeMap getLanguageLevelTypeMap(@Nullable PhpNamedElementImpl<?> parameter) {
        StubElement stub = parameter.getGreenStub();
        if (stub instanceof PhpLanguageTypeMapOwnerStub) {
            return ((PhpLanguageTypeMapOwnerStub)stub).getLanguageTypeMap();
        }
        if (parameter instanceof PhpAttributesOwner) {
            return ParameterImpl.getLanguageLevelTypeMapFromAttributes((PhpAttributesOwner)parameter);
        }
        return null;
    }

    @Nullable
    protected static PhpLanguageTypeMap getLanguageLevelTypeMapFromAttributes(PhpAttributesOwner parameter) {
        PhpAttribute attribute = (PhpAttribute)ContainerUtil.getFirstItem((Collection)parameter.getAttributes("\\JetBrains\\PhpStorm\\Internal\\LanguageLevelTypeAware"));
        if (attribute == null) {
            return null;
        }
        ArrayCreationExpression map = (ArrayCreationExpression)ObjectUtils.tryCast((Object)attribute.getParameter(0), ArrayCreationExpression.class);
        StringLiteralExpression defaultType = (StringLiteralExpression)ObjectUtils.tryCast((Object)attribute.getParameter(1), StringLiteralExpression.class);
        if (map == null || defaultType == null) {
            return null;
        }
        HashMap<String, PhpType> res = new HashMap<String, PhpType>();
        for (ArrayHashElement element : map.getHashElements()) {
            StringLiteralExpression key = (StringLiteralExpression)ObjectUtils.tryCast((Object)element.getKey(), StringLiteralExpression.class);
            StringLiteralExpression value = (StringLiteralExpression)ObjectUtils.tryCast((Object)element.getValue(), StringLiteralExpression.class);
            if (key == null || value == null) continue;
            PhpType type = ParameterImpl.getTypeFromEncodedLanguageTypeMapEntry(value);
            res.put(key.getContents(), type);
        }
        return new PhpLanguageTypeMap(res, ParameterImpl.getTypeFromEncodedLanguageTypeMapEntry(defaultType));
    }

    @NotNull
    private static PhpType getTypeFromEncodedLanguageTypeMapEntry(StringLiteralExpression value) {
        PhpType type = new PhpType();
        StringUtil.split((String)value.getContents(), (String)"|").forEach(t -> {
            String fqn = PhpLangUtil.isClassNameSpecial(t) ? t : PhpLangUtil.toFQN(t);
            type.add(fqn);
        });
        PhpType phpType = type;
        if (phpType == null) {
            ParameterImpl.$$$reportNull$$$0(14);
        }
        return phpType;
    }

    @NotNull
    public PhpType getDeclaredTypeWithPrimitiveTypesNotTransformed() {
        PhpParameterStub stub = (PhpParameterStub)this.getGreenStub();
        if (stub != null) {
            PhpType phpType = stub.getDeclaredType();
            if (phpType == null) {
                ParameterImpl.$$$reportNull$$$0(15);
            }
            return phpType;
        }
        PhpType phpType = ParameterImpl.getTypeFromDeclaration(this);
        if (phpType == null) {
            ParameterImpl.$$$reportNull$$$0(16);
        }
        return phpType;
    }

    private PhpType getDocType(boolean pluraliseVariadics) {
        PhpType res = new PhpType();
        for (PhpDocTag phpDocTag : this.getDocTagsForFetchingType()) {
            res.add(this.getType(phpDocTag, pluraliseVariadics));
        }
        this.getCustomTags().forEach(tag -> res.add(this.getType((PhpDocTag)tag, pluraliseVariadics)));
        return res;
    }

    @NotNull
    private PhpType getLocalDocMethodParameterType() {
        PhpType type = new PhpType();
        if (this.isDocMethodParameter()) {
            for (PsiElement parameterType : this.getChildren()) {
                if (PhpType.isArray((String)PhpLangUtil.toFQN(parameterType.getText()))) {
                    type.add(PhpType.ARRAY);
                    continue;
                }
                if (!PhpPsiUtil.isOfType(parameterType, (IElementType)PhpDocElementTypes.phpDocMethodType)) continue;
                type.add(ParameterImpl.getTypeFromDeclaration((PhpPsiElement)parameterType));
            }
        }
        PhpType phpType = type;
        if (phpType == null) {
            ParameterImpl.$$$reportNull$$$0(17);
        }
        return phpType;
    }

    @NotNull
    protected Stream<PhpDocTag> getCustomTags() {
        return ParameterImpl.customTags(this);
    }

    @NotNull
    protected Collection<? extends PhpDocTag> getDocTagsForFetchingType() {
        List list = ContainerUtil.createMaybeSingletonList((Object)this.getDocTag());
        if (list == null) {
            ParameterImpl.$$$reportNull$$$0(18);
        }
        return list;
    }

    @NotNull
    public static Stream<PhpDocTag> customTags(Parameter parameter) {
        Collection<PhpDocTag> customTags = PhpCustomDocTagTypeProvider.getTypeFromCustomTag(parameter.getDocComment(), PhpCustomDocTagTypeProvider::getParamTag);
        Stream<PhpDocTag> stream = customTags.stream().filter(tag -> tag instanceof PhpDocParamTag && PhpLangUtil.equalsParameterNames(((PhpDocParamTag)tag).getVarName(), parameter.getName()));
        if (stream == null) {
            ParameterImpl.$$$reportNull$$$0(19);
        }
        return stream;
    }

    private PhpType getType(PhpDocTag docTag, boolean pluraliseVariadics) {
        PhpType type = docTag != null ? docTag.getDocType() : PhpType.EMPTY;
        return !pluraliseVariadics && (this.isVariadic() || docTag instanceof PhpDocParamTag && ((PhpDocParamTag)docTag).isVariadic()) ? type.unpluralize() : type;
    }

    @NotNull
    public PhpType getDocType() {
        PhpType phpType = this.getDocType(true);
        if (phpType == null) {
            ParameterImpl.$$$reportNull$$$0(20);
        }
        return phpType;
    }

    @NotNull
    public @NotNull Collection<@NotNull PhpAttribute> getAttributes() {
        Collection<PhpAttribute> collection = ParameterImpl.getAttributesStubAware(this);
        if (collection == null) {
            ParameterImpl.$$$reportNull$$$0(21);
        }
        return collection;
    }

    @Nullable
    public PhpDeprecationAttributeOwner.PhpDeprecationInfo getDeprecationInfo() {
        return FunctionImpl.getDeprecationInfoFromAttribute((PhpAttributesOwner)this);
    }

    @NotNull
    public static PhpType transformPrimitiveTypes(@NotNull Project project, @NotNull PhpType type) {
        if (project == null) {
            ParameterImpl.$$$reportNull$$$0(22);
        }
        if (type == null) {
            ParameterImpl.$$$reportNull$$$0(23);
        }
        PhpType transformedType = new PhpType();
        for (String t : ParameterImpl.getTypesMixedAware(type)) {
            String shortName;
            String unpluralized;
            if (!PhpType.isUnresolved((String)t) && (PhpLangUtil.isParameterTypeHint(unpluralized = StringUtil.trimEnd((String)(shortName = PhpLangUtil.toShortName(t)), (String)"[]"), project) || "null".equals(unpluralized) || "false".equals(unpluralized) || "true".equals(unpluralized))) {
                transformedType.add(shortName);
                continue;
            }
            transformedType.add(t);
        }
        PhpType phpType = transformedType;
        if (phpType == null) {
            ParameterImpl.$$$reportNull$$$0(24);
        }
        return phpType;
    }

    private static @NotNull Set<@NlsSafe String> getTypesMixedAware(@NotNull PhpType type) {
        if (type == null) {
            ParameterImpl.$$$reportNull$$$0(25);
        }
        Set set = PhpType.intersects((PhpType)type, (PhpType)PhpType.MIXED) ? type.filterOut(s -> !"\\void".equalsIgnoreCase((String)s) && !"\\mixed".equalsIgnoreCase((String)s) && PhpType.isNotExtendablePrimitiveType((String)s)).getTypesWithParametrisedParts() : type.getTypesWithParametrisedParts();
        if (set == null) {
            ParameterImpl.$$$reportNull$$$0(26);
        }
        return set;
    }

    public static PhpType getTypeFromDeclaration(PhpPsiElement parameter) {
        PhpTypeDeclaration typeDeclaration = (PhpTypeDeclaration)PsiTreeUtil.getChildOfType((PsiElement)parameter, PhpTypeDeclaration.class);
        if (typeDeclaration != null) {
            parameter = typeDeclaration;
        }
        PhpType type = new PhpType();
        boolean phpDocMethod = PhpPsiUtil.getParentOfClass((PsiElement)parameter, Method.class) instanceof PhpDocMethod;
        for (PsiElement child = parameter.getFirstChild(); child != null; child = child.getNextSibling()) {
            IElementType elementType;
            if (child instanceof ClassReference) {
                if (PhpPsiUtil.isOfType(child.getFirstChild(), PhpTokenTypes.kwARRAY)) {
                    type.add(PhpType.ARRAY);
                    continue;
                }
                if (PhpPsiUtil.isOfType(child.getFirstChild(), PhpTokenTypes.kwCALLABLE)) {
                    type.add(PhpType.CALLABLE);
                    continue;
                }
                String text = child.getText();
                PhpType t = new PhpType().add(phpDocMethod && (PhpType.isPrimitiveType((String)text) || PhpType.isResourceOrNumberType((String)text)) ? text : ((ClassReference)child).getFQN());
                PsiElement next = child.getNextSibling();
                if (PhpPsiUtil.isOfType(next, PhpTokenTypes.chLBRACKET)) {
                    t = t.pluralise();
                    child = next;
                }
                type.add(t);
                continue;
            }
            if (PhpPsiUtil.isOfType(child, PhpElementTypes.CLASS_REFERENCES_GROUP)) {
                type.add(PhpTypeDeclarationImpl.getTypeDeclarationPartType(child));
                continue;
            }
            ASTNode childNode = child.getNode();
            IElementType iElementType = elementType = childNode == null ? null : childNode.getElementType();
            if (elementType == PhpTokenTypes.VARIABLE) break;
            if (elementType != PhpTokenTypes.opQUEST || PhpPsiUtil.isOfType(PhpPsiUtil.getNextSiblingIgnoreWhitespace(child, true), PhpTokenTypes.VARIABLE)) continue;
            type.add(PhpType.NULL);
        }
        if (!phpDocMethod && typeDeclaration instanceof PhpTypeDeclarationImpl) {
            return ((PhpTypeDeclarationImpl)typeDeclaration).updateTypeWithIntersection(type);
        }
        return type;
    }

    @NotNull
    public PhpType getInferredType() {
        PsiElement defaultValue = this.getDefaultValue();
        if (defaultValue instanceof PhpTypedElement) {
            return ParameterImpl.generaliseDefaultValueType(((PhpTypedElement)defaultValue).getType());
        }
        PhpType phpType = PhpType.EMPTY;
        if (phpType == null) {
            ParameterImpl.$$$reportNull$$$0(27);
        }
        return phpType;
    }

    @NotNull
    public static PhpType generaliseDefaultValueType(PhpType inferredType) {
        PhpType type = PhpType.intersects((PhpType)inferredType, (PhpType)PhpType.or((PhpType)PhpType.FALSE, (PhpType)PhpType.TRUE)) ? inferredType.filter(PhpType.FALSE).filter(PhpType.TRUE).add(PhpType.BOOLEAN) : inferredType;
        return ParameterImpl.removeParametrisedIntType(type);
    }

    @NotNull
    public static PhpType removeParametrisedIntType(PhpType type) {
        PhpType phpType = type.map(t -> "\\int".equals(PhpType.removeParametrisedType((String)t)) ? PhpType.removeParametrisedType((String)t) : t);
        if (phpType == null) {
            ParameterImpl.$$$reportNull$$$0(28);
        }
        return phpType;
    }

    @NotNull
    private PhpType getTypeFromDeclaration() {
        PhpType typeHint = this.getDeclaredTypeWithPrimitiveTypesNotTransformed();
        PsiElement defaultValue = this.getDefaultValue();
        PhpType type = defaultValue instanceof PhpTypedElement ? new PhpType().add(typeHint).add(defaultValue) : typeHint;
        type.add(this.getLocalDocMethodParameterType());
        PhpType phpType = type;
        if (phpType == null) {
            ParameterImpl.$$$reportNull$$$0(29);
        }
        return phpType;
    }

    @NotNull
    public PhpType getLocalType() {
        PhpType type = FunctionImpl.getLocalTypeFromGistOrStub(this);
        if (type != null) {
            PhpType phpType = type;
            if (phpType == null) {
                ParameterImpl.$$$reportNull$$$0(30);
            }
            return phpType;
        }
        type = new PhpType();
        PhpType docType = this.getDocType(false);
        type.add(docType);
        PhpType declaredType = this.getTypeFromDeclaration();
        if (PhpTypeAnalyserVisitor.isParametrisedInt(docType)) {
            declaredType = declaredType.filter(PhpType.INT);
        }
        boolean hasPluralDocType = docType.getTypes().stream().anyMatch(PhpType::isPluralType);
        if (!declaredType.filterNull().equals((Object)PhpType.ARRAY) || !hasPluralDocType) {
            type.add(declaredType);
        } else if (declaredType.isNullable()) {
            type.add(PhpType.NULL);
        }
        type.add(PhpArrayFunctionsProcessorParameterTypeProvider.createLocalType(this));
        PhpType phpType = type.add(ParameterImpl.createSignatureTypeFromParentMethod(this, type));
        if (phpType == null) {
            ParameterImpl.$$$reportNull$$$0(31);
        }
        return phpType;
    }

    @Nullable
    public PsiElement getDefaultValue() {
        PsiElement e = this.findChildByType(PhpElementTypes.PARAMETER_DEFAULT_VALUE);
        return e != null ? e.getFirstChild() : null;
    }

    public PhpType getDefaultValueType() {
        PhpParameterStub stub = (PhpParameterStub)this.getGreenStub();
        if (stub != null) {
            return stub.getDefaultValueType();
        }
        return new PhpType().add(this.getDefaultValue());
    }

    @Nullable
    public String getDefaultValuePresentation() {
        PhpParameterStub stub = (PhpParameterStub)this.getStub();
        if (stub != null) {
            return stub.getDefaultValuePresentation();
        }
        PsiElement defaultValue = this.getDefaultValue();
        return defaultValue != null ? ConstantImpl.getValuePresentationInternal(defaultValue) : null;
    }

    @Nullable
    public PhpDocParamTag getDocTag() {
        PhpDocComment docComment = this.getDocComment();
        return docComment != null ? docComment.getParamTagByName(this.getName()) : null;
    }

    public Collection<PhpDocTag> getDocTags() {
        return Stream.concat(this.getCustomTags(), this.getDocTagsForFetchingType().stream()).collect(Collectors.toSet());
    }

    @Override
    @NotNull
    public String getFQN() {
        String string = this.getFunctionFQN() + "(" + this.getName() + ")";
        if (string == null) {
            ParameterImpl.$$$reportNull$$$0(32);
        }
        return string;
    }

    @NotNull
    private String getFunctionFQN() {
        String string = this.getFunction().getFQN();
        if (string == null) {
            ParameterImpl.$$$reportNull$$$0(33);
        }
        return string;
    }

    @NotNull
    private Function getFunction() {
        Function function = Objects.requireNonNull(PhpPsiUtil.getParentOfClass((PsiElement)this, Function.class));
        if (function == null) {
            ParameterImpl.$$$reportNull$$$0(34);
        }
        return function;
    }

    @Override
    public void processDocs(Processor<PhpDocComment> processor2) {
        Method method = PhpPsiUtil.getParentOfClass((PsiElement)this, Method.class);
        if (method != null) {
            method.processDocs(processor2);
        }
    }

    @Override
    public PhpDocComment getDocComment() {
        PhpNamedStub stub = (PhpNamedStub)this.getGreenStub();
        Function function = stub != null ? (Function)stub.getParentStubOfType(Function.class) : PhpPsiUtil.getParentOfClass((PsiElement)this, Function.class);
        return function != null ? function.getDocComment() : null;
    }

    public boolean isWriteAccess() {
        return true;
    }

    @NotNull
    private static PhpType createSignatureTypeFromParentMethod(Parameter parameter, PhpType local) {
        Method method = (Method)ObjectUtils.tryCast((Object)PhpPsiUtil.getParentOfClass((PsiElement)parameter, true, Function.class), Method.class);
        if (method == null) {
            PhpType phpType = PhpType.EMPTY;
            if (phpType == null) {
                ParameterImpl.$$$reportNull$$$0(35);
            }
            return phpType;
        }
        PhpClass aClass = method.getContainingClass();
        if (aClass == null) {
            PhpType phpType = PhpType.EMPTY;
            if (phpType == null) {
                ParameterImpl.$$$reportNull$$$0(36);
            }
            return phpType;
        }
        boolean shouldAddTypeFromSuperParameter = !(!local.isEmpty() && local.isComplete() || method.getMethodType(false) == Method.MethodType.CONSTRUCTOR || aClass.getSuperFQN() == null && aClass.getInterfaceNames().length == 0);
        PhpDocComment docComment = method.getDocComment();
        PhpDocParamTag parameterDocTag = parameter.getDocTag();
        boolean shouldAddTypeFromSuperParameterDoc = docComment != null && docComment.hasInheritDocTag() && parameterDocTag == null;
        PhpType type = new PhpType();
        String parameterIndexSignature = ParameterImpl.getParameterSignature(parameter, (Function)method);
        if (parameterIndexSignature == null) {
            PhpType phpType = PhpType.EMPTY;
            if (phpType == null) {
                ParameterImpl.$$$reportNull$$$0(37);
            }
            return phpType;
        }
        if (shouldAddTypeFromSuperParameter) {
            type.add(PhpOptionalCompletionTP.TYPE_KEY.sign((CharSequence)PhpTypeSignatureKey.SUPER_MEMBER.sign((CharSequence)parameterIndexSignature)));
        }
        type.add(ParameterImpl.tryGetDocOfSuperMember(parameterIndexSignature, shouldAddTypeFromSuperParameterDoc, parameterDocTag == null && PhpType.intersects((PhpType)local, (PhpType)PhpType.ARRAY)));
        PhpType phpType = type;
        if (phpType == null) {
            ParameterImpl.$$$reportNull$$$0(38);
        }
        return phpType;
    }

    public static PhpType tryGetDocOfSuperMember(String type, boolean shouldAddTypeFromSuperParameterDoc, boolean arrayWithoutDocTag) {
        PhpType docOfSuperMember = new PhpType().add(PhpTypeSignatureKey.DOC_OF_SUPER_MEMBER.sign((CharSequence)type));
        if (shouldAddTypeFromSuperParameterDoc) {
            return docOfSuperMember;
        }
        if (arrayWithoutDocTag) {
            return docOfSuperMember.filterOutIncompleteTypesAware((PhpType.PhpTypeExclusion)PhpType.ExcludeCode.ONLY_PLURAL);
        }
        return PhpType.EMPTY;
    }

    @Nullable
    public static String getParameterSignature(@NotNull Parameter parameter, @Nullable Function function) {
        if (parameter == null) {
            ParameterImpl.$$$reportNull$$$0(39);
        }
        if (function == null) {
            return null;
        }
        Object[] parameters = function.getParameters();
        int parameterIndex = ArrayUtil.indexOf((Object[])parameters, (Object)parameter);
        if (parameterIndex < 0) {
            return null;
        }
        return ParameterImpl.getParameterIndexSignature(function, parameterIndex);
    }

    @Nullable
    private static String getParameterIndexSignature(Function function, int parameterIndex) {
        String signature;
        if (function instanceof Method) {
            PhpClass containingClass = ((Method)function).getContainingClass();
            if (containingClass == null) {
                return null;
            }
            signature = PhpTypeSignatureKey.METHOD.sign((CharSequence)PhpTypeSignatureKey.CLASS.sign((CharSequence)(containingClass.getFQN() + "." + function.getName())));
        } else {
            signature = PhpTypeSignatureKey.FUNCTION.sign((CharSequence)function.getFQN());
        }
        return PhpTypeSignatureKey.PARAMETER.sign((CharSequence)(signature + "." + parameterIndex));
    }

    @Nullable
    public PhpParameterType getTypeDeclaration() {
        return (PhpParameterType)PsiTreeUtil.getChildOfType((PsiElement)this, PhpParameterType.class);
    }

    public boolean updateType(@NotNull PhpType type) {
        if (type == null) {
            ParameterImpl.$$$reportNull$$$0(40);
        }
        if (super.updateType(type)) {
            return true;
        }
        PhpParameterType parameterType = PhpPsiElementFactory.createParameterType(this.getProject(), PhpUpdateSignatureFromPhpDocQuickFix.getTypeString((PsiElement)this, type, PhpType.EMPTY));
        this.addBefore((PsiElement)parameterType, this.findAnchorToInsertTypeBefore());
        return true;
    }

    @Nullable
    private PsiElement findAnchorToInsertTypeBefore() {
        PsiElement anchor = this.getNameIdentifier();
        PsiElement prev = PhpPsiUtil.getPrevSiblingIgnoreWhitespace(anchor, true);
        if (PhpPsiUtil.isOfType(prev, PhpTokenTypes.opBIT_AND, PhpTokenTypes.opVARIADIC)) {
            anchor = prev;
            prev = PhpPsiUtil.getPrevSiblingIgnoreWhitespace(anchor, true);
            if (PhpPsiUtil.isOfType(prev, PhpTokenTypes.opBIT_AND, PhpTokenTypes.opVARIADIC)) {
                anchor = prev;
            }
        }
        return anchor;
    }

    @Override
    @Nullable
    protected String getDeprecationVersionFromDocComment() {
        return null;
    }

    @Override
    @Nullable
    protected String getDeprecatedSinceVersionFromSuperCommentsSkippingInheritDoc() {
        return null;
    }

    public boolean isAvailableByLanguageLevel() {
        return PhpIndexImpl.suitsPhpStormStubsLanguageLevel(this.getProject(), this);
    }

    public static boolean isAvailableByLanguageLevel(@Nullable PsiElement parameter) {
        return !(parameter instanceof ParameterImpl) || ((ParameterImpl)parameter).isAvailableByLanguageLevel();
    }

    public boolean isComputableCompileTimeDefaultValue() {
        PhpParameterStub stub = (PhpParameterStub)this.getGreenStub();
        if (stub instanceof PhpParameterStubImpl) {
            return ((PhpParameterStubImpl)stub).isComputableCompileTimeDefaultValue();
        }
        PsiElement defaultValue = this.getDefaultValue();
        return defaultValue == null || PhpAnnotatorVisitor.isComputableCompileTimeDefaultValue(defaultValue);
    }

    public boolean isDocMethodParameter() {
        return this.getParent().getParent() instanceof PhpDocMethod;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 4, 5, 11, 12, 22, 23, 25, 39, 40 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/elements/impl/ParameterImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpElementVisitor";
                break;
            }
            case 11: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageTypeMap";
                break;
            }
            case 23: 
            case 25: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPromotedFieldAccess";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameCS";
                break;
            }
            case 4: 
            case 5: 
            case 11: 
            case 12: 
            case 22: 
            case 23: 
            case 25: 
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/elements/impl/ParameterImpl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getUseScope";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclaredType";
                break;
            }
            case 9: 
            case 10: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeFromEncodedLanguageTypeMapEntry";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclaredTypeWithPrimitiveTypesNotTransformed";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalDocMethodParameterType";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocTagsForFetchingType";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "customTags";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocType";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributes";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "transformPrimitiveTypes";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypesMixedAware";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getInferredType";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "removeParametrisedIntType";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeFromDeclaration";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalType";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getFQN";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionFQN";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunction";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "createSignatureTypeFromParentMethod";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "transformPrimitiveTypes";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getTypesMixedAware";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getParameterSignature";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "updateType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 4, 5, 11, 12, 22, 23, 25, 39, 40 -> new IllegalArgumentException(string);
        };
    }
}

