/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.patterns;

import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.InitialPatternCondition;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.injection.PhpElementPattern;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.ArrayHashElement;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.ConcatenationExpression;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.ParenthesizedExpression;
import com.jetbrains.php.lang.psi.elements.PhpEval;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import dk.brics.automaton.AutomatonProvider;
import dk.brics.automaton.DatatypesAutomatonProvider;
import dk.brics.automaton.RegExp;
import dk.brics.automaton.RunAutomaton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpPatterns
extends PlatformPatterns {
    private static final int STRING_LITERAL_LIMIT = 10000;
    static final Map<String, RunAutomaton> map = ContainerUtil.createWeakKeyWeakValueMap();

    public static PhpElementPattern phpElement() {
        return new PhpElementPattern.Capture<PhpPsiElement>(PhpPsiElement.class);
    }

    public static PhpElementPattern phpFunctionReference() {
        return new PhpElementPattern.Capture<FunctionReference>(FunctionReference.class);
    }

    public static PhpElementPattern.Capture<StringLiteralExpression> phpLiteralExpression() {
        return PhpPatterns.phpLiteralExpression(null);
    }

    private static PsiElementPattern.Capture<BinaryExpression> phpConcatenationExpression() {
        return (PsiElementPattern.Capture)PhpPatterns.psiElement(BinaryExpression.class).and((ElementPattern)PhpPatterns.psiElement((IElementType)PhpElementTypes.CONCATENATION_EXPRESSION));
    }

    public static PhpElementPattern.Capture<StringLiteralExpression> phpStringLiteralInsideEval() {
        return (PhpElementPattern.Capture)PhpPatterns.phpLiteralExpression().inside(true, (ElementPattern)PhpPatterns.phpEval(), (ElementPattern)PhpPatterns.not((ElementPattern)PhpPatterns.or((ElementPattern[])new ElementPattern[]{PhpPatterns.phpEval(), PhpPatterns.phpConcatenationExpression()})));
    }

    private static PhpElementPattern.Capture<PhpEval> phpEval() {
        return new PhpElementPattern.Capture<PhpEval>(PhpEval.class);
    }

    public static PhpElementPattern.Capture<PhpExpression> phpFirstArgument(final @Nullable PhpElementPattern.Capture<FunctionReference> functionReferenceCapture) {
        return new PhpElementPattern.Capture<PhpExpression>(PhpExpression.class){

            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                if (!(o instanceof PhpExpression)) {
                    return false;
                }
                PsiElement anchor = (PsiElement)o;
                while (anchor.getParent() instanceof ConcatenationExpression || anchor.getParent() instanceof ParenthesizedExpression) {
                    anchor = anchor.getParent();
                }
                ParameterList parameterList = (ParameterList)ObjectUtils.tryCast((Object)anchor.getParent(), ParameterList.class);
                return PhpPatterns.isFirstArgument(anchor, parameterList, functionReferenceCapture);
            }
        };
    }

    @NotNull
    public static Collection<PsiElement> unwrapConcatenation(@Nullable PsiElement argument) {
        return PhpPatterns.unwrapOperation(argument, PhpTokenTypes.opCONCAT);
    }

    @NotNull
    public static Collection<PsiElement> unwrapOperation(@Nullable PsiElement argument, IElementType operation) {
        if (argument instanceof ParenthesizedExpression) {
            return PhpPatterns.unwrapOperation((PsiElement)((ParenthesizedExpression)argument).extract(), operation);
        }
        if (argument instanceof BinaryExpression && ((BinaryExpression)argument).getOperationType() == operation) {
            ArrayList<PsiElement> res = new ArrayList<PsiElement>();
            res.addAll(PhpPatterns.unwrapOperation(((BinaryExpression)argument).getLeftOperand(), operation));
            res.addAll(PhpPatterns.unwrapOperation(((BinaryExpression)argument).getRightOperand(), operation));
            ArrayList<PsiElement> arrayList = res;
            if (arrayList == null) {
                PhpPatterns.$$$reportNull$$$0(0);
            }
            return arrayList;
        }
        Collection<Object> collection = argument != null ? Collections.singleton(argument) : Collections.emptyList();
        if (collection == null) {
            PhpPatterns.$$$reportNull$$$0(1);
        }
        return collection;
    }

    public static PhpElementPattern.Capture<? extends PsiElement> pcreFunctionFirstArgument() {
        return PhpPatterns.phpFirstArgument(PhpPatterns.pcreFunction());
    }

    public static PhpElementPattern.Capture<PhpExpression> phpDirectFirstArgument(final @Nullable PhpElementPattern.Capture<FunctionReference> functionReferenceCapture) {
        return new PhpElementPattern.Capture<PhpExpression>(PhpExpression.class){

            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                if (!(o instanceof PhpExpression)) {
                    return false;
                }
                ParameterList parameterList = (ParameterList)ObjectUtils.tryCast((Object)((PhpExpression)o).getParent(), ParameterList.class);
                return PhpPatterns.isFirstArgument((PsiElement)((PhpExpression)o), parameterList, functionReferenceCapture);
            }
        };
    }

    private static boolean isFirstArgument(@NotNull PsiElement element, ParameterList parameterList, PhpElementPattern.Capture<FunctionReference> capture) {
        PsiElement firstArgument;
        if (element == null) {
            PhpPatterns.$$$reportNull$$$0(2);
        }
        PsiElement psiElement = firstArgument = parameterList != null ? parameterList.getParameter(0) : null;
        if (firstArgument != element) {
            return false;
        }
        if (capture == null) {
            return true;
        }
        FunctionReference functionReference = (FunctionReference)ObjectUtils.tryCast((Object)parameterList.getParent(), FunctionReference.class);
        return capture.accepts(functionReference);
    }

    @NotNull
    public static PhpElementPattern.Capture<FunctionReference> pcreFunction() {
        PhpElementPattern.Capture<FunctionReference> capture = PhpPatterns.phpWithName((ElementPattern<String>)PhpPatterns.string().oneOf(new String[]{"preg_filter", "preg_grep", "preg_match_all", "preg_match", "preg_replace_callback", "preg_replace", "preg_split", "preg_replace_callback_array"}));
        if (capture == null) {
            PhpPatterns.$$$reportNull$$$0(3);
        }
        return capture;
    }

    public static ElementPattern<? extends PsiElement> phpArrayValueSkippingConcatenation(final PhpElementPattern.Capture<? extends PsiElement> arrayPattern) {
        PatternCondition<ArrayCreationExpression> pattern = new PatternCondition<ArrayCreationExpression>("php array pattern condition"){

            public boolean accepts(@NotNull ArrayCreationExpression expression, ProcessingContext context) {
                if (expression == null) {
                    3.$$$reportNull$$$0(0);
                }
                return arrayPattern.accepts(expression);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/jetbrains/php/lang/patterns/PhpPatterns$3", "accepts"));
            }
        };
        return PhpPatterns.phpArrayValueSkippingConcatenation((ElementPattern<PsiElement>)PhpPatterns.or((ElementPattern[])new ElementPattern[]{PhpPatterns.psiElement(ArrayCreationExpression.class).with((PatternCondition)pattern), PhpPatterns.psiElement(ArrayHashElement.class).withParent((ElementPattern)PhpPatterns.psiElement(ArrayCreationExpression.class).with((PatternCondition)pattern))}));
    }

    @NotNull
    private static PhpElementPattern.Capture<PhpExpression> phpArrayValueSkippingConcatenation(final ElementPattern<PsiElement> parentValue) {
        return new PhpElementPattern.Capture<PhpExpression>(PhpExpression.class){

            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                if (!(o instanceof PhpExpression)) {
                    return false;
                }
                PsiElement parent = ((PhpExpression)o).getParent();
                int i = 0;
                while (parent instanceof ConcatenationExpression || parent instanceof ParenthesizedExpression) {
                    parent = parent.getParent();
                    if (i++ <= 100) continue;
                    return false;
                }
                return PhpPsiUtil.isOfType(parent, PhpElementTypes.ARRAY_VALUE) && parentValue.accepts((Object)parent.getParent());
            }
        };
    }

    public static PhpElementPattern.Capture<FunctionReference> phpWithName(final @NotNull ElementPattern<String> namePattern) {
        if (namePattern == null) {
            PhpPatterns.$$$reportNull$$$0(4);
        }
        return new PhpElementPattern.Capture<FunctionReference>(new InitialPatternCondition<FunctionReference>(FunctionReference.class){

            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                return o instanceof PhpPsiElement && namePattern.accepts((Object)((PhpPsiElement)o).getName());
            }
        });
    }

    public static synchronized PhpElementPattern.Capture<StringLiteralExpression> phpLiteralMatchesBrics(@NotNull String pattern) {
        if (pattern == null) {
            PhpPatterns.$$$reportNull$$$0(5);
        }
        final RunAutomaton runAutomaton = map.computeIfAbsent(pattern, s -> {
            StringBuilder sb = new StringBuilder(s.length() * 5);
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                if (c == ' ') {
                    sb.append("<whitespacechar>");
                    continue;
                }
                if (Character.isUpperCase(c) && !PhpPatterns.notInSymbolRange(s, i)) {
                    sb.append('[').append(Character.toUpperCase(c)).append(Character.toLowerCase(c)).append(']');
                    continue;
                }
                sb.append(c);
            }
            RegExp regExp = new RegExp(sb.toString());
            return new RunAutomaton(regExp.toAutomaton((AutomatonProvider)new DatatypesAutomatonProvider()), true);
        });
        return new PhpElementPattern.Capture<StringLiteralExpression>(new InitialPatternCondition<StringLiteralExpression>(StringLiteralExpression.class){

            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                StringLiteralExpression expr;
                if (o instanceof StringLiteralExpression && (expr = (StringLiteralExpression)o).getTextLength() < 10000) {
                    String value = expr.getContents();
                    boolean run = runAutomaton.run(value);
                    return run;
                }
                return false;
            }
        });
    }

    private static boolean notInSymbolRange(String s, int i) {
        return i + 1 < s.length() && s.charAt(i + 1) == '-' || i - 1 >= 0 && s.charAt(i - 1) == '-';
    }

    public static PhpElementPattern.Capture<StringLiteralExpression> phpLiteralExpressionWithValue(final ElementPattern<String> valuePattern) {
        return new PhpElementPattern.Capture<StringLiteralExpression>(new InitialPatternCondition<StringLiteralExpression>(StringLiteralExpression.class){

            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                return o instanceof StringLiteralExpression && valuePattern.accepts((Object)((StringLiteralExpression)o).getContents());
            }
        });
    }

    public static PhpElementPattern.Capture<StringLiteralExpression> phpLiteralExpression(final String name) {
        return new PhpElementPattern.Capture<StringLiteralExpression>(new InitialPatternCondition<StringLiteralExpression>(StringLiteralExpression.class){

            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                StringLiteralExpression s;
                return o instanceof StringLiteralExpression && (!PhpPsiUtil.isOfType((s = (StringLiteralExpression)o).getParent(), PhpElementTypes.CONCATENATION_EXPRESSION) || s.getPrevPsiSibling() == null) && (name == null && s.getName() == null || name != null && name.equalsIgnoreCase(s.getName()));
            }
        });
    }

    public static PhpElementPattern.Capture<StringLiteralExpression> withTopmostConcatenationOperand(final PhpElementPattern.Capture<StringLiteralExpression> capture) {
        return new PhpElementPattern.Capture<StringLiteralExpression>(new InitialPatternCondition<StringLiteralExpression>(StringLiteralExpression.class){

            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                if (o instanceof StringLiteralExpression) {
                    PsiElement leftOperand;
                    PsiElement grandParent;
                    if (capture.accepts(o)) {
                        return true;
                    }
                    ConcatenationExpression parent = (ConcatenationExpression)ObjectUtils.tryCast((Object)((StringLiteralExpression)o).getParent(), ConcatenationExpression.class);
                    while (parent != null && (grandParent = parent.getParent()) instanceof ConcatenationExpression) {
                        parent = (ConcatenationExpression)grandParent;
                    }
                    if (parent != null && (leftOperand = parent.getLeftOperand()) != null && capture.accepts(leftOperand)) {
                        return true;
                    }
                }
                return false;
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/patterns/PhpPatterns";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namePattern";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "unwrapOperation";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/patterns/PhpPatterns";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "pcreFunction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isFirstArgument";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "phpWithName";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "phpLiteralMatchesBrics";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 4, 5 -> new IllegalArgumentException(string);
        };
    }
}

