/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.intentions.strings.converters;

import com.intellij.modcommand.ActionContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.highlighting.PhpConversionSpecificationParser;
import com.jetbrains.php.lang.intentions.PhpReplaceQuotesIntention;
import com.jetbrains.php.lang.intentions.stringDoc.PhpHeredocToStringIntention;
import com.jetbrains.php.lang.intentions.strings.converters.PhpInterpolationStringRepresentationConverter;
import com.jetbrains.php.lang.intentions.strings.converters.PhpLazyStringPartDescriptor;
import com.jetbrains.php.lang.intentions.strings.converters.PhpStringPartDescriptor;
import com.jetbrains.php.lang.intentions.strings.converters.PhpStringPartDescriptorImpl;
import com.jetbrains.php.lang.intentions.strings.converters.PhpStringRepresentationConverter;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpSprintfStringRepresentationConverter
implements PhpStringRepresentationConverter<FunctionReference> {
    public static final PhpSprintfStringRepresentationConverter INSTANCE = new PhpSprintfStringRepresentationConverter();

    @Override
    @NotNull
    public List<PhpStringPartDescriptor> getStringParts(@NotNull FunctionReference reference, @NotNull ActionContext context) {
        if (reference == null) {
            PhpSprintfStringRepresentationConverter.$$$reportNull$$$0(0);
        }
        if (context == null) {
            PhpSprintfStringRepresentationConverter.$$$reportNull$$$0(1);
        }
        List<PhpStringPartDescriptor> list = this.getStringParts(reference);
        if (list == null) {
            PhpSprintfStringRepresentationConverter.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public List<PhpStringPartDescriptor> getStringParts(@NotNull FunctionReference reference) {
        if (reference == null) {
            PhpSprintfStringRepresentationConverter.$$$reportNull$$$0(3);
        }
        PsiElement[] parameters = reference.getParameters();
        StringLiteralExpression string = (StringLiteralExpression)parameters[0];
        List<PhpConversionSpecificationParser.ConversionSpecification> specifications = PhpSprintfStringRepresentationConverter.getSpecifications(string, parameters);
        return PhpSprintfStringRepresentationConverter.getStringParts(reference.getProject(), parameters, string.getContents(), string.isSingleQuote(), specifications);
    }

    @NotNull
    private static List<PhpConversionSpecificationParser.ConversionSpecification> getSpecifications(StringLiteralExpression formatString, PsiElement[] parameters) {
        String contents = formatString.getContents();
        List<PhpConversionSpecificationParser.ConversionSpecification> list = PhpConversionSpecificationParser.parseConversionSpecifications(contents, formatString.isSingleQuote() || PhpHeredocToStringIntention.isNowdoc((PsiElement)formatString)).values().stream().filter(e -> e.getOrder() < parameters.length).sorted(Comparator.comparingInt(e -> e.getRangeInElement().getStartOffset())).collect(Collectors.toList());
        if (list == null) {
            PhpSprintfStringRepresentationConverter.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    private static List<PhpStringPartDescriptor> getStringParts(Project project, PsiElement[] parameters, String contents, boolean singleQuote, List<PhpConversionSpecificationParser.ConversionSpecification> specifications) {
        SmartList elements = new SmartList();
        int lastOffset = 0;
        for (PhpConversionSpecificationParser.ConversionSpecification specification : specifications) {
            TextRange element = specification.getRangeInElement();
            int startOffset = element.getStartOffset();
            if (startOffset > 0 && lastOffset < startOffset) {
                elements.add(PhpSprintfStringRepresentationConverter.getLazyStringDescriptor(project, contents, singleQuote, lastOffset, startOffset));
            }
            elements.add(new PhpStringPartDescriptorImpl(parameters[specification.getOrder()]));
            lastOffset = specification.getRangeInElement().getEndOffset();
        }
        int length = contents.length();
        if (lastOffset < length) {
            elements.add(PhpSprintfStringRepresentationConverter.getLazyStringDescriptor(project, contents, singleQuote, lastOffset, length));
        }
        SmartList smartList = elements;
        if (smartList == null) {
            PhpSprintfStringRepresentationConverter.$$$reportNull$$$0(5);
        }
        return smartList;
    }

    @NotNull
    private static PhpLazyStringPartDescriptor getLazyStringDescriptor(Project project, String contents, boolean singleQuote, int lastOffset, int length) {
        String substring = contents.substring(lastOffset, length).replace("%%", "%");
        return new PhpLazyStringPartDescriptor(() -> PhpPsiElementFactory.createStringLiteralExpression(project, substring, singleQuote), StringLiteralExpression.class, PhpElementTypes.STRING);
    }

    @Override
    public boolean isAvailable(@NotNull FunctionReference reference, @NotNull ActionContext context) {
        if (reference == null) {
            PhpSprintfStringRepresentationConverter.$$$reportNull$$$0(6);
        }
        if (context == null) {
            PhpSprintfStringRepresentationConverter.$$$reportNull$$$0(7);
        }
        if (!PhpSprintfStringRepresentationConverter.isSprintfWithStringLiteralAsFirstArgument(reference)) {
            return false;
        }
        PsiElement[] parameters = reference.getParameters();
        return ContainerUtil.and(PhpSprintfStringRepresentationConverter.getSpecifications((StringLiteralExpression)parameters[0], parameters), PhpConversionSpecificationParser.ConversionSpecification::simple);
    }

    @Override
    @NotNull
    public FunctionReference createExpression(@NotNull Project project, @NotNull List<PsiElement> parts) {
        if (project == null) {
            PhpSprintfStringRepresentationConverter.$$$reportNull$$$0(8);
        }
        if (parts == null) {
            PhpSprintfStringRepresentationConverter.$$$reportNull$$$0(9);
        }
        List<PsiElement> arguments = PhpSprintfStringRepresentationConverter.getArguments(project, parts);
        String argumentsText = StreamEx.of(arguments).map(PsiElement::getText).joining((CharSequence)",");
        FunctionReference functionReference = PhpPsiElementFactory.createFunctionReference(project, "sprintf(" + argumentsText + ")");
        if (functionReference == null) {
            PhpSprintfStringRepresentationConverter.$$$reportNull$$$0(10);
        }
        return functionReference;
    }

    private static List<PsiElement> getArguments(@NotNull Project project, @NotNull List<PsiElement> parts) {
        if (project == null) {
            PhpSprintfStringRepresentationConverter.$$$reportNull$$$0(11);
        }
        if (parts == null) {
            PhpSprintfStringRepresentationConverter.$$$reportNull$$$0(12);
        }
        SmartList restArguments = new SmartList();
        StringBuilder formatStringSb = new StringBuilder();
        boolean useSingleQuote = PhpInterpolationStringRepresentationConverter.allLiteralsAreSingleQuoted(parts);
        for (PsiElement part : parts) {
            if (part instanceof StringLiteralExpression) {
                String formatString = !useSingleQuote && ((StringLiteralExpression)part).isSingleQuote() ? PhpReplaceQuotesIntention.createLiteralWithChangedQuotes((StringLiteralExpression)part).getContents() : ((StringLiteralExpression)part).getContents();
                formatStringSb.append(formatString.replace("%", "%%"));
                continue;
            }
            restArguments.add(part);
            formatStringSb.append(PhpSprintfStringRepresentationConverter.getConversionSpecificationPlaceholder(part));
        }
        StringLiteralExpression formatString = PhpPsiElementFactory.createStringLiteralExpression(project, formatStringSb.toString(), useSingleQuote);
        return ContainerUtil.prepend((List)restArguments, (Object[])new PsiElement[]{formatString});
    }

    private static String getConversionSpecificationPlaceholder(PsiElement part) {
        if (part instanceof PhpTypedElement) {
            PhpType type = ((PhpTypedElement)part).getType();
            for (String typeString : type.getTypes()) {
                if (StringUtil.equals((CharSequence)typeString, (CharSequence)"\\double")) {
                    return "%f";
                }
                if (!StringUtil.equals((CharSequence)typeString, (CharSequence)"\\int")) continue;
                return "%d";
            }
        }
        return "%s";
    }

    @Override
    @Nullable
    public FunctionReference getTargetElement(@NotNull PsiElement element) {
        if (element == null) {
            PhpSprintfStringRepresentationConverter.$$$reportNull$$$0(13);
        }
        while (element != null) {
            FunctionReference functionReference = PhpPsiUtil.getParentOfClass(element, false, FunctionReference.class);
            if (PhpSprintfStringRepresentationConverter.isSprintfWithStringLiteralAsFirstArgument(functionReference)) {
                return functionReference;
            }
            element = functionReference != null ? functionReference.getParent() : null;
        }
        return null;
    }

    private static boolean isSprintfWithStringLiteralAsFirstArgument(@Nullable FunctionReference reference) {
        return reference != null && reference.getParameter(0) instanceof StringLiteralExpression && PhpCodeInsightUtil.isGlobalFunctionCallWithName(reference, "sprintf");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 5, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/intentions/strings/converters/PhpSprintfStringRepresentationConverter";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parts";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/intentions/strings/converters/PhpSprintfStringRepresentationConverter";
                break;
            }
            case 2: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringParts";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSpecifications";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getStringParts";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 10: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createExpression";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getArguments";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getTargetElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 5, 10 -> new IllegalStateException(string);
        };
    }
}

