/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.intentions.array;

import com.intellij.codeInspection.util.IntentionName;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.lang.intentions.array.PhpConvertToTraditionalArraySyntaxIntention;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.MultiassignmentExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpConvertToTraditionalListSyntaxIntention
extends PhpConvertToTraditionalArraySyntaxIntention {
    @Override
    @Nullable
    protected Presentation getPresentation(@NotNull ActionContext context, @NotNull PsiElement element) {
        if (context == null) {
            PhpConvertToTraditionalListSyntaxIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            PhpConvertToTraditionalListSyntaxIntention.$$$reportNull$$$0(1);
        }
        if (!PhpProjectConfigurationFacade.getInstance(context.project()).getLanguageLevel().hasFeature(PhpLanguageFeature.LIST_ASSIGN)) {
            return null;
        }
        ArrayCreationExpression array = PhpPsiUtil.getParentOfClass(element, ArrayCreationExpression.class);
        MultiassignmentExpression expr = PhpPsiUtil.getParentOfClass(element, MultiassignmentExpression.class);
        if (expr != null && array != null && array.isShortSyntax() || this.insideArrayInForeach(element)) {
            return Presentation.of((String)this.getFamilyName());
        }
        return null;
    }

    private boolean insideArrayInForeach(PsiElement element) {
        ForeachStatement foreach = PhpPsiUtil.getParentOfClass(element, ForeachStatement.class);
        if (foreach == null) {
            return false;
        }
        int leftOffset = this.getLeftStartOffset((PsiElement)foreach);
        int rightOffset = this.getEndOffset((PsiElement)foreach);
        return leftOffset > -1 && rightOffset > -1 && TextRange.create((int)leftOffset, (int)rightOffset).contains(element.getTextRange());
    }

    @Override
    public void invokeWithStrategy(Project project, PsiElement element, boolean isRecursive) {
        PsiElement expression = PhpConvertToTraditionalListSyntaxIntention.getExpression(element);
        if (expression != null) {
            this.singleReplace(element.getContainingFile().getViewProvider().getDocument(), PsiDocumentManager.getInstance((Project)project), expression);
        }
    }

    @Nullable
    private static PsiElement getExpression(@NotNull PsiElement element) {
        ArrayCreationExpression expression;
        if (element == null) {
            PhpConvertToTraditionalListSyntaxIntention.$$$reportNull$$$0(2);
        }
        if ((expression = PhpPsiUtil.getParentOfClass(element, false, ArrayCreationExpression.class)) == null) {
            expression = PhpPsiUtil.getParentOfClass(element, ForeachStatement.class);
        }
        return expression;
    }

    @Override
    public String openStringToInsert() {
        return "list(";
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = PhpConvertToTraditionalListSyntaxIntention.getIntentionText();
        if (string == null) {
            PhpConvertToTraditionalListSyntaxIntention.$$$reportNull$$$0(3);
        }
        return string;
    }

    @IntentionName
    public static String getIntentionText() {
        return PhpBundle.message("intention.convert.to.traditional.syntax.list", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/intentions/array/PhpConvertToTraditionalListSyntaxIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/intentions/array/PhpConvertToTraditionalListSyntaxIntention";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getExpression";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

