/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.intentions;

import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.lang.ASTNode;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpSmartLineSplitIntention
extends PsiUpdateModCommandAction<PsiElement> {
    static final char SINGLE_QUOTE = '\'';
    static final char DOUBLE_QUOTE = '\"';

    public PhpSmartLineSplitIntention() {
        super(PsiElement.class);
    }

    @NotNull
    public String getFamilyName() {
        String string = PhpSmartLineSplitIntention.getTitle();
        if (string == null) {
            PhpSmartLineSplitIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    protected void invoke(@NotNull ActionContext context, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
        ASTNode node;
        if (context == null) {
            PhpSmartLineSplitIntention.$$$reportNull$$$0(1);
        }
        if (element == null) {
            PhpSmartLineSplitIntention.$$$reportNull$$$0(2);
        }
        if (updater == null) {
            PhpSmartLineSplitIntention.$$$reportNull$$$0(3);
        }
        char newQuote = !PhpPsiUtil.isOfType(node = (element = PhpSmartLineSplitIntention.getInnerStringElement(element)).getNode(), PhpTokenTypes.STRING_LITERAL_SINGLE_QUOTE) && !PhpPsiUtil.isOfType(node, PhpTokenTypes.chRSINGLE_QUOTE) ? (char)'\"' : '\'';
        String binary = "";
        Document document = element.getContainingFile().getFileDocument();
        TextRange range = element.getTextRange();
        int position = context.offset();
        PsiElement outerString = element.getParent();
        if (outerString.getText().startsWith("b")) {
            binary = "b";
        }
        if (outerString.getText().startsWith("B")) {
            binary = "B";
        }
        String toInsert = newQuote + " . " + binary + newQuote;
        document.insertString(position, (CharSequence)toInsert);
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)context.project());
        PsiFile file = element.getContainingFile();
        psiDocumentManager.commitDocument(document);
        CodeStyleManager.getInstance((Project)context.project()).reformatText(file, range.getStartOffset(), range.getEndOffset() + toInsert.length());
    }

    @Nullable
    protected Presentation getPresentation(@NotNull ActionContext context, @NotNull PsiElement element) {
        if (context == null) {
            PhpSmartLineSplitIntention.$$$reportNull$$$0(4);
        }
        if (element == null) {
            PhpSmartLineSplitIntention.$$$reportNull$$$0(5);
        }
        if (!context.selection().isEmpty()) {
            return null;
        }
        if (!PhpWorkaroundUtil.isIntentionAvailable(element)) {
            return null;
        }
        ASTNode node = element.getNode();
        if (node == null) {
            return null;
        }
        PsiElement innerString = PhpSmartLineSplitIntention.getInnerStringElement(element);
        if (innerString.getNode().getTreeParent() == null || !PhpLanguageFeature.CONSTANT_SCALAR_EXPRESSIONS.isSupported(context.project()) && PhpSmartLineSplitIntention.isClassField(innerString.getNode())) {
            return null;
        }
        boolean available = PhpSmartLineSplitIntention.isStringLiteral(innerString.getNode()) || innerString.getNode().getStartOffset() == context.offset() && !PhpSmartLineSplitIntention.prevSiblingIsLeftBrace(innerString.getNode()) && !PhpSmartLineSplitIntention.nextSiblingIsRightBrace(innerString.getNode()) && !PhpPsiUtil.isOfType(element, PhpTokenTypes.chLSINGLE_QUOTE) && !PhpPsiUtil.isOfType(element, PhpTokenTypes.chLDOUBLE_QUOTE);
        return available ? Presentation.of((String)this.getFamilyName()) : null;
    }

    private static boolean isClassField(ASTNode node) {
        ASTNode parent = node.getTreeParent().getTreeParent();
        return parent != null && (parent.getElementType() == PhpStubElementTypes.CLASS_FIELD || parent.getElementType() == PhpStubElementTypes.CLASS_CONST);
    }

    private static PsiElement getInnerStringElement(PsiElement element) {
        PsiElement innerString = element;
        if (!PhpPsiUtil.isOfType(element, PhpTokenTypes.STRING_LITERAL_SINGLE_QUOTE)) {
            while (innerString.getNode().getTreeParent() != null && innerString.getNode().getTreeParent().getElementType() != PhpElementTypes.STRING) {
                innerString = innerString.getParent();
            }
        }
        return innerString;
    }

    private static boolean isStringLiteral(ASTNode node) {
        return node.getElementType() == PhpTokenTypes.STRING_LITERAL || node.getElementType() == PhpTokenTypes.STRING_LITERAL_SINGLE_QUOTE;
    }

    private static boolean nextSiblingIsRightBrace(ASTNode node) {
        if (node.getElementType() == PhpTokenTypes.chRBRACE) {
            return true;
        }
        ASTNode nextSibling = node.getTreeNext();
        if (nextSibling != null) {
            return nextSibling.getElementType() == PhpTokenTypes.chRBRACE;
        }
        return false;
    }

    private static boolean prevSiblingIsLeftBrace(ASTNode node) {
        ASTNode prevSibling = node.getTreePrev();
        if (prevSibling != null) {
            return prevSibling.getElementType() == PhpTokenTypes.chLBRACE;
        }
        return false;
    }

    @IntentionFamilyName
    public static String getTitle() {
        return PhpBundle.message("intention.line.split", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/intentions/PhpSmartLineSplitIntention";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/intentions/PhpSmartLineSplitIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }
}

