/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.intentions;

import com.google.common.collect.Streams;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInspection.IntentionAndQuickFixAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Query;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.refactoring.PhpRefactoringErrorException;
import com.jetbrains.php.refactoring.inline.function.PhpInlineFunctionHandler;
import com.jetbrains.php.refactoring.inline.function.PhpInlineFunctionProcessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpInlineMethodIntention
extends IntentionAndQuickFixAction {
    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, PsiFile psiFile) {
        Method method;
        if (project == null) {
            PhpInlineMethodIntention.$$$reportNull$$$0(0);
        }
        if ((method = PhpInlineMethodIntention.getTargetMethod(editor)) == null) {
            return false;
        }
        if (!method.getAccess().isPrivate()) {
            return false;
        }
        if (!PhpInlineMethodIntention.isValid(project, method)) {
            return false;
        }
        return PhpInlineMethodIntention.hasOnlyOneUsage((PsiElement)method);
    }

    @Nullable
    private static Method getTargetMethod(@Nullable Editor editor) {
        if (editor == null) {
            return null;
        }
        PsiElement targetElement = TargetElementUtil.findTargetElement((Editor)editor, (int)3);
        return (Method)ObjectUtils.tryCast((Object)targetElement, Method.class);
    }

    private static boolean isValid(@NotNull Project project, @NotNull Method method) {
        if (project == null) {
            PhpInlineMethodIntention.$$$reportNull$$$0(1);
        }
        if (method == null) {
            PhpInlineMethodIntention.$$$reportNull$$$0(2);
        }
        try {
            PhpInlineFunctionHandler.validate(project, (Function)method);
            return true;
        }
        catch (PhpRefactoringErrorException e) {
            return false;
        }
    }

    private static boolean hasOnlyOneUsage(@NotNull PsiElement element) {
        Query search;
        if (element == null) {
            PhpInlineMethodIntention.$$$reportNull$$$0(3);
        }
        return Streams.stream((search = ReferencesSearch.search((PsiElement)element, (SearchScope)element.getUseScope())).asIterable().iterator()).limit(2L).count() == 1L;
    }

    public void applyFix(@NotNull Project project, PsiFile psiFile, @Nullable Editor editor) {
        Method method;
        if (project == null) {
            PhpInlineMethodIntention.$$$reportNull$$$0(4);
        }
        if ((method = PhpInlineMethodIntention.getTargetMethod(editor)) == null) {
            return;
        }
        PhpInlineFunctionProcessor processor2 = new PhpInlineFunctionProcessor(project, (Function)method, null, false, true);
        processor2.invokeProcess(false, true);
    }

    @NotNull
    public String getName() {
        String string = this.getFamilyName();
        if (string == null) {
            PhpInlineMethodIntention.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = PhpBundle.message("intention.inline.method.family.name", new Object[0]);
        if (string == null) {
            PhpInlineMethodIntention.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/intentions/PhpInlineMethodIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/intentions/PhpInlineMethodIntention";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isValid";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "hasOnlyOneUsage";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6 -> new IllegalStateException(string);
        };
    }
}

