/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.intentions;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.annotator.PhpAdjustMemberAccessFix;
import com.jetbrains.php.lang.annotator.PhpAnnotatorVisitor;
import com.jetbrains.php.lang.documentation.phpdoc.PhpDocUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocProperty;
import com.jetbrains.php.lang.formatter.PhpCodeStyleSettings;
import com.jetbrains.php.lang.inspections.phpdoc.PhpDocCommentGenerator;
import com.jetbrains.php.lang.inspections.phpdoc.PhpRedundantDocCommentInspection;
import com.jetbrains.php.lang.intentions.PhpUndefinedInConstructorIntentionBase;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.impl.PhpClassImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.refactoring.PhpRefactoringUtil;
import java.util.Collection;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpDeclareFieldIntention
extends PhpUndefinedInConstructorIntentionBase {
    protected void invoke(@NotNull ActionContext context, @NotNull FieldReference reference, @NotNull ModPsiUpdater updater) {
        if (context == null) {
            PhpDeclareFieldIntention.$$$reportNull$$$0(0);
        }
        if (reference == null) {
            PhpDeclareFieldIntention.$$$reportNull$$$0(1);
        }
        if (updater == null) {
            PhpDeclareFieldIntention.$$$reportNull$$$0(2);
        }
        PhpClass klazz = PhpPsiUtil.getParentOfClass((PsiElement)reference, PhpClass.class);
        String name = reference.getName();
        if (klazz != null && name != null) {
            PhpDeclareFieldIntention.insertFieldFromUsage(klazz, (MemberReference)reference, name, updater);
        }
    }

    public static void insertFieldFromUsage(@NotNull PhpClass klazz, @NotNull MemberReference fieldReference, @NotNull String name, @NotNull ModPsiUpdater updater) {
        PhpClassImpl classImpl;
        Field existingField;
        if (klazz == null) {
            PhpDeclareFieldIntention.$$$reportNull$$$0(3);
        }
        if (fieldReference == null) {
            PhpDeclareFieldIntention.$$$reportNull$$$0(4);
        }
        if (name == null) {
            PhpDeclareFieldIntention.$$$reportNull$$$0(5);
        }
        if (updater == null) {
            PhpDeclareFieldIntention.$$$reportNull$$$0(6);
        }
        Project project = klazz.getProject();
        PhpType type = fieldReference.getGlobalType();
        PhpModifier.Access accessibleInContextAccess = PhpDeclareFieldIntention.getAccessibleInContextAccess(project, klazz, fieldReference);
        if (klazz instanceof PhpClassImpl && (existingField = (Field)ContainerUtil.find((classImpl = (PhpClassImpl)klazz).findOwnFieldsByName(name, fieldReference.getReferenceType().isStatic(), false), f -> !(f instanceof PhpDocProperty) && !(f instanceof PhpClassImpl.MyRenamableFakePsiElement))) != null) {
            PhpModifier.Access existingFieldAccess = existingField.getModifier().getAccess();
            if (accessibleInContextAccess.isWeakerThan(existingFieldAccess)) {
                PhpAdjustMemberAccessFix.getDelegate(accessibleInContextAccess).weakenAccess(existingField);
            }
            return;
        }
        PhpModifier modifier = PhpModifier.instance((PhpModifier.Access)accessibleInContextAccess, (PhpModifier.Abstractness)PhpModifier.Abstractness.IMPLEMENTED, (PhpModifier.State)(fieldReference.getReferenceType().isStatic() ? PhpModifier.State.STATIC : PhpModifier.State.DYNAMIC));
        PhpPsiElement field = PhpPsiElementFactory.createClassField(project, modifier, false, name, null, PhpRefactoringUtil.createFieldTypeDeclaration(project, type, (PsiElement)klazz));
        PhpDocComment comment = PhpDeclareFieldIntention.getDocComment(project, (PsiElement)field, klazz, type);
        PsiElement insertedField = PhpCodeEditUtil.insertClassMemberWithPhpDoc(klazz, (PsiElement)field, comment);
        PhpDeclareFieldIntention.createFieldTemplate(updater, (PhpPsiElement)insertedField);
    }

    public static void createFieldTemplate(@NotNull ModPsiUpdater updater, PhpPsiElement insertedField) {
        PhpPsiElement accessElement;
        if (updater == null) {
            PhpDeclareFieldIntention.$$$reportNull$$$0(7);
        }
        if ((accessElement = insertedField.getFirstPsiChild()) != null) {
            updater.templateBuilder().field((PsiElement)accessElement, accessElement.getText());
        }
    }

    @NotNull
    public static PhpModifier.Access getAccessibleInContextAccess(@NotNull Project project, @NotNull PhpClass klazz, @NotNull MemberReference fieldReference) {
        if (project == null) {
            PhpDeclareFieldIntention.$$$reportNull$$$0(8);
        }
        if (klazz == null) {
            PhpDeclareFieldIntention.$$$reportNull$$$0(9);
        }
        if (fieldReference == null) {
            PhpDeclareFieldIntention.$$$reportNull$$$0(10);
        }
        Collection<PhpClass> current = PhpAnnotatorVisitor.resolveCurrentScope((PhpReference)fieldReference, null);
        PhpModifier.Access accessibleInContextAccess = PhpAnnotatorVisitor.getStrictestAccessibleInContextReferenceAccess((PhpReference)fieldReference, klazz, current);
        PhpCodeStyleSettings settings = (PhpCodeStyleSettings)CodeStyle.getSettings((Project)project).getCustomSettings(PhpCodeStyleSettings.class);
        PhpModifier.Access defaultVisibility = settings.FIELDS_DEFAULT_VISIBILITY;
        if (defaultVisibility.isWeakerThan(accessibleInContextAccess)) {
            PhpModifier.Access access = defaultVisibility;
            if (access == null) {
                PhpDeclareFieldIntention.$$$reportNull$$$0(11);
            }
            return access;
        }
        PhpModifier.Access access = accessibleInContextAccess;
        if (access == null) {
            PhpDeclareFieldIntention.$$$reportNull$$$0(12);
        }
        return access;
    }

    @Nullable
    public static PhpDocComment getDocComment(@NotNull Project project, @Nullable PsiElement classFields, @NotNull PhpClass klazz, @NotNull PhpType docType) {
        if (project == null) {
            PhpDeclareFieldIntention.$$$reportNull$$$0(13);
        }
        if (klazz == null) {
            PhpDeclareFieldIntention.$$$reportNull$$$0(14);
        }
        if (docType == null) {
            PhpDeclareFieldIntention.$$$reportNull$$$0(15);
        }
        if (!PhpDocCommentGenerator.isTemplateNullOrEmpty(classFields)) {
            String typeHint = PhpDocUtil.getTypePresentation(project, docType, PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)klazz));
            HashMap<String, String> additionalAttributes = new HashMap<String, String>();
            additionalAttributes.put("TYPE_HINT", typeHint);
            additionalAttributes.put("CLASS_NAME", klazz.getName());
            PhpDocComment docComment = PhpDocCommentGenerator.constructDocComment(project, classFields, additionalAttributes);
            Field field = (Field)PhpPsiUtil.getChildByCondition(classFields, (Condition<? super PsiElement>)Field.INSTANCEOF);
            if (field != null && docComment != null && !PhpRedundantDocCommentInspection.isRedundantPropertyDocComment(project, field, docComment)) {
                return docComment;
            }
        }
        return null;
    }

    @NotNull
    public String getFamilyName() {
        String string = PhpDeclareFieldIntention.getFamilyNameText();
        if (string == null) {
            PhpDeclareFieldIntention.$$$reportNull$$$0(16);
        }
        return string;
    }

    @IntentionFamilyName
    public static String getFamilyNameText() {
        return PhpBundle.message("intention.declare.missing.field", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11, 12, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 3: 
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "klazz";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldReference";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/intentions/PhpDeclareFieldIntention";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/intentions/PhpDeclareFieldIntention";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessibleInContextAccess";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "insertFieldFromUsage";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createFieldTemplate";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getAccessibleInContextAccess";
                break;
            }
            case 11: 
            case 12: 
            case 16: {
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getDocComment";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11, 12, 16 -> new IllegalStateException(string);
        };
    }
}

