/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.type;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.elements.PhpStaticStatement;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.MemberReferenceImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpExpressionAlwaysNullInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpExpressionAlwaysNullInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(this){

            public void visitPhpReturn(PhpReturn returnStatement) {
                if (PhpExpressionAlwaysNullInspection.insideReturnByReferenceFunction(returnStatement)) {
                    return;
                }
                this.check((PhpTypedElement)ObjectUtils.tryCast((Object)returnStatement.getArgument(), PhpTypedElement.class));
            }

            private void check(PhpTypedElement argument) {
                if (argument == null || argument instanceof FunctionReference || argument instanceof MemberReference || argument instanceof AssignmentExpression || argument instanceof ArrayCreationExpression || argument instanceof NewExpression || argument instanceof ConstantReference) {
                    return;
                }
                if (PhpExpressionAlwaysNullInspection.alwaysNull(argument) && !PhpExpressionAlwaysNullInspection.isAmbiguousVariable(argument)) {
                    PsiElement fixElement = PhpExpressionAlwaysNullInspection.findAnchor((PsiElement)argument);
                    if (fixElement != null) {
                        holder.problem(fixElement, PhpBundle.message("inspection.php.expression.always.null.description", new Object[0])).fix((ModCommandAction)new PhpReplaceWithNullQuickFix(fixElement, PhpBundle.message("php.replace.with.null.quick.fix.family.name", new Object[0]))).register();
                    } else {
                        holder.registerProblem((PsiElement)argument, PhpBundle.message("inspection.php.expression.always.null.description", new Object[0]), new LocalQuickFix[0]);
                    }
                }
            }

            public void visitPhpMethodReference(MethodReference reference) {
                this.check((PhpTypedElement)reference.getClassReference());
            }

            public void visitPhpFieldReference(FieldReference fieldReference) {
                this.check((PhpTypedElement)fieldReference.getClassReference());
            }
        };
    }

    private static PsiElement findAnchor(PsiElement argument) {
        boolean isClassReference;
        PsiElement parent = argument.getParent();
        boolean bl = isClassReference = parent instanceof MemberReferenceImpl && ((MemberReferenceImpl)parent).getClassReference() == argument;
        if (isClassReference && ((MemberReferenceImpl)parent).isNullSafeDereference()) {
            return parent;
        }
        if (!isClassReference) {
            return argument;
        }
        return null;
    }

    @Nullable
    public static LocalQuickFix getFix(PsiElement argument, @NotNull @Nls String message) {
        PsiElement anchor;
        if (message == null) {
            PhpExpressionAlwaysNullInspection.$$$reportNull$$$0(1);
        }
        return (anchor = PhpExpressionAlwaysNullInspection.findAnchor(argument)) == null ? null : LocalQuickFix.from((ModCommandAction)new PhpReplaceWithNullQuickFix(anchor, message));
    }

    private static boolean isAmbiguousVariable(PhpTypedElement argument) {
        return argument instanceof Variable && (PhpExpressionAlwaysNullInspection.isReferenced((Variable)argument) || PhpExpressionAlwaysNullInspection.resolvedToAmbiguousDeclaration((Variable)argument, new HashSet<Variable>()));
    }

    public static boolean insideReturnByReferenceFunction(PhpReturn returnStatement) {
        Function function = PhpPsiUtil.getParentOfClass((PsiElement)returnStatement, Function.class);
        return function != null && function.isReturningByReference();
    }

    private static boolean alwaysNull(PhpTypedElement argument) {
        return PhpType.globalTypeEquals((PhpTypedElement)argument, (PhpType)PhpType.NULL);
    }

    private static boolean resolvedToAmbiguousDeclaration(@NotNull Variable argument, Collection<Variable> visited) {
        if (argument == null) {
            PhpExpressionAlwaysNullInspection.$$$reportNull$$$0(2);
        }
        if (!visited.add(argument)) {
            return true;
        }
        for (PhpNamedElement namedElement : argument.resolveLocal()) {
            if (namedElement instanceof Variable && namedElement.getParent() instanceof PhpUseList && PhpExpressionAlwaysNullInspection.resolvedToAmbiguousDeclaration((Variable)namedElement, visited)) {
                return true;
            }
            if (namedElement instanceof Parameter && PhpLangUtil.isNull(((Parameter)namedElement).getDefaultValue())) {
                return true;
            }
            AssignmentExpression assignment = PhpPsiUtil.getParentOfClass((PsiElement)namedElement, AssignmentExpression.class);
            if (assignment == null) continue;
            if (PhpPsiUtil.getParentOfClass((PsiElement)assignment, PhpStaticStatement.class) != null) {
                return true;
            }
            if (!(assignment.getValue() instanceof FieldReference)) continue;
            return true;
        }
        return false;
    }

    public static boolean isReferenced(@NotNull Variable argument) {
        PhpAccessVariableInstruction instruction;
        if (argument == null) {
            PhpExpressionAlwaysNullInspection.$$$reportNull$$$0(3);
        }
        if ((instruction = PhpControlFlowUtil.getAccessInstruction((PhpPsiElement)argument, PhpAccessVariableInstruction.class)) == null) {
            return true;
        }
        PhpScopeHolder scopeHolder = PhpPsiUtil.getScopeHolder((PsiElement)argument);
        return scopeHolder == null || instruction.getAccess().isReadRef() || PhpControlFlowUtil.isReferenced(scopeHolder, instruction);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/type/PhpExpressionAlwaysNullInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "resolvedToAmbiguousDeclaration";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isReferenced";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class PhpReplaceWithNullQuickFix
    extends PsiUpdateModCommandAction<PsiElement> {
        @NotNull
        @Nls
        private final String myMessage;

        protected PhpReplaceWithNullQuickFix(@NotNull PsiElement element, @NotNull @Nls String message) {
            if (element == null) {
                PhpReplaceWithNullQuickFix.$$$reportNull$$$0(0);
            }
            if (message == null) {
                PhpReplaceWithNullQuickFix.$$$reportNull$$$0(1);
            }
            super(element);
            this.myMessage = message;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = this.myMessage;
            if (string == null) {
                PhpReplaceWithNullQuickFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        protected void invoke(@NotNull ActionContext context, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (context == null) {
                PhpReplaceWithNullQuickFix.$$$reportNull$$$0(3);
            }
            if (element == null) {
                PhpReplaceWithNullQuickFix.$$$reportNull$$$0(4);
            }
            if (updater == null) {
                PhpReplaceWithNullQuickFix.$$$reportNull$$$0(5);
            }
            element.replace((PsiElement)PhpPsiElementFactory.createConstantReference(context.project(), "null"));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/type/PhpExpressionAlwaysNullInspection$PhpReplaceWithNullQuickFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/type/PhpExpressionAlwaysNullInspection$PhpReplaceWithNullQuickFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

