/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.type;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpArrayAccessOnIllegalTypeInspection
extends PhpInspection {
    private static final PhpType NOT_ALLOWED_TYPES = PhpType.SCALAR.filter(PhpType.STRING);

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpArrayAccessOnIllegalTypeInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(this){

            public void visitPhpArrayAccessExpression(ArrayAccessExpression expression) {
                PhpTypedElement reference = (PhpTypedElement)ObjectUtils.tryCast((Object)expression.getValue(), PhpTypedElement.class);
                if (reference == null || reference instanceof ArrayAccessExpression) {
                    return;
                }
                PhpType type = reference.getType();
                if (ContainerUtil.exists((Iterable)type.filterUnknown().getTypes(), PhpArrayAccessOnIllegalTypeInspection::isAllowedType)) {
                    return;
                }
                PhpType referenceType = type.global(expression.getProject()).filterUnknown();
                if (!referenceType.isEmpty() && ContainerUtil.all((Collection)referenceType.getTypes(), (Condition)Conditions.not(PhpArrayAccessOnIllegalTypeInspection::isAllowedType))) {
                    holder.registerProblem((PsiElement)expression.getValue(), PhpBundle.message("inspection.message.illegal.array.offset.access", referenceType.toStringResolved()), new LocalQuickFix[0]);
                }
            }
        };
    }

    private static boolean isAllowedType(String t) {
        return !NOT_ALLOWED_TYPES.getTypes().contains(t) && !PhpType.TRUE.getTypes().contains(t);
    }

    @Override
    @Nullable
    protected ProblemHighlightType getPhp8CustomSeverity() {
        return ProblemHighlightType.WARNING;
    }

    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP740;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/type/PhpArrayAccessOnIllegalTypeInspection", "buildVisitor"));
    }
}

