/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.suppression;

import com.intellij.codeInspection.InspectionSuppressor;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.RedundantSuppressionDetector;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.documentation.phpdoc.PhpDocUtil;
import com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocTokenTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.inspections.suppression.PhpSuppressionUtil;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpInspectionSuppressor
implements InspectionSuppressor,
RedundantSuppressionDetector {
    public boolean isSuppressedFor(@NotNull PsiElement element, @NotNull String toolId) {
        if (element == null) {
            PhpInspectionSuppressor.$$$reportNull$$$0(0);
        }
        if (toolId == null) {
            PhpInspectionSuppressor.$$$reportNull$$$0(1);
        }
        return PhpSuppressionUtil.isSuppressedFor(element, toolId);
    }

    public SuppressQuickFix @NotNull [] getSuppressActions(@Nullable PsiElement element, @NotNull String toolId) {
        if (toolId == null) {
            PhpInspectionSuppressor.$$$reportNull$$$0(2);
        }
        SuppressQuickFix[] suppressQuickFixArray = PhpSuppressionUtil.getSuppressActions(element, toolId);
        if (suppressQuickFixArray == null) {
            PhpInspectionSuppressor.$$$reportNull$$$0(3);
        }
        return suppressQuickFixArray;
    }

    @Nullable
    public String getSuppressionIds(@NotNull PsiElement element) {
        if (element == null) {
            PhpInspectionSuppressor.$$$reportNull$$$0(4);
        }
        return PhpSuppressionUtil.getSuppressionsIds((PhpDocComment)ObjectUtils.tryCast((Object)element, PhpDocComment.class)).collect(Collectors.joining(","));
    }

    @NotNull
    public LocalQuickFix createRemoveRedundantSuppressionFix(@NotNull String toolId) {
        if (toolId == null) {
            PhpInspectionSuppressor.$$$reportNull$$$0(5);
        }
        return new RemoveRedundantSuppressionQuickFix(toolId);
    }

    public boolean isSuppressionFor(@NotNull PsiElement elementWithSuppression, @NotNull PsiElement place, @NotNull String toolId) {
        PhpDocComment docComment;
        if (elementWithSuppression == null) {
            PhpInspectionSuppressor.$$$reportNull$$$0(6);
        }
        if (place == null) {
            PhpInspectionSuppressor.$$$reportNull$$$0(7);
        }
        if (toolId == null) {
            PhpInspectionSuppressor.$$$reportNull$$$0(8);
        }
        return (docComment = (PhpDocComment)ObjectUtils.tryCast((Object)elementWithSuppression, PhpDocComment.class)) != null && PhpSuppressionUtil.isSuppressedInComment(toolId, docComment) || PhpSuppressionUtil.getAllSuppressionDocComments(place).contains(elementWithSuppression);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/suppression/PhpInspectionSuppressor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementWithSuppression";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/suppression/PhpInspectionSuppressor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuppressActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isSuppressedFor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSuppressActions";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSuppressionIds";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createRemoveRedundantSuppressionFix";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isSuppressionFor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    private static final class RemoveRedundantSuppressionQuickFix
    extends PsiUpdateModCommandQuickFix {
        private final String myToolId;

        private RemoveRedundantSuppressionQuickFix(String toolId) {
            this.myToolId = toolId;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("remove.redundant.suppression.quick.fix.family.name", this.myToolId);
            if (string == null) {
                RemoveRedundantSuppressionQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PhpDocComment docComment;
            if (project == null) {
                RemoveRedundantSuppressionQuickFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                RemoveRedundantSuppressionQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                RemoveRedundantSuppressionQuickFix.$$$reportNull$$$0(3);
            }
            if ((docComment = PhpPsiUtil.getParentOfClass(element, false, PhpDocComment.class)) == null) {
                return;
            }
            if (PhpDocUtil.hasOnlyNoInspectionTag(docComment)) {
                docComment.delete();
            } else {
                PhpDocTag docTag = (PhpDocTag)ContainerUtil.find((Object[])docComment.getTagElementsByName("@noinspection"), tag -> SuppressionUtil.isInspectionToolIdMentioned((String)PhpSuppressionUtil.getInspectionIdsList(tag), (String)this.myToolId));
                assert (docTag != null);
                PsiElement adjacentLeadingAsterisk = PhpPsiUtil.getPrevSiblingIgnoreWhitespace((PsiElement)docTag, true);
                if (PhpPsiUtil.isOfType(adjacentLeadingAsterisk, PhpDocTokenTypes.DOC_LEADING_ASTERISK)) {
                    PsiElement whitespaceBeforeAsterisk = adjacentLeadingAsterisk.getPrevSibling();
                    docComment.deleteChildRange(whitespaceBeforeAsterisk, (PsiElement)docTag);
                } else {
                    docTag.delete();
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/suppression/PhpInspectionSuppressor$RemoveRedundantSuppressionQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/suppression/PhpInspectionSuppressor$RemoveRedundantSuppressionQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

