/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.regexp;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.jetbrains.php.PhpBundle;
import java.util.HashSet;
import java.util.function.BiFunction;
import org.intellij.lang.regexp.psi.RegExpChar;
import org.intellij.lang.regexp.psi.RegExpCharRange;
import org.intellij.lang.regexp.psi.RegExpClass;
import org.intellij.lang.regexp.psi.RegExpClassElement;
import org.intellij.lang.regexp.psi.RegExpElement;
import org.intellij.lang.regexp.psi.RegExpElementVisitor;
import org.intellij.lang.regexp.psi.RegExpSimpleClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpCoveredCharacterInClassInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpCoveredCharacterInClassInspection.$$$reportNull$$$0(0);
        }
        return new RegExpElementVisitor(this){

            public void visitRegExpClass(RegExpClass regExpClass) {
                PsiFile file = regExpClass.getContainingFile();
                if (file == null || InjectedLanguageManager.getInstance((Project)file.getProject()).isFrankensteinInjection((PsiElement)file)) {
                    return;
                }
                PhpCoveredCharacterInClassInspection.checkEnumeratedElements(regExpClass, (f, s) -> {
                    if (1.isCoveredBy(f, s)) {
                        holder.registerProblem((PsiElement)s, PhpBundle.message("inspection.message.element.already.covered.by", s.getText(), f.getText()), new LocalQuickFix[]{new PhpDeleteCoveredElementFix((RegExpElement)s)});
                        return true;
                    }
                    return false;
                });
            }

            private static boolean isCoveredBy(RegExpClassElement f, RegExpClassElement s) {
                CharRange fRange = PhpCoveredCharacterInClassInspection.getRange(f);
                CharRange sRange = PhpCoveredCharacterInClassInspection.getRange(s);
                return fRange != null && sRange != null && fRange.contains(sRange) && !fRange.equals(sRange);
            }
        };
    }

    @Nullable
    public static CharRange getRange(RegExpClassElement f) {
        if (f instanceof RegExpChar) {
            int value = ((RegExpChar)f).getValue();
            if (value >= 0) {
                return new CharRange(value, value);
            }
        } else if (f instanceof RegExpCharRange) {
            int toValue;
            RegExpChar from = ((RegExpCharRange)f).getFrom();
            RegExpChar to = ((RegExpCharRange)f).getTo();
            int fromValue = from.getValue();
            int n = toValue = to != null ? to.getValue() : -1;
            if (fromValue >= 0 && toValue >= 0) {
                return new CharRange(fromValue, toValue);
            }
        } else if (f instanceof RegExpSimpleClass) {
            RegExpSimpleClass.Kind kind = ((RegExpSimpleClass)f).getKind();
            if (kind == RegExpSimpleClass.Kind.DIGIT) {
                return CharRange.DIGIT;
            }
            if (kind == RegExpSimpleClass.Kind.SPACE) {
                return CharRange.SPACE;
            }
            if (kind == RegExpSimpleClass.Kind.ANY) {
                return AnyCharRange.INSTANCE;
            }
        }
        return null;
    }

    public static void checkEnumeratedElements(RegExpClass regExpClass, BiFunction<? super RegExpClassElement, ? super RegExpClassElement, Boolean> function) {
        HashSet<RegExpClassElement> visited = new HashSet<RegExpClassElement>();
        RegExpClassElement[] elements = regExpClass.getElements();
        if (elements.length > 1000) {
            return;
        }
        for (RegExpClassElement f : elements) {
            if (visited.contains(f)) continue;
            for (RegExpClassElement s : elements) {
                if (visited.contains(s) || !function.apply((RegExpClassElement)f, (RegExpClassElement)s).booleanValue()) continue;
                visited.add(s);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/regexp/PhpCoveredCharacterInClassInspection", "buildVisitor"));
    }

    public static class CharRange {
        private static final CharRange SPACE = new CharRange(32, 32){

            @Override
            public boolean equals(Object o) {
                return o == this;
            }
        };
        private static final CharRange DIGIT = new CharRange(48, 57);
        private final int myFrom;
        private final int myTo;

        private CharRange(int from, int to) {
            this.myFrom = from;
            this.myTo = to;
        }

        public boolean contains(CharRange another) {
            if (another instanceof AnyCharRange) {
                return false;
            }
            return this.myFrom <= another.myFrom && this.myTo >= another.myTo;
        }

        public int getFrom() {
            return this.myFrom;
        }

        public int getTo() {
            return this.myTo;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CharRange range = (CharRange)o;
            return this.myFrom == range.myFrom && this.myTo == range.myTo;
        }
    }

    private static class AnyCharRange
    extends CharRange {
        private static final CharRange INSTANCE = new AnyCharRange();

        private AnyCharRange() {
            super(0, 0);
        }

        @Override
        public boolean contains(CharRange another) {
            return true;
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof AnyCharRange;
        }
    }

    private static final class PhpDeleteCoveredElementFix
    extends PsiUpdateModCommandQuickFix {
        private final String myText;

        private PhpDeleteCoveredElementFix(RegExpElement predefinedCharacterClass) {
            this.myText = predefinedCharacterClass.getText();
        }

        @NotNull
        public String getName() {
            String string = PhpBundle.message("quick.fix.delete", this.myText);
            if (string == null) {
                PhpDeleteCoveredElementFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.delete.covered.element", new Object[0]);
            if (string == null) {
                PhpDeleteCoveredElementFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                PhpDeleteCoveredElementFix.$$$reportNull$$$0(2);
            }
            if (element == null) {
                PhpDeleteCoveredElementFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                PhpDeleteCoveredElementFix.$$$reportNull$$$0(4);
            }
            element.delete();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/regexp/PhpCoveredCharacterInClassInspection$PhpDeleteCoveredElementFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/regexp/PhpCoveredCharacterInClassInspection$PhpDeleteCoveredElementFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }
}

