/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.reference.elements;

import com.google.common.base.Predicates;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.codeInspection.reference.WritableRefEntity;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SmartHashSet;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefClass;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefClassMember;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefElement;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefElementImpl;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefUtil;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpRefClassMemberImpl
extends PhpRefElementImpl
implements PhpRefElement,
PhpRefClassMember {
    private static final int ACCESS_PRIVATE = 0x400000;
    private static final int ACCESS_PROTECTED = 0x800000;
    private static final int ACCESS_PUBLIC = 0x1000000;
    private static final int IS_ABSTRACT_MASK = 0x4000000;
    private static final int IS_DYNAMIC_MASK = 0x8000000;
    private static final int IS_STATIC_MASK = 0x10000000;
    private static final int IS_FINAL_MASK = 0x20000000;
    private static final int WAS_USED_BY_STATIC_REFERENCE_MASK = 0x40000000;
    @Nullable
    private Set<PhpRefClassMember> myDuplicateMembers;
    private boolean wasUsedNotInSelfOrParent = false;
    private boolean wasUsedInSelfOrParentOnly = false;

    PhpRefClassMemberImpl(PhpClassMember member, RefManager manager) {
        super(member.getName(), (PhpPsiElement)member, manager);
        this.setModifiers(member);
    }

    @Override
    protected synchronized void initialize() {
        PhpClassMember element = this.getPhpElement();
        assert (element != null);
        RefElement owner = PhpRefUtil.getReferenceEx((PsiElement)element.getContainingClass(), this.getRefManager());
        this.setOwner((WritableRefEntity)owner);
    }

    @NotNull
    public Collection<? extends PhpRefClassMember> getAllSuperMembers() {
        ArrayDeque toVisit = new ArrayDeque(this.getSuperMembers());
        HashSet<PhpRefClassMember> visitedMethods = new HashSet<PhpRefClassMember>();
        while (!toVisit.isEmpty()) {
            PhpRefClassMember currentMethod = (PhpRefClassMember)toVisit.poll();
            if (!visitedMethods.add(currentMethod)) continue;
            toVisit.addAll(currentMethod.getSuperMembers());
        }
        HashSet<PhpRefClassMember> hashSet = visitedMethods;
        if (hashSet == null) {
            PhpRefClassMemberImpl.$$$reportNull$$$0(0);
        }
        return hashSet;
    }

    @NotNull
    private PhpModifier.Access getAccess() {
        if (this.isPublic()) {
            PhpModifier.Access access = PhpModifier.Access.PUBLIC;
            if (access == null) {
                PhpRefClassMemberImpl.$$$reportNull$$$0(1);
            }
            return access;
        }
        if (this.isProtected()) {
            PhpModifier.Access access = PhpModifier.Access.PROTECTED;
            if (access == null) {
                PhpRefClassMemberImpl.$$$reportNull$$$0(2);
            }
            return access;
        }
        if (this.isPrivate()) {
            PhpModifier.Access access = PhpModifier.Access.PRIVATE;
            if (access == null) {
                PhpRefClassMemberImpl.$$$reportNull$$$0(3);
            }
            return access;
        }
        PhpModifier.Access access = PhpModifier.Access.PUBLIC;
        if (access == null) {
            PhpRefClassMemberImpl.$$$reportNull$$$0(4);
        }
        return access;
    }

    private PhpModifier.State getState() {
        if (this.isStatic()) {
            return PhpModifier.State.STATIC;
        }
        return PhpModifier.State.DYNAMIC;
    }

    private PhpModifier.Abstractness getAbstractness() {
        if (this.isAbstract()) {
            return PhpModifier.Abstractness.ABSTRACT;
        }
        if (this.isFinal()) {
            return PhpModifier.Abstractness.FINAL;
        }
        return PhpModifier.Abstractness.IMPLEMENTED;
    }

    @NotNull
    public String getAccessModifierString() {
        String string = this.getAccessModifier().toString();
        if (string == null) {
            PhpRefClassMemberImpl.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public PhpModifier getAccessModifier() {
        PhpModifier phpModifier = PhpModifier.instance((PhpModifier.Access)this.getAccess(), (PhpModifier.Abstractness)this.getAbstractness(), (PhpModifier.State)this.getState());
        if (phpModifier == null) {
            PhpRefClassMemberImpl.$$$reportNull$$$0(6);
        }
        return phpModifier;
    }

    @NotNull
    public String getQualifiedName() {
        PhpClassMember phpMember = this.getPhpElement();
        return phpMember != null ? phpMember.getFQN() : "";
    }

    private void setModifiers(@NotNull PhpClassMember classMember) {
        if (classMember == null) {
            PhpRefClassMemberImpl.$$$reportNull$$$0(7);
        }
        PhpModifier modifier = classMember.getModifier();
        this.setIsStatic(modifier.isStatic());
        this.setIsPrivate(modifier.isPrivate());
        this.setIsProtected(modifier.isProtected());
        this.setIsPublic(modifier.isPublic());
        this.setIsAbstract(modifier.isAbstract());
        this.setIsDynamic(modifier.isDynamic());
    }

    @Nullable
    public PhpRefClass getOwnerClass() {
        return (PhpRefClass)ObjectUtils.tryCast((Object)this.getOwner(), PhpRefClass.class);
    }

    public boolean isFinal() {
        return this.checkFlag(0x20000000L);
    }

    public boolean wasUsedByStaticReference() {
        return this.checkFlag(0x40000000L);
    }

    public synchronized boolean wasUsedBySelfOrParentOnly() {
        return this.wasUsedInSelfOrParentOnly;
    }

    public boolean isStatic() {
        return this.checkFlag(0x10000000L);
    }

    public boolean isDynamic() {
        return this.checkFlag(0x8000000L);
    }

    public boolean isAbstract() {
        return this.checkFlag(0x4000000L);
    }

    public boolean isPublic() {
        return this.checkFlag(0x1000000L);
    }

    public boolean isProtected() {
        return this.checkFlag(0x800000L);
    }

    public boolean isPrivate() {
        return this.checkFlag(0x400000L);
    }

    void setIsStatic(boolean isStatic) {
        this.setFlag(isStatic, 0x10000000L);
    }

    void setIsFinal(boolean isFinal) {
        this.setFlag(isFinal, 0x20000000L);
    }

    private void setIsDynamic(boolean isDynamic) {
        this.setFlag(isDynamic, 0x8000000L);
    }

    private void setIsAbstract(boolean isAbstract) {
        this.setFlag(isAbstract, 0x4000000L);
    }

    private void setIsPublic(boolean isPublic) {
        this.setFlag(isPublic, 0x1000000L);
    }

    private void setIsProtected(boolean isProtected) {
        this.setFlag(isProtected, 0x800000L);
    }

    private void setIsPrivate(boolean isPrivate) {
        this.setFlag(isPrivate, 0x400000L);
    }

    public void setWasUsedByStaticReference(boolean wasUsedByStaticReference) {
        this.setFlag(wasUsedByStaticReference, 0x40000000L);
        this.setWasUsedBySelfOrParent(false);
    }

    public synchronized void setWasUsedBySelfOrParent(boolean wasOnlyByInheritors) {
        if (!wasOnlyByInheritors) {
            this.wasUsedNotInSelfOrParent = true;
        }
        this.wasUsedInSelfOrParentOnly = !this.wasUsedNotInSelfOrParent;
    }

    @NotNull
    protected <T extends PhpRefClassMember> Set<T> addRefMemberTo(@NotNull T refMember, @Nullable Set<T> refMembers) {
        if (refMember == null) {
            PhpRefClassMemberImpl.$$$reportNull$$$0(8);
        }
        Set members = (Set)ObjectUtils.notNull(refMembers, SmartHashSet::new);
        members.add(refMember);
        Set set = members;
        if (set == null) {
            PhpRefClassMemberImpl.$$$reportNull$$$0(9);
        }
        return set;
    }

    protected <T extends PhpRefClassMember> void removeRefMemberFrom(@NotNull T refMember, @Nullable Collection<T> refMembers) {
        if (refMember == null) {
            PhpRefClassMemberImpl.$$$reportNull$$$0(10);
        }
        if (refMembers != null) {
            refMembers.remove(refMember);
        }
    }

    @Override
    public void buildReferences() {
    }

    @NotNull
    public String getExternalName() {
        PhpRefClass myRefClass = this.getOwnerClass();
        if (myRefClass != null) {
            String string = myRefClass.getExternalName() + " " + this.getName();
            if (string == null) {
                PhpRefClassMemberImpl.$$$reportNull$$$0(11);
            }
            return string;
        }
        return "";
    }

    @Nullable
    public PhpClassMember getPhpElement() {
        return this.getPhpElement(PhpClassMember.class);
    }

    @Nullable
    public static PhpClass classFromClassMemberExternalName(@NotNull RefManagerImpl manager, @NotNull List<String> qualifiedPath) {
        if (manager == null) {
            PhpRefClassMemberImpl.$$$reportNull$$$0(12);
        }
        if (qualifiedPath == null) {
            PhpRefClassMemberImpl.$$$reportNull$$$0(13);
        }
        if (qualifiedPath.size() == 2) {
            return (PhpClass)ContainerUtil.getFirstItem((Collection)PhpIndex.getInstance((Project)manager.getProject()).getClassesByFQN(qualifiedPath.get(0)));
        }
        return null;
    }

    protected <T extends PhpRefClassMemberImpl> void appendDirectSuperMembers(@NotNull Class<T> memberClass, @NotNull Consumer<? super T> appender) {
        PhpClass phpClass;
        if (memberClass == null) {
            PhpRefClassMemberImpl.$$$reportNull$$$0(14);
        }
        if (appender == null) {
            PhpRefClassMemberImpl.$$$reportNull$$$0(15);
        }
        PhpClassMember member = this.getPhpElement();
        PhpRefClass ownerClass = this.getOwnerClass();
        PhpClass phpClass2 = phpClass = ownerClass != null ? ownerClass.getPhpElement() : null;
        if (member != null && phpClass != null) {
            PhpClassHierarchyUtils.processSuperMembers((PhpClassMember)member, (baseMember, subClass, baseClass) -> {
                PhpRefClassMemberImpl superRefMember;
                if (subClass == phpClass && (superRefMember = (PhpRefClassMemberImpl)((Object)((Object)ObjectUtils.tryCast((Object)PhpRefUtil.getReferenceEx((PsiElement)baseMember, this.getRefManager()), (Class)memberClass)))) != null) {
                    appender.consume((Object)superRefMember);
                    return true;
                }
                return false;
            });
        }
    }

    public static void inferUsagesByInheritance(@NotNull PhpRefClassMember member) {
        PhpRefClassMemberImpl superMember;
        PhpRefClassMemberImpl classMember;
        if (member == null) {
            PhpRefClassMemberImpl.$$$reportNull$$$0(16);
        }
        if ((classMember = (PhpRefClassMemberImpl)((Object)ObjectUtils.tryCast((Object)member, PhpRefClassMemberImpl.class))) != null && classMember.wasUsedInSelfOrParentOnly && (superMember = classMember.fetchSuperWithDefaultUsages()) != null) {
            superMember.subsCanBeImplicitlyUsed();
        }
    }

    @Nullable
    private PhpRefClassMemberImpl fetchSuperWithDefaultUsages() {
        return this.fetchSuperWithDefaultUsagesInternal(new HashSet<PhpRefClassMember>());
    }

    @Nullable
    private PhpRefClassMemberImpl fetchSuperWithDefaultUsagesInternal(@NotNull Set<PhpRefClassMember> usedMembers) {
        if (usedMembers == null) {
            PhpRefClassMemberImpl.$$$reportNull$$$0(17);
        }
        if (usedMembers.add(this)) {
            for (PhpRefClassMember superMember : this.getSuperMembers()) {
                PhpRefClassMemberImpl superMemberImpl = (PhpRefClassMemberImpl)superMember;
                if (superMemberImpl.wasUsedNotInSelfOrParent) {
                    return superMemberImpl;
                }
                PhpRefClassMemberImpl classMember = superMemberImpl.fetchSuperWithDefaultUsagesInternal(usedMembers);
                if (classMember == null) continue;
                return classMember;
            }
        }
        return null;
    }

    private void subsCanBeImplicitlyUsed() {
        this.subsCanBeImplicitlyUsedInternal(new HashSet<PhpRefClassMember>());
    }

    private void subsCanBeImplicitlyUsedInternal(@NotNull Set<PhpRefClassMember> usedMembers) {
        if (usedMembers == null) {
            PhpRefClassMemberImpl.$$$reportNull$$$0(18);
        }
        if (usedMembers.add(this)) {
            for (PhpRefClassMember member : this.getDerivedMembers()) {
                PhpRefClassMemberImpl memberImpl = (PhpRefClassMemberImpl)((Object)ObjectUtils.tryCast((Object)member, PhpRefClassMemberImpl.class));
                if (memberImpl == null) continue;
                memberImpl.setWasUsedBySelfOrParent(false);
                memberImpl.subsCanBeImplicitlyUsedInternal(usedMembers);
            }
        }
    }

    public synchronized void addDuplicate(@NotNull PhpRefClassMember refDuplicateMember) {
        if (refDuplicateMember == null) {
            PhpRefClassMemberImpl.$$$reportNull$$$0(19);
        }
        this.myDuplicateMembers = this.addRefMemberTo(refDuplicateMember, this.myDuplicateMembers);
    }

    public void addDuplicates(@NotNull Collection<? extends PhpRefClassMember> members) {
        if (members == null) {
            PhpRefClassMemberImpl.$$$reportNull$$$0(20);
        }
        for (PhpRefClassMember phpRefClassMember : members) {
            if (phpRefClassMember == this) continue;
            this.addDuplicate(phpRefClassMember);
        }
    }

    @NotNull
    public synchronized Collection<PhpRefClassMember> getDuplicates() {
        Collection collection = (Collection)ObjectUtils.notNull(this.myDuplicateMembers, Collections.emptySet());
        if (collection == null) {
            PhpRefClassMemberImpl.$$$reportNull$$$0(21);
        }
        return collection;
    }

    public boolean hasDuplicatesByClass() {
        PhpRefClass ownerClass = this.getOwnerClass();
        return ownerClass != null && !ownerClass.getDuplicates().isEmpty();
    }

    public boolean hasSuspiciousCallers() {
        return this.hasSuspiciousCallersByMember() || this.hasSuspiciousDuplicate() || this.hasDuplicatesByClass() && this.getDuplicates().isEmpty() && this.hasSuspiciousCallersBySuperMembers();
    }

    private boolean hasSuspiciousCallersByMember() {
        return super.hasSuspiciousCallers();
    }

    private boolean hasSuspiciousCallersBySuperMembers() {
        return ((StreamEx)StreamEx.of(this.getAllSuperMembers()).select(PhpRefClassMemberImpl.class).filter((Predicate)Predicates.not(RefElement::isEntry))).anyMatch(PhpRefClassMemberImpl::hasSuspiciousCallersByMember);
    }

    private boolean hasSuspiciousDuplicate() {
        for (PhpRefClassMember duplicate : this.getDuplicates()) {
            if (!(duplicate instanceof PhpRefClassMemberImpl) || duplicate == this || duplicate.isEntry() || !((PhpRefClassMemberImpl)duplicate).hasSuspiciousCallersByMember()) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 7, 8, 10, 12, 13, 14, 15, 16, 17, 18, 19, 20 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/reference/elements/PhpRefClassMemberImpl";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classMember";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refMember";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedPath";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberClass";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appender";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usedMembers";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refDuplicateMember";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "members";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllSuperMembers";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccess";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessModifierString";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessModifier";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/reference/elements/PhpRefClassMemberImpl";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "addRefMemberTo";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalName";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getDuplicates";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setModifiers";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addRefMemberTo";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "removeRefMemberFrom";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "classFromClassMemberExternalName";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "appendDirectSuperMembers";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "inferUsagesByInheritance";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "fetchSuperWithDefaultUsagesInternal";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "subsCanBeImplicitlyUsedInternal";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addDuplicate";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addDuplicates";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 7, 8, 10, 12, 13, 14, 15, 16, 17, 18, 19, 20 -> new IllegalArgumentException(string);
        };
    }
}

