/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.quickfix;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpSwitchLanguageLevelQuickFix
implements LocalQuickFix {
    static final HashMap<PhpLanguageLevel, PhpSwitchLanguageLevelQuickFix> fixCache = new HashMap();
    @NotNull
    private final PhpLanguageLevel myLanguageLevel;
    @NotNull
    @IntentionFamilyName
    private final String myName;

    public PhpSwitchLanguageLevelQuickFix(@NotNull PhpLanguageLevel languageLevel) {
        if (languageLevel == null) {
            PhpSwitchLanguageLevelQuickFix.$$$reportNull$$$0(0);
        }
        this.myLanguageLevel = languageLevel;
        this.myName = PhpBundle.message("inspection.language.level.quick.fix.switch.language.level.name.0", this.myLanguageLevel.getPresentableName());
    }

    @NotNull
    public String getFamilyName() {
        String string = this.myName;
        if (string == null) {
            PhpSwitchLanguageLevelQuickFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile file) {
        if (file == null) {
            PhpSwitchLanguageLevelQuickFix.$$$reportNull$$$0(2);
        }
        return null;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            PhpSwitchLanguageLevelQuickFix.$$$reportNull$$$0(3);
        }
        if (descriptor == null) {
            PhpSwitchLanguageLevelQuickFix.$$$reportNull$$$0(4);
        }
        PhpProjectConfigurationFacade.getInstance(project).setLanguageLevel(this.myLanguageLevel);
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
        if (project == null) {
            PhpSwitchLanguageLevelQuickFix.$$$reportNull$$$0(5);
        }
        if (previewDescriptor == null) {
            PhpSwitchLanguageLevelQuickFix.$$$reportNull$$$0(6);
        }
        IntentionPreviewInfo intentionPreviewInfo = this.generatePreview();
        if (intentionPreviewInfo == null) {
            PhpSwitchLanguageLevelQuickFix.$$$reportNull$$$0(7);
        }
        return intentionPreviewInfo;
    }

    @NotNull
    public IntentionPreviewInfo generatePreview() {
        HtmlChunk.Element chunk = HtmlChunk.tag((String)"option").addText(this.myLanguageLevel.getPresentableName()).attr("selected", "selected");
        HtmlChunk.Element select = HtmlChunk.tag((String)"select").child((HtmlChunk)chunk);
        HtmlChunk.Element table = HtmlChunk.tag((String)"table").child((HtmlChunk)HtmlChunk.tag((String)"tr").children(new HtmlChunk[]{HtmlChunk.tag((String)"td").child(HtmlChunk.text((String)PhpBundle.message("php.language.level.widget", new Object[0]))), HtmlChunk.tag((String)"td").child((HtmlChunk)select)}));
        HtmlChunk content = new HtmlBuilder().append(PhpBundle.message("set.the.following.option", new Object[0])).br().br().append((HtmlChunk)table).toFragment();
        return new IntentionPreviewInfo.Html(content);
    }

    @NotNull
    public static LocalQuickFix getInstance(@NotNull PhpLanguageLevel languageLevel) {
        PhpSwitchLanguageLevelQuickFix fix;
        if (languageLevel == null) {
            PhpSwitchLanguageLevelQuickFix.$$$reportNull$$$0(8);
        }
        if ((fix = fixCache.get(languageLevel)) == null) {
            fix = new PhpSwitchLanguageLevelQuickFix(languageLevel);
            fixCache.put(languageLevel, fix);
        }
        PhpSwitchLanguageLevelQuickFix phpSwitchLanguageLevelQuickFix = fix;
        if (phpSwitchLanguageLevelQuickFix == null) {
            PhpSwitchLanguageLevelQuickFix.$$$reportNull$$$0(9);
        }
        return phpSwitchLanguageLevelQuickFix;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 7, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 1: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/quickfix/PhpSwitchLanguageLevelQuickFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previewDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/quickfix/PhpSwitchLanguageLevelQuickFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePreview";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 7: 
            case 9: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getElementToMakeWritable";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 7, 9 -> new IllegalStateException(string);
        };
    }
}

