/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpRemoveAllStatementsQuickFix
extends PsiUpdateModCommandQuickFix {
    @IntentionFamilyName
    private final String name;
    private final IElementType delivery;

    public PhpRemoveAllStatementsQuickFix(@NotNull String name, @Nullable IElementType delivery) {
        if (name == null) {
            PhpRemoveAllStatementsQuickFix.$$$reportNull$$$0(0);
        }
        this.name = PhpBundle.message("intention.family.name.remove", name);
        this.delivery = delivery;
    }

    @NotNull
    public final String getFamilyName() {
        String string = this.name;
        if (string == null) {
            PhpRemoveAllStatementsQuickFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
        List<PsiElement> conditionElements;
        if (project == null) {
            PhpRemoveAllStatementsQuickFix.$$$reportNull$$$0(2);
        }
        if (element == null) {
            PhpRemoveAllStatementsQuickFix.$$$reportNull$$$0(3);
        }
        if (updater == null) {
            PhpRemoveAllStatementsQuickFix.$$$reportNull$$$0(4);
        }
        if ((conditionElements = this.getElementsToRemove(element)) != null) {
            this.removeElements(ContainerUtil.map(conditionElements, arg_0 -> ((ModPsiUpdater)updater).getWritable(arg_0)));
        }
    }

    public void remove(@Nullable PsiElement element) {
        List<PsiElement> conditionElements = this.getElementsToRemove(element);
        if (conditionElements != null) {
            if (!ContainerUtil.exists(conditionElements, e -> IntentionPreviewUtils.isPreviewElement((PsiElement)e)) && !FileModificationService.getInstance().preparePsiElementsForWrite(conditionElements)) {
                return;
            }
            this.removeElements(conditionElements);
        }
    }

    private void removeElements(List<PsiElement> conditionElements) {
        for (PsiElement psiElement : conditionElements) {
            PhpDocComment phpDocComment;
            if (psiElement instanceof PhpNamedElement) {
                PhpNamedElement namedElement = (PhpNamedElement)psiElement;
                phpDocComment = namedElement.getDocComment();
            } else {
                phpDocComment = null;
            }
            PhpDocComment comment = phpDocComment;
            PhpCodeEditUtil.removeStatementWithDelivery(psiElement, this.delivery);
            if (comment == null) continue;
            this.updatePhpDoc(comment);
        }
    }

    protected void updatePhpDoc(@NotNull PhpDocComment comment) {
        if (comment == null) {
            PhpRemoveAllStatementsQuickFix.$$$reportNull$$$0(5);
        }
        comment.delete();
    }

    @Nullable
    protected abstract List<PsiElement> getElementsToRemove(@Nullable PsiElement var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/quickfix/PhpRemoveAllStatementsQuickFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/quickfix/PhpRemoveAllStatementsQuickFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "updatePhpDoc";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

