/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.probablyBug;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ArrayUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.probablyBug.PhpDuplicateSwitchCaseBodyInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.PhpBreak;
import com.jetbrains.php.lang.psi.elements.PhpCase;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.elements.PhpSwitch;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpSwitchCaseWithoutDefaultBranchInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpSwitchCaseWithoutDefaultBranchInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(this){

            public void visitPhpSwitch(PhpSwitch switchStatement) {
                PhpCase defaultCase = switchStatement.getDefaultCase();
                if (defaultCase == null && PhpSwitchCaseWithoutDefaultBranchInspection.getAnchor(switchStatement) != null) {
                    holder.problem((PsiElement)switchStatement, PhpBundle.message("inspection.switch.without.default.case", new Object[0])).fix((ModCommandAction)new PhpAddDefaultSwitchCaseQuickFix()).register();
                }
            }
        };
    }

    private static PsiElement getAnchor(PhpSwitch phpSwitch) {
        PhpCase element = (PhpCase)ArrayUtil.getLastElement((Object[])phpSwitch.getCases());
        if (element != null) {
            return element;
        }
        ASTNode openBrace = phpSwitch.getNode().findChildByType(PhpTokenTypes.chLBRACE);
        return openBrace != null ? openBrace.getPsi() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/probablyBug/PhpSwitchCaseWithoutDefaultBranchInspection", "buildVisitor"));
    }

    public static class PhpAddDefaultSwitchCaseQuickFix
    extends PsiUpdateModCommandAction<PhpSwitch> {
        public PhpAddDefaultSwitchCaseQuickFix() {
            super(PhpSwitch.class);
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("insert.default.branch", new Object[0]);
            if (string == null) {
                PhpAddDefaultSwitchCaseQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        private static void insertDefaultSwitchCase(Project project, PhpSwitch phpSwitch) {
            if (phpSwitch == null) {
                return;
            }
            PhpCase defaultCase = PhpPsiElementFactory.createPhpPsiFromText(project, PhpCase.class, "switch(a){ default: throw new \\Exception('Unexpected value');}");
            PhpAddDefaultSwitchCaseQuickFix.insertSwitchCase(phpSwitch, defaultCase);
        }

        public static void insertSwitchCase(PhpSwitch phpSwitch, PhpCase phpCase) {
            PsiElement anchor = PhpSwitchCaseWithoutDefaultBranchInspection.getAnchor(phpSwitch);
            if (anchor == null) {
                return;
            }
            if (anchor instanceof PhpCase) {
                PsiElement lastStatement;
                GroupStatement caseBeforeBody = PhpDuplicateSwitchCaseBodyInspection.getBody((PhpCase)anchor);
                PsiElement psiElement = lastStatement = caseBeforeBody != null ? (PsiElement)ArrayUtil.getLastElement((Object[])caseBeforeBody.getStatements()) : null;
                if (!(lastStatement instanceof PhpBreak) && !(lastStatement instanceof PhpReturn)) {
                    PhpAddDefaultSwitchCaseQuickFix.addBreakAsLastStatement((PhpCase)anchor, caseBeforeBody, lastStatement);
                }
            }
            phpSwitch.addAfter((PsiElement)phpCase, anchor);
        }

        private static void addBreakAsLastStatement(@NotNull PhpCase phpCase, @Nullable GroupStatement body, PsiElement lastStatement) {
            if (phpCase == null) {
                PhpAddDefaultSwitchCaseQuickFix.$$$reportNull$$$0(1);
            }
            PhpBreak phpBreak = PhpPsiElementFactory.createFromText(phpCase.getProject(), PhpBreak.class, "switch a{case 1: break;}");
            assert (phpBreak != null);
            if (lastStatement != null) {
                PsiElement parent = phpBreak.getParent();
                assert (parent != null);
                assert (body != null);
                body.addAfter(parent, lastStatement);
            } else {
                GroupStatement breakBody = PhpPsiUtil.getParentOfClass((PsiElement)phpBreak, GroupStatement.class);
                assert (breakBody != null);
                if (body != null) {
                    body.replace((PsiElement)breakBody);
                } else {
                    ASTNode colonNode = phpCase.getNode().findChildByType(PhpTokenTypes.opCOLON);
                    if (colonNode == null) {
                        return;
                    }
                    phpCase.addAfter((PsiElement)breakBody, colonNode.getPsi());
                }
            }
        }

        protected void invoke(@NotNull ActionContext context, @NotNull PhpSwitch phpSwitch, @NotNull ModPsiUpdater updater) {
            if (context == null) {
                PhpAddDefaultSwitchCaseQuickFix.$$$reportNull$$$0(2);
            }
            if (phpSwitch == null) {
                PhpAddDefaultSwitchCaseQuickFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                PhpAddDefaultSwitchCaseQuickFix.$$$reportNull$$$0(4);
            }
            PhpAddDefaultSwitchCaseQuickFix.insertDefaultSwitchCase(context.project(), phpSwitch);
            PhpCase defaultCase = phpSwitch.getDefaultCase();
            assert (defaultCase != null);
            GroupStatement body = PhpDuplicateSwitchCaseBodyInspection.getBody(defaultCase);
            assert (body != null);
            PsiElement argumentOfInsertedCase = body.getStatements()[0];
            updater.templateBuilder().field(argumentOfInsertedCase, argumentOfInsertedCase.getText());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/probablyBug/PhpSwitchCaseWithoutDefaultBranchInspection$PhpAddDefaultSwitchCaseQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "phpCase";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "phpSwitch";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/probablyBug/PhpSwitchCaseWithoutDefaultBranchInspection$PhpAddDefaultSwitchCaseQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "addBreakAsLastStatement";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }
}

