/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.deadcode.local;

import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import org.jetbrains.annotations.NotNull;

public final class PhpOverridesImplicitlyUsagesProvider
implements ImplicitUsageProvider {
    @NotNull
    private static final Key<CachedValue<Boolean>> CACHED_OVERRIDES_USAGE_KEY = Key.create((String)"php.unused.local.symbol.reference.overrides.key");

    public boolean isImplicitUsage(@NotNull PsiElement element) {
        if (element == null) {
            PhpOverridesImplicitlyUsagesProvider.$$$reportNull$$$0(0);
        }
        if (element instanceof PhpClassMember) {
            PhpClassMember classMember = (PhpClassMember)element;
            PhpClass phpClass = classMember.getContainingClass();
            return phpClass != null && !phpClass.isInterface() && !phpClass.isTrait() && !classMember.getModifier().isAbstract() && this.checkMember(classMember);
        }
        return false;
    }

    public boolean checkMember(@NotNull PhpClassMember method) {
        if (method == null) {
            PhpOverridesImplicitlyUsagesProvider.$$$reportNull$$$0(1);
        }
        return (Boolean)CachedValuesManager.getCachedValue((PsiElement)method, CACHED_OVERRIDES_USAGE_KEY, () -> CachedValueProvider.Result.create((Object)PhpOverridesImplicitlyUsagesProvider.isOverrides(method), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    public boolean isImplicitRead(@NotNull PsiElement element) {
        if (element == null) {
            PhpOverridesImplicitlyUsagesProvider.$$$reportNull$$$0(2);
        }
        return false;
    }

    public boolean isImplicitWrite(@NotNull PsiElement element) {
        if (element == null) {
            PhpOverridesImplicitlyUsagesProvider.$$$reportNull$$$0(3);
        }
        return false;
    }

    private static boolean isOverrides(@NotNull PhpClassMember member) {
        if (member == null) {
            PhpOverridesImplicitlyUsagesProvider.$$$reportNull$$$0(4);
        }
        Ref implementsSuperMembers = new Ref((Object)false);
        PhpClassHierarchyUtils.processSuperMembers((PhpClassMember)member, (classMember, subClass, baseClass) -> {
            implementsSuperMembers.set((Object)true);
            return false;
        });
        return (Boolean)implementsSuperMembers.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/deadcode/local/PhpOverridesImplicitlyUsagesProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isImplicitUsage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "checkMember";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isImplicitRead";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isImplicitWrite";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isOverrides";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

