/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.deadcode.coreDeclaration;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefClass;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefMethod;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.ArrayIndex;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.PhpEmpty;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpIsset;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpUnset;
import one.util.streamex.IntStreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public interface PhpCoreHandler {
    public static final ExtensionPointName<PhpCoreHandler> EP_NAME = ExtensionPointName.create((String)"com.jetbrains.php.coreMethodProvider");
    public static final String COUNT_FUNCTION_REFERENCE = "count";
    public static final int ARRAY_ACCESS_SET = 1;
    public static final int ARRAY_ACCESS_GET = 2;
    public static final int ARRAY_FOREACH_USAGE = 4;
    public static final int ARRAY_COUNT_USAGE = 8;
    public static final int ISSET_USAGE = 16;
    public static final int UNSET_USAGE = 32;
    public static final int ARRAY_EXISTS_HASH = 64;
    public static final int ARRAY_UNSET_HASH = 128;
    public static final int FIELDS_IMPLICITLY_USAGE_HASH = 512;
    public static final int ARRAY_ACCESS_HASH = 1;
    public static final int ARRAY_OBJECT_HASH = 2;
    public static final int ARRAY_ITERATOR_HASH = 4;
    public static final int ITERATOR_HASH = 8;
    public static final int COUNTABLE_HASH = 16;
    public static final int ITERATOR_AGGREGATE_HASH = 32;

    default public int getArrayAccessHash(@NotNull ArrayAccessExpression accessExpression) {
        if (accessExpression == null) {
            PhpCoreHandler.$$$reportNull$$$0(0);
        }
        ArrayIndex index = accessExpression.getIndex();
        PhpPsiElement psiElement = accessExpression.getValue();
        if (index != null) {
            if (index.getValue() == null) {
                return 1;
            }
            PhpPsiElement arrayAccessContext = (PhpPsiElement)PhpPsiUtil.getParentByCondition((PsiElement)psiElement, (Condition<? super PsiElement>)AssignmentExpression.INSTANCEOF, (Condition<? super PsiElement>)PhpScopeHolder.INSTANCE_OF);
            if (arrayAccessContext != null) {
                return 3;
            }
            return 2;
        }
        return 0;
    }

    default public boolean isArrayExistsContext(@NotNull PhpPsiElement context, @NotNull PhpPsiElement psiElement) {
        PsiElement elementParent;
        if (context == null) {
            PhpCoreHandler.$$$reportNull$$$0(1);
        }
        if (psiElement == null) {
            PhpCoreHandler.$$$reportNull$$$0(2);
        }
        boolean isArrayAccess = (elementParent = psiElement.getParent()) instanceof ArrayAccessExpression && ((ArrayAccessExpression)elementParent).getIndex() != null;
        return isArrayAccess || context instanceof PhpEmpty;
    }

    default public int getArrayExistsHash(@NotNull PhpPsiElement context, @NotNull PhpPsiElement element) {
        if (context == null) {
            PhpCoreHandler.$$$reportNull$$$0(3);
        }
        if (element == null) {
            PhpCoreHandler.$$$reportNull$$$0(4);
        }
        if (this.isArrayExistsContext(context, element)) {
            if (context instanceof PhpIsset || context instanceof PhpEmpty) {
                return 64;
            }
            if (context instanceof PhpUnset) {
                return 128;
            }
        }
        return 0;
    }

    default public int getArrayForHash(@NotNull PhpPsiElement element, @NotNull PhpPsiElement forStmt) {
        if (element == null) {
            PhpCoreHandler.$$$reportNull$$$0(5);
        }
        if (forStmt == null) {
            PhpCoreHandler.$$$reportNull$$$0(6);
        }
        if (forStmt instanceof ForeachStatement) {
            return ((ForeachStatement)forStmt).getArray() == element ? 4 : 0;
        }
        return 0;
    }

    default public boolean isAllowed(@NotNull PhpRefClass refClass, int ... refHashes) {
        if (refClass == null) {
            PhpCoreHandler.$$$reportNull$$$0(7);
        }
        return IntStreamEx.of((int[])refHashes).anyMatch(arg_0 -> ((PhpRefClass)refClass).isCoreInterfacesImplemented(arg_0));
    }

    default public int getFunctionReferenceHash(@NotNull PhpPsiElement reference) {
        if (reference == null) {
            PhpCoreHandler.$$$reportNull$$$0(8);
        }
        int referenceHash = this.getCountableHash(reference);
        referenceHash = this.getIssetHash(reference, referenceHash);
        referenceHash = this.getUnsetHash(reference, referenceHash);
        return referenceHash;
    }

    default public int getCountableHash(@NotNull PhpPsiElement element) {
        if (element == null) {
            PhpCoreHandler.$$$reportNull$$$0(9);
        }
        return COUNT_FUNCTION_REFERENCE.equals(element.getName()) ? 8 : 0;
    }

    default public int getIssetHash(@NotNull PhpPsiElement element, int referenceHash) {
        if (element == null) {
            PhpCoreHandler.$$$reportNull$$$0(10);
        }
        return element instanceof PhpIsset ? 16 : referenceHash;
    }

    default public int getUnsetHash(@NotNull PhpPsiElement element, int referenceHash) {
        if (element == null) {
            PhpCoreHandler.$$$reportNull$$$0(11);
        }
        return element instanceof PhpUnset ? 32 : referenceHash;
    }

    public boolean accepts(@NotNull PhpPsiElement var1, @NotNull PhpPsiElement var2);

    public boolean accepts(@NotNull PhpRefClass var1, @NotNull PhpRefMethod var2);

    public boolean acceptsClass(@NotNull PhpRefClass var1);

    public int getHash(@NotNull PhpPsiElement var1, @NotNull PhpPsiElement var2);

    public int getClassHash(@NotNull PhpRefClass var1);

    public boolean inferImplicitlyUsages(@NotNull PhpRefClass var1, @NotNull String var2);

    public static boolean isMethodUsed(int methodHash, int usedHash) {
        return (methodHash & usedHash) > 0;
    }

    public static int getCoreHash(@NotNull PhpExpression classExpression, @NotNull PhpPsiElement magicContext) {
        if (classExpression == null) {
            PhpCoreHandler.$$$reportNull$$$0(12);
        }
        if (magicContext == null) {
            PhpCoreHandler.$$$reportNull$$$0(13);
        }
        int hash = 0;
        for (PhpCoreHandler handler : (PhpCoreHandler[])EP_NAME.getExtensions()) {
            if (!handler.accepts((PhpPsiElement)classExpression, magicContext)) continue;
            hash |= handler.getHash((PhpPsiElement)classExpression, magicContext);
        }
        return hash;
    }

    public static int getCoreDeclarationHash(@NotNull PhpRefClass refClass) {
        if (refClass == null) {
            PhpCoreHandler.$$$reportNull$$$0(14);
        }
        for (PhpCoreHandler handler : (PhpCoreHandler[])EP_NAME.getExtensions()) {
            if (!handler.acceptsClass(refClass)) continue;
            return handler.getClassHash(refClass);
        }
        return 0;
    }

    @Nullable
    public static PhpCoreHandler getCoreDeclarationProvider(@NotNull PhpRefClass refClass, @NotNull PhpRefMethod refMethod) {
        if (refClass == null) {
            PhpCoreHandler.$$$reportNull$$$0(15);
        }
        if (refMethod == null) {
            PhpCoreHandler.$$$reportNull$$$0(16);
        }
        return (PhpCoreHandler)ContainerUtil.find((Object[])((PhpCoreHandler[])EP_NAME.getExtensions()), handler -> handler.accepts(refClass, refMethod));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessExpression";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forStmt";
                break;
            }
            case 7: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refClass";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classExpression";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "magicContext";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refMethod";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/deadcode/coreDeclaration/PhpCoreHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getArrayAccessHash";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isArrayExistsContext";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getArrayExistsHash";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getArrayForHash";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isAllowed";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getFunctionReferenceHash";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getCountableHash";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "getIssetHash";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "getUnsetHash";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "getCoreHash";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "getCoreDeclarationHash";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "getCoreDeclarationProvider";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

