/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.controlFlow.constantCondition.variable;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpArrayAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpCallInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpEntryPointInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.dataFlow.type.PhpTypeConditionDFAnalyzer;
import com.jetbrains.php.codeInsight.typeInference.PhpAmbiguousCompositeTypeState;
import com.jetbrains.php.codeInsight.typeInference.PhpCompositeTypeState;
import com.jetbrains.php.codeInsight.typeInference.PhpDfaBaseStateConditionDFAnalyzer;
import com.jetbrains.php.codeInsight.typeInference.PhpDfaBasedAnalyzerProcessor;
import com.jetbrains.php.codeInsight.typeInference.PhpDfaBasedTypeState;
import com.jetbrains.php.codeInsight.typeInference.PhpDfaDelegateBasedTypeState;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.controlFlow.PhpConditionAlreadyCheckedInspection;
import com.jetbrains.php.lang.inspections.controlFlow.constantCondition.PhpPreviousDfaAnalyzerProcessor;
import com.jetbrains.php.lang.inspections.controlFlow.constantCondition.PhpPreviousDfaBaseStateConditionDFAnalyzer;
import com.jetbrains.php.lang.inspections.controlFlow.constantCondition.PhpStateArgumentInfo;
import com.jetbrains.php.lang.inspections.controlFlow.constantCondition.variable.PhpDfaBasedVariableAnalyzerProcessor;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.ArrayHashElement;
import com.jetbrains.php.lang.psi.elements.Catch;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Global;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.ArrayCreationExpressionImpl;
import com.jetbrains.php.lang.psi.elements.impl.MultiassignmentExpressionImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpPreviousVariableDfaAnalyzerProcessor
extends PhpPreviousDfaAnalyzerProcessor {
    public static final PhpDfaBasedTypeState[] EMPTY_ARRAY = PhpDfaBasedTypeState.EMPTY_ARRAY;
    private static final PhpDfaBasedTypeState[] NOT_NULL_EMPTY_ARRAY = PhpDfaBasedTypeState.EMPTY_ARRAY;
    private final boolean mySeekNotNullByMethodCallState;
    @Nullable
    private final PhpScopeHolder myScopeHolder;

    public PhpPreviousVariableDfaAnalyzerProcessor(@NotNull Project project, String variableName, boolean stopOnNegations, TextRange outerTextRange, PhpDfaBasedAnalyzerProcessor.PhpVariableDfaStateWithInstruction<PhpDfaBasedTypeState> currentState, boolean seekNotNullByMethodCallState, boolean global, @Nullable PhpScopeHolder scope) {
        if (project == null) {
            PhpPreviousVariableDfaAnalyzerProcessor.$$$reportNull$$$0(0);
        }
        super(project, variableName, variableName, stopOnNegations, outerTextRange, null, currentState, global);
        this.myScopeHolder = scope;
        if (StringUtil.isNotEmpty((String)variableName)) {
            PhpStateArgumentInfo.PhpVariableStateArgumentInfo info = new PhpStateArgumentInfo.PhpVariableStateArgumentInfo(variableName);
            this.myStateDependenciesCheckers = ContainerUtil.union((Collection)this.myStateDependenciesCheckers, info.getIndirectDependencies(global, scope));
        }
        this.mySeekNotNullByMethodCallState = seekNotNullByMethodCallState;
    }

    @Override
    public boolean sameElement(@Nullable PsiElement element) {
        return element instanceof Variable && this.sameVariableName(((Variable)element).getName());
    }

    @Override
    protected PhpPreviousVariableDfaAnalyzerProcessor createProcessor(TextRange outerRange) {
        return this.createProcessor(outerRange, true);
    }

    @NotNull
    private PhpPreviousVariableDfaAnalyzerProcessor createProcessor(TextRange outerRange, boolean seekNotNullByMethodCallState) {
        return new PhpPreviousVariableDfaAnalyzerProcessor(this.myProject, (String)this.myVariableName, this.myStopOnNegations, outerRange, this.myCurrentState, seekNotNullByMethodCallState, this.myGlobal, this.myScopeHolder);
    }

    @Override
    public boolean processEntryPointInstruction(PhpEntryPointInstruction instruction) {
        if (this.myInjectedState != null) {
            return super.processEntryPointInstruction(instruction);
        }
        PsiElement scopeHolder = instruction.getAnchor();
        if (scopeHolder instanceof Function) {
            Parameter parameter = PhpConditionAlreadyCheckedInspection.findParameterByName((Function)scopeHolder, this.myVariableName);
            if (parameter != null) {
                PhpDfaBasedTypeState state = PhpPreviousVariableDfaAnalyzerProcessor.getParameterTypeState(parameter);
                if (state != null) {
                    this.registerState((PhpInstruction)instruction, parameter.getTextRange(), (PhpDfaBasedAnalyzerProcessor.PhpVariableDfaState<PhpDfaBasedTypeState>)new PhpDfaBasedAnalyzerProcessor.PhpVariableDfaStateWithInstruction<PhpDfaBasedTypeState>(this.myVariableName, state, (PhpInstruction)instruction));
                    return false;
                }
                return super.processEntryPointInstruction(instruction);
            }
        } else if (scopeHolder instanceof PhpFile) {
            for (Variable variable : PhpIndex.getInstance((Project)scopeHolder.getProject()).getVariablesByName(String.valueOf(this.myVariableName))) {
                if (!this.tryRegisterVariableState((PhpInstruction)instruction, variable.getGlobalType(), this.myOuterTextRange)) continue;
                return false;
            }
        }
        return super.processEntryPointInstruction(instruction);
    }

    @Nullable
    private static PhpDfaBasedTypeState getParameterTypeState(Parameter parameter) {
        PhpDfaBasedTypeState intRangeState = PhpDfaBaseStateConditionDFAnalyzer.getIntBoundRangesState(parameter.getDocType());
        PhpDfaBasedTypeState stateFromDeclaredType = PhpPreviousVariableDfaAnalyzerProcessor.getStateFromDeclaredType(parameter);
        if (stateFromDeclaredType == null) {
            return intRangeState;
        }
        if (intRangeState != null) {
            return new PhpDfaDelegateBasedTypeState("Doc and declared types", stateFromDeclaredType, intRangeState);
        }
        return stateFromDeclaredType;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable
    private static PhpDfaBasedTypeState getStateFromDeclaredType(Parameter parameter) {
        PhpType declaredType = parameter.getDeclaredType().global(parameter.getProject());
        if (!declaredType.isAmbiguous()) {
            @NlsSafe Set types = declaredType.getTypes();
            return PhpPreviousVariableDfaAnalyzerProcessor.creteCompositeState(types, PhpPreviousVariableDfaAnalyzerProcessor.defaultValueStates(parameter));
        }
        return null;
    }

    @Nullable
    public static PhpDfaBasedTypeState creteCompositeState(Set<@NlsSafe String> types, Stream<PhpDfaBasedTypeState> additionalStates) {
        Object[] states = (PhpDfaBasedTypeState[])((StreamEx)((StreamEx)StreamEx.of(types).map(PhpPreviousVariableDfaAnalyzerProcessor::createStateFromType).append(additionalStates)).distinct()).toArray((Object[])EMPTY_ARRAY);
        if (states.length > 0 && ArrayUtil.indexOf((Object[])states, null) < 0) {
            return states.length == 1 ? states[0] : new PhpAmbiguousCompositeTypeState((PhpDfaBasedTypeState[])states);
        }
        return null;
    }

    @NotNull
    private static Stream<PhpDfaBasedTypeState> defaultValueStates(Parameter parameter) {
        PsiElement defaultValue = parameter.getDefaultValue();
        if (defaultValue == null) {
            Stream<PhpDfaBasedTypeState> stream = Stream.empty();
            if (stream == null) {
                PhpPreviousVariableDfaAnalyzerProcessor.$$$reportNull$$$0(1);
            }
            return stream;
        }
        Stream<PhpDfaBasedTypeState> stream = Stream.of(PhpLangUtil.isNull(defaultValue) ? PhpPreviousVariableDfaAnalyzerProcessor.createStateFromType("\\null") : null);
        if (stream == null) {
            PhpPreviousVariableDfaAnalyzerProcessor.$$$reportNull$$$0(2);
        }
        return stream;
    }

    private static PhpDfaBasedTypeState createStateFromType(String type) {
        if (PhpType.isNull((String)type)) {
            return PhpDfaBasedTypeState.NULL;
        }
        if (PhpType.isCallableType((String)type)) {
            return PhpDfaDelegateBasedTypeState.PhpNotNullByPrimitiveTypeChecker.IS_CALLABLE_CHECK;
        }
        if (PhpType.isNotExtendablePrimitiveType((String)type) || PhpType.isArray((String)type) || PhpType.isPluralType((String)type) || PhpType.isObject((String)type) || "\\iterable".equals(type)) {
            List states = ContainerUtil.map(PhpPreviousVariableDfaAnalyzerProcessor.getPrimitiveTypeCheckersFromDeclaredType(new PhpType().add(type)), PhpDfaBaseStateConditionDFAnalyzer::createNotNullByPrimitiveTypeCheckerState);
            if (!states.isEmpty()) {
                return states.size() == 1 ? (PhpDfaBasedTypeState)states.get(0) : new PhpCompositeTypeState(states.toArray(NOT_NULL_EMPTY_ARRAY));
            }
        } else {
            return PhpDfaDelegateBasedTypeState.PhpInstanceofTypeState.createInstance(type);
        }
        return null;
    }

    @NotNull
    private static Collection<String> getPrimitiveTypeCheckersFromDeclaredType(@NotNull PhpType type) {
        if (type == null) {
            PhpPreviousVariableDfaAnalyzerProcessor.$$$reportNull$$$0(3);
        }
        HashSet<String> typeCheckers = new HashSet<String>(PhpTypeConditionDFAnalyzer.getPrimitiveTypeCheckerTypeFromName(type));
        if (PhpType.intersects((PhpType)type, (PhpType)PhpType.OBJECT)) {
            typeCheckers.add("is_object");
        }
        if (PhpType.intersects((PhpType)type, (PhpType)PhpType.ITERABLE)) {
            typeCheckers.add("is_iterable");
        }
        HashSet<String> hashSet = typeCheckers;
        if (hashSet == null) {
            PhpPreviousVariableDfaAnalyzerProcessor.$$$reportNull$$$0(4);
        }
        return hashSet;
    }

    @Override
    public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
        if (!super.processInstruction((PhpInstruction)instruction)) {
            return false;
        }
        PhpAccessInstruction.Access access = instruction.getAccess();
        if (this.sameVariableName(instruction.getVariableName())) {
            if (PhpConditionAlreadyCheckedInspection.isModifyingAccess(access, this.myGlobal)) {
                if (this.registerStateFromGlobal(instruction)) {
                    return false;
                }
                if (this.registerStateFromAssignedValue((PhpAccessInstruction)instruction)) {
                    return false;
                }
                if (this.registerStateFromExceptionCatch(instruction)) {
                    return false;
                }
                if (this.registerStateFromForeachKeyValue(instruction)) {
                    return false;
                }
                this.registerUnsetOrUnknownState((PhpAccessInstruction)instruction, instruction.getVariableName());
                return false;
            }
            if (this.myVariableName != null && this.mayBePreviouslyCapturedVariable(this.myVariableName, (PhpInstruction)instruction)) {
                this.setUnknownState((PhpInstruction)instruction, this.myVariableName);
                return false;
            }
        }
        return true;
    }

    private boolean registerStateFromGlobal(PhpAccessVariableInstruction instruction) {
        PhpPsiElement anchor;
        if (instruction.getAccess().isWriteRef() && (anchor = instruction.getAnchor()) instanceof Variable) {
            Variable variable = (Variable)anchor;
            if (anchor.getParent() instanceof Global && this.tryRegisterVariableState((PhpInstruction)instruction, variable.getGlobalType(), anchor.getTextRange())) {
                return true;
            }
        }
        return false;
    }

    private boolean tryRegisterVariableState(PhpInstruction instruction, @NotNull PhpType type, TextRange range) {
        PhpDfaBasedTypeState state;
        if (type == null) {
            PhpPreviousVariableDfaAnalyzerProcessor.$$$reportNull$$$0(5);
        }
        if ((state = PhpDfaBaseStateConditionDFAnalyzer.getIntBoundRangesState(type)) != null) {
            super.registerState(instruction, range, (PhpDfaBasedAnalyzerProcessor.PhpVariableDfaState<PhpDfaBasedTypeState>)new PhpDfaBasedAnalyzerProcessor.PhpVariableDfaStateWithInstruction<PhpDfaBasedTypeState>(this.myVariableName, state, instruction));
            return true;
        }
        return false;
    }

    private boolean registerStateFromForeachKeyValue(PhpAccessVariableInstruction instruction) {
        PsiElement parent = instruction.getAnchor().getParent();
        if (parent instanceof ForeachStatement) {
            PsiElement end;
            PsiElement start;
            PhpDfaBasedAnalyzerProcessor.PhpVariableDfaState<PhpDfaBasedTypeState> stateFromRangeCheck;
            ParameterList list;
            PsiElement array = ((ForeachStatement)parent).getArray();
            if (array instanceof ArrayCreationExpression) {
                List<PhpPsiElement> arrayHashKeys;
                if (((ForeachStatement)parent).getValue() == instruction.getAnchor() ? this.registerStateFromIteratedValued(instruction, MultiassignmentExpressionImpl.getVariables(array), false) : ((ForeachStatement)parent).getKey() == instruction.getAnchor() && !(arrayHashKeys = ArrayCreationExpressionImpl.children((ArrayCreationExpression)array).stream().map(e -> e instanceof ArrayHashElement ? ((ArrayHashElement)e).getKey() : null).collect(Collectors.toList())).contains(null) && this.registerStateFromIteratedValued(instruction, arrayHashKeys, true)) {
                    return true;
                }
            } else if (this.myGlobal && array instanceof FunctionReference && PhpCodeInsightUtil.isGlobalFunctionCallWithName((FunctionReference)array, "range") && ((ForeachStatement)parent).getValue() == instruction.getAnchor() && (list = ((FunctionReference)array).getParameterList()) != null && (stateFromRangeCheck = this.createStateFromRangeCheck(instruction, start = list.getParameter("start", 0), end = list.getParameter("end", 1))) != null) {
                this.registerState((PhpInstruction)instruction, TextRange.EMPTY_RANGE, stateFromRangeCheck);
                return true;
            }
        }
        return false;
    }

    private static boolean nonNumericStringLiteral(PhpPsiElement s) {
        if (s instanceof StringLiteralExpression) {
            return PhpDfaDelegateBasedTypeState.PhpPrimitiveTypeCheckByComparison.isStringWithoutInterpolations((PsiElement)s) && !PhpPreviousVariableDfaAnalyzerProcessor.containsDigit(((StringLiteralExpression)s).getContents());
        }
        return PhpPsiUtil.isOfType((PsiElement)s, PhpElementTypes.NUMBER);
    }

    private static boolean containsDigit(String contents) {
        return contents.chars().anyMatch(Character::isDigit);
    }

    @Nullable
    private PhpDfaBasedAnalyzerProcessor.PhpVariableDfaState<PhpDfaBasedTypeState> createStateFromRangeCheck(@NotNull PhpAccessVariableInstruction instruction, PsiElement start, PsiElement end) {
        if (instruction == null) {
            PhpPreviousVariableDfaAnalyzerProcessor.$$$reportNull$$$0(6);
        }
        Integer startValue = PhpPreviousVariableDfaAnalyzerProcessor.getIntValue(start);
        Integer endValue = PhpPreviousVariableDfaAnalyzerProcessor.getIntValue(end);
        if (startValue == null || endValue == null) {
            return null;
        }
        if (startValue >= endValue) {
            PsiElement tmp = start;
            start = end;
            end = tmp;
        }
        PhpDfaBaseStateConditionDFAnalyzer.PhpVariableDfaState startState = this.createAnalyzer().tryCreateRangeState(true, PhpTokenTypes.opGREATER_OR_EQUAL, (PsiElement)instruction.getAnchor(), start);
        PhpDfaBaseStateConditionDFAnalyzer.PhpVariableDfaState endState = this.createAnalyzer().tryCreateRangeState(true, PhpTokenTypes.opLESS_OR_EQUAL, (PsiElement)instruction.getAnchor(), end);
        if (startState == null) {
            return endState;
        }
        if (endState == null) {
            return startState;
        }
        PhpDfaDelegateBasedTypeState composedState = new PhpDfaDelegateBasedTypeState("RANGE CHECK", (PhpDfaBasedTypeState)startState.getState(), (PhpDfaBasedTypeState)endState.getState());
        return new PhpDfaBasedAnalyzerProcessor.PhpVariableDfaStateWithInstruction<PhpDfaBasedTypeState>(instruction.getVariableName(), composedState, (PhpInstruction)instruction);
    }

    private static Integer getIntValue(PsiElement element) {
        Integer value;
        if (PhpPsiUtil.isOfType(element, PhpElementTypes.NUMBER)) {
            try {
                return Integer.parseInt(element.getText());
            }
            catch (NumberFormatException ignored) {
                return null;
            }
        }
        if (element instanceof UnaryExpression && PhpPsiUtil.isOfType(((UnaryExpression)element).getOperation(), PhpTokenTypes.opMINUS) && (value = PhpPreviousVariableDfaAnalyzerProcessor.getIntValue((PsiElement)((UnaryExpression)element).getValue())) != null) {
            return value * -1;
        }
        return null;
    }

    private boolean registerStateFromIteratedValued(PhpAccessVariableInstruction instruction, List<PhpPsiElement> variables, boolean mayBeConverted) {
        PhpDfaBasedTypeState stateFromForeachIteratedValues = this.getCompositeStateFromVariables(variables, mayBeConverted);
        if (stateFromForeachIteratedValues != null) {
            PhpDfaBasedAnalyzerProcessor.PhpVariableDfaStateWithInstruction<PhpDfaBasedTypeState> variableState = new PhpDfaBasedAnalyzerProcessor.PhpVariableDfaStateWithInstruction<PhpDfaBasedTypeState>(instruction.getVariableName(), stateFromForeachIteratedValues, (PhpInstruction)instruction);
            this.registerState((PhpInstruction)instruction, TextRange.EMPTY_RANGE, (PhpDfaBasedAnalyzerProcessor.PhpVariableDfaState<PhpDfaBasedTypeState>)variableState);
            return true;
        }
        return false;
    }

    @Nullable
    private PhpDfaBasedTypeState getCompositeStateFromVariables(@NotNull List<PhpPsiElement> variables, boolean mayBeConverted) {
        PhpDfaBasedTypeState[] states;
        if (variables == null) {
            PhpPreviousVariableDfaAnalyzerProcessor.$$$reportNull$$$0(7);
        }
        if ((states = (PhpDfaBasedTypeState[])StreamEx.of(variables).map(v -> this.createAnalyzer(true).getPrimitiveTypeCheckState((PsiElement)v, false, !mayBeConverted || PhpPreviousVariableDfaAnalyzerProcessor.nonNumericStringLiteral(v))).nonNull().toArray((Object[])PhpDfaBasedTypeState.EMPTY_ARRAY)).length == 1) {
            return states[0];
        }
        if (states.length > 0) {
            return new PhpAmbiguousCompositeTypeState(states);
        }
        return null;
    }

    private boolean registerStateFromExceptionCatch(PhpAccessVariableInstruction instruction) {
        List instanceofStates;
        PsiElement parent = instruction.getAnchor().getParent();
        if (parent instanceof Catch && !(instanceofStates = ContainerUtil.map((Collection)((Catch)parent).getExceptionTypes(), e -> PhpDfaBaseStateConditionDFAnalyzer.getInstanceofTypeState(e.getProject(), e, this.myGlobal))).isEmpty()) {
            PhpDfaBasedTypeState state = instanceofStates.size() == 1 ? (PhpDfaBasedTypeState)instanceofStates.get(0) : new PhpAmbiguousCompositeTypeState(instanceofStates.toArray(EMPTY_ARRAY));
            PhpDfaBasedTypeState[] previousStates = (PhpPreviousDfaBaseStateConditionDFAnalyzer.PhpNotInstanceofTypeState[])StreamEx.of(PhpPreviousVariableDfaAnalyzerProcessor.getExceptionsFromPreviousCatches((Catch)parent)).map(classReference -> PhpDfaBaseStateConditionDFAnalyzer.getInstanceofTypeState(classReference.getProject(), classReference, this.myGlobal)).nonNull().map(PhpPreviousDfaBaseStateConditionDFAnalyzer.PhpNotInstanceofTypeState::new).toArray(PhpPreviousDfaBaseStateConditionDFAnalyzer.PhpNotInstanceofTypeState.class);
            if (previousStates.length > 0) {
                state = new PhpCompositeTypeState(state, new PhpCompositeTypeState(previousStates));
            }
            PhpDfaBasedAnalyzerProcessor.PhpVariableDfaStateWithInstruction<PhpDfaBasedTypeState> variableState = new PhpDfaBasedAnalyzerProcessor.PhpVariableDfaStateWithInstruction<PhpDfaBasedTypeState>(instruction.getVariableName(), state, (PhpInstruction)instruction);
            this.registerState((PhpInstruction)instruction, TextRange.EMPTY_RANGE, (PhpDfaBasedAnalyzerProcessor.PhpVariableDfaState<PhpDfaBasedTypeState>)variableState);
            return true;
        }
        return false;
    }

    private static Collection<ClassReference> getExceptionsFromPreviousCatches(Catch aCatch) {
        ArrayList<ClassReference> res = new ArrayList<ClassReference>();
        Catch prevCatch = aCatch;
        while ((prevCatch = (Catch)ObjectUtils.tryCast((Object)PhpPsiUtil.getPrevSiblingIgnoreWhitespace((PsiElement)prevCatch, true), Catch.class)) != null) {
            res.addAll(prevCatch.getExceptionTypes());
        }
        return res;
    }

    @Override
    @NotNull
    protected PhpPreviousDfaBaseStateConditionDFAnalyzer createAnalyzer(boolean stopOnNegations) {
        return new PhpDfaBasedVariableAnalyzerProcessor.PhpVariableDfaBaseStateConditionDFAnalyzer(this.myVariableName, this.myGlobal, stopOnNegations, false);
    }

    @Override
    @Nullable
    protected CharSequence computeVariableName(PhpArrayAccessInstruction instruction, PsiElement anchor) {
        return instruction.getVariableName();
    }

    public boolean processPhpCallInstruction(PhpCallInstruction instruction) {
        Variable variable;
        if (!this.mySeekNotNullByMethodCallState || this.isInnerRangeToSkip((PhpInstruction)instruction)) {
            return super.processPhpCallInstruction(instruction);
        }
        MethodReference methodCall = (MethodReference)ObjectUtils.tryCast((Object)instruction.getFunctionReference(), MethodReference.class);
        Variable variable2 = variable = methodCall != null ? (Variable)ObjectUtils.tryCast((Object)methodCall.getClassReference(), Variable.class) : null;
        if (variable != null && this.sameElement((PsiElement)variable)) {
            boolean insideSilenceOperator;
            boolean bl = insideSilenceOperator = PhpPsiUtil.getParentByCondition((PsiElement)methodCall, (Condition<? super PsiElement>)((Condition)PhpConditionAlreadyCheckedInspection::isSilenceOperator), (Condition<? super PsiElement>)Statement.INSTANCEOF) != null;
            if (!insideSilenceOperator) {
                TextRange range = methodCall.getTextRange();
                PhpDfaBasedAnalyzerProcessor.PhpVariableDfaStateWithInstruction<PhpDfaBasedTypeState> stateFromPreviousInstruction = this.getStateFromPreviousInstruction((PhpInstruction)instruction, this.createProcessor(range, false));
                if (stateFromPreviousInstruction != null && this.registerStateFromPreviousInstruction((PhpInstruction)instruction, range, stateFromPreviousInstruction)) {
                    this.myLastDfaInstruction = stateFromPreviousInstruction.getInstruction();
                    this.put(range, this.composeStates(range, PhpPreviousVariableDfaAnalyzerProcessor.createNotNullByMethodCallState(instruction, variable)));
                } else {
                    this.registerState((PhpInstruction)instruction, range, (PhpDfaBasedAnalyzerProcessor.PhpVariableDfaState<PhpDfaBasedTypeState>)PhpPreviousVariableDfaAnalyzerProcessor.createNotNullByMethodCallState(instruction, variable));
                }
                return false;
            }
        } else {
            if (this.myVariableName != null && PhpPreviousVariableDfaAnalyzerProcessor.isUnresolvedFunctionWithVariableParameter(this.myVariableName, instruction)) {
                this.setUnknownState((PhpInstruction)instruction, this.myVariableName);
                return false;
            }
            if (this.myVariableName != null && this.mayBePreviouslyCapturedVariable(this.myVariableName, (PhpInstruction)instruction)) {
                this.setUnknownState((PhpInstruction)instruction, this.myVariableName);
                return false;
            }
        }
        return super.processPhpCallInstruction(instruction);
    }

    private boolean mayBePreviouslyCapturedVariable(@NotNull CharSequence variableName, @NotNull PhpInstruction instruction) {
        if (variableName == null) {
            PhpPreviousVariableDfaAnalyzerProcessor.$$$reportNull$$$0(8);
        }
        if (instruction == null) {
            PhpPreviousVariableDfaAnalyzerProcessor.$$$reportNull$$$0(9);
        }
        return this.myScopeHolder != null && ContainerUtil.exists((Iterable)PhpPreviousVariableDfaAnalyzerProcessor.getVariableNameToReadRefNumMap(this.myScopeHolder, this.myGlobal).get((Object)variableName), i -> i <= instruction.num());
    }

    @NotNull
    private static MultiMap<CharSequence, Integer> getVariableNameToReadRefNumMap(@NotNull PhpScopeHolder scopeHolder, boolean global) {
        if (scopeHolder == null) {
            PhpPreviousVariableDfaAnalyzerProcessor.$$$reportNull$$$0(10);
        }
        MultiMap multiMap = (MultiMap)CachedValuesManager.getCachedValue((PsiElement)scopeHolder, () -> CachedValueProvider.Result.create(PhpPreviousVariableDfaAnalyzerProcessor.computeVariableNameToReadRefNumMap(scopeHolder, global), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
        if (multiMap == null) {
            PhpPreviousVariableDfaAnalyzerProcessor.$$$reportNull$$$0(11);
        }
        return multiMap;
    }

    private static MultiMap<CharSequence, Integer> computeVariableNameToReadRefNumMap(@NotNull PhpScopeHolder scopeHolder, final boolean global) {
        if (scopeHolder == null) {
            PhpPreviousVariableDfaAnalyzerProcessor.$$$reportNull$$$0(12);
        }
        final MultiMap variableNameToReadRefInstructionNum = new MultiMap();
        PhpControlFlowUtil.processFlow(scopeHolder.getControlFlow(), new PhpInstructionProcessor(){

            public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                boolean isConstructorCallOrLambdaCapture;
                boolean bl = isConstructorCallOrLambdaCapture = PhpPsiUtil.getParentByCondition((PsiElement)instruction.getAnchor(), (Condition<? super PsiElement>)((Condition)e -> e instanceof NewExpression || e instanceof PhpUseList), (Condition<? super PsiElement>)((Condition)Statement.class::isInstance)) != null;
                if (isConstructorCallOrLambdaCapture && PhpConditionAlreadyCheckedInspection.isModifyingAccess(instruction.getAccess(), global)) {
                    variableNameToReadRefInstructionNum.putValue((Object)instruction.getVariableName(), (Object)instruction.num());
                }
                return true;
            }
        });
        return variableNameToReadRefInstructionNum;
    }

    @NotNull
    private static PhpDfaBasedAnalyzerProcessor.PhpVariableDfaStateWithInstruction<PhpDfaBasedTypeState> createNotNullByMethodCallState(PhpCallInstruction instruction, Variable variable) {
        return new PhpDfaBasedAnalyzerProcessor.PhpVariableDfaStateWithInstruction<PhpDfaBasedTypeState>(variable.getName(), PhpDfaDelegateBasedTypeState.NOT_FALSE_NOT_NULL, (PhpInstruction)instruction);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 4, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/controlFlow/constantCondition/variable/PhpPreviousVariableDfaAnalyzerProcessor";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variables";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableName";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeHolder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/controlFlow/constantCondition/variable/PhpPreviousVariableDfaAnalyzerProcessor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "defaultValueStates";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrimitiveTypeCheckersFromDeclaredType";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariableNameToReadRefNumMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 11: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPrimitiveTypeCheckersFromDeclaredType";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "tryRegisterVariableState";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createStateFromRangeCheck";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getCompositeStateFromVariables";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "mayBePreviouslyCapturedVariable";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getVariableNameToReadRefNumMap";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "computeVariableNameToReadRefNumMap";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 4, 11 -> new IllegalStateException(string);
        };
    }
}

