/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.controlFlow;

import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.lang.inspections.controlFlow.PhpIfWithCommonPartsInspection;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpBreak;
import com.jetbrains.php.lang.psi.elements.PhpContinue;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.elements.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class PhpStatementsHolder<T extends PsiElement> {
    List<List<PsiElement>> myStatements;
    protected final T myHolder;

    PhpStatementsHolder(T holder) {
        this(holder, Collections.emptyList());
        this.myStatements = this.getStatementsInBranches(holder);
    }

    PhpStatementsHolder(T holder, List<List<PsiElement>> statements) {
        this.myHolder = holder;
        this.myStatements = statements;
    }

    public List<PsiElement> getFirstBranchStatements() {
        return (List)ContainerUtil.getFirstItem(this.myStatements);
    }

    public int size() {
        return this.myStatements.size();
    }

    public int getElseStatementsSize() {
        return this.getElseStatement(this.myHolder) != null || this.myStatements.size() > this.getThenStatements(this.myHolder).size() ? ((List)ContainerUtil.getLastItem(this.myStatements)).size() : 0;
    }

    public boolean isValid() {
        return this.myStatements.size() > 1 && !ContainerUtil.exists(this.myStatements, List::isEmpty);
    }

    @NotNull
    protected List<List<PsiElement>> reversedStatements() {
        List list = ContainerUtil.map(this.myStatements, ContainerUtil::reverse);
        if (list == null) {
            PhpStatementsHolder.$$$reportNull$$$0(0);
        }
        return list;
    }

    protected abstract PhpStatementsHolder<T> reversed();

    protected abstract List<Statement> getThenStatements(T var1);

    @Nullable
    protected abstract Statement getElseStatement(T var1);

    @Nullable
    public Statement getElseStatement() {
        return this.getElseStatement(this.myHolder);
    }

    private List<List<PsiElement>> getStatementsInBranches(T holder) {
        ArrayList<List<PsiElement>> res = new ArrayList<List<PsiElement>>();
        boolean lastStatementIsExit = true;
        for (Statement statement : this.getThenStatements(holder)) {
            List<PsiElement> thenStatements = this.getStatements(statement);
            res.add(thenStatements);
            lastStatementIsExit = lastStatementIsExit && this.lastStatementIsExit(thenStatements);
        }
        List<Object> elseStatements = Collections.emptyList();
        Statement elseStatement = this.getElseStatement(holder);
        if (elseStatement != null) {
            elseStatements = this.getStatements(elseStatement);
        } else if (lastStatementIsExit) {
            elseStatements = PhpStatementsHolder.collectNextSiblingStatements(holder);
            for (int i = 0; i < res.size(); ++i) {
                List elements = (List)res.get(i);
                PsiElement lastIfStatement = (PsiElement)ContainerUtil.getLastItem((List)elements);
                if (!(lastIfStatement instanceof PhpReturn) || ((PhpReturn)lastIfStatement).getArgument() != null) continue;
                res.set(i, elements.subList(0, elements.size() - 1));
            }
        }
        res.add(elseStatements);
        return res;
    }

    @NotNull
    protected List<PsiElement> getStatements(Statement statement) {
        List<PsiElement> list = PhpIfWithCommonPartsInspection.getStatements((PsiElement)statement);
        if (list == null) {
            PhpStatementsHolder.$$$reportNull$$$0(1);
        }
        return list;
    }

    public abstract PsiElement getCondition();

    protected boolean lastStatementIsExit(List<PsiElement> statements) {
        PsiElement lastIfStatement = (PsiElement)ContainerUtil.getLastItem(statements);
        return lastIfStatement instanceof PhpContinue || lastIfStatement instanceof PhpReturn || lastIfStatement instanceof PhpBreak;
    }

    private static List<PsiElement> collectNextSiblingStatements(PsiElement statement) {
        ArrayList<PsiElement> res = new ArrayList<PsiElement>();
        PsiElement nextSibling = statement;
        while ((nextSibling = PhpPsiUtil.getNextSiblingIgnoreWhitespace(nextSibling, true)) != null) {
            if (!(nextSibling instanceof PhpPsiElement)) continue;
            res.add(nextSibling);
        }
        return res;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/php/lang/inspections/controlFlow/PhpStatementsHolder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "reversedStatements";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatements";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

