/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.controlFlow;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpArrayAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpEntryPointInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpExitPointInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpAccessVariableInstructionImpl;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpArrayIndexImmediatelyRewrittenInspection;
import com.jetbrains.php.lang.inspections.PhpElementImmediatelyRewrittenInspectionBase;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.controlFlow.PhpArrayUsedOnlyForWriteInspection;
import com.jetbrains.php.lang.inspections.controlFlow.constantCondition.PhpRangeCheckDfaBasedTypeState;
import com.jetbrains.php.lang.inspections.controlFlow.constantCondition.PhpStateArgumentInfo;
import com.jetbrains.php.lang.inspections.type.PhpExpressionAlwaysNullInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpArrayWriteIsNotUsedInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpArrayWriteIsNotUsedInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(this){

            public void visitPhpArrayAccessExpression(ArrayAccessExpression expression) {
                if (PhpPsiUtil.getScopeHolder((PsiElement)expression) instanceof PhpFile) {
                    return;
                }
                PhpArrayAccessInstruction instruction = PhpControlFlowUtil.getAccessInstruction((PhpPsiElement)expression, PhpArrayAccessInstruction.class);
                if (instruction == null) {
                    return;
                }
                PhpAccessInstruction.Access access = instruction.getAccess();
                if (!access.isWrite()) {
                    return;
                }
                Variable variable = PhpArrayWriteIsNotUsedInspection.extractBaseVariable(expression);
                if (variable == null) {
                    return;
                }
                String variableName = variable.getName();
                if (PhpLangUtil.isSuperGlobal(variableName)) {
                    return;
                }
                if (PhpArrayUsedOnlyForWriteInspection.isReferenced(variable) || PhpArrayWriteIsNotUsedInspection.isNotArray((PsiElement)variable)) {
                    return;
                }
                if (!1.followingReadAccessExists((PhpInstruction)instruction, PhpStateArgumentInfo.tryCreateInfo((PsiElement)expression, true))) {
                    PhpAddByRefToParameterQuickFix phpAddByRefToParameterQuickFix;
                    PsiElement onlyAssignedElement = (PsiElement)ContainerUtil.getOnlyItem(PhpArrayWriteIsNotUsedInspection.getAssignedElements((PsiElement)expression, variableName, (PhpInstruction)instruction));
                    if (onlyAssignedElement instanceof Parameter) {
                        Parameter parameter = (Parameter)onlyAssignedElement;
                        phpAddByRefToParameterQuickFix = new PhpAddByRefToParameterQuickFix(parameter);
                    } else {
                        phpAddByRefToParameterQuickFix = null;
                    }
                    PhpAddByRefToParameterQuickFix fix = phpAddByRefToParameterQuickFix;
                    holder.problem((PsiElement)expression, PhpBundle.message("inspection.message.array.write.access.unused", new Object[0])).highlight(ProblemHighlightType.LIKE_UNUSED_SYMBOL).maybeFix((ModCommandAction)fix).register();
                }
            }

            public void visitPhpAssignmentExpression(AssignmentExpression assignmentExpression) {
                PhpPsiElement variable = assignmentExpression.getVariable();
                PhpPsiElement value = assignmentExpression.getValue();
                if (!(value instanceof ArrayCreationExpression)) {
                    return;
                }
                if (PhpPsiUtil.getScopeHolder((PsiElement)assignmentExpression) instanceof PhpFile) {
                    return;
                }
                if (PhpCodeInsightUtil.isResultUsed((PsiElement)assignmentExpression)) {
                    return;
                }
                if (!(variable instanceof Variable) || PhpExpressionAlwaysNullInspection.isReferenced((Variable)variable)) {
                    return;
                }
                PhpArrayIndexImmediatelyRewrittenInspection.processAssignedArrayKeyInfos(assignmentExpression, (info, instruction, key) -> {
                    if (!1.followingReadAccessExists((PhpInstruction)instruction, info)) {
                        holder.registerProblem(key.getParent(), PhpBundle.message("inspection.message.array.key.unused", new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[0]);
                    }
                });
            }

            private static boolean followingReadAccessExists(PhpInstruction instruction, PhpStateArgumentInfo expressionInfo) {
                if (expressionInfo == null) {
                    return true;
                }
                PhpElementImmediatelyRewrittenInspectionBase.PhpElementOverwriteProcessor<ArrayAccessExpression, PhpArrayAccessInstruction> processor2 = new PhpElementImmediatelyRewrittenInspectionBase.PhpElementOverwriteProcessor<ArrayAccessExpression, PhpArrayAccessInstruction>(PhpArrayWriteIsNotUsedInspection.createBase(expressionInfo), expressionInfo, instruction){

                    @Override
                    public boolean processExitPointInstruction(PhpExitPointInstruction instruction) {
                        return true;
                    }
                };
                PhpControlFlowUtil.processSuccessors(instruction, false, processor2);
                return processor2.getImmediatelyRewrittenValue() != null || processor2.isAmbiguous();
            }
        };
    }

    @Nullable
    private static Variable extractBaseVariable(ArrayAccessExpression expression) {
        ArrayAccessExpression e = expression;
        while (e instanceof ArrayAccessExpression) {
            e = e.getValue();
        }
        return (Variable)ObjectUtils.tryCast((Object)e, Variable.class);
    }

    public static boolean isNotArray(PsiElement e) {
        PhpType type = new PhpType().add(e).global(e.getProject()).filterOut(t -> !PhpType.isMixedType((String)t) && PhpType.isNotExtendablePrimitiveType((String)t));
        return !PhpType.isArray((PhpType)type);
    }

    public static Collection<PsiElement> getAssignedElements(final PsiElement expression, final CharSequence variableName, @Nullable PhpInstruction instruction) {
        if (instruction == null) {
            return Collections.emptyList();
        }
        final ArrayList res = new ArrayList();
        final Ref ambiguous = new Ref((Object)false);
        PhpControlFlowUtil.processPredecessors(instruction, false, new PhpInstructionProcessor(){

            public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                if (PhpLangUtil.equalsVariableNames(instruction.getVariableName(), variableName)) {
                    PhpAccessInstruction.Access access = instruction.getAccess();
                    if (access.isWriteRef()) {
                        ambiguous.set((Object)true);
                        this.haltTraversal();
                        return false;
                    }
                    PsiElement value = ((PhpAccessVariableInstructionImpl)instruction).getAssignedValue();
                    if (value != null) {
                        res.add(value);
                        return false;
                    }
                    if (access.isWrite() || access.isReadRef()) {
                        ambiguous.set((Object)true);
                        this.haltTraversal();
                        return false;
                    }
                }
                return super.processAccessVariableInstruction(instruction);
            }

            public boolean processEntryPointInstruction(PhpEntryPointInstruction instruction) {
                Parameter parameter = PhpArrayWriteIsNotUsedInspection.findNonPassByRefParameter(expression, variableName);
                if (parameter == null) {
                    ambiguous.set((Object)true);
                    this.haltTraversal();
                } else {
                    res.add(parameter);
                }
                return super.processEntryPointInstruction(instruction);
            }
        });
        return (Boolean)ambiguous.get() != false ? Collections.emptyList() : res;
    }

    private static Parameter findNonPassByRefParameter(PsiElement expression, CharSequence variableName) {
        com.jetbrains.php.lang.psi.elements.Function function = PhpPsiUtil.getParentOfClass(expression, com.jetbrains.php.lang.psi.elements.Function.class);
        Parameter parameter = function != null ? (Parameter)ContainerUtil.find((Object[])function.getParameters(), p -> PhpLangUtil.equalsParameterNames(p.getName(), variableName)) : null;
        return parameter != null && !parameter.isPassByRef() ? parameter : null;
    }

    private static PhpElementImmediatelyRewrittenInspectionBase<ArrayAccessExpression, PhpArrayAccessInstruction> createBase(final PhpStateArgumentInfo arrayAccessInfo) {
        return new PhpElementImmediatelyRewrittenInspectionBase<ArrayAccessExpression, PhpArrayAccessInstruction>(){

            @Override
            protected Class<ArrayAccessExpression> getElementClass() {
                return ArrayAccessExpression.class;
            }

            @Override
            protected Class<PhpArrayAccessInstruction> getInstructionClass() {
                return PhpArrayAccessInstruction.class;
            }

            @Override
            protected PsiElement getValue(ArrayAccessExpression element) {
                return element.getValue();
            }

            @Override
            @Nls
            @NotNull
            protected String getMessage() {
                String string = PhpBundle.message("inspection.message.array.index.immediately.rewritten.before.accessing", new Object[0]);
                if (string == null) {
                    3.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            protected boolean instructionMayInvalidateDependency(Collection<? extends Function<PhpInstruction, Boolean>> checkers, PhpInstruction instruction) {
                if (arrayAccessInfo instanceof PhpStateArgumentInfo.PhpArrayStateArgumentInfo && ((PhpStateArgumentInfo.PhpArrayStateArgumentInfo)arrayAccessInfo).getIndex() == null) {
                    checkers = ContainerUtil.union(checkers, Collections.singleton(PhpArrayWriteIsNotUsedInspection.createAnyDynamicArrayAccessDependency(arrayAccessInfo.getBaseInfo())));
                }
                return super.instructionMayInvalidateDependency(checkers, instruction);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/lang/inspections/controlFlow/PhpArrayWriteIsNotUsedInspection$3", "getMessage"));
            }
        };
    }

    private static Function<PhpInstruction, Boolean> createAnyDynamicArrayAccessDependency(PhpStateArgumentInfo info) {
        return PhpRangeCheckDfaBasedTypeState.PhpVariableRangeCheckDfaBasedTypeState.createArrayNameDependency(info, info.getArgumentName(), info.getElementPredicate(), true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/controlFlow/PhpArrayWriteIsNotUsedInspection", "buildVisitor"));
    }

    private static class PhpAddByRefToParameterQuickFix
    extends PsiUpdateModCommandAction<Parameter> {
        @NotNull
        @NlsSafe
        private final String myName;

        private PhpAddByRefToParameterQuickFix(Parameter parameter) {
            super((PsiElement)parameter);
            this.myName = parameter.getName();
        }

        @Nullable
        protected Presentation getPresentation(@NotNull ActionContext context, @NotNull Parameter element) {
            if (context == null) {
                PhpAddByRefToParameterQuickFix.$$$reportNull$$$0(0);
            }
            if (element == null) {
                PhpAddByRefToParameterQuickFix.$$$reportNull$$$0(1);
            }
            return Presentation.of((String)PhpBundle.message("intention.name.add.to.parameter", this.myName));
        }

        protected void invoke(@NotNull ActionContext context, @NotNull Parameter startElement, @NotNull ModPsiUpdater updater) {
            if (context == null) {
                PhpAddByRefToParameterQuickFix.$$$reportNull$$$0(2);
            }
            if (startElement == null) {
                PhpAddByRefToParameterQuickFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                PhpAddByRefToParameterQuickFix.$$$reportNull$$$0(4);
            }
            if (startElement.isPassByRef()) {
                return;
            }
            PsiElement anchorToInsertRefBefore = PhpPsiUtil.getChildOfType((PsiElement)startElement, PhpTokenTypes.opVARIADIC);
            if (anchorToInsertRefBefore == null) {
                anchorToInsertRefBefore = startElement.getNameIdentifier();
            }
            if (anchorToInsertRefBefore != null) {
                PsiElement fn = PhpPsiElementFactory.createFromText(context.project(), PhpTokenTypes.opBIT_AND, "function a(&$f) {}");
                startElement.addBefore(fn, anchorToInsertRefBefore);
            }
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.add.to.parameter", new Object[0]);
            if (string == null) {
                PhpAddByRefToParameterQuickFix.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/controlFlow/PhpArrayWriteIsNotUsedInspection$PhpAddByRefToParameterQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/controlFlow/PhpArrayWriteIsNotUsedInspection$PhpAddByRefToParameterQuickFix";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getPresentation";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5 -> new IllegalStateException(string);
            };
        }
    }
}

