/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeStyle;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.codeStyle.PhpNullSafeOperatorCanBeUsedInspection;
import com.jetbrains.php.lang.inspections.controlFlow.PhpSideEffectDetector;
import com.jetbrains.php.lang.intentions.PhpInvertIfIntention;
import com.jetbrains.php.lang.intentions.PhpReplaceIfWithTernaryIntention;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.Else;
import com.jetbrains.php.lang.psi.elements.If;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpIsset;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.TernaryExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpIssetCanBeReplacedWithCoalesceInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpIssetCanBeReplacedWithCoalesceInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(this){

            public void visitPhpTernaryExpression(TernaryExpression expression) {
                if (expression.isShort()) {
                    return;
                }
                PhpPsiElement condition = expression.getCondition();
                PhpPsiElement variant = expression.getTrueVariant();
                if (expression.getFalseVariant() != null && PhpIssetCanBeReplacedWithCoalesceInspection.sameIssetElementsWithoutSideEffects((PsiElement)condition, (PsiElement)variant)) {
                    holder.registerProblem((PsiElement)expression, PhpBundle.message("inspection.message.can.be.replaced.with.version", new Object[0]), new LocalQuickFix[]{PhpReplaceWithCoalesceQuickFix.INSTANCE});
                }
            }

            public void visitPhpIf(If ifStatement) {
                if (ifStatement.getElseIfBranches().length > 0) {
                    return;
                }
                Else elseBranch = ifStatement.getElseBranch();
                if (elseBranch == null) {
                    return;
                }
                Statement thenStatement = PhpInvertIfIntention.getOnlyStatement((PsiElement)ifStatement.getStatement());
                Statement elseStatement = PhpInvertIfIntention.getOnlyStatement((PsiElement)elseBranch.getStatement());
                PsiElement thenExpression = PhpNullSafeOperatorCanBeUsedInspection.getSingleChild((PsiElement)thenStatement);
                PsiElement elseExpression = PhpNullSafeOperatorCanBeUsedInspection.getSingleChild((PsiElement)elseStatement);
                if (thenExpression instanceof AssignmentExpression && elseExpression instanceof AssignmentExpression) {
                    Variable thenVariable = (Variable)ObjectUtils.tryCast((Object)((AssignmentExpression)thenExpression).getVariable(), Variable.class);
                    Variable elseVariable = (Variable)ObjectUtils.tryCast((Object)((AssignmentExpression)elseExpression).getVariable(), Variable.class);
                    if (thenVariable != null && elseVariable != null && PhpLangUtil.equalsVariableNames(thenVariable.getName(), elseVariable.getName())) {
                        PhpPsiElement thenValue = ((AssignmentExpression)thenExpression).getValue();
                        if (PhpIssetCanBeReplacedWithCoalesceInspection.sameIssetElementsWithoutSideEffects((PsiElement)ifStatement.getCondition(), (PsiElement)thenValue)) {
                            holder.registerProblem(ifStatement.getFirstChild(), PhpBundle.message("inspection.message.if.can.be.replaced.with.version", new Object[0]), new LocalQuickFix[]{PhpReplaceIfWithNullCoalesceQuickFix.INSTANCE});
                        }
                    }
                } else if (thenStatement instanceof PhpReturn && elseStatement instanceof PhpReturn && PhpIssetCanBeReplacedWithCoalesceInspection.sameIssetElementsWithoutSideEffects((PsiElement)ifStatement.getCondition(), ((PhpReturn)thenStatement).getArgument()) && ((PhpReturn)elseStatement).getArgument() != null) {
                    holder.registerProblem(ifStatement.getFirstChild(), PhpBundle.message("inspection.message.if.can.be.replaced.with.version", new Object[0]), new LocalQuickFix[]{PhpReplaceIfWithNullCoalesceQuickFix.INSTANCE});
                }
            }
        };
    }

    private static boolean sameIssetElementsWithoutSideEffects(PsiElement condition, PsiElement variant) {
        return PhpIssetCanBeReplacedWithCoalesceInspection.sameIssetElements(condition, variant) && !PhpSideEffectDetector.canContainSideEffect(variant);
    }

    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP700;
    }

    private static boolean sameIssetElements(PsiElement condition, PsiElement variant) {
        PhpExpression[] variables;
        if (condition instanceof PhpIsset && (variables = ((PhpIsset)condition).getVariables()).length == 1) {
            return PhpPsiUtil.areElementsEquivalent((PsiElement)variables[0], variant);
        }
        return false;
    }

    private static void replaceTernaryExpressionWithNullCoalesce(TernaryExpression ternaryExpression) {
        PhpPsiElement trueVariant = ternaryExpression.getTrueVariant();
        PhpPsiElement falseVariant = ternaryExpression.getFalseVariant();
        if (trueVariant == null || falseVariant == null) {
            return;
        }
        ternaryExpression.replace((PsiElement)PhpPsiElementFactory.createPhpPsiFromText(ternaryExpression.getProject(), BinaryExpression.class, trueVariant.getText() + " ?? " + falseVariant.getText()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/codeStyle/PhpIssetCanBeReplacedWithCoalesceInspection", "buildVisitor"));
    }

    private static class PhpReplaceIfWithNullCoalesceQuickFix
    extends PsiUpdateModCommandQuickFix {
        static final LocalQuickFix INSTANCE = new PhpReplaceIfWithNullCoalesceQuickFix();

        private PhpReplaceIfWithNullCoalesceQuickFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.replace.if.with.version", new Object[0]);
            if (string == null) {
                PhpReplaceIfWithNullCoalesceQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            If anIf;
            PsiElement replacedIf;
            if (project == null) {
                PhpReplaceIfWithNullCoalesceQuickFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                PhpReplaceIfWithNullCoalesceQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpReplaceIfWithNullCoalesceQuickFix.$$$reportNull$$$0(3);
            }
            if ((replacedIf = PhpReplaceIfWithTernaryIntention.replaceWithTernary(anIf = (If)element.getParent())) == null) {
                return;
            }
            TernaryExpression ternaryExpression = (TernaryExpression)PsiTreeUtil.findChildOfAnyType((PsiElement)replacedIf, (Class[])new Class[]{TernaryExpression.class});
            if (ternaryExpression == null) {
                return;
            }
            PhpIssetCanBeReplacedWithCoalesceInspection.replaceTernaryExpressionWithNullCoalesce(ternaryExpression);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeStyle/PhpIssetCanBeReplacedWithCoalesceInspection$PhpReplaceIfWithNullCoalesceQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeStyle/PhpIssetCanBeReplacedWithCoalesceInspection$PhpReplaceIfWithNullCoalesceQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class PhpReplaceWithCoalesceQuickFix
    extends PsiUpdateModCommandQuickFix {
        static final LocalQuickFix INSTANCE = new PhpReplaceWithCoalesceQuickFix();

        private PhpReplaceWithCoalesceQuickFix() {
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.replace.with.version", new Object[0]);
            if (string == null) {
                PhpReplaceWithCoalesceQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                PhpReplaceWithCoalesceQuickFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                PhpReplaceWithCoalesceQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpReplaceWithCoalesceQuickFix.$$$reportNull$$$0(3);
            }
            TernaryExpression ternaryExpression = (TernaryExpression)element;
            PhpIssetCanBeReplacedWithCoalesceInspection.replaceTernaryExpressionWithNullCoalesce(ternaryExpression);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeStyle/PhpIssetCanBeReplacedWithCoalesceInspection$PhpReplaceWithCoalesceQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeStyle/PhpIssetCanBeReplacedWithCoalesceInspection$PhpReplaceWithCoalesceQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

