/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeStyle;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.Strings;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.controlFlow.PhpSideEffectDetector;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.patterns.PhpPatterns;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.ParenthesizedExpression;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpIsset;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class PhpCombineMultipleIssetCallsIntoOneInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpCombineMultipleIssetCallsIntoOneInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(this){

            public void visitPhpBinaryExpression(BinaryExpression expression) {
                if (!PhpCombineMultipleIssetCallsIntoOneInspection.isTopmostLogicalAndExpression(expression)) {
                    return;
                }
                Collection<PsiElement> operands = PhpPatterns.unwrapOperation((PsiElement)expression, PhpTokenTypes.opAND);
                List<List<PhpIsset>> mergeableIssetsList = PhpCombineMultipleIssetCallsIntoOneInspection.groupMergeableIssets(operands);
                for (List<PhpIsset> mergeableIssets : mergeableIssetsList) {
                    this.registerProblems(mergeableIssets, expression);
                }
            }

            private void registerProblems(List<PhpIsset> issetCalls, BinaryExpression expression) {
                for (PsiElement psiElement : issetCalls) {
                    holder.registerProblem(psiElement, PhpBundle.message("inspection.message.multiple.isset.calls.can.be.combined.into.one", new Object[0]), new LocalQuickFix[]{new PhpCombineMultipleIssetCallsIntoOneFix(expression, psiElement)});
                    if (isOnTheFly) continue;
                    break;
                }
            }
        };
    }

    private static List<List<PhpIsset>> groupMergeableIssets(Collection<PsiElement> operands) {
        return ((StreamEx)StreamEx.of(operands).groupRuns((e1, e2) -> !PhpSideEffectDetector.canContainSideEffect(e1) == !PhpSideEffectDetector.canContainSideEffect(e2)).map(list -> ContainerUtil.filterIsInstance((Collection)list, PhpIsset.class)).filter(list -> list.size() >= 2)).toList();
    }

    public static boolean isTopmostLogicalAndExpression(BinaryExpression expression) {
        PsiElement parent = PsiTreeUtil.skipParentsOfType((PsiElement)expression, (Class[])new Class[]{ParenthesizedExpression.class});
        return !(parent instanceof BinaryExpression) || ((BinaryExpression)parent).getOperationType() != PhpTokenTypes.opAND;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/codeStyle/PhpCombineMultipleIssetCallsIntoOneInspection", "buildVisitor"));
    }

    private static class PhpCombineMultipleIssetCallsIntoOneFix
    extends LocalQuickFixOnPsiElement {
        private PhpCombineMultipleIssetCallsIntoOneFix(BinaryExpression binaryExpression, PsiElement selectedPhpIsset) {
            super((PsiElement)binaryExpression, selectedPhpIsset);
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.combine.multiple.isset.calls.into.one", new Object[0]);
            if (string == null) {
                PhpCombineMultipleIssetCallsIntoOneFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getText() {
            String string = this.getFamilyName();
            if (string == null) {
                PhpCombineMultipleIssetCallsIntoOneFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile psiFile, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            List<PsiElement> expressionsAfterFirstIsset;
            if (project == null) {
                PhpCombineMultipleIssetCallsIntoOneFix.$$$reportNull$$$0(2);
            }
            if (psiFile == null) {
                PhpCombineMultipleIssetCallsIntoOneFix.$$$reportNull$$$0(3);
            }
            if (startElement == null) {
                PhpCombineMultipleIssetCallsIntoOneFix.$$$reportNull$$$0(4);
            }
            if (endElement == null) {
                PhpCombineMultipleIssetCallsIntoOneFix.$$$reportNull$$$0(5);
            }
            BinaryExpression logicalAndExpression = (BinaryExpression)ObjectUtils.tryCast((Object)startElement, BinaryExpression.class);
            PhpIsset selectedIssetCall = (PhpIsset)ObjectUtils.tryCast((Object)endElement, PhpIsset.class);
            if (logicalAndExpression == null || selectedIssetCall == null) {
                return;
            }
            ArrayList<PsiElement> expressions = new ArrayList<PsiElement>(PhpPatterns.unwrapOperation((PsiElement)logicalAndExpression, PhpTokenTypes.opAND));
            List phpIssets = (List)ContainerUtil.find(PhpCombineMultipleIssetCallsIntoOneInspection.groupMergeableIssets(expressions), block -> block.contains(selectedIssetCall));
            if (phpIssets.isEmpty()) {
                return;
            }
            List<PsiElement> expressionsBeforeFirstIsset = PhpCombineMultipleIssetCallsIntoOneFix.getElementsBeforeFirst(expressions, phpIssets);
            PhpExpression newLogicalAndExpression = PhpCombineMultipleIssetCallsIntoOneFix.constructLogicalAndExpressionMergingIssetCalls(project, expressionsBeforeFirstIsset, phpIssets, expressionsAfterFirstIsset = PhpCombineMultipleIssetCallsIntoOneFix.getElementsAfterFirst(expressions, phpIssets));
            if (newLogicalAndExpression == null) {
                return;
            }
            logicalAndExpression.replace((PsiElement)newLogicalAndExpression);
        }

        private static @Unmodifiable @NotNull List<PsiElement> getElementsAfterFirst(List<PsiElement> expressions, List<PhpIsset> highlightedIssets) {
            PsiElement firstItem = (PsiElement)ContainerUtil.getFirstItem(highlightedIssets);
            if (firstItem == null) {
                List<PsiElement> list = Collections.emptyList();
                if (list == null) {
                    PhpCombineMultipleIssetCallsIntoOneFix.$$$reportNull$$$0(6);
                }
                return list;
            }
            int index = expressions.indexOf(firstItem);
            if (index < 0) {
                List<PsiElement> list = Collections.emptyList();
                if (list == null) {
                    PhpCombineMultipleIssetCallsIntoOneFix.$$$reportNull$$$0(7);
                }
                return list;
            }
            List list = ContainerUtil.filter((Collection)ContainerUtil.subList(expressions, (int)index), e -> !highlightedIssets.contains(e));
            if (list == null) {
                PhpCombineMultipleIssetCallsIntoOneFix.$$$reportNull$$$0(8);
            }
            return list;
        }

        @NotNull
        private static List<PsiElement> getElementsBeforeFirst(List<PsiElement> expressions, List<PhpIsset> highlightedIssets) {
            PsiElement firstItem = (PsiElement)ContainerUtil.getFirstItem(highlightedIssets);
            if (firstItem == null) {
                List<PsiElement> list = Collections.emptyList();
                if (list == null) {
                    PhpCombineMultipleIssetCallsIntoOneFix.$$$reportNull$$$0(9);
                }
                return list;
            }
            int index = expressions.indexOf(firstItem);
            if (index < 0) {
                List<PsiElement> list = Collections.emptyList();
                if (list == null) {
                    PhpCombineMultipleIssetCallsIntoOneFix.$$$reportNull$$$0(10);
                }
                return list;
            }
            List<PsiElement> list = expressions.subList(0, index);
            if (list == null) {
                PhpCombineMultipleIssetCallsIntoOneFix.$$$reportNull$$$0(11);
            }
            return list;
        }

        @Nullable
        private static PhpExpression constructLogicalAndExpressionMergingIssetCalls(@NotNull Project project, List<PsiElement> expressionsBeforeFirstIsset, List<PhpIsset> phpIssets, List<PsiElement> otherExpressionsAfterFirstIsset) {
            if (project == null) {
                PhpCombineMultipleIssetCallsIntoOneFix.$$$reportNull$$$0(12);
            }
            ArrayList<CallSite> exprToConcat = new ArrayList<CallSite>(ContainerUtil.map(expressionsBeforeFirstIsset, e -> e.getText()));
            exprToConcat.add((CallSite)((Object)("isset(" + phpIssets.stream().flatMap(isset -> Arrays.stream(isset.getVariables()).map(v -> v.getText())).collect(Collectors.joining(", ")) + ")")));
            exprToConcat.addAll(ContainerUtil.map(otherExpressionsAfterFirstIsset, e -> e.getText()));
            return PhpPsiElementFactory.createFirstFromText(project, PhpExpression.class, Strings.join(exprToConcat, (String)" && "));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4, 5, 12 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeStyle/PhpCombineMultipleIssetCallsIntoOneInspection$PhpCombineMultipleIssetCallsIntoOneFix";
                    break;
                }
                case 2: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFile";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeStyle/PhpCombineMultipleIssetCallsIntoOneInspection$PhpCombineMultipleIssetCallsIntoOneFix";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getElementsAfterFirst";
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getElementsBeforeFirst";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "constructLogicalAndExpressionMergingIssetCalls";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4, 5, 12 -> new IllegalArgumentException(string);
            };
        }
    }
}

