/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeSmell;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.annotator.PhpDeleteElementQuickFix;
import com.jetbrains.php.lang.documentation.phpdoc.PhpDocUtil;
import com.jetbrains.php.lang.documentation.phpdoc.parser.PhpDocStubElementTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.phpdoc.PhpDocSignatureIsNotCompleteInspection;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpAttribute;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.ParameterListImpl;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpParametersDefaultValueMatchersIndex;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class PhpRedundantMethodOverrideInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpRedundantMethodOverrideInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(this){

            public void visitPhpMethod(Method method) {
                Ref hasSuperMethod;
                boolean sameAccessAndAttributes;
                PhpClass clazz = method.getContainingClass();
                if (clazz == null || clazz.isTrait() || clazz.isInterface()) {
                    return;
                }
                if (method.isStatic() || method.isFinal() || method.isAbstract()) {
                    return;
                }
                if (method.getMethodType(false) == Method.MethodType.CONSTRUCTOR) {
                    return;
                }
                PhpDocComment comment = method.getDocComment();
                if (comment != null && !PhpDocUtil.hasOnlyTagWithName(comment, "@inheritDoc") && !PhpDocSignatureIsNotCompleteInspection.RemovePhpDocSignatureTagsQuickFix.isEmptyPhpDoc(comment)) {
                    return;
                }
                if (!PhpRedundantMethodOverrideInspection.bodyConsistsOnlyOfParentCallWithSameArguments(method)) {
                    return;
                }
                if (method.getNameIdentifier() != null && (sameAccessAndAttributes = PhpClassHierarchyUtils.processSuperMethods((Method)method, (arg_0, arg_1, arg_2) -> 1.lambda$visitPhpMethod$0(hasSuperMethod = Ref.create((Object)false), method, arg_0, arg_1, arg_2))) && ((Boolean)hasSuperMethod.get()).booleanValue()) {
                    holder.problem(method.getNameIdentifier(), PhpBundle.message("inspection.message.redundant.method.override", new Object[0])).fix((ModCommandAction)new PhpDeleteElementQuickFix((PsiElement)method, PhpBundle.message("delete.redundant.method.override", new Object[0]), (IElementType)(comment != null ? PhpDocStubElementTypes.DOC_COMMENT : null))).register();
                }
            }

            private static /* synthetic */ boolean lambda$visitPhpMethod$0(Ref hasSuperMethod, Method method, Method superMethod, PhpClass subClass, PhpClass baseClass) {
                hasSuperMethod.set((Object)true);
                if (superMethod instanceof PhpDocMethod) {
                    return false;
                }
                if (superMethod.getAccess().getLevel() != method.getAccess().getLevel()) {
                    return false;
                }
                if (!PhpRedundantMethodOverrideInspection.checkEqualAttributes(method.getAttributes(), superMethod.getAttributes())) {
                    return false;
                }
                if (!PhpRedundantMethodOverrideInspection.checkEqualParameterAttributes(method, superMethod)) {
                    return false;
                }
                return PhpRedundantMethodOverrideInspection.checkEqualDefaultValues(method, superMethod);
            }
        };
    }

    private static boolean checkEqualDefaultValues(@NotNull Method method, @NotNull Method superMethod) {
        if (method == null) {
            PhpRedundantMethodOverrideInspection.$$$reportNull$$$0(1);
        }
        if (superMethod == null) {
            PhpRedundantMethodOverrideInspection.$$$reportNull$$$0(2);
        }
        @NotNull List<Map<String, PhpParametersDefaultValueMatchersIndex.PhpParameterDefaultValueMatcher>> matchersList = PhpParametersDefaultValueMatchersIndex.getParameterDefaultValuesMatchers((Function)superMethod);
        Parameter[] parameters = method.getParameters();
        Project project = method.getProject();
        for (Parameter parameter : parameters) {
            PsiElement defaultValue = parameter.getDefaultValue();
            if (matchersList.isEmpty() && defaultValue != null) {
                return false;
            }
            for (Map<String, PhpParametersDefaultValueMatchersIndex.PhpParameterDefaultValueMatcher> matchers : matchersList) {
                PhpParametersDefaultValueMatchersIndex.PhpParameterDefaultValueMatcher matcher = matchers.get(parameter.getName());
                if ((matcher != null || defaultValue == null) && (matcher == null || matcher.matches(defaultValue))) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean bodyConsistsOnlyOfParentCallWithSameArguments(Method method) {
        Object groupStatement = PhpPsiUtil.getChildByCondition((PsiElement)method, (Condition<? super PsiElement>)GroupStatement.INSTANCEOF);
        PsiElement statement = (PsiElement)ContainerUtil.getOnlyItem(PhpPsiUtil.getChildren(groupStatement, (Condition<? super PsiElement>)Statement.INSTANCEOF));
        if (statement == null) {
            return false;
        }
        PsiElement statementToCheck = statement instanceof PhpReturn ? ((PhpReturn)statement).getArgument() : statement.getFirstChild();
        MethodReference methodReference = (MethodReference)ObjectUtils.tryCast((Object)statementToCheck, MethodReference.class);
        if (methodReference == null) {
            return false;
        }
        PhpExpression classReference = methodReference.getClassReference();
        if (classReference == null || !"parent".equalsIgnoreCase(classReference.getName())) {
            return false;
        }
        if (!method.getName().equalsIgnoreCase(methodReference.getName())) {
            return false;
        }
        List<Parameter> parameters = Arrays.asList(method.getParameters());
        List<PsiElement> arguments = Arrays.asList(methodReference.getParameters());
        if (parameters.size() != arguments.size()) {
            return false;
        }
        for (Pair paramArg : ContainerUtil.zip(parameters, arguments)) {
            PsiElement nameIdentifier = ((Parameter)paramArg.first).getNameIdentifier();
            PsiElement argument = (PsiElement)paramArg.getSecond();
            if (nameIdentifier == null || !(argument instanceof Variable) || !nameIdentifier.getText().equals(argument.getText())) {
                return false;
            }
            PsiElement namedArgumentPart = ParameterListImpl.getNameIdentifier(argument);
            if (namedArgumentPart == null || ((Parameter)paramArg.first).getName().equals(namedArgumentPart.getText())) continue;
            return false;
        }
        return true;
    }

    private static boolean checkEqualParameterAttributes(Method method, Method superMethod) {
        Parameter[] superParameters;
        Parameter[] parameters = method.getParameters();
        if (parameters.length != (superParameters = superMethod.getParameters()).length) {
            return false;
        }
        for (int i = 0; i < parameters.length; ++i) {
            if (PhpRedundantMethodOverrideInspection.checkEqualAttributes(parameters[i].getAttributes(), superParameters[i].getAttributes())) continue;
            return false;
        }
        return true;
    }

    private static boolean checkEqualAttributes(Collection<PhpAttribute> attributes, Collection<PhpAttribute> superAttributes) {
        for (PhpAttribute attribute2 : attributes) {
            if (ContainerUtil.exists(superAttributes, superAttribute -> PhpRedundantMethodOverrideInspection.equalAttributes(attribute2, superAttribute))) continue;
            return false;
        }
        for (PhpAttribute superAttribute2 : superAttributes) {
            if (ContainerUtil.exists(attributes, attribute -> PhpRedundantMethodOverrideInspection.equalAttributes(superAttribute2, attribute))) continue;
            return false;
        }
        return true;
    }

    private static boolean equalAttributes(PhpAttribute attribute, PhpAttribute superAttribute) {
        if (PhpLangUtil.equalsClassNames(attribute.getFQN(), superAttribute.getFQN())) {
            return ContainerUtil.all((Collection)attribute.getArguments(), superAttribute.getArguments()::contains);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superMethod";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/codeSmell/PhpRedundantMethodOverrideInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "checkEqualDefaultValues";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

