/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeSmell;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessFieldByVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessFieldInObjectContextInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpArrayAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpCallInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpEntryPointInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.deadcode.PhpUnusedDeclarationInspection;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpPropertyOnlyWrittenInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpPropertyOnlyWrittenInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(this){

            public void visitPhpClass(PhpClass clazz) {
                if (clazz.getTraitNames().length > 0 || clazz.isTrait()) {
                    return;
                }
                Map privateProperties = ((StreamEx)StreamEx.of((Object[])clazz.getOwnFields()).filter(f -> f.getModifier().isPrivate())).toMap(PhpNamedElement::getName, Function.identity(), (f1, f2) -> f1);
                if (privateProperties.isEmpty()) {
                    return;
                }
                HashSet<@Nullable Field> writtenProperties = new HashSet<Field>();
                HashSet<@Nullable Field> readProperties = new HashSet<Field>();
                List hooks = Arrays.stream(clazz.getOwnFields()).flatMap(f -> StreamEx.of((Collection)f.getPropertyHooksList())).toList();
                List methods = StreamEx.of((Object[])clazz.getOwnMethods()).append(hooks).toList();
                for (Method method : methods) {
                    if (privateProperties.isEmpty()) {
                        return;
                    }
                    if (method instanceof PhpDocMethod) continue;
                    this.processProperties(privateProperties, writtenProperties, readProperties, method);
                }
                for (Field field : privateProperties.values()) {
                    if (writtenProperties.contains(field) && !readProperties.contains(field) && !readProperties.contains(null)) {
                        1.tryRegisterProblem(field, PhpBundle.message("inspection.message.property.only.written.but.never.read", new Object[0]), holder);
                        continue;
                    }
                    if (!readProperties.contains(field) || writtenProperties.contains(field) || writtenProperties.contains(null) || field.getDefaultValue() != null) continue;
                    1.tryRegisterProblem(field, PhpBundle.message("inspection.message.property.only.read.but.never.written", new Object[0]), holder);
                }
            }

            private static void tryRegisterProblem(Field field, @InspectionMessage String message, @NotNull ProblemsHolder holder2) {
                if (holder2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!PhpPropertyOnlyWrittenInspection.isEntryPoint((PsiElement)field)) {
                    holder2.registerProblem((PsiElement)field, message, new LocalQuickFix[0]);
                }
            }

            private void processProperties(final Map<String, Field> privateProperties, final Set<Field> writtenProperties, final Set<Field> readProperties, final Method method) {
                PhpEntryPointInstruction entryPoint = method.getControlFlow().getEntryPoint();
                PhpControlFlowUtil.processSuccessors((PhpInstruction)entryPoint, false, new PhpControlFlowUtil.PhpClosureVisitingInstructionProcessor(this){

                    public boolean processArrayAccessInstruction(PhpArrayAccessInstruction instruction) {
                        if (!super.processArrayAccessInstruction(instruction)) {
                            return false;
                        }
                        ArrayAccessExpression anchor = (ArrayAccessExpression)instruction.getAnchor();
                        PhpPsiElement value = anchor.getValue();
                        while (value instanceof ArrayAccessExpression) {
                            value = ((ArrayAccessExpression)value).getValue();
                        }
                        if (value instanceof FieldReference) {
                            this.processFieldReference((PhpAccessInstruction)instruction, (FieldReference)value);
                        }
                        return true;
                    }

                    @Override
                    public boolean processInstruction(PhpInstruction instruction) {
                        if (privateProperties.isEmpty()) {
                            return false;
                        }
                        return super.processInstruction(instruction);
                    }

                    public boolean processAccessFieldByVariableInstruction(PhpAccessFieldByVariableInstruction instruction) {
                        if (!super.processAccessFieldByVariableInstruction(instruction)) {
                            return false;
                        }
                        FieldReference reference = instruction.getFieldReference();
                        if (reference != null && reference.getParent() instanceof ArrayAccessExpression) {
                            return true;
                        }
                        this.processFieldReference((PhpAccessInstruction)instruction, instruction.getFieldName(), reference, instruction.resolveFields()::contains);
                        return true;
                    }

                    public boolean processAccessFieldInObjectContextInstruction(PhpAccessFieldInObjectContextInstruction instruction) {
                        if (!super.processAccessFieldInObjectContextInstruction(instruction)) {
                            return false;
                        }
                        FieldReference reference = (FieldReference)instruction.getAnchor();
                        if (reference.getParent() instanceof ArrayAccessExpression) {
                            return true;
                        }
                        this.processFieldReference((PhpAccessInstruction)instruction, reference);
                        return true;
                    }

                    private void processFieldReference(@NotNull PhpAccessInstruction instruction, @Nullable FieldReference reference) {
                        if (instruction == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (reference != null) {
                            this.processFieldReference(instruction, reference.getName(), reference, f -> PhpPropertyOnlyWrittenInspection.resolvedToField(reference, f));
                        }
                    }

                    private void processFieldReference(@NotNull PhpAccessInstruction instruction, CharSequence name, FieldReference reference, Predicate<Field> resolvedToFieldPredicate) {
                        if (instruction == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        Field field = (Field)privateProperties.get(name);
                        if (privateProperties.containsKey(name) && resolvedToFieldPredicate.test(field) || StringUtil.isEmpty((CharSequence)name) && reference != null && 1.isFromContainingClass(reference, method)) {
                            PhpAccessInstruction.Access access = instruction.getAccess();
                            if (access.isWrite() || access.isUnset()) {
                                writtenProperties.add(field);
                            } else if (access.isRead() || access.isLightRead()) {
                                readProperties.add(field);
                            } else {
                                privateProperties.remove(name);
                            }
                            if (readProperties.contains(field) && writtenProperties.contains(field)) {
                                if (field == null) {
                                    privateProperties.clear();
                                } else {
                                    privateProperties.remove(name);
                                }
                            }
                        }
                    }

                    public boolean processPhpCallInstruction(PhpCallInstruction instruction) {
                        if (PhpCodeInsightUtil.isGlobalFunctionCallWithName(instruction.getFunctionReference(), "get_object_vars")) {
                            readProperties.addAll(privateProperties.values());
                            return false;
                        }
                        return true;
                    }

                    /*
                     * Issues handling annotations - annotations may be inaccurate
                     */
                    private static boolean isFromContainingClass(FieldReference fieldReference, Method method2) {
                        PhpIndex index = PhpIndex.getInstance((Project)fieldReference.getProject());
                        PhpClass containingClass = method2.getContainingClass();
                        @NlsSafe Set classes = new PhpType().add((PsiElement)fieldReference.getClassReference()).global(fieldReference.getProject()).getTypes();
                        return classes.isEmpty() || classes.stream().flatMap(fqn -> index.getAnyByFQN(fqn).stream()).anyMatch(phpClass -> phpClass == containingClass);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "com/jetbrains/php/lang/inspections/codeSmell/PhpPropertyOnlyWrittenInspection$1$1", "processFieldReference"));
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/codeSmell/PhpPropertyOnlyWrittenInspection$1", "tryRegisterProblem"));
            }
        };
    }

    private static boolean resolvedToField(@NotNull FieldReference reference, Field field) {
        if (reference == null) {
            PhpPropertyOnlyWrittenInspection.$$$reportNull$$$0(1);
        }
        return ContainerUtil.exists((Object[])reference.multiResolve(false), e -> e.getElement() == field);
    }

    public static boolean isEntryPoint(PsiElement f) {
        return ContainerUtil.exists((Object[])PhpUnusedDeclarationInspection.getExtensions(), e -> e.isSelected() && e.isEntryPoint(f));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/codeSmell/PhpPropertyOnlyWrittenInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "resolvedToField";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

