/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeSmell;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpForeachEndHostInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.PhpForeachStartHostInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpBreakContinueInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpHostInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpStatementInstruction;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.ArrayHashElement;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.ArrayCreationExpressionImpl;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.refactoring.unwrap.PhpForeachUnwrapper;
import com.jetbrains.php.refactoring.unwrap.PhpUnwrapper;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpForeachOverSingleElementArrayLiteralInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpForeachOverSingleElementArrayLiteralInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpForeach(ForeachStatement foreach) {
                PsiElement array = foreach.getArray();
                if (array instanceof ArrayCreationExpression && ArrayCreationExpressionImpl.children((ArrayCreationExpression)array).limit(2).size() == 1 && !PhpForeachOverSingleElementArrayLiteralInspection.this.containsBreakOrContinue(foreach)) {
                    holder.problem(foreach.getFirstChild(), PhpBundle.message("inspection.message.foreach.over.array.literal.with.single.element", new Object[0])).fix((ModCommandAction)new PhpUnwrapForeachQuickFix(foreach)).register();
                }
            }
        };
    }

    private boolean containsBreakOrContinue(final ForeachStatement foreach) {
        PhpScopeHolder scopeHolder = PhpPsiUtil.getScopeHolder((PsiElement)foreach);
        if (scopeHolder == null) {
            return true;
        }
        PhpStatementInstruction instruction = PhpControlFlowUtil.getStatementInstruction(scopeHolder.getControlFlow(), (Statement)foreach);
        if (instruction == null) {
            return true;
        }
        PhpForeachStartHostInstructionImpl foreachStartInstruction = this.findForeachStartInstruction(instruction);
        if (foreachStartInstruction == null) {
            return true;
        }
        final Ref containsBreakOrContinue = new Ref((Object)false);
        PhpControlFlowUtil.processSuccessors(foreachStartInstruction, false, new PhpInstructionProcessor(this){

            public boolean processBreakContinueInstruction(PhpBreakContinueInstruction instruction) {
                if (instruction.getTargetStatement() == foreach) {
                    containsBreakOrContinue.set((Object)true);
                    return false;
                }
                return true;
            }

            public boolean processHostInstruction(PhpHostInstruction instruction) {
                if (instruction instanceof PhpForeachEndHostInstructionImpl && instruction.getAnchor() == foreach) {
                    return false;
                }
                return super.processHostInstruction(instruction);
            }
        });
        return (Boolean)containsBreakOrContinue.get();
    }

    private PhpForeachStartHostInstructionImpl findForeachStartInstruction(PhpStatementInstruction statementInstruction) {
        final ArrayList res = new ArrayList();
        PhpControlFlowUtil.processSuccessors((PhpInstruction)statementInstruction, false, new PhpInstructionProcessor(this){

            public boolean processHostInstruction(PhpHostInstruction instruction) {
                if (instruction instanceof PhpForeachStartHostInstructionImpl) {
                    res.add((PhpForeachStartHostInstructionImpl)instruction);
                    return false;
                }
                return super.processHostInstruction(instruction);
            }
        });
        return (PhpForeachStartHostInstructionImpl)((Object)ContainerUtil.getOnlyItem(res));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/codeSmell/PhpForeachOverSingleElementArrayLiteralInspection", "buildVisitor"));
    }

    private static class PhpUnwrapForeachQuickFix
    extends PsiUpdateModCommandAction<ForeachStatement> {
        private PhpUnwrapForeachQuickFix(ForeachStatement foreach) {
            super((PsiElement)foreach);
        }

        protected void invoke(@NotNull ActionContext context, @NotNull ForeachStatement foreach, @NotNull ModPsiUpdater updater) {
            ArrayCreationExpression array;
            if (context == null) {
                PhpUnwrapForeachQuickFix.$$$reportNull$$$0(0);
            }
            if (foreach == null) {
                PhpUnwrapForeachQuickFix.$$$reportNull$$$0(1);
            }
            if (updater == null) {
                PhpUnwrapForeachQuickFix.$$$reportNull$$$0(2);
            }
            if ((array = (ArrayCreationExpression)foreach.getArray()) == null) {
                return;
            }
            PhpPsiElement arrayElement = (PhpPsiElement)ArrayCreationExpressionImpl.children(array).first().orNull();
            if (arrayElement == null) {
                return;
            }
            Variable key = foreach.getKey();
            Variable value = foreach.getValue();
            PhpUnwrapForeachQuickFix.addAssignmentsFromArrayElement((PsiElement)foreach, arrayElement, key, value);
            new PhpForeachUnwrapper().unwrapElement((PsiElement)foreach, new PhpUnwrapper.Context(true));
        }

        private static void addAssignmentsFromArrayElement(@NotNull PsiElement foreach, PhpPsiElement arrayElement, Variable key, Variable value) {
            if (foreach == null) {
                PhpUnwrapForeachQuickFix.$$$reportNull$$$0(3);
            }
            PhpPsiElement elementValue = arrayElement instanceof ArrayHashElement ? ((ArrayHashElement)arrayElement).getValue() : arrayElement.getFirstPsiChild();
            PhpPsiElement elementKey = arrayElement instanceof ArrayHashElement ? ((ArrayHashElement)arrayElement).getKey() : null;
            PsiElement anchor = PhpUnwrapForeachQuickFix.putAssignmentBefore(foreach, value, elementValue != null ? elementValue.getText() : null);
            PhpUnwrapForeachQuickFix.putAssignmentBefore(anchor, key, elementKey != null ? elementKey.getText() : "0");
        }

        @NotNull
        private static PsiElement putAssignmentBefore(@NotNull PsiElement anchor, @Nullable Variable variable, @NlsSafe @Nullable String valueText) {
            if (anchor == null) {
                PhpUnwrapForeachQuickFix.$$$reportNull$$$0(4);
            }
            if (variable != null && valueText != null) {
                Statement statement = PhpPsiElementFactory.createStatement(variable.getProject(), String.format("%s = %s;", variable.getText(), valueText));
                PsiElement psiElement = anchor.getParent().addBefore((PsiElement)statement, anchor);
                if (psiElement == null) {
                    PhpUnwrapForeachQuickFix.$$$reportNull$$$0(5);
                }
                return psiElement;
            }
            PsiElement psiElement = anchor;
            if (psiElement == null) {
                PhpUnwrapForeachQuickFix.$$$reportNull$$$0(6);
            }
            return psiElement;
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.unwrap.foreach", new Object[0]);
            if (string == null) {
                PhpUnwrapForeachQuickFix.$$$reportNull$$$0(7);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5, 6, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "foreach";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "anchor";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeSmell/PhpForeachOverSingleElementArrayLiteralInspection$PhpUnwrapForeachQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeSmell/PhpForeachOverSingleElementArrayLiteralInspection$PhpUnwrapForeachQuickFix";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "putAssignmentBefore";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "addAssignmentsFromArrayElement";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "putAssignmentBefore";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5, 6, 7 -> new IllegalStateException(string);
            };
        }
    }
}

