/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeSmell;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.typeInference.PhpDfaBaseStateConditionDFAnalyzer;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.codeSmell.PhpInstanceofIsAlwaysTrueInspection;
import com.jetbrains.php.lang.inspections.controlFlow.PhpSideEffectDetector;
import com.jetbrains.php.lang.inspections.type.PhpExpressionAlwaysConstantEvaluator;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpDuplicateOperandInComparisonInspection
extends PhpInspection {
    private static final Map<IElementType, PhpType> SUPPORTED_TOKENS = Map.of(PhpTokenTypes.opPLUS, PhpType.FLOAT_INT, PhpTokenTypes.opMINUS, PhpType.FLOAT_INT, PhpTokenTypes.opMUL, PhpType.FLOAT_INT, PhpTokenTypes.opAND, PhpType.BOOLEAN, PhpTokenTypes.opOR, PhpType.BOOLEAN, PhpTokenTypes.opCONCAT, PhpType.STRING);

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpDuplicateOperandInComparisonInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(this){

            public void visitPhpBinaryExpression(BinaryExpression expression) {
                PsiElement operation = expression.getOperation();
                if (!PhpPsiUtil.isOfType(operation, PhpTokenTypes.tsCOMPARE_OPS)) {
                    return;
                }
                PsiElement left = PhpPsiUtil.unparenthesize(expression.getLeftOperand());
                PsiElement right = PhpPsiUtil.unparenthesize(expression.getRightOperand());
                if (left == null || right == null) {
                    return;
                }
                if (left instanceof BinaryExpression && right instanceof BinaryExpression) {
                    IElementType operationType = ((BinaryExpression)left).getOperationType();
                    if (operationType != ((BinaryExpression)right).getOperationType() || !SUPPORTED_TOKENS.containsKey(operationType)) {
                        return;
                    }
                    PhpDuplicateOperandDescriptor descriptor = PhpDuplicateOperandInComparisonInspection.getDuplicateOperandDescriptor((BinaryExpression)left, (BinaryExpression)right);
                    if (descriptor != null && !PhpSideEffectDetector.canContainSideEffect(descriptor.myDuplicateOperand) && PhpDuplicateOperandInComparisonInspection.typeMatches(descriptor.myLeftOperandToRemain, descriptor.myDuplicateOperand, SUPPORTED_TOKENS.get(operationType)) && PhpDuplicateOperandInComparisonInspection.typeMatches(descriptor.myRightOperandToRemain, descriptor.myDuplicateOperand, SUPPORTED_TOKENS.get(operationType))) {
                        if (operationType == PhpTokenTypes.opMUL && !PhpDuplicateOperandInComparisonInspection.isNonZeroNumber(descriptor.myDuplicateOperand)) {
                            return;
                        }
                        holder.registerProblem((PsiElement)expression, PhpBundle.message("inspection.message.expression.have.duplicate.operand", descriptor.myDuplicateOperand.getText()), new LocalQuickFix[]{new PhpRemoveDuplicateOperandQuickFix(PhpDuplicateOperandInComparisonInspection.getNewBinaryExpressionText(operation, descriptor))});
                    }
                } else {
                    this.checkOperandsWithOneBinaryExpression(expression, left, right);
                }
            }

            private void checkOperandsWithOneBinaryExpression(BinaryExpression expression, PsiElement left, PsiElement right) {
                PsiElement oppositeOperand;
                BinaryExpression binaryExpressionOperand;
                if (left instanceof BinaryExpression) {
                    binaryExpressionOperand = (BinaryExpression)left;
                    oppositeOperand = right;
                } else if (right instanceof BinaryExpression) {
                    binaryExpressionOperand = (BinaryExpression)right;
                    oppositeOperand = left;
                } else {
                    return;
                }
                if (oppositeOperand == null) {
                    return;
                }
                PsiElement binaryLeft = binaryExpressionOperand.getLeftOperand();
                PsiElement binaryRight = binaryExpressionOperand.getRightOperand();
                if (SUPPORTED_TOKENS.containsKey(binaryExpressionOperand.getOperationType()) && (PhpPsiUtil.areElementsEquivalent(oppositeOperand, binaryLeft) && PhpDuplicateOperandInComparisonInspection.isLiteralWithNonWeakNullValue(binaryRight) || PhpPsiUtil.areElementsEquivalent(oppositeOperand, binaryRight) && PhpDuplicateOperandInComparisonInspection.isLiteralWithNonWeakNullValue(binaryLeft)) && !PhpSideEffectDetector.canContainSideEffect(oppositeOperand)) {
                    holder.registerProblem((PsiElement)expression, PhpBundle.message("inspection.message.expression.have.duplicate.operand", oppositeOperand.getText()), new LocalQuickFix[]{PhpInstanceofIsAlwaysTrueInspection.getFix(PhpExpressionAlwaysConstantEvaluator.ConstantValue.FALSE, (PsiElement)expression)});
                }
            }
        };
    }

    private static boolean isNonZeroNumber(PsiElement operand) {
        return PhpPsiUtil.isOfType(operand, PhpElementTypes.NUMBER) && !PhpDfaBaseStateConditionDFAnalyzer.isZero(operand);
    }

    private static boolean isLiteralWithNonWeakNullValue(PsiElement element) {
        return PhpPsiUtil.isOfType(element, PhpElementTypes.SCALARS) && !PhpDfaBaseStateConditionDFAnalyzer.nonStrictNullValue(element);
    }

    private static String getNewBinaryExpressionText(PsiElement operation, PhpDuplicateOperandDescriptor descriptor) {
        PsiElement leftOperandToRemain = descriptor.myLeftOperandToRemain;
        PsiElement rightOperandToRemain = descriptor.myRightOperandToRemain;
        return String.format("%s %s %s", leftOperandToRemain.getText(), operation.getText(), rightOperandToRemain.getText());
    }

    @Nullable
    private static PhpDuplicateOperandDescriptor getDuplicateOperandDescriptor(BinaryExpression left, BinaryExpression right) {
        PsiElement leftLeft = left.getLeftOperand();
        PsiElement leftRight = left.getRightOperand();
        PsiElement rightLeft = right.getLeftOperand();
        PsiElement rightRight = right.getRightOperand();
        if (PhpPsiUtil.areElementsEquivalent(leftLeft, rightLeft)) {
            return PhpDuplicateOperandDescriptor.create(leftLeft, leftRight, rightRight);
        }
        if (PhpLangUtil.isCommutativeOperator(right.getOperationType()) && PhpPsiUtil.areElementsEquivalent(leftLeft, rightRight)) {
            return PhpDuplicateOperandDescriptor.create(leftLeft, leftRight, rightLeft);
        }
        if (PhpPsiUtil.areElementsEquivalent(leftRight, rightRight)) {
            return PhpDuplicateOperandDescriptor.create(leftRight, leftLeft, rightLeft);
        }
        if (PhpLangUtil.isCommutativeOperator(right.getOperationType()) && PhpPsiUtil.areElementsEquivalent(leftRight, rightLeft)) {
            return PhpDuplicateOperandDescriptor.create(rightLeft, leftLeft, rightRight);
        }
        return null;
    }

    private static boolean typeMatches(PsiElement l, PsiElement r, PhpType operationType) {
        PhpType leftType = new PhpType().add(l).global(l.getProject());
        PhpType rightType = new PhpType().add(r).global(r.getProject());
        return leftType.size() == 1 && rightType.size() == 1 && leftType.equals((Object)rightType) && PhpType.isSubType((PhpType)rightType, (PhpType)operationType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/codeSmell/PhpDuplicateOperandInComparisonInspection", "buildVisitor"));
    }

    private static class PhpDuplicateOperandDescriptor {
        private final PsiElement myDuplicateOperand;
        private final PsiElement myLeftOperandToRemain;
        private final PsiElement myRightOperandToRemain;

        private PhpDuplicateOperandDescriptor(@NotNull PsiElement duplicateOperand, @NotNull PsiElement leftOperandToRemain, @NotNull PsiElement rightOperandToRemain) {
            if (duplicateOperand == null) {
                PhpDuplicateOperandDescriptor.$$$reportNull$$$0(0);
            }
            if (leftOperandToRemain == null) {
                PhpDuplicateOperandDescriptor.$$$reportNull$$$0(1);
            }
            if (rightOperandToRemain == null) {
                PhpDuplicateOperandDescriptor.$$$reportNull$$$0(2);
            }
            this.myDuplicateOperand = duplicateOperand;
            this.myLeftOperandToRemain = leftOperandToRemain;
            this.myRightOperandToRemain = rightOperandToRemain;
        }

        @Nullable
        private static PhpDuplicateOperandDescriptor create(@NotNull PsiElement duplicateOperand, @Nullable PsiElement leftOperandToRemain, @Nullable PsiElement rightOperandToRemain) {
            if (duplicateOperand == null) {
                PhpDuplicateOperandDescriptor.$$$reportNull$$$0(3);
            }
            if (leftOperandToRemain == null || rightOperandToRemain == null) {
                return null;
            }
            return new PhpDuplicateOperandDescriptor(duplicateOperand, leftOperandToRemain, rightOperandToRemain);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "duplicateOperand";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "leftOperandToRemain";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rightOperandToRemain";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/lang/inspections/codeSmell/PhpDuplicateOperandInComparisonInspection$PhpDuplicateOperandDescriptor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "create";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpRemoveDuplicateOperandQuickFix
    extends PsiUpdateModCommandQuickFix {
        private final String myNewText;

        private PhpRemoveDuplicateOperandQuickFix(String newBinaryExpressionText) {
            this.myNewText = newBinaryExpressionText;
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.remove.duplicate.operand", new Object[0]);
            if (string == null) {
                PhpRemoveDuplicateOperandQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getName() {
            String string = PhpBundle.message("intention.family.name.replace.with", this.myNewText);
            if (string == null) {
                PhpRemoveDuplicateOperandQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                PhpRemoveDuplicateOperandQuickFix.$$$reportNull$$$0(2);
            }
            if (element == null) {
                PhpRemoveDuplicateOperandQuickFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                PhpRemoveDuplicateOperandQuickFix.$$$reportNull$$$0(4);
            }
            element.replace((PsiElement)PhpPsiElementFactory.createPhpPsiFromText(project, BinaryExpression.class, this.myNewText));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeSmell/PhpDuplicateOperandInComparisonInspection$PhpRemoveDuplicateOperandQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeSmell/PhpDuplicateOperandInComparisonInspection$PhpRemoveDuplicateOperandQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }
}

