/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeSmell;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpBreak;
import com.jetbrains.php.lang.psi.elements.PhpContinue;
import com.jetbrains.php.lang.psi.elements.PhpLoop;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpSwitch;
import com.jetbrains.php.lang.psi.elements.StatementWithArgument;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.navigation.PhpGotoBreakContinueHandler;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class PhpContinueTargetingSwitchInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpContinueTargetingSwitchInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(this){

            public void visitPhpContinue(PhpContinue continueStatement) {
                int argument = PhpGotoBreakContinueHandler.Companion.getArgument((StatementWithArgument)continueStatement);
                if (PhpPsiUtil.getLoopStatement((PhpPsiElement)continueStatement, argument) instanceof PhpSwitch) {
                    holder.registerProblem((PsiElement)continueStatement, PhpBundle.message("inspection.message.continue.targeting.switch.equivalent.to.break", new Object[0]), PhpContinueTargetingSwitchInspection.getFixes(continueStatement, argument));
                }
            }
        };
    }

    @Override
    public Map<PhpLanguageLevel, ProblemHighlightType> getCustomSeverities() {
        return Map.of(PhpLanguageLevel.PHP730, ProblemHighlightType.WARNING);
    }

    private static LocalQuickFix[] getFixes(PhpContinue continueStatement, int argument) {
        if (PhpPsiUtil.getLoopStatement((PhpPsiElement)continueStatement, argument + 1) instanceof PhpLoop) {
            return new LocalQuickFix[]{new PhpReplaceWithBreakQuickFix(argument), new PhpReplaceContinueArgumentQuickFix(argument + 1)};
        }
        return new LocalQuickFix[]{new PhpReplaceWithBreakQuickFix(argument)};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/codeSmell/PhpContinueTargetingSwitchInspection", "buildVisitor"));
    }

    private static class PhpReplaceWithBreakQuickFix
    extends PsiUpdateModCommandQuickFix {
        private final int myArgument;

        private PhpReplaceWithBreakQuickFix(int argument) {
            this.myArgument = argument;
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.replace.with", "break" + (String)(this.myArgument == 1 ? "" : " " + this.myArgument) + ";");
            if (string == null) {
                PhpReplaceWithBreakQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiElement argument;
            if (project == null) {
                PhpReplaceWithBreakQuickFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                PhpReplaceWithBreakQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpReplaceWithBreakQuickFix.$$$reportNull$$$0(3);
            }
            String argumentText = (argument = ((PhpContinue)element).getArgument()) != null ? argument.getText() : "";
            PhpBreak phpBreak = PhpPsiElementFactory.createPhpPsiFromText(project, PhpBreak.class, "while(true) break " + argumentText + ";");
            element.replace((PsiElement)phpBreak);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeSmell/PhpContinueTargetingSwitchInspection$PhpReplaceWithBreakQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeSmell/PhpContinueTargetingSwitchInspection$PhpReplaceWithBreakQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class PhpReplaceContinueArgumentQuickFix
    extends PsiUpdateModCommandQuickFix {
        private final int myArgument;

        private PhpReplaceContinueArgumentQuickFix(int argument) {
            this.myArgument = argument;
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.replace.with", "continue " + this.myArgument + ";");
            if (string == null) {
                PhpReplaceContinueArgumentQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                PhpReplaceContinueArgumentQuickFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                PhpReplaceContinueArgumentQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpReplaceContinueArgumentQuickFix.$$$reportNull$$$0(3);
            }
            PsiElement argument = ((PhpContinue)element).getArgument();
            PhpContinue phpContinue = PhpPsiElementFactory.createPhpPsiFromText(project, PhpContinue.class, "while (true) continue " + this.myArgument + ";");
            if (argument != null) {
                argument.replace(phpContinue.getArgument());
            } else {
                element.replace((PsiElement)phpContinue);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeSmell/PhpContinueTargetingSwitchInspection$PhpReplaceContinueArgumentQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeSmell/PhpContinueTargetingSwitchInspection$PhpReplaceContinueArgumentQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

