/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeSmell;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpArrayPushWithOneElementInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpArrayPushWithOneElementInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(this){

            public void visitPhpFunctionCall(FunctionReference reference) {
                PsiElement[] parameters = reference.getParameters();
                if (parameters.length == 2 && !PhpCodeInsightUtil.isUnpackedArgument(parameters[1]) && PhpArrayPushWithOneElementInspection.isInsideSingleStatement(reference) && PhpCodeInsightUtil.isGlobalFunctionCallWithName(reference, "array_push")) {
                    holder.problem((PsiElement)reference, PhpBundle.message("inspection.message.array.push.with.single.element", new Object[0])).fix((ModCommandAction)new PhpReplaceWithArrayAssignmentQuickFix(reference)).register();
                }
            }
        };
    }

    private static boolean isInsideSingleStatement(FunctionReference reference) {
        PsiElement semicolon;
        PsiElement parent = reference.getParent();
        return parent instanceof Statement && parent.getFirstChild() == reference && PhpPsiUtil.isOfType(semicolon = PhpPsiUtil.getNextSiblingIgnoreWhitespace((PsiElement)reference, true), PhpTokenTypes.opSEMICOLON) && parent.getLastChild() == semicolon;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/codeSmell/PhpArrayPushWithOneElementInspection", "buildVisitor"));
    }

    private static class PhpReplaceWithArrayAssignmentQuickFix
    extends PsiUpdateModCommandAction<FunctionReference> {
        private final String myAssignmentText;

        private PhpReplaceWithArrayAssignmentQuickFix(FunctionReference reference) {
            super((PsiElement)reference);
            this.myAssignmentText = PhpReplaceWithArrayAssignmentQuickFix.buildText(reference);
        }

        private static String buildText(FunctionReference reference) {
            PsiElement[] parameters = reference.getParameters();
            return String.format("%s[] = %s", parameters[0].getText(), parameters[1].getText());
        }

        @Nullable
        protected Presentation getPresentation(@NotNull ActionContext context, @NotNull FunctionReference element) {
            if (context == null) {
                PhpReplaceWithArrayAssignmentQuickFix.$$$reportNull$$$0(0);
            }
            if (element == null) {
                PhpReplaceWithArrayAssignmentQuickFix.$$$reportNull$$$0(1);
            }
            return Presentation.of((String)PhpBundle.message("intention.family.name.replace.with", this.myAssignmentText));
        }

        protected void invoke(@NotNull ActionContext context, @NotNull FunctionReference functionReference, @NotNull ModPsiUpdater updater) {
            if (context == null) {
                PhpReplaceWithArrayAssignmentQuickFix.$$$reportNull$$$0(2);
            }
            if (functionReference == null) {
                PhpReplaceWithArrayAssignmentQuickFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                PhpReplaceWithArrayAssignmentQuickFix.$$$reportNull$$$0(4);
            }
            functionReference.replace((PsiElement)PhpPsiElementFactory.createPhpPsiFromText(context.project(), AssignmentExpression.class, this.myAssignmentText));
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.replace.with.array.assignment", new Object[0]);
            if (string == null) {
                PhpReplaceWithArrayAssignmentQuickFix.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "functionReference";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeSmell/PhpArrayPushWithOneElementInspection$PhpReplaceWithArrayAssignmentQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeSmell/PhpArrayPushWithOneElementInspection$PhpReplaceWithArrayAssignmentQuickFix";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getPresentation";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5 -> new IllegalStateException(string);
            };
        }
    }
}

