/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.ResolveResult;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.PhpSwitchCaseAwareInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessFieldByVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpArrayAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpConditionInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpEntryPointInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.dataFlow.PhpConditionDFAnalyzer;
import com.jetbrains.php.codeInsight.dataFlow.reachingDefinition.PhpReachingDefinitionDFAnalyzer;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpRenameWrongReferenceQuickFix;
import com.jetbrains.php.lang.inspections.PhpUndefinedClassVisitorBase;
import com.jetbrains.php.lang.inspections.PhpUndefinedMemberInspection;
import com.jetbrains.php.lang.inspections.PhpUndefinedMethodInspection;
import com.jetbrains.php.lang.inspections.quickfix.PhpAddFieldDeclarationQuickFix;
import com.jetbrains.php.lang.inspections.quickfix.PhpAddPropertyQuickFix;
import com.jetbrains.php.lang.inspections.quickfix.PhpQuickFixBase;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpEmpty;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpIsset;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.elements.impl.FieldReferenceImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpClassImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.phpunit.PhpUnitUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpUndefinedFieldInspection
extends PhpUndefinedMemberInspection {
    @IntentionName
    public static final String ADD_PROPERTY_FIX_NAME = PhpBundle.message("add.property", new Object[0]);
    private static final PhpAddPropertyQuickFix ADD_PROPERTY_FIX = new PhpAddPropertyQuickFix();
    public static final LocalQuickFix[] FIXES = new LocalQuickFix[]{PhpAddFieldDeclarationQuickFix.INSTANCE, ADD_PROPERTY_FIX};
    public boolean NOTIFY_ACCESS_VIA_MAGIC_METHOD = true;
    public boolean NOTIFY_DYNAMIC_READ = true;

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpUndefinedFieldInspection.$$$reportNull$$$0(0);
        }
        return new PhpUndefinedClassVisitorBase(holder, isOnTheFly, this.isWarnOnMixed()){

            @Override
            protected void checkMagicMethodAccess(FieldReference reference, Project project, PsiElement psi) {
                LocalQuickFix[] fixes;
                LocalQuickFix[] localQuickFixArray = fixes = PhpUndefinedFieldInspection.isClassQuickFixApplicable(project, psi) ? PhpRenameWrongReferenceQuickFix.appendQuickFix((PhpReference)reference, this.getFixes(reference)) : LocalQuickFix.EMPTY_ARRAY;
                if (PhpUndefinedFieldInspection.this.isNotifyAccessViaMagicMethod()) {
                    holder.registerProblem(psi, PhpUndefinedFieldInspection.getPROBLEM_1(), ProblemHighlightType.WEAK_WARNING, fixes);
                }
            }

            @Override
            protected void checkDynamicDeclaration(FieldReference reference, Project project, PsiElement psi, PhpAccessInstruction.Access access, PhpUndefinedMethodInspection.Reachability reachability, PhpType classReferenceType, boolean probablyUndefined) {
                if (reference.getReferenceType() == PhpModifier.State.DYNAMIC && access.isWrite() && !access.isRead()) {
                    return;
                }
                if (reference.getReferenceType() == PhpModifier.State.DYNAMIC && PhpUndefinedFieldInspection.this.isNotifyDynamicRead() && access.isRead() && probablyUndefined) {
                    this.myHolder.registerProblem(psi, PhpBundle.message("inspection.probably.undefined.property", new Object[0]), ProblemHighlightType.WEAK_WARNING, new LocalQuickFix[0]);
                    return;
                }
                if (PhpUndefinedFieldInspection.this.isNotifyDynamicRead() || !PhpCodeInsightUtil.getAccess((PhpPsiElement)reference).isRead()) {
                    this.myHolder.registerProblem(this.createDescriptor(psi, reference, reachability, classReferenceType));
                }
            }

            private ProblemDescriptor createDescriptor(PsiElement nameIdentifier, FieldReference reference, PhpUndefinedMethodInspection.Reachability reachability, PhpType type) {
                LocalQuickFix[] fixes = PhpUndefinedFieldInspection.isClassQuickFixApplicable(nameIdentifier.getProject(), nameIdentifier) ? PhpRenameWrongReferenceQuickFix.appendQuickFix((PhpReference)reference, this.getFixes(reference)) : LocalQuickFix.EMPTY_ARRAY;
                int reachabilityChoice = reachability == PhpUndefinedMethodInspection.Reachability.MIGHT_BE_DEFINED ? 1 : 0;
                String template = this.myIsOnTheFly ? PhpBundle.message("property.is.undefined.in.class", type.toStringRelativized(reference.getNamespaceName()), reachabilityChoice) : PhpBundle.message("property.is.undefined", reachabilityChoice);
                ProblemHighlightType highlightType = reachability == PhpUndefinedMethodInspection.Reachability.MIGHT_BE_DEFINED ? ProblemHighlightType.WEAK_WARNING : ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
                return InspectionManager.getInstance((Project)nameIdentifier.getProject()).createProblemDescriptor(nameIdentifier, template, this.myIsOnTheFly, fixes, highlightType);
            }
        };
    }

    public static boolean isExplicitlyNotDefined(FieldReference reference) {
        PhpExpression classReference = reference.getClassReference();
        if (classReference == null) {
            return false;
        }
        Ref canBeDefined = new Ref((Object)false);
        Ref canBeUndefined = new Ref((Object)false);
        PhpUndefinedFieldInspection.processDfaReachability(reference, (Ref<Boolean>)canBeDefined, (Ref<Boolean>)canBeUndefined, new MyReachingDefinitionDFAnalyzer((PsiElement)classReference, reference.getName(), null){

            @Override
            @NotNull
            public PhpReachingDefinitionDFAnalyzer.Result performDFA(@NotNull PhpConditionInstruction instruction) {
                if (instruction == null) {
                    2.$$$reportNull$$$0(0);
                }
                PhpReachingDefinitionDFAnalyzer.Result result = this.performDFA(instruction.getCondition(), !instruction.getResult());
                if (result == null) {
                    2.$$$reportNull$$$0(1);
                }
                return result;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "instruction";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpUndefinedFieldInspection$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpUndefinedFieldInspection$2";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "performDFA";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "performDFA";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        });
        return (Boolean)canBeDefined.get() != false && (Boolean)canBeUndefined.get() == false;
    }

    public static boolean isTraitWithMagicMethodsInAllUsages(@NotNull PhpType type, @NotNull PhpIndex index, @NotNull String magicMethod) {
        List traitUsages;
        if (type == null) {
            PhpUndefinedFieldInspection.$$$reportNull$$$0(1);
        }
        if (index == null) {
            PhpUndefinedFieldInspection.$$$reportNull$$$0(2);
        }
        if (magicMethod == null) {
            PhpUndefinedFieldInspection.$$$reportNull$$$0(3);
        }
        if ((traitUsages = type.getTypes().stream().flatMap(t -> index.getTraitsByFQN(t).stream()).flatMap(trait -> index.getTraitUsages(trait).stream()).toList()).isEmpty()) {
            return false;
        }
        return traitUsages.stream().map(PhpTypedElement::getType).allMatch(ut -> PhpCodeInsightUtil.hasMagicMethod(ut, index, magicMethod));
    }

    public static void processDfaReachability(FieldReference reference, Ref<Boolean> canBeDefined, Ref<Boolean> canBeUndefined) {
        PhpExpression classReference = reference.getClassReference();
        if (classReference == null) {
            return;
        }
        PhpUndefinedFieldInspection.processDfaReachability(reference, canBeDefined, canBeUndefined, new MyReachingDefinitionDFAnalyzer((PsiElement)classReference, reference.getName(), null));
    }

    public static void processDfaReachability(FieldReference reference, Ref<Boolean> canBeDefined, Ref<Boolean> canBeUndefined, MyReachingDefinitionDFAnalyzer analyzer) {
        PhpAccessFieldByVariableInstruction instruction = PhpControlFlowUtil.getAccessInstruction((PhpPsiElement)reference, PhpAccessFieldByVariableInstruction.class);
        if (instruction != null) {
            if (instruction.getAccess().isLightRead()) {
                canBeDefined.set((Object)true);
                canBeUndefined.set((Object)false);
                return;
            }
            PhpExpression classReference = reference.getClassReference();
            if (classReference == null) {
                return;
            }
            String fieldName = reference.getName();
            PhpUndefinedFieldInspection.processReachability(classReference, fieldName, (PhpInstruction)instruction, canBeDefined, canBeUndefined, null, analyzer);
        }
    }

    @NotNull
    public static PhpUndefinedMethodInspection.Reachability getReachability(FieldReference reference, Ref<Boolean> canBeDefined, Ref<Boolean> canBeUndefined) {
        PhpExpression classReference = reference.getClassReference();
        if (classReference == null) {
            PhpUndefinedMethodInspection.Reachability reachability = PhpUndefinedMethodInspection.Reachability.UNDEFINED;
            if (reachability == null) {
                PhpUndefinedFieldInspection.$$$reportNull$$$0(4);
            }
            return reachability;
        }
        PhpUndefinedFieldInspection.processDfaReachability(reference, canBeDefined, canBeUndefined);
        if (((Boolean)canBeDefined.get()).booleanValue() && !((Boolean)canBeUndefined.get()).booleanValue()) {
            PhpUndefinedMethodInspection.Reachability reachability = PhpUndefinedMethodInspection.Reachability.DEFINED;
            if (reachability == null) {
                PhpUndefinedFieldInspection.$$$reportNull$$$0(5);
            }
            return reachability;
        }
        PhpAccessInstruction classReferenceAccessInstruction = PhpControlFlowUtil.getAccessInstruction((PhpPsiElement)classReference, PhpAccessInstruction.class);
        String fieldName = reference.getName();
        if (fieldName != null) {
            PhpUndefinedMethodInspection.Reachability reachability = PhpUndefinedMethodInspection.performReachingDefinition(new PhpFieldExistsReachingDFAnalyzer(classReference, fieldName), (PhpInstruction)classReferenceAccessInstruction);
            if (reachability == null) {
                PhpUndefinedFieldInspection.$$$reportNull$$$0(6);
            }
            return reachability;
        }
        PhpUndefinedMethodInspection.Reachability reachability = PhpUndefinedMethodInspection.Reachability.UNDEFINED;
        if (reachability == null) {
            PhpUndefinedFieldInspection.$$$reportNull$$$0(7);
        }
        return reachability;
    }

    public static boolean noResolvedDeclarationExists(PhpReference reference) {
        return PhpUndefinedFieldInspection.allFieldsDynamicallyInitialized(PhpUndefinedFieldInspection.resolve(reference));
    }

    public static boolean allFieldsDynamicallyInitialized(Collection<? extends PsiElement> resolve2) {
        return ContainerUtil.and(resolve2, e -> e instanceof PhpClassImpl.MyRenamableFakePsiElement && PhpUndefinedFieldInspection.isDynamicallyInitialised((PhpClassImpl.MyRenamableFakePsiElement)((Object)e)));
    }

    private static boolean isDynamicallyInitialised(PhpClassImpl.MyRenamableFakePsiElement e) {
        return switch (e.getInitPlace()) {
            default -> throw new MatchException(null, null);
            case PhpClass.PhpDynamicFieldInitPlace.CONSTRUCTOR -> false;
            case PhpClass.PhpDynamicFieldInitPlace.PHPUNIT_SETUP, PhpClass.PhpDynamicFieldInitPlace.PHPUNIT_SETUP_BEFORE_CLASS -> {
                if (!PhpUnitUtil.extendsRootTestClass(e.getContainingClass())) {
                    yield true;
                }
                yield false;
            }
            case PhpClass.PhpDynamicFieldInitPlace.DYNAMIC -> true;
        };
    }

    @NotNull
    public static Collection<PsiElement> resolve(PhpReference reference) {
        Collection collection = Arrays.stream(reference.multiResolve(false)).map(ResolveResult::getElement).filter(e -> !(e instanceof FieldReferenceImpl.DynamicallyDeclaredField)).collect(Collectors.toList());
        if (collection == null) {
            PhpUndefinedFieldInspection.$$$reportNull$$$0(8);
        }
        return collection;
    }

    public static void processReachability(@NotNull PhpExpression classReference, @Nullable String fieldName, PhpInstruction instruction, Ref<Boolean> canBeDefined, Ref<Boolean> canBeUndefined, @Nullable Consumer<FieldReference> fieldNameProcessor) {
        if (classReference == null) {
            PhpUndefinedFieldInspection.$$$reportNull$$$0(9);
        }
        PhpUndefinedFieldInspection.processReachability(classReference, fieldName, instruction, canBeDefined, canBeUndefined, fieldNameProcessor, new MyReachingDefinitionDFAnalyzer((PsiElement)classReference, fieldName, fieldNameProcessor));
    }

    private static void processReachability(final @NotNull PhpExpression classReference, final @Nullable String fieldName, PhpInstruction instruction, final Ref<Boolean> canBeDefined, final Ref<Boolean> canBeUndefined, final @Nullable Consumer<FieldReference> fieldNameProcessor, final MyReachingDefinitionDFAnalyzer analyzer) {
        if (classReference == null) {
            PhpUndefinedFieldInspection.$$$reportNull$$$0(10);
        }
        PhpControlFlowUtil.processPredecessorsIgnoreInitialBackEdges(instruction, false, new PhpSwitchCaseAwareInstructionProcessor<PhpReachingDefinitionDFAnalyzer.Result>(){

            @Override
            protected PhpConditionDFAnalyzer<PhpReachingDefinitionDFAnalyzer.Result> getAnalyzer() {
                return analyzer;
            }

            @Override
            protected boolean processBaseConditionInstruction(PhpConditionInstruction conditionInstruction) {
                return conditionInstruction.getCondition() == null || ((PhpReachingDefinitionDFAnalyzer.Result)this.performDFA(conditionInstruction)).apply((Ref<Boolean>)canBeDefined, (Ref<Boolean>)canBeUndefined);
            }

            public boolean processEntryPointInstruction(PhpEntryPointInstruction instruction) {
                canBeUndefined.set((Object)true);
                return true;
            }

            public boolean processAccessFieldByVariableInstruction(PhpAccessFieldByVariableInstruction instruction) {
                FieldReference writeFieldRef;
                PhpAccessInstruction.Access access = instruction.getAccess();
                return !access.isWrite() && !access.isWriteRef() || (writeFieldRef = (FieldReference)ObjectUtils.tryCast((Object)instruction.getAnchor(), FieldReference.class)) == null || this.processWriteFieldRef(writeFieldRef);
            }

            private boolean processWriteFieldRef(FieldReference writeFieldRef) {
                PhpExpression writeClassRef = writeFieldRef.getClassReference();
                if (writeClassRef != null && PsiEquivalenceUtil.areElementsEquivalent((PsiElement)classReference, (PsiElement)writeClassRef)) {
                    if (fieldNameProcessor != null) {
                        fieldNameProcessor.accept(writeFieldRef);
                    }
                    if (fieldName != null && PhpLangUtil.equalsClassNames(writeFieldRef.getName(), fieldName)) {
                        canBeDefined.set((Object)true);
                        return false;
                    }
                }
                return true;
            }

            public boolean processArrayAccessInstruction(PhpArrayAccessInstruction instruction) {
                PhpAccessInstruction.Access access = instruction.getAccess();
                if (access.isWrite() || access.isWriteRef()) {
                    FieldReference writeFieldRef;
                    ArrayAccessExpression arrayAccess = (ArrayAccessExpression)ObjectUtils.tryCast((Object)instruction.getAnchor(), ArrayAccessExpression.class);
                    FieldReference fieldReference = writeFieldRef = arrayAccess != null ? (FieldReference)ObjectUtils.tryCast((Object)arrayAccess.getValue(), FieldReference.class) : null;
                    if (writeFieldRef != null && !this.processWriteFieldRef(writeFieldRef)) {
                        return false;
                    }
                }
                return true;
            }
        });
    }

    private boolean isNotifyAccessViaMagicMethod() {
        return this.NOTIFY_ACCESS_VIA_MAGIC_METHOD;
    }

    private boolean isNotifyDynamicRead() {
        return this.NOTIFY_DYNAMIC_READ;
    }

    @Override
    public void resetOptions() {
        super.resetOptions();
        this.NOTIFY_ACCESS_VIA_MAGIC_METHOD = false;
        this.NOTIFY_DYNAMIC_READ = true;
        this.WARN_ON_MIXED = false;
    }

    @Override
    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"NOTIFY_ACCESS_VIA_MAGIC_METHOD", (String)PhpBundle.message("inspection.undefined.field.notify.access.magic.method", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"NOTIFY_DYNAMIC_READ", (String)PhpBundle.message("inspection.undefined.field.notify.dynamic.read", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"WARN_ON_MIXED", (String)PhpBundle.message("inspection.undefined.member.warnOnMixed", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            PhpUndefinedFieldInspection.$$$reportNull$$$0(11);
        }
        return optPane;
    }

    public static boolean isClassQuickFixApplicable(Project project, PsiElement element) {
        MemberReference reference = PhpPsiUtil.getParentOfClass(element, false, MemberReference.class);
        if (reference == null) {
            return false;
        }
        PhpClass klass = PhpQuickFixBase.resolveClass(reference, true);
        if (klass == null) {
            return false;
        }
        return ModuleUtilCore.projectContainsFile((Project)project, (VirtualFile)klass.getContainingFile().getVirtualFile(), (boolean)false);
    }

    @InspectionMessage
    private static String getPROBLEM_1() {
        return PhpBundle.message("inspection.undefined.field.problem1", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7, 8, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "magicMethod";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpUndefinedFieldInspection";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpUndefinedFieldInspection";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getReachability";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "resolve";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isTraitWithMagicMethodsInAllUsages";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processReachability";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7, 8, 11 -> new IllegalStateException(string);
        };
    }

    private static class MyReachingDefinitionDFAnalyzer
    extends PhpReachingDefinitionDFAnalyzer {
        @NotNull
        private final PsiElement myReference;
        private final String myName;
        @Nullable
        private final Consumer<FieldReference> myFieldNameProcessor;

        private MyReachingDefinitionDFAnalyzer(@NotNull PsiElement classReference, @Nullable String fieldName, @Nullable Consumer<FieldReference> fieldNameProcessor) {
            if (classReference == null) {
                MyReachingDefinitionDFAnalyzer.$$$reportNull$$$0(0);
            }
            this.myReference = classReference;
            this.myName = fieldName;
            this.myFieldNameProcessor = fieldNameProcessor;
        }

        @Override
        @NotNull
        public PhpReachingDefinitionDFAnalyzer.Result performDFA(@Nullable PsiElement condition, boolean result) {
            if (condition instanceof PhpIsset) {
                PhpReachingDefinitionDFAnalyzer.Result dfaResult = new PhpReachingDefinitionDFAnalyzer.Result();
                if (result) {
                    for (PhpExpression expression : ((PhpIsset)condition).getVariables()) {
                        if (!this.processExpression(dfaResult, expression)) break;
                    }
                }
                PhpReachingDefinitionDFAnalyzer.Result result2 = dfaResult;
                if (result2 == null) {
                    MyReachingDefinitionDFAnalyzer.$$$reportNull$$$0(1);
                }
                return result2;
            }
            if (condition instanceof PhpEmpty) {
                PhpReachingDefinitionDFAnalyzer.Result dfaResult = new PhpReachingDefinitionDFAnalyzer.Result();
                if (!result) {
                    for (PhpExpression expression : ((PhpEmpty)condition).getVariables()) {
                        if (!this.processExpression(dfaResult, expression)) break;
                    }
                }
                PhpReachingDefinitionDFAnalyzer.Result result3 = dfaResult;
                if (result3 == null) {
                    MyReachingDefinitionDFAnalyzer.$$$reportNull$$$0(2);
                }
                return result3;
            }
            PhpReachingDefinitionDFAnalyzer.Result result4 = (PhpReachingDefinitionDFAnalyzer.Result)super.performDFA(condition, result);
            if (result4 == null) {
                MyReachingDefinitionDFAnalyzer.$$$reportNull$$$0(3);
            }
            return result4;
        }

        private boolean processExpression(PhpReachingDefinitionDFAnalyzer.Result dfaResult, PhpExpression expression) {
            while (expression != null) {
                PhpExpression issetClassReference;
                if (expression instanceof FieldReference && (issetClassReference = ((FieldReference)expression).getClassReference()) != null && PsiEquivalenceUtil.areElementsEquivalent((PsiElement)issetClassReference, (PsiElement)this.myReference)) {
                    String issetFieldName = expression.getName();
                    if (this.myFieldNameProcessor != null) {
                        this.myFieldNameProcessor.accept((FieldReference)expression);
                    }
                    if (this.myName != null && PhpLangUtil.equalsClassNames(this.myName, issetFieldName)) {
                        dfaResult.setDefined(true);
                        return false;
                    }
                }
                expression = MyReachingDefinitionDFAnalyzer.unwrapExpression(expression);
            }
            return true;
        }

        @Nullable
        private static PhpExpression unwrapExpression(PhpExpression expression) {
            if (expression instanceof MemberReference) {
                return ((MemberReference)expression).getClassReference();
            }
            if (expression instanceof ArrayAccessExpression) {
                return (PhpExpression)ObjectUtils.tryCast((Object)((ArrayAccessExpression)expression).getValue(), PhpExpression.class);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classReference";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpUndefinedFieldInspection$MyReachingDefinitionDFAnalyzer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpUndefinedFieldInspection$MyReachingDefinitionDFAnalyzer";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "performDFA";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    public static class PhpFieldExistsReachingDFAnalyzer
    extends PhpUndefinedMethodInspection.PhpEntityDefinedViaFunctionCallDFAnalyzer {
        public PhpFieldExistsReachingDFAnalyzer(PhpExpression classReference, String name) {
            super(classReference, name);
        }

        @Override
        @NotNull
        protected String getDefiningFunctionName() {
            return "property_exists";
        }
    }
}

